/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.fingerprint;

import com.kingdee.eas.base.security.fingerprint.FingerprintConfigInfo;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import org.apache.log4j.Logger;

public class FingerprintConfigUtil {
    private static Logger logger = Logger.getLogger(FingerprintConfigUtil.class);
    private static final String ITEM_NAME = "FingerPrintConfig";
    public static final String ENABLE_FINGERPRINT = "enableFingerprint";
    public static final String IMP_CLASS = "ImpClass";
    public static final String TYPE = "type";
    public static final String SERVER_IP = "serverIP";
    public static final String SERVER_PORT = "serverPort";
    public static final String PRODUCT_ID = "productId";
    public static final String ADMIN_NAME = "adminName";
    public static final String ADMIN_PASS = "adminPass";

    public static final FingerprintConfigInfo getFingerprintConfigInfo(XMLConfiguration config) {
        ConfigurationItem configItem = FingerprintConfigUtil.getConfigItem(config);
        FingerprintConfigInfo info = new FingerprintConfigInfo();
        if (configItem != null) {
            String paramStr = configItem.getProperty(ENABLE_FINGERPRINT);
            if (StringUtils.isEmpty((String)paramStr)) {
                info.setEnableFingerprint("false");
            } else {
                info.setEnableFingerprint(paramStr);
            }
            paramStr = configItem.getProperty(IMP_CLASS);
            info.setFingerprintSupplierClass(paramStr);
            paramStr = configItem.getProperty(TYPE);
            info.setAuthType(paramStr);
            paramStr = configItem.getProperty(SERVER_IP);
            info.setServerIP(paramStr);
            paramStr = configItem.getProperty(SERVER_PORT);
            info.setServerPort(paramStr);
            paramStr = configItem.getProperty(PRODUCT_ID);
            info.setProductId(paramStr);
            paramStr = configItem.getProperty(ADMIN_NAME);
            info.setAdminName(paramStr);
            paramStr = configItem.getProperty(ADMIN_PASS);
            info.setAdminPassword(paramStr);
        }
        return info;
    }

    public static final void storeFingerprintConfigInfo(XMLConfiguration config, FingerprintConfigInfo info) {
        if (info != null) {
            ConfigurationItem configItem = FingerprintConfigUtil.getConfigItem(config);
            if (info.getEnableFingerprint() != null) {
                configItem.setProperty(ENABLE_FINGERPRINT, info.getEnableFingerprint());
            }
            if (info.getFingerprintSupplierClass() != null) {
                configItem.setProperty(IMP_CLASS, info.getFingerprintSupplierClass());
            }
            if (info.getAuthType() != null) {
                configItem.setProperty(TYPE, info.getAuthType());
            }
            if (info.getServerIP() != null) {
                configItem.setProperty(SERVER_IP, info.getServerIP());
            }
            if (info.getServerPort() != null) {
                configItem.setProperty(SERVER_PORT, info.getServerPort());
            }
            if (info.getProductId() != null) {
                configItem.setProperty(PRODUCT_ID, info.getProductId());
            }
            if (info.getAdminName() != null) {
                configItem.setProperty(ADMIN_NAME, info.getAdminName());
            }
            if (info.getAdminPassword() != null) {
                configItem.setProperty(ADMIN_PASS, info.getAdminPassword());
            }
            config.store();
        }
    }

    private static ConfigurationItem createFingerprintConfigItem() {
        ConfigurationItem configItem = new ConfigurationItem(ITEM_NAME);
        if (configItem != null) {
            configItem.setProperty(ENABLE_FINGERPRINT, "false");
            configItem.setProperty(IMP_CLASS, "");
            configItem.setProperty(TYPE, "5");
            configItem.setProperty(SERVER_IP, "");
            configItem.setProperty(SERVER_PORT, "");
            configItem.setProperty(PRODUCT_ID, "demo");
            configItem.setProperty(ADMIN_NAME, "sa");
            configItem.setProperty(ADMIN_PASS, "sa");
        }
        return configItem;
    }

    private static ConfigurationItem getConfigItem(XMLConfiguration config) {
        ConfigurationItem configItem = config.getConfigItem(ITEM_NAME);
        if (configItem == null) {
            configItem = FingerprintConfigUtil.createFingerprintConfigItem();
            config.addConfigItem(configItem);
            config.store();
        }
        return configItem;
    }
}

