/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.util;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;

public class LdapUtils {
    private static Logger log = Logger.getLogger((String)LdapUtils.class.getName());

    public static boolean matchRegex(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String exceptMatches(String str, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll("");
    }

    public static Attributes getEntryAttributes(String ldapUrl, String[] attrNames) throws NamingException {
        String entryDn = LdapUtils.exceptMatches(ldapUrl, "^ldap://.*/");
        log.debug((Object)("Entry DN=[" + entryDn + "]"));
        String ldapInfo = LdapUtils.exceptMatches(ldapUrl, "^ldap://|/.*");
        String ldapUser = null;
        String ldapPass = null;
        String ldapServerIp = null;
        String ldapPort = "389";
        if (ldapInfo.indexOf("@") > 0) {
            String ldapCredentials = LdapUtils.exceptMatches(ldapInfo, "@.*");
            log.debug((Object)("Ldap Credentials=[" + ldapCredentials + "]"));
            ldapUser = LdapUtils.exceptMatches(ldapCredentials, ":.*");
            log.debug((Object)("Ldap User=[" + ldapUser + "]"));
            ldapPass = LdapUtils.exceptMatches(ldapCredentials, "^" + ldapUser + ":");
            log.debug((Object)("Ldap Password=[" + ldapPass + "]"));
            String ldapServerInfo = LdapUtils.exceptMatches(ldapInfo, ".*@");
            log.debug((Object)("Ldap Server Url=[ldap://" + ldapServerInfo + "]"));
            if (ldapServerInfo.indexOf(":") > 0) {
                ldapServerIp = LdapUtils.exceptMatches(ldapServerInfo, ":.*");
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = LdapUtils.exceptMatches(ldapServerInfo, ".*:");
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            } else {
                ldapServerIp = ldapServerInfo;
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            }
        } else {
            log.debug((Object)("Ldap User=[" + ldapUser + "]"));
            log.debug((Object)("Ldap Password=[" + ldapPass + "]"));
            log.debug((Object)("Ldap Server Url=[ldap://" + ldapInfo + "]"));
            if (ldapInfo.indexOf(":") > 0) {
                ldapServerIp = LdapUtils.exceptMatches(ldapInfo, ":.*");
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = LdapUtils.exceptMatches(ldapInfo, ".*:");
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            } else {
                ldapServerIp = ldapInfo;
                log.debug((Object)("Ldap Server IP=[" + ldapServerIp + "]"));
                ldapPort = "389";
                log.debug((Object)("Ldap Server Port=[" + ldapPort + "]"));
            }
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapInfo = "ldap://" + ldapServerIp + ":" + ldapPort;
        env.put("java.naming.provider.url", ldapInfo);
        if (ldapUser == null) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", ldapUser);
            env.put("java.naming.security.credentials", ldapPass);
        }
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        Attributes result = ctx.getAttributes(entryDn, attrNames);
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Attribute getEntryAttribute(String ldapUrl, String attrName) throws NamingException {
        String[] attrNames = new String[]{attrName};
        Attributes attrs = LdapUtils.getEntryAttributes(ldapUrl, attrNames);
        Attribute attr = attrs.get(attrName);
        return attr;
    }

    public static String getEntryStringAttr(String ldapUrl, String attrName) throws NamingException {
        Attribute attr = LdapUtils.getEntryAttribute(ldapUrl, attrName);
        return (String)attr.get();
    }

    public static byte[] getEntryBinaryAttr(String ldapUrl, String attrName) throws NamingException {
        Attribute attr = LdapUtils.getEntryAttribute(ldapUrl, attrName);
        byte[] buffer = (byte[])attr.get();
        return buffer;
    }
}

