/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.DecisionItemInfo;
import com.kingdee.eas.base.ssc.IJob;
import com.kingdee.eas.base.ssc.IJobStateTime;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobStaTimHisCollection;
import com.kingdee.eas.base.ssc.JobStaTimHisFactory;
import com.kingdee.eas.base.ssc.JobStaTimHisInfo;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.JobStateTimeCollection;
import com.kingdee.eas.base.ssc.JobStateTimeFactory;
import com.kingdee.eas.base.ssc.JobStateTimeInfo;
import com.kingdee.eas.base.ssc.JobTakeTimeCollection;
import com.kingdee.eas.base.ssc.JobTakeTimeFactory;
import com.kingdee.eas.base.ssc.JobTakeTimeInfo;
import com.kingdee.eas.base.ssc.MessageState;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.TakeTimeType;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.tool.JobTakeTimeUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JobStateChangeUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.JobStateChangeUtil");
    private static Comparator<Map<String, Object>> comparator = new Comparator<Map<String, Object>>(){

        @Override
        public int compare(Map<String, Object> paramT1, Map<String, Object> paramT2) {
            try {
                long d1 = ((Date)paramT1.get("FCOMPLETETME")).getTime();
                long d2 = ((Date)paramT2.get("FCOMPLETETME")).getTime();
                if (d1 == d2) {
                    return 0;
                }
                return d1 < d2 ? 1 : -1;
            }
            catch (Exception e) {
                logger.error((Object)e);
                return 0;
            }
        }
    };

    public static void jobStateChange(Context ctx, JobInfo jobInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message) throws EASBizException, BOSException {
        JobStateChangeUtil.jobStateChange(ctx, jobInfo, userInfo, operation, oldJobState, newJobState, messageState, message, null);
    }

    public static void updatePrevJobIsMiss(Context ctx, JobInfo jobInfo) {
        String billId = jobInfo.getBillID();
        int level = jobInfo.getLevel();
        StringBuffer sql = new StringBuffer("SELECT FID FROM t_ssc_jobhis where FBILLID = ? and FLEVEL < ? order by FCOMPLETETME desc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId, level});
            if (rs.next()) {
                sql = new StringBuffer("update t_ssc_jobhisext set FIsMissJob = ? where fjobid = ?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, rs.getString("FID")});
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void updatePrevOperat(Context ctx, JobInfo jobInfo) {
        try {
            Map<String, String> map;
            String bussAttrId = jobInfo.getBussAttrID().getId().toString();
            String billId = jobInfo.getBillID();
            String jobId = jobInfo.getId().toString();
            StringBuffer buf = new StringBuffer(500);
            buf.append(" select (SELECT max(FCHANGETIME) ");
            buf.append(" FROM t_ssc_jobstatetime ");
            buf.append("  WHERE JOB.FID = FJOBIDID ");
            buf.append(" AND JOB.FJobState = FNEWJOBSTATE) AS CHANGETIME, ");
            buf.append(" (SELECT max(FMESSAGES) ");
            buf.append(" FROM t_ssc_jobstatetime ");
            buf.append(" WHERE FCHANGETIME = ");
            buf.append(" (SELECT max(FCHANGETIME) ");
            buf.append(" FROM t_ssc_jobstatetime ");
            buf.append(" WHERE JOB.FID = FJOBIDID ");
            buf.append(" AND JOB.FJobState = FNEWJOBSTATE) ");
            buf.append(" AND JOB.FID = FJOBIDID ");
            buf.append(" AND JOB.FJobState = FNEWJOBSTATE) MESSAGES ");
            buf.append(" from T_SSC_Job JOB ");
            buf.append(" WHERE JOB.FID = ? ");
            IRowSet rsBuf = DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (Object[])new Object[]{jobId});
            Timestamp changetime = new Timestamp(new Date().getTime());
            String messages = "";
            if (rsBuf.next()) {
                changetime = rsBuf.getTimestamp(1);
                messages = rsBuf.getString(2);
            }
            StringBuffer sql = new StringBuffer("SELECT FPERSONNELIDID,FBUSSATTRIDID ,FBILLID ,FCOMPLETETME,FID  FROM t_ssc_jobhis where FBILLID = ?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
            ArrayList<Map<String, String>> rsList = new ArrayList<Map<String, String>>();
            while (rs.next()) {
                if (bussAttrId.equals(rs.getString("FBUSSATTRIDID"))) continue;
                map = new HashMap<String, String>(2);
                map.put("FPERSONNELIDID", rs.getString("FPERSONNELIDID"));
                map.put("FCOMPLETETME", (String)rs.getObject("FCOMPLETETME"));
                map.put("FID", rs.getString("FID"));
                rsList.add(map);
            }
            if (!rsList.isEmpty()) {
                Collections.sort(rsList, comparator);
                sql.setLength(0);
                map = (Map)rsList.get(0);
                sql.append("update t_ssc_jobext set fprevOperatorId = ?,fprevJobId = ?,fchangeTime = ?,fmessages = ? where fjobid = ?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{map.get("FPERSONNELIDID"), map.get("FID"), changetime, messages, jobId});
            } else {
                sql.setLength(0);
                sql.append("update t_ssc_jobext set fchangeTime = ?,fmessages = ? where fjobid = ?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{changetime, messages, jobId});
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void jobStateChange(Context ctx, JobInfo jobInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message, String innerMsg) throws EASBizException, BOSException {
        jobInfo.setJobState(newJobState);
        JobStateChangeUtil.getIJob(ctx).update((IObjectPK)new ObjectUuidPK(jobInfo.getId()), (CoreBaseInfo)jobInfo);
        JobStateChangeUtil.addJobStateTime(ctx, jobInfo, userInfo, operation, oldJobState, newJobState, messageState, message, innerMsg);
        JobStateChangeUtil.updatePrevOperat(ctx, jobInfo);
        JobStateChangeUtil.addJobTakeTime(ctx, jobInfo, userInfo, operation, oldJobState, newJobState, message, innerMsg, true);
    }

    public static void addJobTakeTime(Context ctx, JobInfo jobInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, String message, String innerMsg, boolean isProcess) throws BOSException, EASBizException {
        if (operation.getValue() == "5" || operation.getValue() == "3") {
            JobTakeTimeInfo jobTakeTimeInfo = new JobTakeTimeInfo();
            jobTakeTimeInfo.setJobId(jobInfo.getId().toString());
            jobTakeTimeInfo.setOrgId(jobInfo.getOrgID().getId().toString());
            jobTakeTimeInfo.setBillId(jobInfo.getBillID());
            jobTakeTimeInfo.setBussId(jobInfo.getBussAttrID().getId().toString());
            jobTakeTimeInfo.setSubject(jobInfo.getSubject());
            jobTakeTimeInfo.setShareCenter(jobInfo.getShareCenterID().getId().toString());
            jobTakeTimeInfo.setReceiveTime(jobInfo.getReceiveTime());
            jobTakeTimeInfo.setCompleteTme(jobInfo.getCompleteTme());
            jobTakeTimeInfo.setOperatorId(userInfo.getId().toString());
            jobTakeTimeInfo.setReason(message);
            jobTakeTimeInfo.setBegin(new Timestamp(System.currentTimeMillis()));
            if ("3" == operation.getValue()) {
                jobTakeTimeInfo.setType(TakeTimeType.pause);
            } else {
                jobTakeTimeInfo.setType(TakeTimeType.rescan);
            }
            jobTakeTimeInfo.setIsProcess(isProcess);
            JobTakeTimeFactory.getLocalInstance(ctx).addnew(jobTakeTimeInfo);
        }
        if (operation.getValue() == "4" || operation.getValue() == "16") {
            String type = "pause";
            type = "4" == operation.getValue() ? "pause" : "rescan";
            JobTakeTimeCollection jobTakeTimeColl = JobTakeTimeFactory.getLocalInstance(ctx).getJobTakeTimeCollection(" where jobId = '" + jobInfo.getId().toString() + "' and type = '" + type + "'  order by createtime desc ");
            if (jobTakeTimeColl == null || jobTakeTimeColl.size() < 1) {
                return;
            }
            JobTakeTimeInfo jobTakeTimeInfo = jobTakeTimeColl.get(0);
            JobStateTimeCollection coll = JobStateTimeFactory.getLocalInstance(ctx).getJobStateTimeCollection("select *,jobID.shareCenterId where jobID = '" + jobInfo.getId().toString() + "' order by changeTime desc ");
            JobTakeTimeUtil jttu = new JobTakeTimeUtil();
            Map<String, Object> map = jttu.getTakeTime(ctx, coll);
            jobTakeTimeInfo.setEnd(new Timestamp(System.currentTimeMillis()));
            jobTakeTimeInfo.setTakeTime((BigDecimal)map.get("takeTime"));
            JobTakeTimeFactory.getLocalInstance(ctx).save((CoreBaseInfo)jobTakeTimeInfo);
        }
    }

    public static void addJobStateTime(Context ctx, JobInfo jobInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message) throws EASBizException, BOSException {
        JobStateChangeUtil.addJobStateTime(ctx, jobInfo, userInfo, operation, oldJobState, newJobState, messageState, message, null);
        JobStateChangeUtil.addJobTakeTime(ctx, jobInfo, userInfo, operation, oldJobState, newJobState, message, "", true);
    }

    public static void addBatchJobStateTime(Context ctx, List<JobInfo> jobInfos, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message, String innerMsg) throws EASBizException, BOSException {
        CoreBaseCollection core = new CoreBaseCollection();
        JobStateTimeInfo jobStateTimeInfo = null;
        for (int i = 0; i < jobInfos.size(); ++i) {
            String deciId;
            JobInfo jobInfo = jobInfos.get(i);
            jobStateTimeInfo = new JobStateTimeInfo();
            jobStateTimeInfo.setBillId(jobInfo.getBillID());
            jobStateTimeInfo.setJobID(jobInfo);
            if (oldJobState == null) {
                oldJobState = jobInfo.getJobState();
            }
            jobStateTimeInfo.setOldJobState(oldJobState);
            if (newJobState == null) {
                newJobState = jobInfo.getJobState();
            }
            jobStateTimeInfo.setNewJobState(newJobState);
            jobStateTimeInfo.setMessages(message);
            jobStateTimeInfo.setMessageState(messageState);
            jobStateTimeInfo.setOperatorID(userInfo);
            jobStateTimeInfo.setOperation(operation);
            jobStateTimeInfo.setBussAttr(jobInfo.getBussAttrID());
            jobStateTimeInfo.setChangeTime(new Timestamp(System.currentTimeMillis()));
            DecisionItemInfo jobDec = jobInfo.getDecision();
            if (jobDec == null && !StringUtils.isEmpty((String)(deciId = jobInfo.getString("decision")))) {
                jobDec = new DecisionItemInfo();
                jobDec.setId(BOSUuid.read((String)deciId));
            }
            jobStateTimeInfo.setDecision(jobDec);
            jobStateTimeInfo.setInnerMsg(innerMsg);
            core.add((CoreBaseInfo)jobStateTimeInfo);
        }
        JobStateChangeUtil.getIJobStateTime(ctx).addnewBatchData(core);
    }

    public static void addJobStateTime(Context ctx, JobInfo jobInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message, String innerMsg) throws EASBizException, BOSException {
        ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>();
        jobInfos.add(jobInfo);
        JobStateChangeUtil.addBatchJobStateTime(ctx, jobInfos, userInfo, operation, oldJobState, newJobState, messageState, message, innerMsg);
    }

    public static void addJobStateHisTime(Context ctx, JobHisInfo jobHisInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, MessageState messageState, String message, String innerMsg) throws EASBizException, BOSException {
        String deciId;
        JobStaTimHisInfo jobStaTimHisInfo = new JobStaTimHisInfo();
        jobStaTimHisInfo.setBillId(jobHisInfo.getBillID());
        jobStaTimHisInfo.setJobID(jobHisInfo);
        jobStaTimHisInfo.setOldJobState(oldJobState);
        jobStaTimHisInfo.setNewJobState(newJobState);
        jobStaTimHisInfo.setMessages(message);
        jobStaTimHisInfo.setMessageState(messageState);
        jobStaTimHisInfo.setOperatorID(userInfo);
        jobStaTimHisInfo.setOperation(operation);
        jobStaTimHisInfo.setBussAttr(jobHisInfo.getBussAttrID());
        jobStaTimHisInfo.setChangeTime(new Time(System.currentTimeMillis()));
        DecisionItemInfo jobDec = jobHisInfo.getDecision();
        if (jobDec == null && !StringUtils.isEmpty((String)(deciId = jobHisInfo.getString("decision")))) {
            jobDec = new DecisionItemInfo();
            jobDec.setId(BOSUuid.read((String)deciId));
        }
        jobStaTimHisInfo.setDecision(jobDec);
        jobStaTimHisInfo.setInnerMsg(innerMsg);
        JobStaTimHisFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)jobStaTimHisInfo);
        JobStateChangeUtil.addJobTakeTime(ctx, jobHisInfo, userInfo, operation, oldJobState, newJobState, message, innerMsg, false);
    }

    public static void addJobTakeTime(Context ctx, JobHisInfo jobHisInfo, UserInfo userInfo, Operation operation, JobState oldJobState, JobState newJobState, String message, String innerMsg, boolean isProcess) throws BOSException, EASBizException {
        if (operation.getValue() == "5" || operation.getValue() == "3") {
            JobTakeTimeInfo jobTakeTimeInfo = new JobTakeTimeInfo();
            jobTakeTimeInfo.setJobId(jobHisInfo.getId().toString());
            jobTakeTimeInfo.setOrgId(jobHisInfo.getOrgID().getId().toString());
            jobTakeTimeInfo.setBillId(jobHisInfo.getBillID());
            jobTakeTimeInfo.setBussId(jobHisInfo.getBussAttrID().getId().toString());
            jobTakeTimeInfo.setSubject(jobHisInfo.getSubject());
            jobTakeTimeInfo.setShareCenter(jobHisInfo.getShareCenterID().getId().toString());
            jobTakeTimeInfo.setReceiveTime(jobHisInfo.getReceiveTime());
            jobTakeTimeInfo.setCompleteTme(jobHisInfo.getCompleteTme());
            jobTakeTimeInfo.setOperatorId(userInfo.getId().toString());
            jobTakeTimeInfo.setReason(message);
            jobTakeTimeInfo.setBegin(new Timestamp(System.currentTimeMillis()));
            if ("3" == operation.getValue()) {
                jobTakeTimeInfo.setType(TakeTimeType.pause);
            } else {
                jobTakeTimeInfo.setType(TakeTimeType.rescan);
            }
            jobTakeTimeInfo.setIsProcess(isProcess);
            JobTakeTimeFactory.getLocalInstance(ctx).addnew(jobTakeTimeInfo);
        }
        if (operation.getValue() == "4" || operation.getValue() == "16") {
            String type = "pause";
            type = "4" == operation.getValue() ? "pause" : "rescan";
            JobTakeTimeCollection jobTakeTimeColl = JobTakeTimeFactory.getLocalInstance(ctx).getJobTakeTimeCollection(" where jobId = '" + jobHisInfo.getId().toString() + "' and type = '" + type + "'  order by createtime desc ");
            if (jobTakeTimeColl == null || jobTakeTimeColl.size() < 1) {
                return;
            }
            JobTakeTimeInfo jobTakeTimeInfo = jobTakeTimeColl.get(0);
            JobStaTimHisCollection coll = JobStaTimHisFactory.getLocalInstance(ctx).getJobStaTimHisCollection("select *,jobID.shareCenterId where jobID = '" + jobHisInfo.getId().toString() + "' order by changeTime desc ");
            JobTakeTimeUtil jttu = new JobTakeTimeUtil();
            Map<String, Object> map = jttu.getTakeTime(ctx, coll);
            jobTakeTimeInfo.setEnd(new Timestamp(System.currentTimeMillis()));
            jobTakeTimeInfo.setTakeTime((BigDecimal)map.get("takeTime"));
            JobTakeTimeFactory.getLocalInstance(ctx).save((CoreBaseInfo)jobTakeTimeInfo);
        }
    }

    private static IJob getIJob(Context ctx) throws BOSException {
        if (ctx == null) {
            return JobFactory.getRemoteInstance();
        }
        return JobFactory.getLocalInstance(ctx);
    }

    private static IJobStateTime getIJobStateTime(Context ctx) throws BOSException {
        if (ctx == null) {
            return JobStateTimeFactory.getRemoteInstance();
        }
        return JobStateTimeFactory.getLocalInstance(ctx);
    }
}

