/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleOrgCollection;
import com.kingdee.eas.base.ssc.RoleOrgFactory;
import com.kingdee.eas.base.ssc.RoleOrgInfo;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AllotRoleOrgThread {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.AllotRoleOrgThread");
    private Context ctx;
    private String roleId;
    private OrgCollection orgColl;
    private OrgCollection orgColl_new;
    private OrgCollection allOrgColl = new OrgCollection();

    public AllotRoleOrgThread(Context ctx, String roleId, OrgCollection orgColl) {
        this.ctx = ctx;
        this.roleId = roleId;
        this.orgColl = orgColl;
    }

    public void goRun() {
        this.setOrgInfoId(this.ctx);
        for (int i = 0; i < this.orgColl.size(); ++i) {
            OrgCollection newOrgColl = this.getAllChildOrg(this.ctx, this.orgColl.get(i));
            this.allOrgColl.addCollection(newOrgColl);
        }
        RoleOrgCollection allRoleOrgColl = this.getAllRoleOrgColl(this.ctx, this.roleId);
        RoleOrgCollection oldRoleOrgColl = this.getOldRoleOrgColl(this.ctx, this.roleId);
        CoreBaseCollection needAddRoleOrgColl = this.removeRepeatedRoleOrg(allRoleOrgColl, oldRoleOrgColl);
        try {
            RoleOrgFactory.getLocalInstance(this.ctx).addnewBatchData(needAddRoleOrgColl);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private CoreBaseCollection removeRepeatedRoleOrg(RoleOrgCollection allRoleOrgColl, RoleOrgCollection oldRoleOrgColl) {
        CoreBaseCollection needAddRoleOrgColl = new CoreBaseCollection();
        for (int i = 0; i < allRoleOrgColl.size(); ++i) {
            String roleid = allRoleOrgColl.get(i).getRoleID().getId().toString();
            String orgid = allRoleOrgColl.get(i).getOrgID().getId().toString();
            String oldroleid = "";
            String oldorgid = "";
            boolean isOldRaletionFlag = false;
            for (int j = 0; j < oldRoleOrgColl.size(); ++j) {
                oldroleid = oldRoleOrgColl.get(j).getRoleID().getId().toString();
                oldorgid = oldRoleOrgColl.get(j).getOrgID().getId().toString();
                if (!roleid.equals(oldroleid) || !orgid.equals(oldorgid)) continue;
                isOldRaletionFlag = true;
                break;
            }
            if (isOldRaletionFlag) continue;
            needAddRoleOrgColl.add((CoreBaseInfo)allRoleOrgColl.get(i));
        }
        return needAddRoleOrgColl;
    }

    private RoleOrgCollection getOldRoleOrgColl(Context ctx, String roleId) {
        RoleOrgCollection oldRoleOrgColl = new RoleOrgCollection();
        String oql = "select roleID,orgID where roleID='" + roleId + "'";
        try {
            oldRoleOrgColl = RoleOrgFactory.getLocalInstance(ctx).getRoleOrgCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return oldRoleOrgColl;
    }

    private RoleOrgCollection getAllRoleOrgColl(Context ctx, String roleId) {
        RoleOrgCollection roleOrgColl = new RoleOrgCollection();
        RoleInfo roleInfo = new RoleInfo();
        roleInfo.setId(BOSUuid.read((String)roleId));
        for (int i = 0; i < this.allOrgColl.size(); ++i) {
            RoleOrgInfo roleOrgInfo = new RoleOrgInfo();
            roleOrgInfo.setRoleID(roleInfo);
            roleOrgInfo.setOrgID(this.allOrgColl.get(i));
            FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)roleOrgInfo);
            roleOrgColl.add(roleOrgInfo);
        }
        return roleOrgColl;
    }

    private void setOrgInfoId(Context ctx) {
        String sql = "select fid from t_ssc_org where forgid= ?";
        IRowSet rs = null;
        for (int i = 0; i < this.orgColl.size(); ++i) {
            BOSUuid id = this.orgColl.get(i).getId();
            if (null != id && StringUtils.isNotBlank((String)id.toString())) continue;
            Object[] params = new Object[]{this.orgColl.get(i).getOrgID()};
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (!rs.next()) continue;
                this.orgColl.get(i).setId(BOSUuid.read((String)rs.getString("fid")));
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private OrgCollection getAllChildOrg(Context ctx, OrgInfo orgInfo) {
        this.orgColl_new = new OrgCollection();
        this.getAllOrg(ctx, orgInfo);
        this.orgColl_new.add(orgInfo);
        return this.orgColl_new;
    }

    private OrgCollection getAllOrg(Context ctx, OrgInfo orgInfo) {
        OrgCollection children = new OrgCollection();
        String oql = "where parent = '" + orgInfo.getOrgID() + "'";
        try {
            children = OrgFactory.getLocalInstance(ctx).getOrgCollection(oql);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.addChildToOrgColl(children);
        return this.getAllOrg(ctx, children);
    }

    private OrgCollection getAllOrg(Context ctx, OrgCollection orgCollection) {
        OrgCollection result = new OrgCollection();
        if (orgCollection == null) {
            return null;
        }
        for (int i = 0; i < orgCollection.size(); ++i) {
            OrgCollection children = this.getAllOrg(ctx, orgCollection.get(i));
            if (children == null || children.isEmpty()) continue;
            this.addChildToOrgColl(children);
            result.addCollection(children);
        }
        return result;
    }

    private void addChildToOrgColl(OrgCollection children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            OrgInfo org = children.get(i);
            if (this.orgColl_new.contains(org)) {
                throw new IllegalArgumentException("\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6b7b\u5faa\u73af\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            this.orgColl_new.add(org);
        }
    }
}

