/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.ssc.AuthBillState;
import com.kingdee.eas.base.ssc.AuthChangeType;
import com.kingdee.eas.base.ssc.AuthorityBillEntryCollection;
import com.kingdee.eas.base.ssc.AuthorityBillEntryInfo;
import com.kingdee.eas.base.ssc.AuthorityBillFactory;
import com.kingdee.eas.base.ssc.AuthorityBillInfo;
import com.kingdee.eas.base.ssc.app.AbstractAuthBillFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuthBillFacadeControllerBean
extends AbstractAuthBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.AuthBillFacadeControllerBean");
    protected String separator = ",";

    @Override
    protected String _approveAuthBill(Context ctx, BOSUuid bosUuid) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        AuthorityBillInfo authBillModel = AuthorityBillFactory.getLocalInstance(ctx).getAuthorityBillInfo(H.PK(bosUuid));
        if (AuthBillState.Save.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade1", (Locale)ctx.getLocale())));
        }
        if (AuthBillState.Approved.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade2", (Locale)ctx.getLocale())));
        }
        if (AuthBillState.Discard.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade3", (Locale)ctx.getLocale())));
        }
        authBillModel.setReviewer(ShareCenterUtils.getSSCUserInfoByCtx(ctx));
        authBillModel.setBillState(AuthBillState.Approved);
        AuthorityBillFactory.getLocalInstance(ctx).update(H.PK(bosUuid.toString()), authBillModel);
        this.assignUserRole(ctx, authBillModel);
        resultMap.put("result", true);
        resultMap.put("message", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade4", (Locale)ctx.getLocale()));
        return JSONUtil.map2json(resultMap);
    }

    protected void assignUserRole(Context ctx, AuthorityBillInfo authBillModel) throws BOSException {
        AuthorityBillEntryCollection entryColl = authBillModel.getAuthEntry();
        AuthChangeType changeType = authBillModel.getAuthChangeType();
        for (int i = 0; i < entryColl.size(); ++i) {
            AuthorityBillEntryInfo entryInfo = entryColl.get(i);
            String roleIds = entryInfo.getRoleIds();
            String userIds = entryInfo.getUserIds();
            List roleIdList = (List)JSON.parse((String)roleIds);
            List userIdList = (List)JSON.parse((String)userIds);
            if (AuthChangeType.addNew.equals((Object)changeType)) {
                this.addNewAuth(ctx, roleIdList, userIdList);
                continue;
            }
            this.cancelAuth(ctx, roleIdList, userIdList);
        }
    }

    protected void cancelAuth(Context ctx, List<String> roleIdList, List<String> userIdList) throws BOSException {
        String sql = "DELETE FROM T_ssc_roleuser WHERE  FROLEIDID =? and FUSERIDID =? ";
        List<Object[]> paramList = this.getDelSqlParams(ctx, roleIdList, userIdList);
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    protected List<Object[]> getDelSqlParams(Context ctx, List<String> roleIdList, List<String> userIdList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (String roleId : roleIdList) {
            for (String userId : userIdList) {
                Object[] objs = new Object[]{roleId, userId};
                paramList.add(objs);
            }
        }
        return paramList;
    }

    protected List<Object[]> getInsertSqlParams(Context ctx, List<String> roleIdList, List<String> userIdList) {
        String easUserId = ShareCenterUtils.getEASUserInfoByCtx(ctx);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Set<String> set = this.existPermission(ctx, roleIdList, userIdList);
        for (String roleId : roleIdList) {
            for (String userId : userIdList) {
                if (set.contains(roleId + this.separator + userId)) continue;
                Object[] objs = new Object[]{roleId, userId, easUserId, easUserId};
                paramList.add(objs);
            }
        }
        return paramList;
    }

    protected Set<String> existPermission(Context ctx, List<String> roleIdList, List<String> userIdList) {
        HashSet<String> existSet = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        builder.append(" SELECT froleidid,fuseridid FROM t_ssc_roleuser ").append(" WHERE  froleidid in ").append(FormatUtils.list2Sql(roleIdList)).append(" AND fuseridid in ").append(FormatUtils.list2Sql(userIdList));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString());
            while (rowSet.next()) {
                existSet.add(rowSet.getString(1) + this.separator + rowSet.getString(2));
            }
        }
        catch (Exception e) {
            logger.error((Object)("existPermission--sql+ " + builder.toString()));
            logger.error((Object)e);
        }
        return existSet;
    }

    protected void addNewAuth(Context ctx, List<String> roleIdList, List<String> userIdList) throws BOSException {
        String sql = "INSERT INTO t_ssc_roleuser (FID ,FROLEIDID ,FUSERIDID ,FCREATETIME ,FCREATORID ,FLASTUPDATETIME ,FLASTUPDATEUSERID, FBYGROUP  ) VALUES ( newbosid('2D16C411'),?,?,now(),?,now(),?,0) ";
        List<Object[]> paramList = this.getInsertSqlParams(ctx, roleIdList, userIdList);
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    @Override
    protected String _discardAuthBill(Context ctx, BOSUuid bosUuid) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        AuthorityBillInfo authBillModel = AuthorityBillFactory.getLocalInstance(ctx).getAuthorityBillInfo(H.PK(bosUuid));
        if (AuthBillState.Save.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade5", (Locale)ctx.getLocale())));
        }
        if (AuthBillState.Approved.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade6", (Locale)ctx.getLocale())));
        }
        if (AuthBillState.Discard.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade7", (Locale)ctx.getLocale())));
        }
        authBillModel.setBillState(AuthBillState.Discard);
        AuthorityBillFactory.getLocalInstance(ctx).update(H.PK(bosUuid.toString()), authBillModel);
        resultMap.put("result", true);
        resultMap.put("message", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade4", (Locale)ctx.getLocale()));
        return JSONUtil.map2json(resultMap);
    }

    @Override
    protected Map _deleteAuthBill(Context ctx, Map params) throws BOSException, EASBizException {
        String authBillId = (String)params.get("authBillId");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        AuthorityBillInfo authBillModel = AuthorityBillFactory.getLocalInstance(ctx).getAuthorityBillInfo(H.PK(authBillId));
        if (AuthBillState.Submit.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade8", (Locale)ctx.getLocale())));
        }
        if (AuthBillState.Approved.equals((Object)authBillModel.getBillState())) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade9", (Locale)ctx.getLocale())));
        }
        AuthorityBillFactory.getLocalInstance(ctx).delete(H.PK(authBillId));
        resultMap.put("result", true);
        resultMap.put("message", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade4", (Locale)ctx.getLocale()));
        return resultMap;
    }

    @Override
    protected String _genAuthBillNum(Context ctx, IObjectValue authBillInfo) throws BOSException, EASBizException {
        String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(authBillInfo, "");
        if (StringUtils.isEmpty((String)number)) {
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.ssc.AuthBillResource", (String)"AuthBillFacade10", (Locale)ctx.getLocale())));
        }
        return number;
    }
}

