/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.AbstractCockpitMangeFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CockpitMangeFacadeControllerBean
extends AbstractCockpitMangeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CockpitMangeFacadeControllerBean");

    @Override
    protected Map _getCockpitData(Context ctx, String type, String billTypeIds, String shareCenterId) throws BOSException, EASBizException {
        String billTypeStr = "";
        if (StringUtils.isNotBlank((CharSequence)billTypeIds)) {
            billTypeStr = FormatUtils.str2Sql(billTypeIds.split(","));
            billTypeStr = billTypeStr.equals("('')") ? "" : billTypeStr;
        }
        HashMap<String, List<Map<String, String>>> cockpitMap = new HashMap<String, List<Map<String, String>>>();
        cockpitMap.put("pressureMonitor", this.getPressureMonitorData(ctx, type, billTypeStr, shareCenterId));
        return cockpitMap;
    }

    private List<Map<String, String>> getTreatedData(Context ctx, String type, String billTypeIds, String shareCenterId, String billTypeStr) {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("");
        sb.append("");
        sb.append("");
        return null;
    }

    private List<Map<String, String>> getUntreatedData(Context ctx, String type, String billTypeIds, String shareCenterId, String billTypeStr) {
        ArrayList<Map<String, String>> treatedList = new ArrayList<Map<String, String>>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select ba.fid id,ba.fname_l2 name,map.fcount count,map.famount amount");
        sb.append(" from t_ssc_bussinessattribute ba,");
        sb.append(" (select fbussattridid,count(1) fcount,sum(famount) famount from t_ssc_job where fsharecenterid = ? group by fbussattridid) map");
        sb.append(" where ba.fid = map.fbussattridid");
        if (StringUtils.isNotBlank((CharSequence)billTypeStr)) {
            sb.append(" and ba.fid in " + billTypeStr);
        }
        Object[] params = new Object[]{shareCenterId};
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            while (rs.next()) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("id", rs.getString(1));
                tempMap.put("name", rs.getString(2));
                tempMap.put("count", rs.getString(3));
                tempMap.put("amount", rs.getString(4));
                treatedList.add(tempMap);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)("sql:" + sb.toString()), (Throwable)e);
        }
        return treatedList;
    }

    private List<Map<String, String>> getPressureMonitorData(Context ctx, String type, String billTypeStr, String shareCenterId) {
        Object[] params;
        ArrayList<Map<String, String>> pressureMonitorList = new ArrayList<Map<String, String>>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select sum(less8) less8Count,sum(greater8) greater8Count,sum(less8amount) less8Amount,sum(greater8amount) greater8Amount");
        sb.append(" from (");
        sb.append(" select");
        sb.append(" (case when fremaindertime <= 8 then 1 else 0 end) less8,");
        sb.append(" (case when fremaindertime > 8 then 1 else 0 end) greater8,");
        sb.append(" (case when fremaindertime <= 8 then famount else 0 end) less8amount,");
        sb.append(" (case when fremaindertime > 8 then famount else 0 end) greater8amount");
        sb.append(" from t_ssc_job");
        sb.append(" where fjobpoolingtype = '2' ");
        if (StringUtils.isNotBlank((CharSequence)shareCenterId)) {
            sb.append(" and fsharecenterid = ? ");
            params = new Object[]{shareCenterId};
        } else {
            sb.append(" and fsharecenterid = '' or fsharecenterid is null");
            params = new Object[]{};
        }
        if (StringUtils.isNotBlank((CharSequence)billTypeStr)) {
            sb.append(" and fbussattridid in ( ");
            sb.append(" select fid from t_ssc_bussinessattribute ba where ba.fbilltypeid in " + billTypeStr);
            sb.append(" )");
        }
        sb.append(" ) a");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            if (rs.next()) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("less8Count", rs.getString(1));
                tempMap.put("greater8Count", rs.getString(2));
                tempMap.put("less8Amount", rs.getString(3));
                tempMap.put("greater8Amount", rs.getString(4));
                pressureMonitorList.add(tempMap);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)("sql:" + sb.toString()), (Throwable)e);
        }
        return pressureMonitorList;
    }

    private List<Map<String, String>> get3DayLaterUntreatedData(Context ctx, String type, String billTypeIds, String shareCenterId, String billTypeStr) {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        sb.append("");
        sb.append("");
        sb.append("");
        sb.append("");
        return null;
    }
}

