/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.ConsignationEntryCollection;
import com.kingdee.eas.base.ssc.ConsignationEntryInfo;
import com.kingdee.eas.base.ssc.ConsignationInfo;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.app.AbstractConsignationFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConsignationFacadeControllerBean
extends AbstractConsignationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.ConsignationFacadeControllerBean");

    @Override
    protected ConsignationInfo _createWebConsignationInfo(Context ctx, String id) throws BOSException, EASBizException {
        return this.createConsignationInfo(ctx, id);
    }

    @Override
    protected ConsignationInfo _getBussAttrType(Context ctx, String assId) throws BOSException, EASBizException {
        return this.createConsignationInfo(ctx, assId);
    }

    private ConsignationInfo createConsignationInfo(Context ctx, String userId) throws BOSException, EASBizException {
        ConsignationInfo conInfo = new ConsignationInfo();
        ConsignationEntryCollection entry = conInfo.getEntrys();
        this.setBussTypeToEntry(ctx, userId, entry);
        IRowSet rsQuality = SSCUtil.getConsignationRowSetByparam(ctx, userId, "ROLE_AUDIT");
        IRowSet rsSpotCheck = SSCUtil.getConsignationRowSetByparam(ctx, userId, "ROLE_LATER");
        this.setBillTypeToEntry(ctx, rsQuality, entry, ConsignationTaskTypeEnum.qualityJob);
        this.setBillTypeToEntry(ctx, rsSpotCheck, entry, ConsignationTaskTypeEnum.spotCheckJob);
        return conInfo;
    }

    private void setBussTypeToEntry(Context ctx, String userId, ConsignationEntryCollection entry) throws BOSException, EASBizException {
        HashMap<String, String> bussIds = new HashMap<String, String>(10);
        IRowSet rs = SSCUtil.getConsignationRowSet(ctx, userId);
        try {
            while (rs.next()) {
                bussIds.put(rs.getString("id"), rs.getString("number"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Set keys = bussIds.keySet();
        if (keys != null) {
            for (Object key : keys) {
                Object value = bussIds.get(key);
                BussinessAttributeInfo info = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo((IObjectPK)new ObjectStringPK(key.toString()));
                ConsignationEntryInfo entryInfo = new ConsignationEntryInfo();
                entryInfo.setBussType(info);
                entryInfo.setBussNum(value.toString());
                entryInfo.setTaskType(ConsignationTaskTypeEnum.shareJob);
                entry.add(entryInfo);
            }
        }
    }

    private void setBillTypeToEntry(Context ctx, IRowSet rs, ConsignationEntryCollection entry, ConsignationTaskTypeEnum jobType) throws BOSException, EASBizException {
        HashMap<String, String> BillTypeIds = new HashMap<String, String>(10);
        try {
            while (rs.next()) {
                BillTypeIds.put(rs.getString("id"), rs.getString("number"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Set keys = BillTypeIds.keySet();
        if (keys != null) {
            for (Object key : keys) {
                Object value = BillTypeIds.get(key);
                BillTypeInfo info = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo((IObjectPK)new ObjectStringPK(key.toString()));
                ConsignationEntryInfo entryInfo = new ConsignationEntryInfo();
                entryInfo.setBillType(info);
                entryInfo.setBussNum(value.toString());
                entryInfo.setTaskType(jobType);
                entry.add(entryInfo);
            }
        }
    }
}

