/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.JobHisFactory;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFactory;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskInfo;
import com.kingdee.eas.base.ssc.app.AbstractCreditLogControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class CreditLogControllerBean
extends AbstractCreditLogControllerBean {
    private static final long serialVersionUID = 5495138114416752845L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CreditLogControllerBean");

    private CreditLogInfo getCreditLog(Context ctx, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, ChangeSourceEnum changeSourceEnum, CreditChangeTypeEnum creditChangeTypeEnum) {
        CreditLogInfo tCreditLogInfo = new CreditLogInfo();
        tCreditLogInfo.setCreditFilesNew(newCreditFilesInfo);
        tCreditLogInfo.setOriginalGrade(oldCreditFilesInfo.getCreditRating());
        BigDecimal oldScore = oldCreditFilesInfo.getCreditScore();
        tCreditLogInfo.setOriginalScore(oldScore);
        tCreditLogInfo.setCurrentGrade(newCreditFilesInfo.getCreditRating());
        BigDecimal currentScore = newCreditFilesInfo.getCreditScore();
        tCreditLogInfo.setCurrentScore(currentScore);
        tCreditLogInfo.setChangeScore(oldScore.subtract(currentScore).abs());
        tCreditLogInfo.setChangeDate(new Date());
        int changeGrade = oldCreditFilesInfo.getCreditRating().getSeqNo() - newCreditFilesInfo.getCreditRating().getSeqNo();
        tCreditLogInfo.setChangGrade(Math.abs(changeGrade));
        tCreditLogInfo.setChangeSource(changeSourceEnum);
        tCreditLogInfo.setCreditChangeType(creditChangeTypeEnum);
        return tCreditLogInfo;
    }

    private void setCreditLogSubjectBySampleId(Context ctx, String sampleLibraryQualityTaskId, CreditLogInfo creditLogInfo) {
        try {
            SampleLibraryQualityTaskInfo sampleLibraryQualityTaskInfo = SampleLibraryQualityTaskFactory.getLocalInstance(ctx).getSampleLibraryQualityTaskInfo("select subject,billId where id='" + sampleLibraryQualityTaskId + "'");
            creditLogInfo.setBillID(sampleLibraryQualityTaskInfo.getBillId());
            creditLogInfo.setSubject(sampleLibraryQualityTaskInfo.getSubject());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setCreditLogSubjectByJobId(Context ctx, String jobId, CreditLogInfo creditLogInfo) {
        try {
            if (JobHisFactory.getLocalInstance(ctx).exists("where id='" + jobId + "'")) {
                JobHisInfo jobhisInfo = JobHisFactory.getLocalInstance(ctx).getJobHisInfo("select subject,billID where id='" + jobId + "'");
                creditLogInfo.setBillID(jobhisInfo.getBillID());
                creditLogInfo.setSubject(jobhisInfo.getSubject());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getShareAuditMinusScoreReduceReason(Context ctx, String jobId, String billId) {
        StringBuffer str = new StringBuffer();
        try {
            StringBuffer queryRule = new StringBuffer(500);
            queryRule.append(" select e.FReducereason_" + ctx.getLocale().toString());
            queryRule.append(" from T_SSC_CreditScoreLdRule r left join T_SSC_CreditSLRRSE e on r.fid=e.FParentID");
            queryRule.append(" where r.FLdRoleType=0 and e.FReduceScoreType=1 and e.freasonbygxshid in");
            queryRule.append(" (select FUnpassreaID from T_SSC_JobUnpassRea where fjobid=?)");
            queryRule.append(" and e.FREASONBYGXSHID not in(");
            queryRule.append(" select FUnpassreaID from T_SSC_JobUnpassRea where FJOBID in (");
            queryRule.append(" SELECT FID FROM T_ssc_jobhis where FBILLID = ? and FID != ?");
            queryRule.append(" )");
            queryRule.append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryRule.toString(), (Object[])new Object[]{jobId, billId, jobId});
            while (rs.next()) {
                str.append(rs.getString("FReducereason_" + ctx.getLocale().toString()) + ";");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return str.toString();
    }

    private String getQualityCheckMinusScoreReason(Context ctx, String sampleLibraryQualityTaskId) throws BOSException {
        StringBuffer reason = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FREDUCEREASON_" + ctx.getLocale());
        sb.append(" FROM T_SSC_CreditSLRRSE");
        sb.append(" where FREASONBYSJZJID in(");
        sb.append(" select FUPQUALIFYREASONID from T_SSC_TaskUnpassReason where FTASKID = ?");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{sampleLibraryQualityTaskId});
            while (rs.next()) {
                reason.append(rs.getString(1) + ";");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getQualityCheckMinusScoreReason error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + sampleLibraryQualityTaskId));
        }
        return reason.toString();
    }

    private String getSpotCheckMinusScoreReason(Context ctx, String sampleLibraryQualityTaskId) throws BOSException {
        StringBuffer reason = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FREDUCEREASON_" + ctx.getLocale());
        sb.append(" FROM T_SSC_CreditSLRRSE");
        sb.append(" where FREASONBYGXFHID in(");
        sb.append(" select FUPQUALIFYREASONID from T_SSC_TaskUnpassReason where FTASKID = ?");
        sb.append(" )");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{sampleLibraryQualityTaskId});
            while (rs.next()) {
                reason.append(rs.getString(1) + ";");
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getSpotCheckMinusScoreReason error!");
            logger.error((Object)("sql:" + sb.toString() + ",taskId:" + sampleLibraryQualityTaskId));
        }
        return reason.toString();
    }

    @Override
    protected void _writeShareAuditAddScoreCreditLog(Context ctx, String jobId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        BigDecimal oldscore = oldCreditFilesInfo.getCreditScore();
        BigDecimal newscore = newCreditFilesInfo.getCreditScore();
        CreditChangeTypeEnum type = CreditChangeTypeEnum.bonusPoint;
        if (oldscore.compareTo(newscore) == 1) {
            type = CreditChangeTypeEnum.deduction;
        }
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.sharedAudit, type);
        this.setCreditLogSubjectByJobId(ctx, jobId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    protected void _writeShareAuditMinusScoreCreditLog(Context ctx, String jobId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.sharedAudit, CreditChangeTypeEnum.deduction);
        this.setCreditLogSubjectByJobId(ctx, jobId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    protected void _writeQulityCheckAddScoreCreditLog(Context ctx, String sampleLibraryQualityTaskId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.auditQuality, CreditChangeTypeEnum.bonusPoint);
        this.setCreditLogSubjectBySampleId(ctx, sampleLibraryQualityTaskId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    protected void _writeQulityCheckMinusScoreCreditLog(Context ctx, String sampleLibraryQualityTaskId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.auditQuality, CreditChangeTypeEnum.deduction);
        this.setCreditLogSubjectBySampleId(ctx, sampleLibraryQualityTaskId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    protected void _writeSpotCheckAddScoreCreditLog(Context ctx, String sampleLibraryQualityTaskId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.sharedReview, CreditChangeTypeEnum.bonusPoint);
        this.setCreditLogSubjectBySampleId(ctx, sampleLibraryQualityTaskId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @Override
    protected void _writeSpotCheckMinusScoreCreditLog(Context ctx, String sampleLibraryQualityTaskId, CreditFilesNewInfo oldCreditFilesInfo, CreditFilesNewInfo newCreditFilesInfo, String description) throws BOSException {
        CreditLogInfo creditLogInfo = this.getCreditLog(ctx, oldCreditFilesInfo, newCreditFilesInfo, ChangeSourceEnum.sharedReview, CreditChangeTypeEnum.deduction);
        this.setCreditLogSubjectBySampleId(ctx, sampleLibraryQualityTaskId, creditLogInfo);
        try {
            creditLogInfo.setDescription(description, ctx.getLocale());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)creditLogInfo);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bb0\u5f55\u4fe1\u7528\u65e5\u5fd7\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

