/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.eas.base.ssc.app.AbstractDumpLogFacadeControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DumpLogFacadeControllerBean
extends AbstractDumpLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.DumpLogFacadeControllerBean");
    private int month = 6;

    @Override
    protected void _dumpData(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = DBUtils.getConnection((Context)ctx);
            this.copyDataToLogHisTable(cn);
            this.clearLogs(cn, "t_ssc_ssclog");
            this.copyDataToLogTable(cn);
            this.clearLogs(cn, "t_ssc_ssclogHis");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void copyDataToLogHisTable(Connection cn) throws SQLException {
        Calendar instance = Calendar.getInstance();
        instance.setTime(new Date());
        instance.add(2, -1 * this.month);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String formatTime = df.format(instance.getTime());
        String sql = "INSERT INTO t_ssc_ssclogHis(FJob,FBusAttrID,FApi,FParam,FResponse,FSubject,FSuccess,FOperation,FShareCenterId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID) SELECT FJob,FBusAttrID,FApi,FParam,FResponse,FSubject,FSuccess,FOperation,FShareCenterId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID FROM t_ssc_ssclog WHERE FCREATETIME >={ts'" + formatTime + "'}";
        this.executeSql(cn, sql);
    }

    private void copyDataToLogTable(Connection cn) throws SQLException {
        String sql = "INSERT INTO t_ssc_ssclog(FJob,FBusAttrID,FApi,FParam,FResponse,FSubject,FSuccess,FOperation,FShareCenterId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID) SELECT FJob,FBusAttrID,FApi,FParam,FResponse,FSubject,FSuccess,FOperation,FShareCenterId,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime,FControlUnitID,FID FROM t_ssc_ssclogHis";
        this.executeSql(cn, sql);
    }

    private void clearLogs(Connection cn, String tableName) throws SQLException {
        String sql = " TRUNCATE TABLE " + tableName;
        this.executeSql(cn, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(Connection cn, String sql) throws SQLException {
        try (PreparedStatement ps = null;){
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
    }
}

