/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.SingleTaskOperterFacadeFactory;
import com.kingdee.eas.base.ssc.app.AbstractJobAutoApproveFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class JobAutoApproveFacadeControllerBean
extends AbstractJobAutoApproveFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.JobAutoApproveFacadeControllerBean");
    private static ExecutorService pool = null;

    @Override
    protected void _jobAutoApprove(Context ctxOld) throws BOSException, EASBizException {
        if (pool == null) {
            pool = Executors.newSingleThreadExecutor();
        }
        AutoApproveRunnable autoApprove = new AutoApproveRunnable(){
            Context ctx;

            @Override
            public AutoApproveRunnable setCtx(Context ctx) {
                this.ctx = ctx;
                return this;
            }

            @Override
            public void run() {
                long begnTime = System.currentTimeMillis();
                long endTime = begnTime + 5000L;
                while (!WfEventListenerStateManager.getInstance().isEnable() && endTime < begnTime) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"\u7ebf\u7a0bsleep\u5931\u8d25", (Throwable)e);
                    }
                    begnTime = System.currentTimeMillis();
                }
                if (!WfEventListenerStateManager.getInstance().isEnable()) {
                    logger.error((Object)"\u5de5\u4f5c\u6d41\u76d1\u542c\u672a\u542f\u52a8,\u65e0\u6cd5\u8fdb\u884c\u5de5\u4f5c\u6d41\u5ba1\u6279\u63a5\u53e3\u7684\u8c03\u7528!");
                    return;
                }
                HashMap<String, String> map = new HashMap<String, String>(4);
                List jobIds = JobAutoApproveFacadeControllerBean.this.getAutoApproveJob(this.ctx);
                for (String jobId : jobIds) {
                    ExtendERPInfo erpInfo = null;
                    String userId = null;
                    try {
                        erpInfo = ERPUtil.getExtendERPInfo(this.ctx, jobId);
                        userId = (String)map.get(erpInfo.getId().toString());
                        if (userId == null) {
                            userId = JobUtils.getAutoApproveUserId(this.ctx, jobId, erpInfo);
                            map.put(erpInfo.getId().toString(), userId);
                        }
                    }
                    catch (BOSException e1) {
                        logger.error((Object)("\u81ea\u52a8\u5ba1\u6279\u83b7\u53d6\u81ea\u52a8\u5ba1\u6279\u4ebaException**jobID**" + jobId), (Throwable)e1);
                    }
                    try {
                        String oql = "where job.id = '" + jobId + "'";
                        if (JobExtFactory.getLocalInstance(this.ctx).exists(oql)) {
                            JobExtInfo info = JobExtFactory.getLocalInstance(this.ctx).getJobExtInfo(oql);
                            if (info.getNextAutoAuditTime().getTime() > new Date().getTime()) continue;
                            SingleTaskOperterFacadeFactory.getLocalInstance(this.ctx).approve(jobId, userId, "\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7", true, null);
                            continue;
                        }
                        SingleTaskOperterFacadeFactory.getLocalInstance(this.ctx).approve(jobId, userId, "\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7", true, null);
                    }
                    catch (Exception e) {
                        try {
                            logger.error((Object)("\u5171\u4eab\u4efb\u52a1\u81ea\u52a8\u5ba1\u6279\u4efb\u52a1\u540e\u53f0\u4e8b\u52a1\u5904\u7406Exception**jobID**" + jobId), (Throwable)e);
                            JobExtFactory.getLocalInstance(this.ctx).calculateNextAutoAuditTime(jobId);
                        }
                        catch (Exception e2) {
                            logger.error((Object)e2.getMessage());
                        }
                    }
                }
            }
        };
        pool.execute(autoApprove.setCtx(ctxOld));
    }

    private List<String> getAutoApproveJob(Context ctx) {
        ArrayList<String> jobIds = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(new Date());
        StringBuffer sb = new StringBuffer();
        sb.append(" select j.fid");
        sb.append(" from t_ssc_job j");
        sb.append(" left join t_ssc_jobext je on j.fid = je.fjobid");
        sb.append(" where j.fautoApprove = 1");
        sb.append(" and (je.fNextAutoAuditTime < {ts'" + date + "'} or je.fNextAutoAuditTime is null)");
        sb.append(" and (je.fcheckState <> 2   or je.fcheckState is null)");
        sb.append(" order by je.fautoauditcount asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            for (int i = 0; rs.next() && i < 50; ++i) {
                jobIds.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return jobIds;
    }

    static interface AutoApproveRunnable
    extends Runnable {
        public AutoApproveRunnable setCtx(Context var1);
    }
}

