/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.ssc.DataBaseCfgInfo;
import com.kingdee.eas.base.ssc.MonitorCollection;
import com.kingdee.eas.base.ssc.MonitorFactory;
import com.kingdee.eas.base.ssc.MonitorInfo;
import com.kingdee.eas.base.ssc.MonitorItem;
import com.kingdee.eas.base.ssc.MonitorLogFactory;
import com.kingdee.eas.base.ssc.MonitorLogInfo;
import com.kingdee.eas.base.ssc.MonitorMultiSqlLogCollection;
import com.kingdee.eas.base.ssc.MonitorMultiSqlLogFactory;
import com.kingdee.eas.base.ssc.MonitorMultiSqlLogInfo;
import com.kingdee.eas.base.ssc.ReceiveLetterFactory;
import com.kingdee.eas.base.ssc.ReceiveLetterInfo;
import com.kingdee.eas.base.ssc.SendCloudInfo;
import com.kingdee.eas.base.ssc.SendMailInfo;
import com.kingdee.eas.base.ssc.SendMessageInfo;
import com.kingdee.eas.base.ssc.SendPhoneInfo;
import com.kingdee.eas.base.ssc.SqlEntryCollection;
import com.kingdee.eas.base.ssc.SqlEntryFactory;
import com.kingdee.eas.base.ssc.SqlEntryInfo;
import com.kingdee.eas.base.ssc.app.AbstractMonitorFacadeControllerBean;
import com.kingdee.eas.base.ssc.monitor.core.model.RowModel;
import com.kingdee.eas.base.ssc.monitor.core.result.MontiorSqlResult;
import com.kingdee.eas.base.ssc.monitor.core.service.MontiorSqlCore;
import com.kingdee.eas.base.ssc.monitor.database.AbstractDataBase;
import com.kingdee.eas.base.ssc.monitor.database.DataBaseFactory;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MonitorFacadeControllerBean
extends AbstractMonitorFacadeControllerBean {
    private static final long serialVersionUID = 9086859409375509741L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.MonitorFacadeControllerBean");
    private static final String fontStyleKey = "style";
    private static final String fontStyleNeedKey = "styleNeed";

    @Override
    protected void _sendMsg(Context ctx, String receiveLetterId) throws BOSException, EASBizException {
        this._sendPhone(ctx, receiveLetterId);
        this._sendEMail(ctx, receiveLetterId);
        this._sendMessage(ctx, receiveLetterId);
    }

    @Override
    public void sendEmail(Context ctx, String receiveLetterId, IObjectCollection monitorList, String downLoadId) throws BOSException, EASBizException {
        ReceiveLetterInfo receiveLetterInfo = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(receiveLetterId));
        if (!receiveLetterInfo.isIsSendEmail() || StringUtils.isBlank((CharSequence)receiveLetterInfo.getAddressee())) {
            return;
        }
        SendMailInfo info = this.buildSendMailInfo(ctx, receiveLetterInfo);
        if (null != monitorList && !monitorList.isEmpty()) {
            List<String> downIdList = Arrays.asList(downLoadId.split(","));
            ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
            for (int i = 0; i < monitorList.size(); ++i) {
                MonitorMultiSqlLogCollection coll = this.getMonitorMutiSqlLog(ctx, (BOSUuid)((CoreBaseCollection)monitorList).get(i).get("id"), downIdList.get(i));
                if (null == coll || 0 == coll.size()) continue;
                Attachment attachment = this.exportExcel(ctx, this.initCollectionToMap(coll), (String)((CoreBaseCollection)monitorList).get(i).get("number"));
                attachmentList.add(attachment);
            }
            KDMessageAttachment[] attachmentArray = new Attachment[attachmentList.size()];
            for (int i = 0; i < attachmentList.size(); ++i) {
                attachmentArray[i] = (Attachment)((Object)attachmentList.get(i));
            }
            info.setAttachment(attachmentArray);
        }
        if (StringUtils.isNotBlank((CharSequence)info.getReceiver())) {
            info.send();
        }
    }

    @Override
    public void sendMsg(Context ctx, String receiveLetterId, IObjectCollection monitorList, String downLoadId) throws BOSException, EASBizException {
        this._sendPhone(ctx, receiveLetterId);
        this.sendEmail(ctx, receiveLetterId, monitorList, downLoadId);
        this._sendMessage(ctx, receiveLetterId);
    }

    private SendMessageInfo buildSendMessageInfo(Context ctx, ReceiveLetterInfo receiveLetterInfo) throws EASBizException, BOSException {
        SendMessageInfo info = new SendMessageInfo(ctx);
        info.setTitle(receiveLetterInfo.getTitle());
        info.setContent(receiveLetterInfo.getContent());
        HashSet<String> pmUserSet = new HashSet<String>();
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        for (String receiverId : receiveLetterInfo.getAddressee().split(",")) {
            try {
                if (!BOSUuid.isValid((String)receiverId, (boolean)true)) continue;
                if ("80EF7DED".equals(new ObjectUuidPK(receiverId).getObjectType().toString())) {
                    Person[] persons = svc.getPersonByPersonID(receiverId);
                    for (int j = 0; j < persons.length; ++j) {
                        Person person = persons[j];
                        if (person == null) continue;
                        pmUserSet.add(person.getUserId());
                    }
                    continue;
                }
                pmUserSet.add(receiverId);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        String[] receiverIds = new String[pmUserSet.size()];
        pmUserSet.toArray(receiverIds);
        info.setReceiverIds(receiverIds);
        return info;
    }

    private SendPhoneInfo buildSendPhoneInfo(Context ctx, ReceiveLetterInfo receiveLetterInfo) {
        SendPhoneInfo info = new SendPhoneInfo(ctx);
        try {
            String[] addresseeIds = receiveLetterInfo.getAddressee().split(",");
            int len = addresseeIds.length;
            Object[] params = new Object[len];
            StringBuffer sb = new StringBuffer();
            sb.append("select fcell from t_pm_user where fid in (");
            for (int i = 0; i < len; ++i) {
                params[i] = addresseeIds[i];
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            ArrayList<String> receiveMobileNumber = new ArrayList<String>();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            while (rs.next()) {
                receiveMobileNumber.add(rs.getString(1));
            }
            info.setTitle(receiveLetterInfo.getTitle());
            info.setContent(receiveLetterInfo.getContent());
            info.setReceiveMobileNumber(receiveMobileNumber);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private SendMailInfo buildSendMailInfo(Context ctx, ReceiveLetterInfo receiveLetterInfo) {
        SendMailInfo info = new SendMailInfo(ctx);
        try {
            String[] addresseeIds = receiveLetterInfo.getAddressee().split(",");
            int len = addresseeIds.length;
            Object[] params = new Object[len];
            StringBuffer sb = new StringBuffer();
            sb.append("select femail from T_BD_Person where fid in (");
            for (int i = 0; i < len; ++i) {
                params[i] = addresseeIds[i];
                sb.append("?,");
            }
            sb.deleteCharAt(sb.length() - 1).append(")");
            StringBuffer receivers = new StringBuffer();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params);
            while (rs.next()) {
                if (!StringUtils.isNotBlank((CharSequence)rs.getString(1))) continue;
                receivers.append(rs.getString(1) + ";");
            }
            info.setTitle(receiveLetterInfo.getTitle());
            info.setContentMimeType(MimeTypeEnum.HTML);
            String content = receiveLetterInfo.getContent() + "<br>";
            content = content + this.getHtmlContext(ctx, receiveLetterInfo);
            info.setContent(content);
            info.setReceiver(receivers.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private SendCloudInfo buildSendCloudInfo(Context ctx, String receiveLetterId) {
        return new SendCloudInfo(ctx);
    }

    @Override
    protected boolean _sendMessage(Context ctx, String receiveLetterId) throws EASBizException, BOSException {
        ReceiveLetterInfo receiveLetterInfo = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(receiveLetterId));
        if (!receiveLetterInfo.isIsSendMsg() || StringUtils.isBlank((CharSequence)receiveLetterInfo.getAddressee())) {
            return false;
        }
        SendMessageInfo info = this.buildSendMessageInfo(ctx, receiveLetterInfo);
        if (null != info.getReceiverIds()) {
            info.send();
        }
        return true;
    }

    @Override
    protected boolean _sendPhone(Context ctx, String receiveLetterId) throws BOSException, EASBizException {
        ReceiveLetterInfo receiveLetterInfo = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(receiveLetterId));
        if (!receiveLetterInfo.isIsSendPhone() || StringUtils.isBlank((CharSequence)receiveLetterInfo.getAddressee())) {
            return false;
        }
        SendPhoneInfo info = this.buildSendPhoneInfo(ctx, receiveLetterInfo);
        if (null != info.getReceiveMobileNumber() && !info.getReceiveMobileNumber().isEmpty()) {
            info.send();
        }
        return true;
    }

    @Override
    protected boolean _sendEMail(Context ctx, String receiveLetterId) throws BOSException, EASBizException {
        ReceiveLetterInfo receiveLetterInfo = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(receiveLetterId));
        if (!receiveLetterInfo.isIsSendEmail() || StringUtils.isBlank((CharSequence)receiveLetterInfo.getAddressee())) {
            return false;
        }
        SendMailInfo info = this.buildSendMailInfo(ctx, receiveLetterInfo);
        if (StringUtils.isNotBlank((CharSequence)info.getReceiver())) {
            info.send();
        }
        return true;
    }

    private MonitorMultiSqlLogCollection getMonitorMutiSqlLog(Context ctx, BOSUuid monitorId, String downId) {
        MonitorMultiSqlLogCollection coll = null;
        try {
            coll = MonitorMultiSqlLogFactory.getLocalInstance(ctx).getMonitorMultiSqlLogCollection("where monitorId = '" + monitorId.toString() + "' and downloadId = '" + downId + "'");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return coll;
    }

    private Attachment exportExcel(Context ctx, Map<String, MonitorMultiSqlLogCollection> map, String number) {
        ArrayList<ExcelExp> mysheet = new ArrayList<ExcelExp>();
        for (String sqlId : map.keySet()) {
            try {
                SqlEntryInfo sqlInfo = SqlEntryFactory.getLocalInstance(ctx).getSqlEntryInfo("where id = '" + sqlId + "'");
                ExcelExp exp = new ExcelExp(sqlInfo.getSqlName(), this.getHandler(map.get(sqlId).get(0)), map.get(sqlId));
                mysheet.add(exp);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.exportManySheetExcel(ctx, mysheet, number);
    }

    private Attachment exportManySheetExcel(Context ctx, List<ExcelExp> mysheets, String number) {
        XSSFWorkbook wb = new XSSFWorkbook();
        Attachment attachment = null;
        List<ExcelExp> sheets = mysheets;
        for (ExcelExp excel : sheets) {
            XSSFFont headfont = wb.createFont();
            headfont.setFontName("\u5b8b\u4f53");
            headfont.setFontHeightInPoints((short)26);
            headfont.setColor((short)57);
            XSSFCellStyle headstyle = wb.createCellStyle();
            headstyle.setFont((Font)headfont);
            headstyle.setAlignment(HorizontalAlignment.CENTER);
            headstyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headstyle.setFillForegroundColor((short)26);
            headstyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headstyle.setLocked(true);
            XSSFSheet sheet = wb.createSheet(excel.getFileName());
            sheet.protectSheet("easadmin");
            List handers = excel.getHanders();
            XSSFCell cell = null;
            if (handers.size() != 0) {
                sheet.addMergedRegion(new CellRangeAddress(0, 1, 0, handers.size() - 1));
                XSSFRow row = sheet.createRow(0);
                row.setHeight((short)841);
                cell = row.createCell(0);
                cell.setCellStyle((CellStyle)headstyle);
                cell.setCellValue(excel.getFileName());
            }
            XSSFRow rowFirst = handers.size() != 0 ? sheet.createRow(2) : sheet.createRow(0);
            for (int i = 0; i < handers.size(); ++i) {
                cell = rowFirst.createCell(i);
                cell.setCellValue((String)handers.get(i));
                cell.setCellStyle((CellStyle)this.initExecelStyle(wb).get(fontStyleKey));
                sheet.setColumnWidth(i, 7000);
            }
            MonitorMultiSqlLogCollection collection = excel.getCollection();
            for (int i = 0; i < collection.size(); ++i) {
                MonitorMultiSqlLogInfo data = collection.get(i);
                XSSFRow listRow = handers.size() != 0 ? sheet.createRow(i + 3) : sheet.createRow(i);
                for (int j = 0; j < handers.size(); ++j) {
                    listRow.createCell(j).setCellValue(this.getRealValue(data, j, handers.size()));
                }
            }
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            wb.write((OutputStream)os);
            byte[] byteArray = os.toByteArray();
            String fileName = "\u76d1\u63a7\u4e8b\u4ef6:" + number + "-\u76d1\u63a7\u7ed3\u679c\u9644\u4ef6.xlsx";
            attachment = new Attachment(fileName, byteArray);
            os.close();
            return attachment;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return attachment;
    }

    private String getValue(String str) {
        String[] array = str.split(",");
        if (array.length == 1) {
            return "";
        }
        return array[1];
    }

    private String getRealValue(MonitorMultiSqlLogInfo info, int n, int length) {
        String realValue = "";
        if (n == length - 1) {
            return info.isInner() ? "\u5173\u8054\u6210\u529f\uff0c\u4f46\u6bd4\u8f83\u89c4\u5219\u5931\u8d25" : "\u5173\u8054\u5931\u8d25";
        }
        try {
            switch (n) {
                case 0: {
                    realValue = this.getValue(info.getField1());
                    break;
                }
                case 1: {
                    realValue = this.getValue(info.getField2());
                    break;
                }
                case 2: {
                    realValue = this.getValue(info.getField3());
                    break;
                }
                case 3: {
                    realValue = this.getValue(info.getField4());
                    break;
                }
                case 4: {
                    realValue = this.getValue(info.getField5());
                    break;
                }
                case 5: {
                    realValue = this.getValue(info.getField6());
                    break;
                }
                case 6: {
                    realValue = this.getValue(info.getField7());
                    break;
                }
                case 7: {
                    realValue = this.getValue(info.getField8());
                    break;
                }
                case 8: {
                    realValue = this.getValue(info.getField9());
                    break;
                }
                case 9: {
                    realValue = this.getValue(info.getField10());
                    break;
                }
                case 10: {
                    realValue = this.getValue(info.getField11());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return realValue;
    }

    private Map<String, Object> initExecelStyle(XSSFWorkbook wb) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        XSSFCellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont fontStyle = wb.createFont();
        fontStyle.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fontStyle.setFontHeightInPoints((short)12);
        style.setFont((Font)fontStyle);
        style.setFillForegroundColor((short)13);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFCellStyle styleNeed = wb.createCellStyle();
        styleNeed.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont fontStyleNeed = wb.createFont();
        fontStyleNeed.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
        fontStyleNeed.setFontHeightInPoints((short)12);
        fontStyleNeed.setColor((short)10);
        styleNeed.setFillForegroundColor((short)52);
        styleNeed.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleNeed.setFont((Font)fontStyleNeed);
        hashMap.put(fontStyleKey, style);
        hashMap.put(fontStyleNeedKey, styleNeed);
        return hashMap;
    }

    private List getHandler(MonitorMultiSqlLogInfo info) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != info.getField1()) {
            list.add(info.getField1().split(",")[0]);
        }
        if (null != info.getField2()) {
            list.add(info.getField2().split(",")[0]);
        }
        if (null != info.getField3()) {
            list.add(info.getField3().split(",")[0]);
        }
        if (null != info.getField4()) {
            list.add(info.getField4().split(",")[0]);
        }
        if (null != info.getField5()) {
            list.add(info.getField5().split(",")[0]);
        }
        if (null != info.getField6()) {
            list.add(info.getField6().split(",")[0]);
        }
        if (null != info.getField7()) {
            list.add(info.getField7().split(",")[0]);
        }
        if (null != info.getField8()) {
            list.add(info.getField8().split(",")[0]);
        }
        if (null != info.getField9()) {
            list.add(info.getField9().split(",")[0]);
        }
        if (null != info.getField10()) {
            list.add(info.getField10().split(",")[0]);
        }
        if (null != info.getField11()) {
            list.add(info.getField11().split(",")[0]);
        }
        if (null != info.getField12()) {
            list.add(info.getField12().split(",")[0]);
        }
        list.add("\u6bd4\u5bf9\u7ed3\u679c");
        return list;
    }

    private Map<String, MonitorMultiSqlLogCollection> initCollectionToMap(MonitorMultiSqlLogCollection coll) {
        HashMap<String, MonitorMultiSqlLogCollection> map = new HashMap<String, MonitorMultiSqlLogCollection>();
        for (int i = 0; i < coll.size(); ++i) {
            MonitorMultiSqlLogInfo info = coll.get(i);
            if (null == map.get(info.getSqlId())) {
                MonitorMultiSqlLogCollection collection = new MonitorMultiSqlLogCollection();
                collection.add(info);
                map.put(info.getSqlId(), collection);
                continue;
            }
            map.get(info.getSqlId()).add(info);
        }
        return map;
    }

    @Override
    protected boolean _sendCloud(Context ctx, String receiveLetterId) throws BOSException, EASBizException {
        SendCloudInfo info = this.buildSendCloudInfo(ctx, receiveLetterId);
        info.send();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _execute(Context ctx, String monitorGroupId) throws EASBizException, BOSException {
        int maxCount = 100;
        MonitorCollection monitorColls = MonitorFactory.getLocalInstance(ctx).getMonitorCollection("where group.id='" + monitorGroupId + "' and isEnable = '1'");
        if (null == monitorColls) return;
        if (monitorColls.isEmpty()) {
            return;
        }
        int failSize = 0;
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        CoreBaseCollection monitorList = new CoreBaseCollection();
        ArrayList<String> downLoadList = new ArrayList<String>();
        for (int i = 0; i < monitorColls.size(); ++i) {
            Boolean multiSql;
            String columns;
            String detail;
            boolean flag;
            String monitorId;
            BOSUuid downId;
            block28: {
                block27: {
                    downId = null;
                    monitorId = monitorColls.get(i).getId().toString();
                    flag = false;
                    detail = "";
                    columns = "";
                    MonitorInfo monitor = null;
                    multiSql = false;
                    MontiorSqlResult multiSqlResult = null;
                    try {
                        List<Object> result;
                        List<Object> columnList;
                        block26: {
                            MontiorSqlCore service;
                            block30: {
                                block29: {
                                    columnList = new ArrayList();
                                    result = new ArrayList();
                                    monitor = MonitorFactory.getLocalInstance(ctx).getMonitorInfo((IObjectPK)new ObjectUuidPK(monitorId));
                                    service = new MontiorSqlCore(ctx);
                                    if (monitor.getMonitorItem() != MonitorItem.Class) break block29;
                                    String path = monitor.getClassPath();
                                    Class<?> cls = Class.forName(path);
                                    Object obj = cls.newInstance();
                                    Method m = cls.getMethod("getResult", new Class[0]);
                                    result = (List)m.invoke(obj, ctx, monitorId);
                                    Method m2 = cls.getMethod("getColumnNames", new Class[0]);
                                    columnList = (List)m2.invoke(obj, ctx, monitorId);
                                    break block26;
                                }
                                if (monitor.getMonitorItem() != MonitorItem.SingleSql) break block30;
                                SqlEntryCollection colls = SqlEntryFactory.getLocalInstance(ctx).getSqlEntryCollection("select *,databaseCfg.* where monitor = '" + monitorId + "'");
                                if (null != colls && !colls.isEmpty()) {
                                    for (int j = 0; j < colls.size(); ++j) {
                                        SqlEntryInfo info = colls.get(j);
                                        String sql = info.getSql();
                                        DataBaseCfgInfo dataBaseCfgInfo = info.getDatabaseCfg();
                                        String databaseName = dataBaseCfgInfo.getDataBaseType().getValue();
                                        if (!dataBaseCfgInfo.isCurrentShareCenter() && !databaseName.equals("Datacenter")) {
                                            int targetDbType = DbType.getValue((String)databaseName);
                                            sql = TransUtil.Translate((String)sql, (int)targetDbType);
                                        }
                                        AbstractDataBase abstractDataBase = DataBaseFactory.getInstance(ctx, dataBaseCfgInfo);
                                        result = abstractDataBase.executeQuery(sql, null);
                                        columnList = abstractDataBase.getColumnNames(sql, null);
                                    }
                                }
                                break block26;
                            }
                            if (monitor.getMonitorItem() == MonitorItem.MultiSql) {
                                downId = BOSUuid.create((BOSObjectType)new MonitorMultiSqlLogInfo().getBOSType());
                                multiSqlResult = service.execute(ctx, monitorId, downId);
                                for (String sqlId : multiSqlResult.getUnInnerResult().getRowModels().keySet()) {
                                    List<RowModel> rows = multiSqlResult.getUnInnerResult().getRowModels().get(sqlId);
                                    if ((null == rows || rows.size() <= 0) && multiSqlResult.getCheckErrorModel().getRowModels().size() == 0) continue;
                                    multiSql = true;
                                    break;
                                }
                            }
                        }
                        if (multiSql.booleanValue()) {
                            flag = false;
                            ++failSize;
                            if (downId != null) {
                                downLoadList.add(downId.toString());
                            }
                            monitorList.add((CoreBaseInfo)monitorColls.get(i));
                        } else if (!multiSql.booleanValue() && (null == result || result.isEmpty() || null == columnList || columnList.isEmpty())) {
                            flag = true;
                        } else {
                            ++failSize;
                        }
                        if (result.size() > maxCount) {
                            result = result.subList(0, maxCount);
                        }
                        detail = JSONUtils.convertObjectToJson((Context)ctx, result);
                        columns = ((Object)columnList).toString().substring(1, ((Object)columnList).toString().length() - 1);
                        if (!StringUtils.isEmpty((CharSequence)columns)) break block27;
                        if (!multiSql.booleanValue()) break block28;
                    }
                    catch (SQLException e) {
                        throw new EASBizException(new NumericExceptionSubItem("SQLEXCEPTION", e.getMessage()), (Throwable)e);
                        catch (Exception e2) {
                            logger.error((Object)e2.getMessage(), (Throwable)e2);
                            continue;
                        }
                    }
                    if (!StringUtils.isEmpty((CharSequence)columns)) break block28;
                }
                this.saveMonitorLog(ctx, monitorId, detail, columns, flag, createTime, downId);
            }
            this.delete30DaysAgo(ctx, monitorId);
            continue;
            finally {
                if (!StringUtils.isEmpty((CharSequence)columns) || multiSql.booleanValue() && StringUtils.isEmpty((CharSequence)columns)) {
                    this.saveMonitorLog(ctx, monitorId, detail, columns, flag, createTime, downId);
                }
                this.delete30DaysAgo(ctx, monitorId);
            }
        }
        String oql = "select id where taskId = '" + monitorGroupId + "'";
        if (ReceiveLetterFactory.getLocalInstance(ctx).exists(oql) && failSize > 0) {
            ReceiveLetterInfo receiveLetterInfo = ReceiveLetterFactory.getLocalInstance(ctx).getReceiveLetterInfo(oql);
            this.sendMsg(ctx, receiveLetterInfo.getId().toString(), (IObjectCollection)monitorList, StringUtils.join(downLoadList, (char)','));
            return;
        }
        logger.error((Object)"ReceiveLetter Not Found !");
    }

    private void delete30DaysAgo(Context ctx, String monitorId) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" delete from t_ssc_monitorLog");
            sb.append(" where FLastUpdateTime < curdate() - 30 ");
            sb.append(" and FMonitorID = ?");
            SSCDbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{monitorId});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void saveMonitorLog(Context ctx, String monitorId, String detail, String columns, boolean flag, Timestamp createTime, BOSUuid downId) {
        try {
            MonitorLogInfo monitorLogInfo = new MonitorLogInfo();
            monitorLogInfo.setMonitor(monitorId);
            monitorLogInfo.setDetail(detail);
            monitorLogInfo.setColumns(columns);
            monitorLogInfo.setIsSuccess(flag);
            monitorLogInfo.setCreateTime(createTime);
            monitorLogInfo.setDownloadId(downId);
            MonitorLogFactory.getLocalInstance(ctx).addnew(monitorLogInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getHtmlContext(Context ctx, ReceiveLetterInfo receiveLetterInfo) {
        String separator = File.separator;
        String cssFile = System.getProperty("easweb.root") + "webviews" + separator + "basebiz" + separator + "ssc" + separator + "css" + separator + "monitorEmail.css";
        String css = this.getCss(cssFile);
        String titleTable = this.getTable(ctx, receiveLetterInfo);
        return css + titleTable;
    }

    private String getTable(Context ctx, ReceiveLetterInfo receiveLetterInfo) {
        Map<String, String> tableMap = this.getTableMap(ctx, receiveLetterInfo.getTaskId().toString());
        StringBuffer table = new StringBuffer();
        table.append("<table>");
        table.append("<tr class='table_head_tr'><td class='table_head td1'>\u4e8b\u4ef6\u5206\u7c7b</td><td class='table_head td1'>\u7f16\u7801</td><td class='table_head td1'>\u540d\u79f0</td><td class='table_head td1'>\u6267\u884c\u7ed3\u679c</td><td class='table_head td1'>\u6267\u884c\u65f6\u95f4</td></tr>");
        table.append("<tr id='tr'>");
        table.append("<td class='table_body'>" + tableMap.get("groupName") + "</td>");
        table.append("<td class='table_body'>" + tableMap.get("number") + "</td>");
        table.append("<td class='table_body'>" + tableMap.get("name") + "</td>");
        table.append("<td class='table_body'>" + tableMap.get("isSuccess") + "</td>");
        table.append("<td class='table_body'>" + tableMap.get("operationTime") + "</td>");
        table.append("</tr>");
        table.append("</table>");
        String[] columns = tableMap.get("columns") == null ? null : tableMap.get("columns").split(",");
        table.append("<table id='detailTable'>");
        if (columns != null) {
            table.append("<tr class='table_head_tr' id='detail_head_tr'><td class='table_head seq'>\u5e8f\u53f7</td>");
            for (int i = 0; i < columns.length; ++i) {
                if ("ID".equalsIgnoreCase(columns[i].trim())) continue;
                table.append("<td id='detail_head_td' class='table_head td2'>" + columns[i].trim() + "</td>");
            }
            table.append("</tr>");
            JSONArray arr = new JSONArray();
            if (tableMap.get("detail") != null) {
                arr = JSONArray.parseArray((String)tableMap.get("detail"));
            }
            for (int i = 0; i < arr.size(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                table.append("<tr id='detail_body_tr'><td class='table_body seq'>" + (i + 1) + "</td>");
                for (int j = 0; j < columns.length; ++j) {
                    if ("ID".equalsIgnoreCase(columns[j].trim())) continue;
                    table.append("<td id='detail_body_td' class='table_body'>" + obj.getString(columns[j].trim()) + "</td>");
                }
                table.append("</tr>");
            }
        }
        table.append("</table>");
        return table.toString();
    }

    private Map<String, String> getTableMap(Context ctx, String monitorGroupId) {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT mg.fname_l2 groupName,");
        sb.append(" m.fnumber number,");
        sb.append(" m.fname_l2 name,");
        sb.append(" ml.fissuccess isSuccess,");
        sb.append(" ml.fcreatetime operationTime,");
        sb.append(" ml.fcolumns columns,");
        sb.append(" ml.fdetail detail");
        sb.append(" FROM T_SSC_MonitorGroup mg");
        sb.append(" inner join T_SSC_Monitor m on mg.fid = m.fgroupId");
        sb.append(" inner join T_SSC_Monitorlog ml on m.fid = ml.fmonitorid");
        sb.append(" where mg.fid = ? and ml.fcreatetime = (select max(fcreatetime) from T_SSC_Monitorlog)");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{monitorGroupId});
            while (rs.next()) {
                tableMap.put("groupName", rs.getString("groupName"));
                tableMap.put("number", rs.getString("number"));
                tableMap.put("name", rs.getString("name"));
                tableMap.put("isSuccess", "0".equals(rs.getString("isSuccess")) ? "\u5f02\u5e38" : "\u6b63\u5e38");
                tableMap.put("operationTime", rs.getString("operationTime"));
                tableMap.put("columns", rs.getString("columns"));
                tableMap.put("detail", rs.getString("detail"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return tableMap;
    }

    private String getCss(String cssFile) {
        StringBuffer sb = new StringBuffer();
        sb.append("<style>");
        sb.append(this.readFile(cssFile));
        sb.append("</style>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String strFile) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(strFile);
            int iAvail = ((InputStream)is).available();
            byte[] bytes = new byte[iAvail];
            ((InputStream)is).read(bytes);
            String string = new String(bytes);
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                is = null;
            }
        }
        return "";
    }

    class Attachment
    extends KDMessageAttachment {
        public Attachment(String name, byte[] bytes) {
            this.name = name;
            this.data = bytes;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
        }

        public int getSize() {
            return 0;
        }

        public void setSize(int i) {
        }

        public void setData(byte[] bytes) throws IOException {
        }

        public byte[] getData() {
            return this.data;
        }

        public void destroy() {
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }

    class ExcelExp {
        private String fileName;
        private List handers;
        private MonitorMultiSqlLogCollection collection;

        public ExcelExp(String fileName, List handers, MonitorMultiSqlLogCollection collection) {
            this.fileName = fileName;
            this.handers = handers;
            this.collection = collection;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public List getHanders() {
            return this.handers;
        }

        public void setHanders(List handers) {
            this.handers = handers;
        }

        public MonitorMultiSqlLogCollection getCollection() {
            return this.collection;
        }

        public void setCollection(MonitorMultiSqlLogCollection collection) {
            this.collection = collection;
        }
    }
}

