/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.ExtendERPInfo;
import com.kingdee.eas.base.ssc.OrgCollection;
import com.kingdee.eas.base.ssc.OrgFactory;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.app.AbstractOrgControllerBean;
import com.kingdee.eas.base.ssc.app.erp.ERPUtil;
import com.kingdee.eas.base.ssc.app.erp.ERPWebService;
import com.kingdee.eas.base.ssc.app.erp.eas.EASWebServiceHandler;
import com.kingdee.eas.base.ssc.tool.FillDataUtils;
import com.kingdee.eas.base.ssc.tool.OrgRoleUserUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgControllerBean
extends AbstractOrgControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.OrgControllerBean");
    private final String ROOTID = "00000000-0000-0000-0000-000000000000CCE7AED4";

    @Override
    protected String _getDirectChildren(Context ctx, String parentId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            OrgInfo rootInfo = this.getRootSSCOrgUnit(ctx);
            result.put("root", this.orgUnitInfo2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        OrgCollection orgColl = OrgFactory.getLocalInstance(ctx).getOrgCollection(this.buildViewInfo(parentId));
        ArrayList<Map> orgList = new ArrayList<Map>();
        for (int i = 0; i < orgColl.size(); ++i) {
            orgList.add(this.orgUnitInfo2Map(orgColl.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private OrgInfo getRootSSCOrgUnit(Context ctx) throws EASBizException, BOSException {
        OrgInfo result = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        view.setFilter(filter);
        view.setSelector(this.getSimpleSic());
        OrgCollection orgColl = OrgFactory.getLocalInstance(ctx).getOrgCollection(view);
        if (orgColl != null && orgColl.size() > 0) {
            result = orgColl.get(0);
        }
        return result;
    }

    private SelectorItemCollection getSimpleSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("displayName");
        sic.add("longNumber");
        sic.add("isLeaf");
        sic.add("level");
        sic.add("parentId.id");
        return sic;
    }

    private EntityViewInfo buildViewInfo(String parentId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentId.id", (Object)parentId));
        viewInfo.setSelector(this.getSimpleSic());
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("longNumber"));
        viewInfo.setSorter(sorterColl);
        return viewInfo;
    }

    @Override
    protected IObjectPK[] _importOrg(Context ctx, IObjectCollection orgCollection, String extendErpId, String orgTreeId) throws BOSException, EASBizException {
        logger.error((Object)(Thread.currentThread().getName() + "\uff0c\u5f00\u59cbimport"));
        ERPWebService service = ERPUtil.getERPWebServiceImplByERPId(ctx, extendErpId);
        if (service == null) {
            return null;
        }
        ExtendERPInfo extendERPInfo = new ExtendERPInfo();
        extendERPInfo.setId(BOSUuid.read((String)extendErpId));
        OrgCollection orgColl = (OrgCollection)orgCollection;
        CoreBaseCollection orgAddColl = new CoreBaseCollection();
        ArrayList<String> orgAddIds = new ArrayList<String>();
        block0: for (int j = 0; j < orgColl.size(); ++j) {
            OrgInfo sscOrgInfo = orgColl.get(j);
            String number = sscOrgInfo.getNumber();
            OrgInfo erpOrgInfo = OrgRoleUserUtils.getOrgByNumber(ctx, extendErpId, number);
            if (erpOrgInfo == null) {
                logger.error((Object)("**extendErpId:**" + extendErpId + " **number:**" + number));
                continue;
            }
            if (!orgAddIds.contains(erpOrgInfo.getOrgID())) {
                erpOrgInfo.setExtendErp(extendERPInfo);
                if (OrgRoleUserUtils.isImportOrgForImportOrg(ctx, erpOrgInfo)) {
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)erpOrgInfo);
                    orgAddColl.add((CoreBaseInfo)erpOrgInfo);
                    orgAddIds.add(erpOrgInfo.getOrgID());
                }
            }
            String erpParentId = erpOrgInfo.getParent();
            String longNumber = erpOrgInfo.getLongNumber();
            while (!(StringUtils.isEmpty((String)erpParentId) || orgAddIds.contains(erpParentId) || OrgRoleUserUtils.existsOrg(ctx, erpParentId, extendErpId))) {
                String orgId;
                int idx = longNumber.lastIndexOf("!");
                number = (idx = (longNumber = longNumber.substring(0, idx)).lastIndexOf("!")) > 0 ? longNumber.substring(idx + 1) : longNumber;
                OrgInfo tempInfo = OrgRoleUserUtils.getOrgByNumber(ctx, extendErpId, number);
                if (tempInfo == null) {
                    logger.error((Object)("**extendErpId:**" + extendErpId + "****orgId:****" + erpOrgInfo.getOrgID() + " ***erpParentId**" + erpParentId + " **parentNumber:**" + number + "****service***:" + service.getClass().getName()));
                    continue block0;
                }
                tempInfo.setExtendErp(extendERPInfo);
                OrgInfo orgInfo = OrgRoleUserUtils.existsOrgByNumber(ctx, number, extendErpId);
                if (orgInfo != null) {
                    logger.error((Object)("number:" + number + "\uff0c\u5df2\u7ecf\u5b58\u5728\u3002\u9700\u8981\u6839\u636efid:" + orgInfo.getId().toString() + "\uff0c\u66f4\u65b0number"));
                    ArrayList<String> orgIds = new ArrayList<String>();
                    orgIds.add(orgInfo.getOrgID());
                    String ids = ((EASWebServiceHandler)service).getOrgByIds(ctx, extendErpId, orgIds);
                    Map resultMap = (Map)JSONUtils.convertJsonToObject((Context)ctx, (String)ids, Map.class);
                    List orgInfos = (List)resultMap.get("existList");
                    for (int i = 0; i < orgInfos.size(); ++i) {
                        Map map = (Map)orgInfos.get(i);
                        orgInfo.setNumber((String)map.get("number"));
                        orgInfo.setName((String)map.get("name_l2"));
                        orgInfo.setLongNumber((String)map.get("longNumber"));
                        orgInfo.setLevel(Integer.valueOf((String)map.get("level")));
                        orgInfo.setIsOUSealUp(Integer.valueOf((String)map.get("isOUSealUp")) == 1);
                        orgInfo.setIsLeaf(Integer.valueOf((String)map.get("isLeaf")) == 1);
                        OrgFactory.getLocalInstance(ctx).save((CoreBaseInfo)orgInfo);
                    }
                }
                if (!orgAddIds.contains(orgId = tempInfo.getOrgID())) {
                    FillDataUtils.fillAuditData(ctx, (ObjectBaseInfo)tempInfo);
                    orgAddColl.add((CoreBaseInfo)tempInfo);
                    orgAddIds.add(orgId);
                }
                erpParentId = tempInfo.getParent();
            }
        }
        IObjectPK[] pkList = null;
        pkList = orgTreeId != null && "smallImport".equals(orgTreeId) ? this.saveOrgCollectionBySql(ctx, orgAddColl) : OrgFactory.getLocalInstance(ctx).addnewBatchData(orgAddColl);
        if (orgTreeId == null || !"importAllOrg".equals(orgTreeId)) {
            OrgFactory.getLocalInstance(ctx).synSscParentId(extendErpId);
            logger.error((Object)"===================synSscParentId=================");
        }
        return pkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectPK[] saveOrgCollectionBySql(Context ctx, CoreBaseCollection orgAddColl) throws BOSException {
        IObjectPK[] objectPKArray = new IObjectPK[orgAddColl.size()];
        ArrayList paramList = new ArrayList(orgAddColl.size());
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String createDate = "{ts'" + sdf.format(date) + "'}";
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < orgAddColl.size(); ++i) {
                OrgInfo orginfo = (OrgInfo)orgAddColl.get(i);
                String fid = BOSUuid.create((String)"88453234").toString();
                String sql = "if not exists (select 1 from t_ssc_org where FNumber = '" + orginfo.getNumber() + "' and FExtendErpID = '" + orginfo.getExtendErp().getId().toString() + "') insert into t_ssc_org (Fid,FName_l1,FName_l2,FName_l3,FNumber,FCreatorID,FCreateTime,FOrgID,FParent,FIsLeaf,FLevel,FLongNumber,FDisplayName_l2,FExtendErpID,FIsOUSealUp,FControlUnitID) values('" + fid + "','" + orginfo.getName(LocaleUtils.locale_L1) + "','" + orginfo.getName(LocaleUtils.locale_L2) + "','" + orginfo.getName(LocaleUtils.locale_L3) + "','" + orginfo.getNumber() + "','" + ctx.getCaller().toString() + "'," + createDate + ",'" + orginfo.getOrgID() + "','" + orginfo.getParent() + "','" + (orginfo.isIsLeaf() ? 1 : 0) + "','" + orginfo.getLevel() + "','" + orginfo.getLongNumber() + "','" + orginfo.getDisplayName() + "','" + orginfo.getExtendErp().getId().toString() + "','" + (orginfo.isIsOUSealUp() ? 1 : 0) + "','00000000-0000-0000-0000-000000000000CCE7AED4')";
                preparedStatement = connection.prepareStatement(sql);
                int insertValue = preparedStatement.executeUpdate();
                if (insertValue > 0) {
                    objectPKArray[i] = new ObjectUuidPK(fid);
                    continue;
                }
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)orginfo.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("extendErp.id", (Object)orginfo.getExtendErp().getId().toString()));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                OrgCollection orgCollection = OrgFactory.getLocalInstance(ctx).getOrgCollection(view);
                if (orgCollection == null || orgCollection.size() <= 0) continue;
                objectPKArray[i] = new ObjectUuidPK(orgCollection.get(0).getId().toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return objectPKArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        Class<OrgControllerBean> clazz = OrgControllerBean.class;
        synchronized (OrgControllerBean.class) {
            Connection cn = null;
            IObjectPK[] objectPKArray = null;
            try {
                cn = this.getConnection(ctx);
                IORMappingDAO dao = this.getDAO(ctx, cn);
                for (IObjectValue value : colls) {
                    if (this._checkDup(ctx, value)) continue;
                    dao.addNewBatch(value);
                }
                objectPKArray = dao.executeBatchWithReturn();
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
                if (this.needCache(ctx)) {
                    ORMValueCacheService.getInstance().discardQuery(ctx, this.getBOSType());
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return objectPKArray;
        }
    }

    private boolean _checkDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgInfo orgInfo = (OrgInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("orgID", (Object)orgInfo.getOrgID());
        filter.appendFilterItem("extendErp", (Object)orgInfo.getExtendErp().getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        OrgCollection results = this.getOrgCollection(ctx, view);
        return results != null && results.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OrgInfo _getOrgByNumber(Context ctx, String extendErpId, String number) throws BOSException, EASBizException {
        Class<OrgControllerBean> clazz = OrgControllerBean.class;
        synchronized (OrgControllerBean.class) {
            OrgInfo tempInfo = null;
            OrgCollection collection = OrgFactory.getLocalInstance(ctx).getOrgCollection("where extendErp.id = '" + extendErpId + "' and number = '" + number + "'");
            if (0 == collection.size()) {
                tempInfo = new OrgInfo();
                ExtendERPInfo extendERPInfo = new ExtendERPInfo();
                extendERPInfo.setId(BOSUuid.read((String)extendErpId));
                tempInfo.setExtendErp(extendERPInfo);
                tempInfo.setNumber(number);
                OrgFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)tempInfo);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return tempInfo;
            }
            tempInfo = collection.get(0);
            if (null != tempInfo && !StringUtils.isEmpty((String)tempInfo.getName())) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return tempInfo;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tempInfo;
        }
    }

    private OrgInfo jsonToOrgInfo(JSONObject jsonObj) {
        OrgInfo orgInfo = new OrgInfo();
        try {
            orgInfo.setOrgID(jsonObj.getString("id"));
            orgInfo.setName(jsonObj.getString("name_l1"), LocaleUtils.locale_L1);
            orgInfo.setName(jsonObj.getString("name_l2"), LocaleUtils.locale_L2);
            orgInfo.setName(jsonObj.getString("name_l3"), LocaleUtils.locale_L3);
            orgInfo.setNumber(jsonObj.getString("number"));
            orgInfo.setLongNumber(jsonObj.getString("longNumber"));
            orgInfo.setParent(jsonObj.getString("parent"));
            orgInfo.setIsLeaf(jsonObj.getBoolean("isLeaf"));
            orgInfo.setLevel(jsonObj.getInt("level"));
            orgInfo.setDisplayName(jsonObj.getString("displayName"));
        }
        catch (JSONException e) {
            logger.error((Object)("jsonObj\uff1a" + jsonObj));
            logger.error((Object)"jsonToOrgInfo error\uff1a", (Throwable)e);
        }
        return orgInfo;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkDup(ctx, model, "number");
        this._checkDup(ctx, model, "orgID");
    }

    private void _checkDup(Context ctx, IObjectValue model, String field) throws BOSException, EASBizException {
        OrgInfo orgInfo = (OrgInfo)model;
        FilterInfo filter = new FilterInfo();
        if ("number".equals(field)) {
            filter.appendFilterItem("number", (Object)orgInfo.getNumber());
        } else if ("orgID".equals(field)) {
            filter.appendFilterItem("orgID", (Object)orgInfo.getOrgID());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        OrgCollection results = this.getOrgCollection(ctx, view);
        if (results != null && results.size() > 0) {
            if ("number".equals(field)) {
                throw new EASBizException(new NumericExceptionSubItem("", "number\u5df2\u5b58\u5728\uff01"));
            }
            if ("orgID".equals(field)) {
                throw new EASBizException(new NumericExceptionSubItem("", "orgID\u5df2\u5b58\u5728\uff01"));
            }
        }
    }

    @Override
    protected void _synSscParentId(Context ctx, String extendErpId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_ssc_org o set fparentid = ");
        sql.append("(select top 1 fid from t_ssc_org o2 ");
        sql.append("where o.fparent = o2.forgId ");
        sql.append("and o.fextenderpid = o2.fextenderpid) ");
        sql.append("where o.fextenderpid = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{extendErpId});
    }

    @Override
    protected String _getEasOrgTypeTree(Context ctx, String orgTreeId, String parentId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)parentId)) {
            OrgStructureInfo rootInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("where level = '1' and tree.id = '" + orgTreeId + "'");
            result.put("root", this.orgStructure2Map(rootInfo));
            parentId = rootInfo.getId().toString();
        }
        OrgStructureCollection oscoll = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("where tree.id = '" + orgTreeId + "' and parent.id = '" + parentId + "' order by longNumber asc");
        ArrayList<Map> orgList = new ArrayList<Map>();
        for (int i = 0; i < oscoll.size(); ++i) {
            orgList.add(this.orgStructure2Map(oscoll.get(i)));
        }
        result.put("children", orgList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private Map orgStructure2Map(OrgStructureInfo osInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String longNumber = osInfo.getLongNumber();
        String longName = osInfo.getDisplayName();
        String number = longNumber.substring(longNumber.lastIndexOf("!") + 1);
        String name = longName.substring(longName.lastIndexOf("_") + 1);
        map.put("id", osInfo.getId().toString());
        map.put("number", number);
        map.put("name", name);
        map.put("isLeaf", osInfo.isIsLeaf());
        map.put("longNumber", longNumber);
        if (osInfo.getParent() == null || osInfo.getParent().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", osInfo.getParent().getId().toString());
        }
        map.put("level", osInfo.getLevel());
        map.put("displayName", longName);
        return map;
    }

    private Map orgUnitInfo2Map(OrgInfo orgInfo) {
        if (orgInfo == null) {
            return new HashMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", orgInfo.getId().toString());
        map.put("name", orgInfo.getName());
        map.put("number", orgInfo.getNumber().toString());
        map.put("displayName", orgInfo.getDisplayName());
        map.put("longNumber", orgInfo.getLongNumber().toString());
        map.put("isLeaf", orgInfo.isIsLeaf());
        map.put("level", orgInfo.getLevel());
        if (orgInfo.getParentId() == null || orgInfo.getParentId().getId() == null) {
            map.put("parent", null);
        } else {
            map.put("parent", orgInfo.getParentId().getId().toString());
        }
        return map;
    }
}

