/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.CreditFilesNewFactory;
import com.kingdee.eas.base.ssc.CreditFilesNewInfo;
import com.kingdee.eas.base.ssc.CreditLogFactory;
import com.kingdee.eas.base.ssc.CreditLogInfo;
import com.kingdee.eas.base.ssc.CreditParamsCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryCollection;
import com.kingdee.eas.base.ssc.CreditParamsEntryFactory;
import com.kingdee.eas.base.ssc.CreditParamsEntryInfo;
import com.kingdee.eas.base.ssc.CreditParamsFacadeFactory;
import com.kingdee.eas.base.ssc.CreditParamsFactory;
import com.kingdee.eas.base.ssc.CreditParamsInfo;
import com.kingdee.eas.base.ssc.CreditScoreCollection;
import com.kingdee.eas.base.ssc.CreditScoreFactory;
import com.kingdee.eas.base.ssc.CreditScoreInfo;
import com.kingdee.eas.base.ssc.PassPercentLogFactory;
import com.kingdee.eas.base.ssc.PassPercentLogInfo;
import com.kingdee.eas.base.ssc.app.AbstractPassPercentUpgradeFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.ChangeSourceEnum;
import com.kingdee.eas.base.ssc.app.CreditChangeTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PassPercentUpgradeFacadeControllerBean
extends AbstractPassPercentUpgradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.PassPercentUpgradeFacadeControllerBean");
    private String start;
    private String ended;
    private Timestamp beginDateTimestamp = null;
    private Timestamp endDateTimestamp = null;

    @Override
    @Deprecated
    protected void _upgradeCreditByPercent(Context ctx, String fristRunTime) throws BOSException {
    }

    private void initTime(Context ctx, String fristRunTime, Date nowDate) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date endDates = new Date();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDates);
        endCalendar.add(5, -1);
        Date endedDate = endCalendar.getTime();
        Date beforeDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        beforeDate = calendar.getTime();
        if (fristRunTime != null && !"".equals(fristRunTime)) {
            try {
                Calendar calendarFristRunTime = Calendar.getInstance();
                calendarFristRunTime.setTime(sdf.parse(fristRunTime));
                beforeDate = calendarFristRunTime.getTime();
            }
            catch (ParseException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        String timeSql = "SELECT TOP 1 FRUNTIME FROM T_SSC_PassPercentLog ORDER BY FRUNTIME DESC";
        IRowSet timeRs = DbUtil.executeQuery((Context)ctx, (String)timeSql);
        try {
            while (timeRs.next()) {
                beforeDate = timeRs.getDate(1);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        this.endDateTimestamp = new Timestamp(endedDate.getTime());
        this.beginDateTimestamp = new Timestamp(beforeDate.getTime());
    }

    protected Boolean upgradeByUserId(Context ctx, Map userIdList) throws EASBizException {
        try {
            HashMap<Integer, CreditScoreInfo> csMap = new HashMap<Integer, CreditScoreInfo>();
            CreditScoreCollection csColl = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreCollection();
            for (int i = 0; i < csColl.size(); ++i) {
                CreditScoreInfo csInfo = csColl.get(i);
                int seqNo = csInfo.getSeqNo();
                csMap.put(seqNo, csInfo);
            }
            Set keySet = userIdList.keySet();
            Iterator it = keySet.iterator();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (it.hasNext()) {
                logger.error((Object)"---------upgradeByUserId\u8fdb\u5165while\u5faa\u73af---------");
                String key = (String)it.next();
                double value = (Double)userIdList.get(key);
                String userIdStr = key;
                double percent = value;
                BigDecimal b = new BigDecimal(percent);
                percent = b.setScale(3, 4).doubleValue();
                String percen = percent * 100.0 + "";
                int location = percen.indexOf(".");
                percen = percen.substring(0, location + 2) + "%";
                CreditFilesNewInfo fileInfo = CreditFilesNewFactory.getLocalInstance(ctx).getCreditFilesNewInfoByUserId(userIdStr);
                if (fileInfo == null) {
                    logger.error((Object)("\u7528\u6237ID\u4e3a" + userIdStr + "\u6ca1\u6709\u5bf9\u5e94\u7684\u4fe1\u7528\u6863\u6848\uff01"));
                    continue;
                }
                logger.error((Object)"---------upgradeByUserId\u8fdb\u5165while\u5faa\u73afelse---------");
                CreditFilesNewInfo oldInfo = (CreditFilesNewInfo)fileInfo.clone();
                String fileId = oldInfo.getId().toString();
                BOSUuid pk = oldInfo.getCreditRating().getId();
                try {
                    CreditScoreInfo scoreInfo = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreInfo((IObjectPK)new ObjectUuidPK(pk));
                    int seqNo = scoreInfo.getSeqNo();
                    if (seqNo == 1) {
                        this.generateCreditLog(ctx, oldInfo, oldInfo.getCreditRating(), 0, percen);
                        continue;
                    }
                    CreditScoreInfo csInfo = (CreditScoreInfo)csMap.get(--seqNo);
                    String newCreditId = csInfo.getId().toString();
                    BigDecimal newScore = csInfo.getScore();
                    paramList.add(new Object[]{newCreditId, newScore, fileId});
                    this.generateCreditLog(ctx, oldInfo, csInfo, 1, percen);
                }
                catch (EASBizException e) {
                    logger.error((Object)("---------upgradeByUserId\u8fdb\u5165while\u5faa\u73afelse-EASBizException--------" + e.getMessage()), (Throwable)e);
                }
            }
            String updateSql = "update t_ssc_creditfilesNew set FCreditRatingID=?,FCreditScore=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
        }
        catch (BOSException e) {
            logger.error((Object)("---------upgradeByUserId\u8fdb\u5165-BOSException--------" + e.getMessage()), (Throwable)e);
        }
        return true;
    }

    protected void generateCreditLog(Context ctx, CreditFilesNewInfo oldCreditFileInfo, CreditScoreInfo scoreInfo, int flag, String percen) {
        CreditLogInfo logInfo = new CreditLogInfo();
        logInfo.setCreditFilesNew(oldCreditFileInfo);
        logInfo.setCreditChangeType(CreditChangeTypeEnum.upgrade);
        logInfo.setChangeSource(ChangeSourceEnum.qualifiedRateUpgrad);
        logInfo.setOriginalGrade(oldCreditFileInfo.getCreditRating());
        logInfo.setOriginalScore(oldCreditFileInfo.getCreditScore());
        logInfo.setCurrentGrade(scoreInfo);
        logInfo.setCurrentScore(scoreInfo.getScore());
        logInfo.setChangeScore(oldCreditFileInfo.getCreditScore().subtract(scoreInfo.getScore()).abs());
        if (flag == 0) {
            logInfo.setChangGrade(0);
        } else {
            logInfo.setChangGrade(1);
        }
        logInfo.setChangeDate(new Date());
        logInfo.setDescription(this.start + "\u5230" + this.ended + "\u671f\u95f4\uff0c\u5408\u683c\u7387\u4e3a:" + percen + "\u4ece" + oldCreditFileInfo.getCreditRating() + "\u7ea7\u522b\u5347\u7ea7\u4e3a" + scoreInfo + "\u7ea7\u522b");
        logger.error((Object)("-----------generateCreditLog--------" + logInfo.getDescription().toString()));
        try {
            CreditLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)(oldCreditFileInfo.getId().toString() + "\u751f\u6210\u65e5\u5fd7\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)(oldCreditFileInfo.getId().toString() + "\u751f\u6210\u65e5\u5fd7\u5931\u8d25" + e.getMessage()), (Throwable)e);
        }
    }

    protected String getCreditId(Context ctx, int seqNo) {
        String scoreId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("seqNo", (Object)seqNo));
        view.setFilter(filter);
        try {
            CreditScoreCollection coll = CreditScoreFactory.getLocalInstance(ctx).getCreditScoreCollection(view);
            CreditScoreInfo info = coll.get(0);
            scoreId = info.getId().toString();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return scoreId;
    }

    protected String conditionSql(Context ctx) {
        String conditionSql = "";
        ArrayList<String> allTypeList = new ArrayList<String>();
        try {
            int i;
            CreditParamsEntryCollection coll = CreditParamsEntryFactory.getLocalInstance(ctx).getCreditParamsEntryCollection();
            if (coll != null && coll.size() > 0) {
                for (i = 0; i < coll.size(); ++i) {
                    String querySql = "SELECT JS.FID FROM T_SSC_JOBHIS JS INNER JOIN T_SSC_BUSSINESSATTRIBUTE BA ON JS.FBUSSATTRIDID=BA.FID INNER JOIN T_SSC_DYNVALUEHIS DV ON JS.FID=DV.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DT ON DV.FDYNAMICIDID=DT.FID WHERE BA.FBILLTYPEID='";
                    CreditParamsEntryInfo info = coll.get(i);
                    String billId = info.getBillType().getId().toString();
                    querySql = querySql + billId + "'";
                    ArrayList<String> billTypeList = new ArrayList<String>();
                    billTypeList.add(billId);
                    allTypeList.add(billId);
                    Map map = CreditParamsFacadeFactory.getLocalInstance(ctx).getFilteringSql(null, billTypeList, querySql);
                    Set key = map.keySet();
                    Iterator iterator = key.iterator();
                    while (iterator.hasNext()) {
                        String keyStr = iterator.next().toString();
                        String resultSql = map.get(keyStr).toString();
                        resultSql = " " + resultSql + " ";
                        if (conditionSql == "") {
                            conditionSql = conditionSql + resultSql;
                            continue;
                        }
                        conditionSql = conditionSql + " UNION " + resultSql;
                    }
                }
            }
            if (allTypeList != null && allTypeList.size() > 0) {
                for (i = 0; i < allTypeList.size(); ++i) {
                    String billTypeStr = (String)allTypeList.get(i);
                    conditionSql = conditionSql.replace("'" + billTypeStr.toUpperCase() + "'", "'" + billTypeStr + "'");
                }
            } else {
                return "";
            }
            conditionSql = " AND JSO.FID IN (" + conditionSql + ")";
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return conditionSql;
    }

    private int getType(Context ctx) {
        try {
            CreditParamsCollection coll = CreditParamsFactory.getLocalInstance(ctx).getCreditParamsCollection();
            for (int i = 0; i < coll.size(); ++i) {
                CreditParamsInfo info = coll.get(i);
                boolean auditFlag = info.isAuditQuality();
                boolean shareFlag = info.isSharedAudit();
                boolean reviewFlag = info.isSharedReview();
                if (!auditFlag) {
                    if (shareFlag && !reviewFlag) {
                        return 1;
                    }
                    if (!shareFlag && reviewFlag) {
                        return 2;
                    }
                    if (!shareFlag || !reviewFlag) continue;
                    return 3;
                }
                if (shareFlag && !reviewFlag) {
                    return 4;
                }
                if (!shareFlag && reviewFlag) {
                    return 5;
                }
                if (shareFlag && reviewFlag) {
                    return 6;
                }
                if (shareFlag || reviewFlag) continue;
                return 7;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    protected void writeRunLog(Context ctx, Date date) {
        PassPercentLogInfo runInfo = new PassPercentLogInfo();
        runInfo.setRunTime(date);
        try {
            PassPercentLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)runInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String get_sqlPersonAll(String condition) {
        String sqlPersonAll = "/*dialect*/ insert into t_temp_personAll (userid,count) (/*dialect*/SELECT DVO.FDINAMICVALUE,COUNT(DISTINCT JSO.FBILLID)  FROM T_SSC_JOBHIS JSO INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID = DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID = DTO.FID WHERE JSO.FISLASTLEVEL=1 AND JSO.FJobState IN ('3','4','10') AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND JSO.FAutoApprove!=1  AND JSO.FCompleteTme  BETWEEN ? AND ?  " + condition + " group by DVO.fdinamicvalue)";
        return sqlPersonAll;
    }

    private String get_sqlPersonPassNA(String condition) {
        String sqlPersonPassNA = "/*dialect*/ insert into t_temp_PersonPassNA (userid,count) (SELECT DVO.FDINAMICVALUE,COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_JOBHIS JSO INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID = DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID = DTO.FID WHERE JSO.FISLASTLEVEL=1 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND ( JSO.FJOBSTATE='3' or JSO.FJOBSTATE='10')  AND JSO.FAutoApprove!=1 AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " group by DVO.fdinamicvalue)";
        return sqlPersonPassNA;
    }

    private String get_sqlRecheckAll(String condition) {
        String sqlRecheckAll = "/*dialect*/ INSERT INTO t_temp_RecheckAll(USERID,COUNT)  (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=10 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlRecheckAll;
    }

    private String get_sqlRecheckPassNA(String condition) {
        String sqlRecheckPassNA = "/*dialect*/ INSERT INTO t_temp_RecheckPassNA(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=10 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FCHECKRESULT='1' and JSO.FBILLID NOT IN(SELECT JS.FBILLID FROM T_SSC_CREDITDEIMAGELOG CD  INNER JOIN T_SSC_JOBHIS JS ON CD.FJOBID =JS.FID)  AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlRecheckPassNA;
    }

    private String get_sqlPersonHAP(String condition) {
        String sqlPersonHAP = "/*dialect*/ insert into t_temp_PersonHAP (userid,count) (SELECT DVO.FDINAMICVALUE,COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_JOBHIS JSO INNER JOIN T_SSC_SAMPLELIBRARYQUALITYTASK SQ ON JSO.FBILLID=SQ.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID = DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID = DTO.FID WHERE JSO.FISLASTLEVEL=1 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND (JSO.FJOBSTATE='3' or JSO.FJOBSTATE='10') AND SQ.FCHECKRESULT!='0' AND JSO.FAutoApprove!=1 AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " group by DVO.fdinamicvalue)";
        return sqlPersonHAP;
    }

    private String get_sqlPersonNAP(String condition) {
        String sqlPersonNAP = "/*dialect*/ insert into t_temp_PersonNAP (userid,count) (SELECT DVO.FDINAMICVALUE,COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_JOBHIS JSO INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID = DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID = DTO.FID WHERE JSO.FISLASTLEVEL=1 AND JSO.FCheckType!='2' AND JSO.FCheckType!='3'  AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND ( JSO.FJOBSTATE='3' or  JSO.FJOBSTATE='10') AND JSO.FAutoApprove!=1  AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " group by DVO.fdinamicvalue)";
        return sqlPersonNAP;
    }

    private String get_sqlRecheckPassHAP(String condition) {
        String sqlRecheckPassHAP = "/*dialect*/ INSERT INTO t_temp_RecheckPassHAP(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARYQUALITYTASK SQ2 ON SQ.FBILLID=SQ2.FBILLID INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_SAMPLELIBRARY SL2 ON SQ2.FPARENTID=SL2.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=10 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FCHECKRESULT='1' AND JSO.FBILLID NOT IN(SELECT JS.FBILLID FROM T_SSC_CREDITDEIMAGELOG CD  INNER JOIN T_SSC_JOBHIS JS ON CD.FJOBID =JS.FID)  AND SL2.FCHECKTYPE=20 AND SQ2.FCHECKRESULT!='0' AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlRecheckPassHAP;
    }

    private String get_sqlRecheckPassNAP(String condition) {
        String sqlRecheckPassNAP = "/*dialect*/ INSERT INTO t_temp_RecheckPassNAP(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=10 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FCHECKRESULT='1' AND JSO.FBILLID NOT IN(SELECT JS.FBILLID FROM T_SSC_CREDITDEIMAGELOG CD  INNER JOIN T_SSC_JOBHIS JS ON CD.FJOBID =JS.FID)  AND JSO.FCheckType!='2' AND JSO.FCheckType!='3'  AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlRecheckPassNAP;
    }

    private String get_sqlAuditAll(String condition) {
        String sqlAuditAll = "/*dialect*/ INSERT INTO t_temp_auditAll(USERID,COUNT)  (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=20 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlAuditAll;
    }

    private String get_sqlAuditPass(String condition) {
        String sqlAuditPass = "/*dialect*/ INSERT INTO t_temp_auditPass(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT SQ.FBILLID) FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SAMPLELIBRARY SL ON SQ.FPARENTID=SL.FID INNER JOIN T_SSC_JOBHIS JSO ON SQ.FBILLID=JSO.FBILLID INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE SL.FCHECKTYPE=20 AND DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND SQ.FCHECKRESULT='1' AND JSO.FBILLID NOT IN(SELECT JS.FBILLID FROM T_SSC_CREDITDEIMAGELOG CD  INNER JOIN T_SSC_JOBHIS JS ON CD.FJOBID =JS.FID)  AND SQ.FExaminedate   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlAuditPass;
    }

    private String get_sqlImageOutDataHC(String condition) {
        String sqlImageOutDataHC = "/*dialect*/ INSERT INTO t_temp_imageHC(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_CreditDeImageLog cd INNER JOIN T_SSC_JOBHIS JSO ON cd.FJOBID =JSO.fid INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND JSO.FBILLID NOT IN (SELECT SQ.FBILLID  FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SampleLibrary SL ON SQ.FPARENTID =SL.FID WHERE SL.FCheckType=10 ) AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlImageOutDataHC;
    }

    private String get_sqlImageOutDataHCHA(String condition) {
        String sqlImageOutDataHCHA = "/*dialect*/ INSERT INTO t_temp_imageHCHA(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_CreditDeImageLog cd INNER JOIN T_SSC_JOBHIS JSO ON cd.FJOBID =JSO.fid INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND JSO.FBILLID NOT IN (SELECT DISTINCT SQ.FBILLID  FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SampleLibrary SL ON SQ.FPARENTID =SL.FID WHERE SL.FCheckType=10  UNION ALL SELECT SQ.FBILLID  FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SampleLibrary SL ON SQ.FPARENTID =SL.FID WHERE SL.FCheckType=20  AND SL.FState='4' ) AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlImageOutDataHCHA;
    }

    private String get_sqlImageOutDataHA(String condition) {
        String sqlImageOutDataHA = "/*dialect*/ INSERT INTO t_temp_imageHA(USERID,COUNT) (SELECT DVO.FDINAMICVALUE, COUNT(DISTINCT JSO.FBILLID) FROM T_SSC_CreditDeImageLog cd INNER JOIN T_SSC_JOBHIS JSO ON cd.FJOBID =JSO.fid INNER JOIN T_SSC_DYNVALUEHIS DVO ON JSO.FID=DVO.FJOBIDID INNER JOIN T_SSC_DYNAMICATTRIBUTE DTO ON DVO.FDYNAMICIDID=DTO.FID WHERE DTO.FID='4VBUlqSUQuO8g8sPkTkXsZvLn80=' AND JSO.FBILLID NOT IN (SELECT DISTINCT SQ.FBILLID  FROM T_SSC_SAMPLELIBRARYQUALITYTASK SQ INNER JOIN T_SSC_SampleLibrary SL ON SQ.FPARENTID =SL.FID WHERE SL.FCheckType=20  AND SL.FState='4' ) AND JSO.FCompleteTme   BETWEEN ? AND ?  " + condition + " GROUP BY DVO.FDINAMICVALUE)";
        return sqlImageOutDataHA;
    }

    private String get_sqlPercent() {
        String sqlPercent = "/*dialect*/ SELECT A.USERID,SUMB/SUMA FROM (SELECT A1.USERID,SUM(A1.COUNT) SUMA FROM (SELECT USERID,COUNT FROM t_temp_personAll PA UNION ALL  SELECT USERID,COUNT FROM t_temp_recheckall RA UNION ALL  SELECT USERID,COUNT FROM t_temp_imageHC HC)A1 GROUP BY A1.USERID) A LEFT OUTER JOIN (SELECT B1.USERID,SUM(B1.COUNT) SUMB FROM  (SELECT USERID,COUNT FROM t_temp_PersonPassNA PP UNION ALL  SELECT USERID,COUNT FROM t_temp_RecheckPassNA RP)B1 GROUP BY B1.USERID) B ON A.USERID=B.USERID";
        return sqlPercent;
    }

    private String get_sqlPercentPerson() {
        String sqlPercentPerson = "/*dialect*/SELECT A.USERID, B.COUNT/A.COUNT FROM T_TEMP_PERSONALL A  LEFT JOIN t_temp_PersonPassNA B ON A.USERID=B.USERID";
        return sqlPercentPerson;
    }

    private String get_sqlPercentRecheck() {
        String sqlPercentRecheck = "/*dialect*/ SELECT A.USERID, B.COUNT/A.SUMA FROM  (SELECT A1.USERID,SUM(A1.COUNT) SUMA FROM (SELECT USERID,COUNT FROM T_TEMP_RECHECKALL PA UNION ALL  SELECT USERID,COUNT FROM t_temp_imageHC HC)A1 GROUP BY A1.USERID) A LEFT JOIN t_temp_RecheckPassNA B ON A.USERID=B.USERID";
        return sqlPercentRecheck;
    }

    private String get_sqlPercentA() {
        StringBuffer sb = new StringBuffer(500);
        sb.append(" /*dialect*/ SELECT A.USERID,B.SUMB/A.SUMA ");
        sb.append(" FROM(SELECT A1.USERID,SUM(A1.COUNT) SUMA ");
        sb.append(" FROM (SELECT USERID,COUNT FROM t_temp_personAll PA ");
        sb.append(" UNION ALL  SELECT USERID,COUNT FROM t_temp_recheckall RA  ");
        sb.append(" UNION ALL  SELECT USERID,COUNT FROM t_temp_imageHCHA HCHA )A1 ");
        sb.append(" GROUP BY A1.USERID ");
        sb.append(" ) A LEFT OUTER JOIN ( ");
        sb.append(" SELECT B1.USERID,SUM(B1.COUNT) SUMB ");
        sb.append(" FROM  (SELECT USERID,COUNT FROM t_temp_PersonHAP PAP ");
        sb.append(" UNION ALL  SELECT USERID,COUNT FROM t_temp_PersonNAP PNP  ");
        sb.append(" UNION ALL SELECT USERID,COUNT FROM t_temp_RecheckPassHAP RAP ");
        sb.append(" UNION ALL  SELECT USERID,COUNT FROM t_temp_RecheckPassNAP RNP ");
        sb.append(" )B1 GROUP BY B1.USERID ");
        sb.append(" ) B ON A.USERID=B.USERID ");
        return sb.toString();
    }

    private String get_sqlPercentPersonA() {
        String sqlPercentPersonA = "/*dialect*/ SELECT A.USERID,B.SUMB/A.COUNT FROM  (SELECT USERID,COUNT FROM t_temp_personAll) A LEFT OUTER JOIN (SELECT B1.USERID,SUM(B1.COUNT) SUMB FROM  (SELECT USERID,COUNT FROM t_temp_PersonHAP PP UNION ALL  SELECT USERID,COUNT FROM t_temp_PersonNAP RP)B1 GROUP BY B1.USERID) B ON A.USERID=B.USERID";
        return sqlPercentPersonA;
    }

    private String get_sqlPercentRecheckA() {
        String sqlPercentRecheckA = "/*dialect*/ SELECT A.USERID,B.SUMB/A.SUMB FROM (SELECT A1.USERID,SUM(A1.COUNT) SUMB FROM  (SELECT USERID,COUNT FROM t_temp_RecheckAll RA UNION ALL SELECT USERID,COUNT FROM t_temp_imageHCHA HCHA)A1 GROUP BY A1.USERID) A LEFT OUTER JOIN (SELECT B1.USERID,SUM(B1.COUNT) SUMB FROM  (SELECT USERID,COUNT FROM t_temp_RecheckPassHAP PP UNION ALL  SELECT USERID,COUNT FROM t_temp_RecheckPassNAP RP)B1 GROUP BY B1.USERID) B ON A.USERID=B.USERID";
        return sqlPercentRecheckA;
    }

    private String get_sqlPercentAudit() {
        String sqlPercentAudit = "/*dialect*/ SELECT A.USERID, B.SUMB/A.COUNT FROM t_temp_auditAll A  LEFT OUTER JOIN (SELECT B1.USERID,SUM(B1.COUNT) SUMB FROM  (SELECT USERID,COUNT FROM t_temp_auditPass AP UNION ALL  SELECT USERID,COUNT FROM t_temp_imageHA RP)B1 GROUP BY B1.USERID) B ON A.USERID=B.USERID";
        return sqlPercentAudit;
    }

    private Map<String, String> getBeforeStrAndEndStr(Context ctx, String fristRunTime, Date nowDate) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String nowStr = "{ts'" + sdf.format(nowDate) + "'}";
        Date endDate = new Date();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        endCalendar.add(5, -1);
        Date endedDate = endCalendar.getTime();
        this.ended = sdf.format(endedDate).toString();
        Date beforeDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        beforeDate = calendar.getTime();
        if (fristRunTime != null && !"".equals(fristRunTime)) {
            try {
                Calendar calendarFristRunTime = Calendar.getInstance();
                calendarFristRunTime.setTime(sdf.parse(fristRunTime));
                beforeDate = calendarFristRunTime.getTime();
            }
            catch (ParseException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
        String timeSql = "SELECT TOP 1 FRUNTIME FROM T_SSC_PassPercentLog ORDER BY FRUNTIME DESC";
        IRowSet timeRs = DbUtil.executeQuery((Context)ctx, (String)timeSql);
        try {
            while (timeRs.next()) {
                beforeDate = timeRs.getDate(1);
            }
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        String beforeStr = "{ts'" + sdf.format(beforeDate) + "'}";
        this.start = sdf.format(beforeDate) + "";
        map.put("beforeStr", beforeStr);
        map.put("nowStr", nowStr);
        return map;
    }
}

