/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.AbstractJobInfo;
import com.kingdee.eas.base.ssc.ConsignationCollection;
import com.kingdee.eas.base.ssc.ConsignationFactory;
import com.kingdee.eas.base.ssc.ConsignationInfo;
import com.kingdee.eas.base.ssc.ConsignationStatusEnum;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.IConsignation;
import com.kingdee.eas.base.ssc.JobCollection;
import com.kingdee.eas.base.ssc.JobExpireState;
import com.kingdee.eas.base.ssc.JobExtCollection;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobPoolingType;
import com.kingdee.eas.base.ssc.JobStateChangeUtil;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.ParamSetFacadeFactory;
import com.kingdee.eas.base.ssc.ReminderTimeFacadeFactory;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.TaskStateTimeCollection;
import com.kingdee.eas.base.ssc.TaskStateTimeFactory;
import com.kingdee.eas.base.ssc.TaskStateTimeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.UserTaskInfo;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.analysis.util.AnalysisUtil;
import com.kingdee.eas.base.ssc.app.AbstractReminderTimeFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.ReminderTimeInfo;
import com.kingdee.eas.base.ssc.app.StopAssignEnum;
import com.kingdee.eas.base.ssc.app.assign.util.AssignJobUtils;
import com.kingdee.eas.base.ssc.external.TransferFlowSend;
import com.kingdee.eas.base.ssc.tool.ArithmeticUtils;
import com.kingdee.eas.base.ssc.tool.EqualDivisionUtils;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.JobUtils;
import com.kingdee.eas.base.ssc.tool.SSCUtil;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReminderTimeFacadeControllerBean
extends AbstractReminderTimeFacadeControllerBean {
    private static final long serialVersionUID = 1119056677013952535L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.ReminderTimeFacadeControllerBean");
    private ReminderTimeInfo reminderTimeInfo;

    @Override
    @Deprecated
    protected void _calculateReminderTime(Context ctx) throws BOSException, EASBizException {
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateRemTime(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateAssignedJob(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateToBeAssignJob(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateQualityTaskReminderTimeNew(null);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    protected void updateJobExtData(Context ctx) throws BOSException {
        JobExtCollection jobExtCollection = this.getJobExtCollection(ctx);
        JobExtInfo jobExtInfo = null;
        AbstractJobInfo jobInfo = null;
        CoreBaseCollection collection = new CoreBaseCollection();
        for (int i = 0; i < jobExtCollection.size(); ++i) {
            jobExtInfo = jobExtCollection.get(i);
            try {
                jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(jobExtInfo.getJob().getId().toString()));
            }
            catch (EASBizException e) {
                logger.error((Object)(jobInfo.getSubject() + "\uff0c\u4efb\u52a1\u4e3a\uff1a" + jobInfo.getId() + "\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01"), (Throwable)e);
            }
            if (null == jobInfo || null == jobInfo.getShareCenterID()) continue;
            this.updateJobExt(ctx, (JobInfo)jobInfo, jobExtInfo);
            collection.add((CoreBaseInfo)jobExtInfo);
        }
        try {
            JobExtFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
        catch (EASBizException e) {
            throw new BOSException("\u8f7b\u5206\u6790\u5237\u65b0\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }

    private JobExtCollection getJobExtCollection(Context ctx) {
        JobExtCollection jobExtCollection = null;
        String queryJob = " select fid FROM t_ssc_job WHERE fjobPoolingType  in  ('1','2')";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryJob);
            HashSet<String> jobExtSet = new HashSet<String>();
            try {
                while (rs.next()) {
                    jobExtSet.add(rs.getString("fid"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("job.id", jobExtSet, CompareType.INCLUDE));
            view.setFilter(filter);
            jobExtCollection = JobExtFactory.getLocalInstance(ctx).getJobExtCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return jobExtCollection;
    }

    private void updateJobExt(Context ctx, JobInfo jobInfo, JobExtInfo jobExtInfo) {
        WorkDateUtil workDateUtil = null;
        try {
            workDateUtil = WorkDateUtil.getInstance(ctx, jobInfo.getShareCenterID().getId().toString(), false);
        }
        catch (EASBizException e) {
            logger.error((Object)("\u4e3b\u9898\u4e3a\uff1a" + jobInfo.getSubject() + "\uff0c\u4efb\u52a1\u4e3a\uff1a" + jobInfo.getId() + "\u672a\u59d4\u6258\u884c\u653f\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\uff01"), (Throwable)e);
            return;
        }
        long costTimeLong = workDateUtil.calWorkTimeBetweenDays(jobInfo.getCreateTime(), new java.util.Date());
        double costTime = (double)costTimeLong * 1.0 / 3600000.0;
        jobExtInfo.setCostTime(new BigDecimal(String.valueOf(costTime)));
        if (jobInfo.getJobPoolingType() == JobPoolingType.NotAssign) {
            long waitAssignTimeLong = workDateUtil.calWorkTimeBetweenDays(jobInfo.getLastUpdateTime(), new java.util.Date());
            double waitAssignTime = (double)waitAssignTimeLong * 1.0 / 3600000.0;
            jobExtInfo.setWaitAssignTime(new BigDecimal(String.valueOf(waitAssignTime)));
            if (new Double(waitAssignTime).compareTo(new Double("1.00")) > 0) {
                jobExtInfo.setIsExtraHour(true);
            } else {
                jobExtInfo.setIsExtraHour(false);
            }
        } else if (jobInfo.getJobPoolingType() == JobPoolingType.Operating) {
            try {
                if (jobInfo.getExpireState() == JobExpireState.Expired && -1 == jobInfo.getRemainderTime().compareTo(BigDecimal.ZERO)) {
                    jobExtInfo.setExpireDays(jobInfo.getRemainderTime().abs().intValue());
                }
                AnalysisUtil.setJobDoingTime(ctx, jobInfo, jobExtInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private HashMap<String, java.util.Date> getJobStateChangeTime(Context ctx, String jobId, String oldJobSate, String newJobSate) {
        HashMap<String, java.util.Date> map = new HashMap<String, java.util.Date>();
        String sql = "SELECT FCHANGETIME,FOPERATION FROM T_SSC_JobStateTime WHERE FJOBIDID = ? AND FNEWJOBSTATE = ? AND FOLDJOBSTATE = ? ORDER BY FCHANGETIME desc ";
        Date changeTime = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{jobId, oldJobSate, newJobSate});
            if (rs.next()) {
                if ("14".equals(rs.getString("FOPERATION")) || "8".equals(rs.getString("FOPERATION")) || "15".equals(rs.getString("FOPERATION"))) {
                    changeTime = rs.getDate("FCHANGETIME");
                    map.put(rs.getString("FOPERATION"), changeTime);
                } else if ("3".equals(rs.getString("FOPERATION"))) {
                    map.put(rs.getString("FOPERATION"), changeTime);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return map;
    }

    private void calDwellTime(Context ctx, Map<String, SimpleJob> jobId_simpleJob) {
        HashMap<String, WorkDateUtil> workDateUtilCache = new HashMap<String, WorkDateUtil>();
        HashMap<String, ReminderTimeInfo> jobId_reminderTime = new HashMap<String, ReminderTimeInfo>();
        for (String jobId : jobId_simpleJob.keySet()) {
            try {
                this.reminderTimeInfo = new ReminderTimeInfo();
                SimpleJob simpleJob = jobId_simpleJob.get(jobId);
                WorkDateUtil util = null;
                if (StringUtils.isBlank((String)simpleJob.getShareCenterID())) {
                    logger.debug((Object)("\u4efb\u52a1\u6ca1\u6709\u5171\u4eab\u4e2d\u5fc3id\u4fe1\u606f.\u505c\u7559\u65f6\u95f4\u8ba1\u7b97\u8df3\u8fc7!jobId:" + jobId));
                    continue;
                }
                try {
                    if (workDateUtilCache.containsKey(simpleJob.getShareCenterID())) {
                        util = (WorkDateUtil)workDateUtilCache.get(simpleJob.getShareCenterID());
                    } else {
                        util = WorkDateUtil.getInstance(ctx, simpleJob.getShareCenterID(), false);
                        workDateUtilCache.put(simpleJob.getShareCenterID(), util);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5931\u8d25,\u8df3\u8fc7\u8be5\u4efb\u52a1\u7684\u505c\u7559\u65f6\u95f4\u8ba1\u7b97.jobId:" + jobId + "    " + e));
                }
                if (util == null) continue;
                double workCost = util.getCalWorkTimes(simpleJob.getCreateTime(), new java.util.Date(System.currentTimeMillis()), 0);
                this.reminderTimeInfo.setCostWorkTime(new BigDecimal(this.millSecondsToHour((long)workCost)));
                jobId_reminderTime.put(jobId, this.reminderTimeInfo);
            }
            catch (Exception e) {
                logger.debug((Object)("\u8be5\u4efb\u52a1\u7684\u505c\u7559\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38,\u7ee7\u7eed\u4e0b\u4e00\u4e2a.jobId:" + jobId), (Throwable)e);
                jobId_reminderTime.remove(jobId);
            }
        }
        this.updateDwellTime(ctx, jobId_reminderTime);
    }

    @Override
    protected void _calculateReminderTimeNew(Context ctx, String shareCenterNumber) throws BOSException, EASBizException {
        String tmp = shareCenterNumber + "@" + ctx.getAIS();
        logger.error((Object)(tmp + "_calculateReminderTime start " + Thread.currentThread().toString() + " " + System.currentTimeMillis()));
        DataBaseInfo shareCenterInfo = ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber);
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateRemTime(shareCenterInfo.get("id") + "");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateAssignedJob(shareCenterInfo.get("id") + "");
            this.updateJobExtData(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateToBeAssignJob(shareCenterInfo.get("id") + "");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).calculateQualityTaskReminderTimeNew(shareCenterInfo.get("id") + "");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateDwellTime(Context ctx, Map<String, ReminderTimeInfo> jobId_reminderTime) {
        if (jobId_reminderTime == null || jobId_reminderTime.isEmpty()) {
            return;
        }
        String sql = "update T_SSC_JobExt set FDwellTime=? where FJOBID=?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String jobId : jobId_reminderTime.keySet()) {
            ReminderTimeInfo reminderTimeInfo = jobId_reminderTime.get(jobId);
            Object[] param = new Object[]{reminderTimeInfo.getCostWorkTime(), jobId};
            params.add(param);
            if (params.size() % 500 != 0) continue;
            try {
                DbUtil.executeBatch((Context)ctx, (String)sql, params);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            params = new ArrayList();
        }
        if (params.size() > 0) {
            try {
                DbUtil.executeBatch((Context)ctx, (String)sql, params);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateDB(Context ctx, Map<String, ReminderTimeInfo> jobId_reminderTime) {
        if (jobId_reminderTime == null || jobId_reminderTime.isEmpty()) {
            return;
        }
        String sql = "update T_SSC_Job set FREMAINDERTIME=?,FWaitTime=?,FPauseWaitTimes=?,FReScanWaitTime=?,FCostWorkTime=?,FIsExpired=?, FExpireState=?, FLASTUPDATETIME=now() where FID=?";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String jobId : jobId_reminderTime.keySet()) {
            ReminderTimeInfo reminderTimeInfo = jobId_reminderTime.get(jobId);
            int isExpired = 0;
            int expireState = 0;
            if (reminderTimeInfo.getReminderTime().doubleValue() >= 0.0) {
                if (reminderTimeInfo.getReminderTime().doubleValue() > reminderTimeInfo.getTipLimit().doubleValue()) {
                    isExpired = 0;
                    expireState = 0;
                } else {
                    expireState = 2;
                    isExpired = 0;
                }
            } else {
                expireState = 1;
                isExpired = 1;
            }
            Object[] param = new Object[]{reminderTimeInfo.getReminderTime(), reminderTimeInfo.getWaitTime(), reminderTimeInfo.getPauseWaitTimes(), reminderTimeInfo.getReScanWaitTime(), reminderTimeInfo.getCostWorkTime(), isExpired, expireState, jobId};
            params.add(param);
            if (params.size() % 500 != 0) continue;
            try {
                DbUtil.executeBatch((Context)ctx, (String)sql, params);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            params = new ArrayList();
        }
        if (params.size() > 0) {
            try {
                DbUtil.executeBatch((Context)ctx, (String)sql, params);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<String, ReminderTimeInfo> getReminderTimeMap(Context ctx, Map<String, SimpleJob> jobId_simpleJob, Map<String, List<SimpleJobStateTime>> jobId_simpleJobStaTimList) throws EASBizException {
        HashMap<String, ReminderTimeInfo> jobId_reminderTime = new HashMap<String, ReminderTimeInfo>();
        if (jobId_simpleJob == null || jobId_simpleJob.isEmpty() || jobId_simpleJobStaTimList == null || jobId_simpleJobStaTimList.isEmpty()) {
            return jobId_reminderTime;
        }
        HashMap<String, WorkDateUtil> workDateUtilCache = new HashMap<String, WorkDateUtil>();
        for (String jobId : jobId_simpleJob.keySet()) {
            try {
                this.reminderTimeInfo = new ReminderTimeInfo();
                SimpleJob simpleJob = jobId_simpleJob.get(jobId);
                List<SimpleJobStateTime> simpleJobStaTimList = jobId_simpleJobStaTimList.get(jobId);
                WorkDateUtil util = null;
                if (StringUtils.isBlank((String)simpleJob.getShareCenterID())) {
                    logger.debug((Object)("\u4efb\u52a1\u6ca1\u6709\u5171\u4eab\u4e2d\u5fc3id\u4fe1\u606f.\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97\u8df3\u8fc7!jobId:" + jobId));
                    continue;
                }
                try {
                    if (workDateUtilCache.containsKey(simpleJob.getShareCenterID())) {
                        util = (WorkDateUtil)workDateUtilCache.get(simpleJob.getShareCenterID());
                    } else {
                        util = WorkDateUtil.getInstance(ctx, simpleJob.getShareCenterID(), false);
                        workDateUtilCache.put(simpleJob.getShareCenterID(), util);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5931\u8d25,\u8df3\u8fc7\u8be5\u4efb\u52a1\u7684\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97.jobId:" + jobId + "    " + e));
                }
                if (util == null) continue;
                double totalCost = util.getCalWorkTimes(simpleJob.getReceiveTime(), new java.util.Date(System.currentTimeMillis()), 0);
                long stateChangeCost = this.getStateChangeCost(ctx, util, simpleJobStaTimList);
                long workCost = (long)(totalCost - (double)stateChangeCost);
                long limit = this.hourToMillSeconds(simpleJob.getTaskduration() == null ? 0.0 : simpleJob.getTaskduration().doubleValue());
                double priorityValue = simpleJob.getPriorityValue().doubleValue();
                if (priorityValue <= 10.0) {
                    this.reminderTimeInfo.setTipLimit(new BigDecimal(simpleJob.getTipLimit().doubleValue() / 120.0));
                } else {
                    this.reminderTimeInfo.setTipLimit(new BigDecimal(simpleJob.getTipLimit().doubleValue() / 60.0));
                }
                long reminderTime = limit - workCost;
                this.reminderTimeInfo.setCostWorkTime(new BigDecimal(this.millSecondsToHour(workCost)));
                this.reminderTimeInfo.setReminderTime(new BigDecimal(this.millSecondsToHour(reminderTime)));
                this.reminderTimeInfo.setWaitTime(new BigDecimal(this.millSecondsToHour(stateChangeCost)));
                jobId_reminderTime.put(jobId, this.reminderTimeInfo);
            }
            catch (Exception e) {
                logger.debug((Object)("\u8be5\u4efb\u52a1\u7684\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97\u5f02\u5e38,\u7ee7\u7eed\u4e0b\u4e00\u4e2a.jobId:" + jobId), (Throwable)e);
                jobId_reminderTime.remove(jobId);
            }
        }
        return jobId_reminderTime;
    }

    private long getStateChangeCost(Context ctx, WorkDateUtil util, List<SimpleJobStateTime> simpleJobStaTimList) throws EASBizException {
        if (simpleJobStaTimList == null || simpleJobStaTimList.size() == 0) {
            return 0L;
        }
        Collections.sort(simpleJobStaTimList, new Comparator<SimpleJobStateTime>(){

            @Override
            public int compare(SimpleJobStateTime arg0, SimpleJobStateTime arg1) {
                if (arg0.getChangeTime().compareTo(arg1.getChangeTime()) > 0) {
                    return 1;
                }
                return -1;
            }
        });
        long stateChangeCost = this.getPauseAndRescaneCost(ctx, util, simpleJobStaTimList);
        SimpleJobStateTime lastJobStateTime = simpleJobStaTimList.get(simpleJobStaTimList.size() - 1);
        if ("0".equals(lastJobStateTime.newJobState) || "1".equals(lastJobStateTime.newJobState)) {
            stateChangeCost += util.calWorkTimeBetweenDays(lastJobStateTime.getChangeTime(), new Timestamp(System.currentTimeMillis()));
        }
        return stateChangeCost;
    }

    private long getPauseAndRescaneCost(Context ctx, WorkDateUtil util, List<SimpleJobStateTime> simpleJobStaTimList) throws EASBizException {
        Timestamp pauseBegin = null;
        boolean pauseFlag = false;
        Timestamp rescanBegin = null;
        boolean rescanFlag = false;
        long pauseAndRescanCost = 0L;
        for (int i = 0; i < simpleJobStaTimList.size(); ++i) {
            SimpleJobStateTime stateTime = simpleJobStaTimList.get(i);
            if (stateTime.getNewJobState().equals(stateTime.getOldJobState())) continue;
            if ("0".equals(stateTime.getNewJobState()) && !pauseFlag) {
                pauseFlag = true;
                pauseBegin = stateTime.getChangeTime();
            }
            if ("1".equals(stateTime.getNewJobState()) && !rescanFlag) {
                rescanFlag = true;
                rescanBegin = stateTime.getChangeTime();
            }
            if ("0".equals(stateTime.getOldJobState()) && pauseFlag) {
                pauseFlag = false;
                long pauseWaitTimes = (long)util.getCalWorkTimes(pauseBegin, stateTime.getChangeTime(), 0);
                pauseAndRescanCost += pauseWaitTimes;
                if (this.reminderTimeInfo.getPauseWaitTimes() == null) {
                    this.reminderTimeInfo.setPauseWaitTimes(new BigDecimal(this.millSecondsToHour(pauseWaitTimes)));
                } else {
                    this.reminderTimeInfo.setPauseWaitTimes(new BigDecimal(this.millSecondsToHour(this.reminderTimeInfo.getPauseWaitTimes().longValue() + pauseWaitTimes)));
                }
            }
            if (!"1".equals(stateTime.getOldJobState()) || !rescanFlag) continue;
            rescanFlag = false;
            long reScanWaitTime = (long)util.getCalWorkTimes(rescanBegin, stateTime.getChangeTime(), 0);
            pauseAndRescanCost += reScanWaitTime;
            if (this.reminderTimeInfo.getReScanWaitTime() == null) {
                this.reminderTimeInfo.setReScanWaitTime(new BigDecimal(this.millSecondsToHour(reScanWaitTime)));
                continue;
            }
            this.reminderTimeInfo.setReScanWaitTime(new BigDecimal(this.millSecondsToHour(this.reminderTimeInfo.getReScanWaitTime().longValue() + reScanWaitTime)));
        }
        return pauseAndRescanCost;
    }

    private long getOneCost(Context ctx, WorkDateUtil util, SimpleJobStateTime pre, SimpleJobStateTime next) throws EASBizException {
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "1".equals(pre.getNewJobState()) && "1".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long reScanWaitTime = (long)util.getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (this.reminderTimeInfo.getReScanWaitTime() == null) {
                this.reminderTimeInfo.setReScanWaitTime(new BigDecimal(this.millSecondsToHour(reScanWaitTime)));
            } else {
                this.reminderTimeInfo.setReScanWaitTime(new BigDecimal(this.reminderTimeInfo.getReScanWaitTime().doubleValue() + this.millSecondsToHour(reScanWaitTime)));
            }
            return reScanWaitTime;
        }
        if (("2".equals(pre.getOldJobState()) || "7".equals(pre.getOldJobState())) && "0".equals(pre.getNewJobState()) && "0".equals(next.getOldJobState()) && ("2".equals(next.getNewJobState()) || "7".equals(next.getNewJobState()))) {
            long PauseWaitTimes = (long)util.getCalWorkTimes(pre.getChangeTime(), next.getChangeTime(), 0);
            if (this.reminderTimeInfo.getPauseWaitTimes() == null) {
                this.reminderTimeInfo.setPauseWaitTimes(new BigDecimal(this.millSecondsToHour(PauseWaitTimes)));
            } else {
                this.reminderTimeInfo.setPauseWaitTimes(new BigDecimal(this.reminderTimeInfo.getPauseWaitTimes().doubleValue() + this.millSecondsToHour(PauseWaitTimes)));
            }
            return PauseWaitTimes;
        }
        return 0L;
    }

    private IRowSet getRowSetByShareCenterID(Context ctx, String shareCenterID, boolean assignedJob, boolean allNormalJob) throws BOSException {
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select Job.FID as jobId,Job.FReceiveTime as receiveTime,Job.FJobPriority as jobPriority ");
        querySql.append(" ,JobStateTime.FOldJobState as oldJobState,JobStateTime.FNewJobState as newJobState,JobStateTime.FChangeTime as changeTime ");
        querySql.append(" ,SystemAttr.FTimeLimit as timeLimit,SystemAttr.FUrgentTimeLimit as urgentTimeLimit,SystemAttr.FTipLimit as tipLimit,Entry.ftaskduration as taskduration,Entry.flevelnumber as priorityvalue ");
        querySql.append(" ,Job.FShareCenterID as shareCenterID ,Entry.FShareCenterID as entryShareCenterID, Job.FCREATETIME as createTime ");
        querySql.append(" From T_SSC_Job as Job ");
        querySql.append(" left outer join T_SSC_JobStateTime as JobStateTime ");
        querySql.append(" on Job.FID = JobStateTime.FJobIDID ");
        querySql.append(" left outer join  T_SSC_BussinessAttribute as BusAttr ");
        querySql.append(" on Job.FBussAttrIDID = BusAttr.FID ");
        querySql.append(" left outer join  T_SSC_billType as billType ");
        querySql.append(" on billType.fid=BusAttr.fbillTypeID  ");
        querySql.append(" left outer join  T_SSC_SystemAttribute as SystemAttr  ");
        querySql.append(" on billType.FSYSATTRID = SystemAttr.FID  ");
        querySql.append(" left outer join T_SSC_BussinessAttributeEntry as Entry ");
        querySql.append(" on BusAttr.FID=Entry.Fparentid ");
        if (assignedJob) {
            if (allNormalJob) {
                querySql.append(" where Job.FJobPoolingType = '2' and  Job.FJobState in('2','7') and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
            } else {
                querySql.append(" where Job.FJobPoolingType = '2' and  Job.FJobState not in ('2','7') and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
            }
        } else {
            querySql.append(" where (Job.FJobPoolingType = '1') and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
        }
        Object[] params = new Object[]{};
        if (!StringUtils.isBlank((String)shareCenterID)) {
            querySql.append(" and Job.FShareCenterID = ? ");
            params = new Object[]{shareCenterID};
        }
        querySql.append(" order by JobStateTime.FChangeTime ASC");
        return DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
    }

    private void parseRowSet(IRowSet rowSet, Map<String, SimpleJob> jobId_simpleJob, Map<String, List<SimpleJobStateTime>> jobId_simpleJobStaTimList) {
        if (jobId_simpleJob == null) {
            jobId_simpleJob = new HashMap<String, SimpleJob>();
        }
        if (jobId_simpleJobStaTimList == null) {
            jobId_simpleJobStaTimList = new HashMap<String, List<SimpleJobStateTime>>();
        }
        try {
            while (rowSet.next()) {
                List<Object> simpleJobStaTimList;
                BigDecimal taskDuration;
                String jobId = rowSet.getString("jobId");
                Timestamp receiveTime = rowSet.getTimestamp("receiveTime");
                String jobPriority = rowSet.getString("jobPriority");
                BigDecimal timeLimit = rowSet.getBigDecimal("timeLimit");
                BigDecimal urgentTimeLimit = rowSet.getBigDecimal("urgentTimeLimit");
                BigDecimal tipLimit = rowSet.getBigDecimal("tipLimit");
                String shareCenterID = rowSet.getString("shareCenterID");
                shareCenterID = shareCenterID == null ? "" : shareCenterID;
                String entryShareCenterID = rowSet.getString("entryShareCenterID");
                Timestamp createTime = rowSet.getTimestamp("createTime");
                if (!jobId_simpleJob.containsKey(jobId)) {
                    taskDuration = rowSet.getBigDecimal("taskduration");
                    int priorityValueInt = rowSet.getInt("priorityvalue");
                    BigDecimal priorityValue = new BigDecimal(priorityValueInt);
                    SimpleJob simpleJob = new SimpleJob(createTime, receiveTime, jobPriority, timeLimit, urgentTimeLimit, tipLimit, taskDuration, priorityValue);
                    simpleJob.setShareCenterID(shareCenterID);
                    jobId_simpleJob.put(jobId, simpleJob);
                } else if (shareCenterID.equals(entryShareCenterID)) {
                    taskDuration = rowSet.getBigDecimal("taskduration");
                    SimpleJob simpleJob = jobId_simpleJob.get(jobId);
                    if (!simpleJob.getTaskduration().equals(taskDuration)) {
                        simpleJob.setTaskduration(taskDuration);
                    }
                }
                Timestamp changeTime = rowSet.getTimestamp("changeTime");
                String oldJobState = rowSet.getString("oldJobState");
                String newJobState = rowSet.getString("newJobState");
                SimpleJobStateTime simpleJobStaTim = new SimpleJobStateTime(changeTime, oldJobState, newJobState);
                simpleJobStaTim.setShareCenterID(shareCenterID);
                if (changeTime != null && changeTime.before(receiveTime)) continue;
                if (!jobId_simpleJobStaTimList.containsKey(jobId)) {
                    simpleJobStaTimList = new ArrayList<SimpleJobStateTime>();
                    simpleJobStaTimList.add(simpleJobStaTim);
                    jobId_simpleJobStaTimList.put(jobId, simpleJobStaTimList);
                    continue;
                }
                simpleJobStaTimList = jobId_simpleJobStaTimList.get(jobId);
                simpleJobStaTimList.add(simpleJobStaTim);
                jobId_simpleJobStaTimList.put(jobId, simpleJobStaTimList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private IRowSet getRowSetByShareCenterID(Context ctx, String shareCenterID, Object isAllJob) throws BOSException {
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select Job.FID as jobId,Job.FReceiveTime as receiveTime,Job.FJobPriority as jobPriority ");
        querySql.append(" ,JobStateTime.FOldJobState as oldJobState,JobStateTime.FNewJobState as newJobState,JobStateTime.FChangeTime as changeTime ");
        querySql.append(" ,SystemAttr.FTimeLimit as timeLimit,SystemAttr.FUrgentTimeLimit as urgentTimeLimit,SystemAttr.FTipLimit as tipLimit,Entry.ftaskduration as taskduration,Entry.flevelnumber as priorityvalue ");
        querySql.append(" ,Job.FShareCenterID as shareCenterID ,Entry.FShareCenterID as entryShareCenterID, Job.FCREATETIME as createTime ");
        querySql.append(" From T_SSC_Job as Job ");
        querySql.append(" left outer join T_SSC_JobStateTime as JobStateTime ");
        querySql.append(" on Job.FID = JobStateTime.FJobIDID ");
        querySql.append(" left outer join  T_SSC_BussinessAttribute as BusAttr ");
        querySql.append(" on Job.FBussAttrIDID = BusAttr.FID ");
        querySql.append(" left outer join  T_SSC_billType as billType ");
        querySql.append(" on billType.fid=BusAttr.fbillTypeID  ");
        querySql.append(" left outer join  T_SSC_SystemAttribute as SystemAttr  ");
        querySql.append(" on billType.FSYSATTRID = SystemAttr.FID  ");
        querySql.append(" left outer join T_SSC_BussinessAttributeEntry as Entry ");
        querySql.append(" on BusAttr.FID=Entry.Fparentid ");
        if (isAllJob == null) {
            querySql.append(" where Job.FJobPoolingType = '2' and  (Job.FJobState='2' or Job.FjobState='7') and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
        } else if (Boolean.parseBoolean(isAllJob.toString())) {
            querySql.append(" where Job.FJobPoolingType = '2' and  (Job.FJobState='2' or Job.FjobState='7') and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
        } else {
            querySql.append(" where ((Job.FJobPoolingType = '2' and  (Job.FJobState not in ('2','7'))) or (Job.FJobPoolingType = '1')) and (Job.Fjoblevelid=Entry.FJobLevelNameid)");
        }
        Object[] params = new Object[]{};
        if (!StringUtils.isBlank((String)shareCenterID)) {
            querySql.append(" and Job.FShareCenterID = ? ");
            params = new Object[]{shareCenterID};
        }
        querySql.append(" order by JobStateTime.FChangeTime ASC");
        return DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
    }

    private long hourToMillSeconds(double hour) {
        return (long)hour * 3600L * 1000L;
    }

    private double millSecondsToHour(long ms) {
        return (double)ms / 3600000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _calculateJobReminderTime(Context ctx, String jobID) throws BOSException, EASBizException {
        IRowSet rowSet = null;
        try {
            HashMap<String, SimpleJob> jobId_simpleJob = new HashMap<String, SimpleJob>();
            HashMap<String, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<String, List<SimpleJobStateTime>>();
            HashMap<String, ReminderTimeInfo> jobId_reminderTime = new HashMap();
            rowSet = this.getRowSet(ctx, jobID);
            this.parseRowSet(rowSet, jobId_simpleJob, jobId_simpleJobStaTimList);
            jobId_reminderTime = this.getReminderTimeMap(ctx, jobId_simpleJob, jobId_simpleJobStaTimList);
            this.updateDB(ctx, jobId_reminderTime);
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    private IRowSet getRowSet(Context ctx, String jobID) throws BOSException {
        String querySql = new StringBuffer().append(" select Job.FID as jobId,Job.fsharecenterId as sharecenterId,Entry.FShareCenterID as entryShareCenterID,Job.FReceiveTime as receiveTime,Job.FJobPriority as jobPriority ").append(" ,JobStateTime.FOldJobState as oldJobState,JobStateTime.FNewJobState as newJobState,JobStateTime.FChangeTime as changeTime, Job.FCREATETIME as createTime ").append(" ,SystemAttr.FTimeLimit as timeLimit,SystemAttr.FUrgentTimeLimit as urgentTimeLimit,SystemAttr.FTipLimit as tipLimit,Entry.ftaskduration as taskduration,Entry.flevelnumber as priorityvalue ").append(" From T_SSC_Job as Job ").append(" inner join T_SSC_JobStateTime as JobStateTime ").append(" on Job.FID = JobStateTime.FJobIDID ").append(" inner join T_SSC_BussinessAttribute as BusAttr ").append(" on Job.FBussAttrIDID = BusAttr.FID ").append(" inner join T_SSC_billType as billType ").append(" on billType.fid=BusAttr.fbillTypeID  ").append(" inner join T_SSC_SystemAttribute as SystemAttr ").append(" on billType.FSYSATTRID = SystemAttr.FID ").append(" inner join T_SSC_BussinessAttributeEntry as Entry ").append(" on BusAttr.FID=Entry.Fparentid").append(" where Job.FID = ? ").append(" and Job.Fjoblevelid=Entry.FjobLevelNameid ").append(" order by JobStateTime.FChangeTime ASC").toString();
        return DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{jobID});
    }

    @Override
    protected void _consignate(Context ctx) throws BOSException, EASBizException {
        logger.error((Object)("\u8fdb\u5165\u6240\u6709\u5171\u4eab\u4e2d\u5fc3\u4efb\u52a1\u5206\u914d\u65b9\u6cd5dataCenter:" + ctx.getAIS()));
        List<DataBaseInfo> list = ShareCenterUtils.getAllShareCenterInfo(ctx);
        if (list == null || list.isEmpty()) {
            logger.error((Object)"\u5929\u54ea!\u67e5\u5230\u6ca1\u6709\u5171\u4eab\u4e2d\u5fc3,\u4e2d\u5fc3\u90fd\u6ca1\u4e86,\u4efb\u52a1\u6ca1\u5fc5\u8981\u59d4\u6258\u4e86.it's over!");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ReminderTimeFacadeFactory.getLocalInstance(ctx).consignateNew(list.get(i).getNumber());
        }
    }

    @Override
    protected void _consignateNew(Context ctx, String shareCenterNumber) throws BOSException, EASBizException {
        DataBaseInfo shareCenterInfo = ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber);
        if (shareCenterInfo == null) {
            logger.error((Object)"_consignateNew get shareCenterNumber is null");
            return;
        }
        String shareCenterID = shareCenterInfo.getId() + "";
        this.effect(ctx, shareCenterID);
        this.complete(ctx, shareCenterID);
        this.invalid(ctx, shareCenterID);
    }

    private void invalid(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("consigner.shareCenterId", (Object)shareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        IConsignation iConsignation = ConsignationFactory.getLocalInstance(ctx);
        ConsignationCollection consignationCol = iConsignation.getConsignationCollection(view);
        CoreBaseCollection collection = new CoreBaseCollection();
        for (int i = 0; i < consignationCol.size(); ++i) {
            consignationCol.get(i).setStatus(ConsignationStatusEnum.Invalid);
            collection.add((CoreBaseInfo)consignationCol.get(i));
        }
        if (!collection.isEmpty()) {
            iConsignation.updateBatchData(collection);
        }
    }

    private void effect(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)20));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)30));
        filter.getFilterItems().add(new FilterItemInfo("consigner.shareCenterId", (Object)shareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("beginTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.GREATER_EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ConsignationCollection consignationColl = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(view);
        if (consignationColl == null || consignationColl.size() == 0) {
            return;
        }
        for (int i = 0; i < consignationColl.size(); ++i) {
            ConsignationInfo consignationInfo = consignationColl.get(i);
            this._effectConsignationNew(ctx, (IObjectValue)consignationInfo, shareCenterID);
        }
    }

    private void complete(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"30"));
        filter.getFilterItems().add(new FilterItemInfo("consigner.shareCenterId", (Object)shareCenterID));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("consigner.*"));
        view.setSelector(sic);
        ConsignationCollection consignationColl = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(view);
        if (consignationColl == null || consignationColl.size() == 0) {
            return;
        }
        for (int i = 0; i < consignationColl.size(); ++i) {
            ConsignationInfo consignationInfo = consignationColl.get(i);
            this._completeConsignationNew(ctx, (IObjectValue)consignationInfo, shareCenterID);
        }
        RoleFactory.getLocalInstance(ctx).deleteTempConsignRole();
    }

    private void effect(Context ctx) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)20));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)30));
        filter.getFilterItems().add(new FilterItemInfo("beginTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endTime", (Object)new Timestamp(System.currentTimeMillis()), CompareType.GREATER_EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        ConsignationCollection consignationColl = ConsignationFactory.getLocalInstance(ctx).getConsignationCollection(view);
        if (consignationColl == null || consignationColl.size() == 0) {
            return;
        }
        for (int i = 0; i < consignationColl.size(); ++i) {
            ConsignationInfo consignationInfo = consignationColl.get(i);
            this.effectConsignation(ctx, consignationInfo);
        }
    }

    private void complete(Context ctx) throws BOSException, EASBizException {
        List<DataBaseInfo> shareCenterInfos = ShareCenterUtils.getAllValidShareCenterInfo(ctx);
        for (DataBaseInfo shareCenterInfo : shareCenterInfos) {
            this.complete(ctx, shareCenterInfo.getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void singleEffect(Context ctx, ConsignationInfo consignationInfo, String shareCenterNumber, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        UserInfo consigner = consignationInfo.getConsigner();
        UserInfo assignee = consignationInfo.getAssignee();
        if (consigner == null || consigner.getId() == null || assignee == null || assignee.getId() == null) {
            return;
        }
        String consignerId = consigner.getId().toString();
        String taskSql = "SELECT st.fid,st.FBILLTYPEID FROM T_SSC_SampleLibraryQualityTask st inner join T_SSC_SampleLibrary sl on st.FPARENTID = sl.FID  where  sl.fcheckType in(?,'30') and st.FTASKSTATE = '2'  and st.FBILLTYPEID in(SELECT fbillType FROM T_ssc_ConsignationEntry where FPARENTID in(SELECT fid FROM T_ssc_Consignation where fstatus='30' and FCONSIGNERID = ?) and ftaskType = ?)  and st.FEXAMINERID = ?";
        Object[] param = ConsignationTaskTypeEnum.qualityJob.equals((Object)taskType) ? new Object[]{"20", consignerId, "1", consignerId} : new Object[]{"10", consignerId, "2", consignerId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)taskSql, (Object[])param);
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        ArrayList<String> taskList = null;
        boolean isExistConsignationRation = false;
        try {
            while (rs.next()) {
                isExistConsignationRation = true;
                String billTypeId = rs.getString(2);
                taskList = (ArrayList<String>)map.get(billTypeId);
                if (null == taskList) {
                    taskList = new ArrayList<String>();
                }
                taskList.add(rs.getString(1));
                map.put(billTypeId, taskList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JobUtils.closeRS(rs);
        }
        if (!isExistConsignationRation) {
            return;
        }
        for (String billtypeId : map.keySet()) {
            List taskListByBillType = (List)map.get(billtypeId);
            List<UserInfo> assigneeInfos = SSCUtil.getAssignee(ctx, consignerId, billtypeId, taskType);
            ArrayList<String> assigneeIds = new ArrayList<String>();
            for (UserInfo user : assigneeInfos) {
                assigneeIds.add(user.getId().toString());
            }
            List<UserTaskInfo> users = ReminderTimeFacadeControllerBean.getAssigneeTaskCountInfo(ctx, billtypeId, assigneeIds, taskType);
            ArithmeticUtils.matrix(users, taskListByBillType.size());
            String updateJobSql = "update T_SSC_SampleLibraryQualityTask set FEXAMINERID =?,fconsigner=? where fid = ?";
            int index = 0;
            for (UserTaskInfo UserTaskInfo2 : users) {
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                int assingedTaskCount = UserTaskInfo2.getAssinged();
                String assigneeId = UserTaskInfo2.getUserId();
                for (int i = 0; i < assingedTaskCount && index < taskListByBillType.size(); ++i, ++index) {
                    params.add(new Object[]{assigneeId, consignerId, taskListByBillType.get(index)});
                }
                DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                AssignJobUtils.checkPermissionIfNoteExistCreate(ctx, assigneeId, billtypeId, shareCenterNumber, taskType);
            }
            this.addBatchTaskTimeState(ctx, taskListByBillType, consignerId, "", Operation.Consignation);
        }
    }

    private void addBatchTaskTimeState(Context ctx, List<String> taskIds, String consignerId, String advice, Operation operation) throws BOSException, EASBizException {
        try {
            UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(consignerId));
            com.kingdee.eas.base.permission.UserInfo userInfoPermission = new com.kingdee.eas.base.permission.UserInfo();
            userInfoPermission.setId(BOSUuid.read((String)userInfo.getUserID()));
            this.addBatchTaskTimeState(ctx, taskIds, userInfo, advice, operation, userInfoPermission);
        }
        catch (BOSException e) {
            logger.error((Object)("get user fail,this param is " + consignerId), (Throwable)e);
        }
    }

    private void addBatchTaskTimeState(Context ctx, List<String> taskIds, UserInfo operator, String advice, Operation operation, com.kingdee.eas.base.permission.UserInfo pmuser) throws BOSException, EASBizException {
        CoreBaseCollection core = new CoreBaseCollection();
        TaskStateTimeInfo tsInfo = null;
        for (int i = 0; i < taskIds.size(); ++i) {
            tsInfo = new TaskStateTimeInfo();
            tsInfo.setOperation(operation);
            tsInfo.setOperationAdvice(advice);
            tsInfo.setChangeTime(new Time(System.currentTimeMillis()));
            tsInfo.setTaskID(taskIds.get(i));
            if (operator != null) {
                tsInfo.setOperatorId(operator);
                tsInfo.setLastUpdateUser(pmuser);
                tsInfo.setCreator(pmuser);
            }
            core.add((CoreBaseInfo)tsInfo);
        }
        if (!core.isEmpty()) {
            TaskStateTimeFactory.getLocalInstance(ctx).saveBatchData(core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void singleEffect(Context ctx, ConsignationInfo consignationInfo, String shareCenterNumber) throws BOSException, EASBizException {
        UserInfo consigner = consignationInfo.getConsigner();
        UserInfo assignee = consignationInfo.getAssignee();
        if (consigner == null || consigner.getId() == null || assignee == null || assignee.getId() == null) {
            return;
        }
        String consignerId = consigner.getId().toString();
        String jobIdSql = "select fid,fbussattridid from t_ssc_job b where b.fjobpoolingtype='2' and b.FJobState in ('2','7') and  fbussattridid in( SELECT fBussTypeID FROM T_ssc_ConsignationEntry where fparentid in (select fid from T_ssc_Consignation where fstatus='30' and FCONSIGNERID = '" + consignerId + "') and fBussTypeID is not null) and FPersonnelIDID ='" + consignerId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)jobIdSql);
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        ArrayList<String> jobList = null;
        boolean isExistConsignationRation = false;
        try {
            while (rs.next()) {
                isExistConsignationRation = true;
                String bussAttrId = rs.getString(2);
                jobList = (ArrayList<String>)map.get(bussAttrId);
                if (null == jobList) {
                    jobList = new ArrayList<String>();
                }
                jobList.add(rs.getString(1));
                map.put(bussAttrId, jobList);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            JobUtils.closeRS(rs);
        }
        if (!isExistConsignationRation) {
            return;
        }
        for (String bussAttrId : map.keySet()) {
            List jobIds = (List)map.get(bussAttrId);
            ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>(jobIds.size());
            JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where id in " + FormatUtils.list2Sql(jobIds) + "");
            for (int i = 0; i < jobCollection.size(); ++i) {
                jobInfos.add(jobCollection.get(i));
            }
            JobStateChangeUtil.addBatchJobStateTime(ctx, jobInfos, consigner, Operation.Consignation, null, null, null, null, null);
            List<UserInfo> assigneeInfos = SSCUtil.getAssignee(ctx, consignerId, bussAttrId);
            ArrayList<String> assigneeIds = new ArrayList<String>();
            for (UserInfo user : assigneeInfos) {
                assigneeIds.add(user.getId().toString());
            }
            List<UserTaskInfo> users = ReminderTimeFacadeControllerBean.getAssigneeJobCountInfo(ctx, bussAttrId, assigneeIds);
            ArithmeticUtils.matrix(users, jobIds.size());
            String updateJobSql = "update t_ssc_job set FPersonnelIDID =?,FConsignerID=? where fid = ?";
            int index = 0;
            for (UserTaskInfo UserTaskInfo2 : users) {
                int i;
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                int assinged = UserTaskInfo2.getAssinged();
                String assigneeId = UserTaskInfo2.getUserId();
                for (i = 0; i < assinged && index < jobIds.size(); ++i, ++index) {
                    params.add(new Object[]{assigneeId, consignerId, jobIds.get(index)});
                }
                DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                if (!SSCUtil.checkPermission(ctx, assigneeId, bussAttrId)) {
                    SSCUtil.genAndAllotCompelRole(ctx, bussAttrId, assigneeId, shareCenterNumber, true);
                    logger.info((Object)(assigneeId + "\u5206\u914d" + bussAttrId + "\u6743\u9650\u6210\u529f"));
                }
                for (i = 0; i < assinged && index < jobIds.size(); ++i, ++index) {
                    this.updateWorkflowCurrentHandler(ctx, assigneeId, (String)jobIds.get(index));
                }
                DataBaseInfo info = ShareCenterUtils.getShareCenterInfoByNumber(ctx, shareCenterNumber);
                String sid = null;
                if (info != null) {
                    sid = info.getId().toString();
                }
                if (!EqualDivisionUtils.isEqualDivision(ctx, sid) || !StringUtils.isNotBlank((String)assigneeId)) continue;
                WorkPressureFactory.getLocalInstance(ctx).addMulitJob(assigneeId, bussAttrId, assinged);
            }
        }
    }

    private void updateWorkflowCurrentHandler(Context ctx, String assigneeId, String jobId) throws EASBizException, BOSException {
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("*");
        selectorColl.add("bussAttrID.id");
        selectorColl.add("bussAttrID.number");
        selectorColl.add("bussAttrID.name");
        JobInfo jobInfo = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(jobId), selectorColl);
        String FassignId = jobInfo.getAssignId();
        String solution = jobInfo.getSolution();
        String dataCenter = jobInfo.getDataCenter();
        logger.debug((Object)"transfer interface begin-----------");
        logger.debug((Object)("transfer interface send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + assigneeId));
        TransferFlowSend TransferFlowSend1 = new TransferFlowSend();
        boolean sendOk = TransferFlowSend1.sendTask(ctx, jobInfo, solution, dataCenter, FassignId, assigneeId);
        if (!sendOk) {
            logger.error((Object)("transfer interface not send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + assigneeId));
        }
        logger.debug((Object)"transfer interface end-----------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserTaskInfo> getAssigneeTaskCountInfo(Context ctx, String billTypeId, List<String> assigneeIds, ConsignationTaskTypeEnum taskTypeEnum) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select u.fid,");
        sb.append(" (SELECT count(*) FROM T_SSC_SampleLibraryQualityTask slt inner join T_SSC_SampleLibrary sl on slt.FPARENTID = sl.FID where slt.FBILLTYPEID = ? and slt.FTASKSTATE = '2'");
        if (ConsignationTaskTypeEnum.qualityJob.equals((Object)taskTypeEnum)) {
            sb.append(" and sl.FCHECKTYPE in (20,30)");
        } else {
            sb.append(" and sl.FCHECKTYPE in (10,30)");
        }
        sb.append("  and slt.FEXAMINERID  = u.FID )  as operatingCount");
        sb.append("  FROM t_ssc_user u where u.fid in " + FormatUtils.list2Sql(assigneeIds));
        sb.append(" order by  operatingCount asc");
        ArrayList<UserTaskInfo> users = new ArrayList<UserTaskInfo>();
        Object[] param = new Object[]{billTypeId};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                UserTaskInfo userTask = new UserTaskInfo();
                userTask.setUserId(rs.getString(1));
                userTask.setCurNumber(rs.getInt(2));
                users.add(userTask);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)"Query least task user error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserTaskInfo> getAssigneeJobCountInfo(Context ctx, String bussAttrId, List<String> assigneeIds) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select u.fid,");
        sb.append(" (select count(1) from t_ssc_job j");
        sb.append(" where j.FPersonnelIDID = u.fid");
        sb.append(" and j.FJobPoolingType = '2'");
        sb.append(" and j.FBussAttrIDID in");
        sb.append(" (select ba.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where sy.fid =");
        sb.append(" (select sy.fid from t_ssc_bussinessattribute ba inner join t_ssc_billType bt on ba.fbilltypeid=bt.fid inner join t_ssc_systemattribute sy on bt.fsysattrid=sy.fid where ba.fid = ?)");
        sb.append(" )");
        sb.append(" ) as operatingCount");
        sb.append(" from t_ssc_user u");
        sb.append(" where u.FID in " + FormatUtils.list2Sql(assigneeIds));
        sb.append(" order by operatingCount asc");
        ArrayList<UserTaskInfo> users = new ArrayList<UserTaskInfo>();
        Object[] param = new Object[]{bussAttrId};
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
            while (rs.next()) {
                UserTaskInfo userTask = new UserTaskInfo();
                userTask.setUserId(rs.getString(1));
                userTask.setCurNumber(rs.getInt(2));
                users.add(userTask);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("sql:" + sb.toString()));
                logger.error((Object)"Query least task user error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                JobUtils.closeRS(rs);
                throw throwable;
            }
            JobUtils.closeRS(rs);
        }
        JobUtils.closeRS(rs);
        return users;
    }

    private void singleComplete(Context ctx, ConsignationInfo consignationInfo, String shareCenterId) throws BOSException, EASBizException {
        UserInfo consigner = consignationInfo.getConsigner();
        UserInfo assignee = consignationInfo.getAssignee();
        if (consigner == null || consigner.getId() == null || assignee == null || assignee.getId() == null) {
            return;
        }
        ConsignationStatusEnum status = ConsignationStatusEnum.Completed;
        this.updateConsignationStatus(ctx, consignationInfo.getId().toString(), status);
        String isReturnToOriginalPerson = "";
        isReturnToOriginalPerson = StringUtils.isBlank((String)shareCenterId) ? ParamSetFacadeFactory.getLocalInstance(ctx).getSSCParam().getIsReturnToOriginalPerson() : ParamSetFacadeFactory.getLocalInstance(ctx).getSSCParam(shareCenterId).getIsReturnToOriginalPerson();
        this.processShareJobsConsignEnd(ctx, consigner, assignee, Boolean.parseBoolean(isReturnToOriginalPerson), shareCenterId);
        this.processCheckJobsConsignEnd(ctx, consigner, assignee, Boolean.parseBoolean(isReturnToOriginalPerson), ConsignationTaskTypeEnum.qualityJob);
        this.processCheckJobsConsignEnd(ctx, consigner, assignee, Boolean.parseBoolean(isReturnToOriginalPerson), ConsignationTaskTypeEnum.spotCheckJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCheckJobsConsignEnd(Context ctx, UserInfo consigner, UserInfo assignee, boolean isReturnToOriginalPerson, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        if (consigner.isIsEnabled() && StopAssignEnum.normal == consigner.getIsStopAssign()) {
            String jobsql = "SELECT st.fid FROM T_SSC_SampleLibraryQualityTask st inner join T_SSC_SampleLibrary sl on st.FPARENTID = sl.fid where sl.FCHECKTYPE = ? and st.FTASKSTATE = ? and st.FEXAMINERID = ? and st.Fconsigner=?";
            IRowSet rs = null;
            HashSet<String> jobIdSet = new HashSet<String>();
            try {
                Object[] param = new Object[]{};
                if (ConsignationTaskTypeEnum.qualityJob.equals((Object)taskType)) {
                    param = new Object[]{"20", "2", assignee.getId().toString(), consigner.getId().toString()};
                } else if (ConsignationTaskTypeEnum.spotCheckJob.equals((Object)taskType)) {
                    param = new Object[]{"10", "2", assignee.getId().toString(), consigner.getId().toString()};
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)jobsql, (Object[])param);
                while (rs.next()) {
                    jobIdSet.add(rs.getString(1));
                }
            }
            catch (Exception e) {
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
            if (jobIdSet == null || jobIdSet.size() == 0) {
                return;
            }
            ArrayList<String> taskIds = new ArrayList<String>();
            if (isReturnToOriginalPerson) {
                String updateJobSql = "update T_SSC_SampleLibraryQualityTask set FEXAMINERID =?,Fconsigner=? where fid = ?";
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (String jobId : jobIdSet) {
                    Object[] param = new Object[]{consigner.getId().toString(), null, jobId};
                    params.add(param);
                    taskIds.add(jobId);
                    if (params.size() % 500 != 0) continue;
                    DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                    params = new ArrayList();
                }
                if (params.size() > 0) {
                    try {
                        DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                this.addBatchTaskTimeState(ctx, taskIds, assignee.getId().toString(), "", Operation.ConsignationReturn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processShareJobsConsignEnd(Context ctx, UserInfo consigner, UserInfo assignee, boolean isReturnToOriginalPerson, String shareCenterId) throws BOSException, EASBizException {
        String assigneeId = assignee.getId().toString();
        String consignerId = consigner.getId().toString();
        if (consigner.isIsEnabled() && StopAssignEnum.normal == consigner.getIsStopAssign()) {
            String jobSql = "select fid,FBUSSATTRIDID from t_ssc_job where fjobpoolingtype = ? and FPersonnelIDID = ? and FConsignerID=? ";
            HashSet<String> jobIdSet = new HashSet<String>();
            ArrayList<String> bussAttrIds = new ArrayList<String>();
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)jobSql, (Object[])new Object[]{"2", assignee.getId().toString(), consigner.getId().toString()});
                while (rs.next()) {
                    jobIdSet.add(rs.getString(1));
                    bussAttrIds.add(rs.getString(2));
                }
            }
            catch (Exception e) {
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
            if (jobIdSet == null || jobIdSet.size() == 0) {
                return;
            }
            if (!isReturnToOriginalPerson) {
                String updateSql = "update t_ssc_job set FConsignerID=null where fjobpoolingtype = '2' and FPersonnelIDID = ? and FConsignerID=?";
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{assigneeId, consignerId});
                if (EqualDivisionUtils.isEqualDivision(ctx, shareCenterId) && null != consignerId && StringUtils.isNotBlank((String)consignerId)) {
                    for (String bussAttrId : bussAttrIds) {
                        WorkPressureFactory.getLocalInstance(ctx).subtractSingleJob(consignerId, bussAttrId);
                    }
                }
                return;
            }
            String updateJobSql = "update t_ssc_job set FPersonnelIDID =?,FConsignerID=? where fid = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String jobId : jobIdSet) {
                Object[] param = new Object[]{consigner.getId().toString(), null, jobId};
                params.add(param);
                if (params.size() % 500 != 0) continue;
                DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                params = new ArrayList();
            }
            if (params.size() > 0) {
                try {
                    DbUtil.executeBatch((Context)ctx, (String)updateJobSql, params);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ArrayList<JobInfo> jobInfos = new ArrayList<JobInfo>(jobIdSet.size());
            JobCollection jobCollection = JobFactory.getLocalInstance(ctx).getJobCollection("where id in " + FormatUtils.set2Sql(jobIdSet) + "");
            for (int i = 0; i < jobCollection.size(); ++i) {
                jobInfos.add(jobCollection.get(i));
            }
            JobStateChangeUtil.addBatchJobStateTime(ctx, jobInfos, assignee, Operation.ConsignationReturn, null, null, null, null, null);
            if (EqualDivisionUtils.isEqualDivision(ctx, shareCenterId) && null != assigneeId && StringUtils.isNotBlank((String)assigneeId)) {
                for (String bussAttrId : bussAttrIds) {
                    WorkPressureFactory.getLocalInstance(ctx).subtractSingleJob(assigneeId, bussAttrId);
                }
            }
        }
    }

    private void updateConsignationStatus(Context ctx, String consignationId, ConsignationStatusEnum status) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_SSC_Consignation set FStatus = ? where FID = ?");
        Object[] param = new Object[]{status.getValue(), consignationId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
    }

    @Override
    protected void _effectConsignation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsignationInfo consignationInfo = (ConsignationInfo)model;
        this.singleEffect(ctx, consignationInfo, null);
    }

    @Override
    protected void _completeConsignation(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ConsignationInfo consignationInfo = (ConsignationInfo)model;
        this.singleComplete(ctx, consignationInfo, null);
    }

    @Override
    protected void _completeConsignationNew(Context ctx, IObjectValue model, String shareCenterId) throws BOSException, EASBizException {
        ConsignationInfo consignationInfo = (ConsignationInfo)model;
        this.singleComplete(ctx, consignationInfo, shareCenterId);
    }

    @Override
    protected void _effectConsignationNew(Context ctx, IObjectValue model, String shareCenterId) throws BOSException, EASBizException {
        ConsignationInfo consignationInfo = (ConsignationInfo)model;
        ConsignationStatusEnum status = ConsignationStatusEnum.Effected;
        this.updateConsignationStatus(ctx, consignationInfo.getId().toString(), status);
        this.singleEffect(ctx, consignationInfo, shareCenterId);
        this.singleEffect(ctx, consignationInfo, shareCenterId, ConsignationTaskTypeEnum.qualityJob);
        this.singleEffect(ctx, consignationInfo, shareCenterId, ConsignationTaskTypeEnum.spotCheckJob);
    }

    private void _calculateQualityTaskReminderTime(Context ctx, String shareCenterId) throws BOSException {
        this.getQualitTaskRS(ctx, shareCenterId);
    }

    private void getQualitTaskRS(Context ctx, String shareCenterId) {
        HashMap map = new HashMap();
        LinkedList<QualitTask> list = new LinkedList<QualitTask>();
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(" select distinct sbt.fid taskId,");
        buffer.append(" sb.fplanfinishtime as planFinishTime ,sc.fsharecenterid as shareCenterId, ");
        buffer.append(" st.fchangetime changeTime,st.foperation operation ");
        buffer.append(" from  t_ssc_SampleLibraryQualityTask sbt  ");
        buffer.append(" inner join t_ssc_SampleLibrary sb on sb.FID =sbt.fparentid ");
        buffer.append(" inner join t_ssc_CheckScheme sc on sc.FID = sb.FCHECKSCHEMEID ");
        buffer.append(" inner join t_ssc_TaskStateTime  st on st.FTASKID = sbt.FID  ");
        buffer.append(" where (sbt.FRecheckstate=2 or sbt.FRecheckstate=3)  ");
        buffer.append(" and sb.fcheckType = 10  ");
        buffer.append(" and (sb.fstate = '2' or sb.fstate = '5') ");
        if (shareCenterId != null) {
            buffer.append(" and sc.FShareCenterId = '" + shareCenterId + "'");
        }
        try {
            Object qtt;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            while (rs.next()) {
                List<Object> listQ;
                Timestamp planFinishTime = rs.getTimestamp("planFinishTime");
                if (planFinishTime == null) continue;
                String taskId = rs.getString("taskId");
                if (map.containsKey(taskId)) {
                    listQ = (List)map.get(taskId);
                    qtt = new QualitTaskTime();
                    ((QualitTaskTime)qtt).setChangeTime(rs.getTimestamp("changeTime"));
                    ((QualitTaskTime)qtt).setOperation(rs.getString("operation"));
                    ((QualitTaskTime)qtt).setTaskId(taskId);
                    listQ.add(qtt);
                    continue;
                }
                listQ = new LinkedList();
                qtt = new QualitTaskTime();
                ((QualitTaskTime)qtt).setChangeTime(rs.getTimestamp("changeTime"));
                ((QualitTaskTime)qtt).setOperation(rs.getString("operation"));
                ((QualitTaskTime)qtt).setTaskId(taskId);
                listQ.add(qtt);
                map.put(taskId, listQ);
                QualitTask qt = new QualitTask();
                qt.setPlanFinishTime(rs.getTimestamp("planFinishTime"));
                qt.setShareCenterId(rs.getString("shareCenterId"));
                qt.setTaskId(taskId);
                list.add(qt);
            }
            HashMap<String, WorkDateUtil> workDateUtilCache = new HashMap<String, WorkDateUtil>();
            for (int i = 0; i < list.size(); ++i) {
                QualitTask qt = (QualitTask)list.get(i);
                qtt = (List)map.get(qt.getTaskId());
                WorkDateUtil util = null;
                if (StringUtils.isBlank((String)qt.getShareCenterId())) {
                    logger.debug((Object)("\u4efb\u52a1\u6ca1\u6709\u5171\u4eab\u4e2d\u5fc3id\u4fe1\u606f.\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97\u8df3\u8fc7!tsakId:" + qt.getTaskId()));
                    continue;
                }
                try {
                    if (workDateUtilCache.containsKey(qt.getShareCenterId())) {
                        util = (WorkDateUtil)workDateUtilCache.get(qt.getShareCenterId());
                    } else {
                        util = WorkDateUtil.getInstance(ctx, qt.getShareCenterId(), false);
                        workDateUtilCache.put(qt.getShareCenterId(), util);
                    }
                }
                catch (Exception e) {
                    logger.debug((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5931\u8d25,\u8df3\u8fc7\u8be5\u4efb\u52a1\u7684\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97.tsakId:" + qt.getTaskId() + "    " + e));
                }
                if (util == null) continue;
                Collections.sort(qtt, new Comparator<QualitTaskTime>(){

                    @Override
                    public int compare(QualitTaskTime arg0, QualitTaskTime arg1) {
                        if (arg0.getChangeTime().compareTo(arg1.getChangeTime()) > 0) {
                            return 1;
                        }
                        return -1;
                    }
                });
                for (int j = 0; j < qtt.size() - 1; ++j) {
                    this.calculateTime(ctx, util, qt, (QualitTaskTime)qtt.get(j), (QualitTaskTime)qtt.get(j + 1));
                }
                qt.setTimeLimit(new BigDecimal(util.getCalWorkTimes(new Timestamp(System.currentTimeMillis()), qt.getPlanFinishTime(), 0)).divide(new BigDecimal(3600000), 2, 4).add(qt.getPauseTime()).add(qt.getRescanTime()));
            }
            this.updateQualitTask(ctx, list);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateQualitTask(Context ctx, List<QualitTask> list) {
        String upsql = " update t_ssc_SampleLibraryQualityTask set FRemainderTime =? ,FExpireState =? where fid=? ";
        if (list.size() > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal limeLimit = list.get(i).getTimeLimit();
                if (limeLimit == null) continue;
                int expireState = limeLimit.doubleValue() > 2.0 ? 0 : (limeLimit.doubleValue() <= 2.0 && limeLimit.doubleValue() >= 0.0 ? 2 : 1);
                if (i > 0 && i % 1000 == 0) {
                    try {
                        DbUtil.executeBatch((Context)ctx, (String)upsql, paramList);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    paramList = new ArrayList();
                }
                paramList.add(new Object[]{limeLimit, expireState, list.get(i).getTaskId()});
            }
            try {
                DbUtil.executeBatch((Context)ctx, (String)upsql, paramList);
            }
            catch (BOSException e) {
                logger.error((Object)("\u6570\u636e\u4fee\u6539\u5f02\u5e38,sql=" + upsql.toString()));
            }
        }
    }

    private void calculateTime(Context ctx, WorkDateUtil util, QualitTask qt, QualitTaskTime fri, QualitTaskTime sed) {
        if (fri.getOperation() == "3" && sed.getOperation() == "4") {
            long pauseL = (long)util.getCalWorkTimes(fri.getChangeTime(), sed.getChangeTime(), 0);
            qt.setPauseTime(qt.getPauseTime().add(new BigDecimal(this.millSecondsToHour(pauseL))));
        }
        if (fri.getOperation() == "5" && sed.getOperation() == "16") {
            long rescanL = (long)util.getCalWorkTimes(fri.getChangeTime(), sed.getChangeTime(), 0);
            qt.setRescanTime(qt.getRescanTime().add(new BigDecimal(this.millSecondsToHour(rescanL))));
        }
    }

    private void updateDB2(Context ctx, List<SimpleTask> list) {
        String sql = " update t_ssc_SampleLibraryQualityTask set FRemainderTime =? ,FExpireState =? where fid=?";
        if (list.size() > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal remindtime = list.get(i).getRemindTime();
                int expireState = (remindtime = remindtime.divide(new BigDecimal(3600000), 2, 4)).doubleValue() > 2.0 ? 0 : (remindtime.doubleValue() <= 2.0 && remindtime.doubleValue() >= 0.0 ? 2 : 1);
                paramList.add(new Object[]{remindtime, expireState, list.get(i).getTaskId()});
            }
            try {
                DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
            }
            catch (BOSException e) {
                logger.error((Object)("\u6570\u636e\u4fee\u6539\u5f02\u5e38,sql=" + sql.toString()));
            }
        }
    }

    protected void deal(Context ctx, TaskStateTimeCollection taskTimeColl, SimpleTask simpleTask) {
        double stateChangeCostTime = 0.0;
        if (taskTimeColl != null && taskTimeColl.size() > 0) {
            Timestamp time1 = null;
            Timestamp time2 = null;
            for (int i = 0; i < taskTimeColl.size(); ++i) {
                TaskStateTimeInfo taskStateTimeInfo = taskTimeColl.get(i);
                if (taskStateTimeInfo.getOperation().getValue() == "4") {
                    time1 = taskStateTimeInfo.getCreateTime();
                } else if (taskStateTimeInfo.getOperation().getValue() == "3") {
                    time2 = taskStateTimeInfo.getCreateTime();
                } else if (taskStateTimeInfo.getOperation().getValue() == "16") {
                    time1 = taskStateTimeInfo.getCreateTime();
                } else {
                    if (taskStateTimeInfo.getOperation().getValue() != "5") continue;
                    time2 = taskStateTimeInfo.getCreateTime();
                }
                if (time1 == null || time2 == null) continue;
                WorkDateUtil util = null;
                if (StringUtils.isBlank((String)simpleTask.getShareCenterId())) {
                    logger.debug((Object)("\u4efb\u52a1\u6ca1\u6709\u5171\u4eab\u4e2d\u5fc3id\u4fe1\u606f.\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97\u8df3\u8fc7!tsakId:" + simpleTask.getTaskId()));
                    continue;
                }
                try {
                    util = WorkDateUtil.getInstance(ctx, simpleTask.getShareCenterId(), false);
                }
                catch (Exception e) {
                    logger.debug((Object)("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5931\u8d25,\u8df3\u8fc7\u8be5\u4efb\u52a1\u7684\u5269\u4f59\u65f6\u95f4\u8ba1\u7b97.tsakId:" + simpleTask.getTaskId() + "    " + e));
                }
                if (util == null) continue;
                try {
                    stateChangeCostTime += util.getCalWorkTimes(time1, time2, 0);
                }
                catch (Exception e) {
                    logger.error((Object)("\u53d6\u6d88\u6682\u6302time:" + time1 + "\u6682\u6302\u65f6\u95f4time2:" + time2));
                }
                time1 = null;
                time2 = null;
            }
        }
        simpleTask.setPauseRecanTime(new BigDecimal(stateChangeCostTime));
    }

    @Override
    protected void _calculateQualityTaskReminderTime(Context ctx) throws BOSException {
    }

    @Override
    protected void _calculateToBeAssignJob(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        logger.error((Object)("_calculateToBeAssignJob start " + Thread.currentThread().toString() + " " + System.currentTimeMillis()));
        IRowSet rowSet = null;
        HashMap<String, SimpleJob> jobId_simpleJob = new HashMap<String, SimpleJob>();
        try {
            jobId_simpleJob = new HashMap();
            rowSet = this.getRowSetByShareCenterID(ctx, shareCenterID, false, false);
            this.parseRowSet(rowSet, jobId_simpleJob, null);
            if (jobId_simpleJob != null && !jobId_simpleJob.isEmpty()) {
                this.calDwellTime(ctx, jobId_simpleJob);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    protected void _calculateAssignedJob(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        try {
            logger.error((Object)("_calculateAssignedJob start " + Thread.currentThread().toString() + " " + System.currentTimeMillis()));
            IRowSet rowSet = null;
            HashMap<String, SimpleJob> jobId_simpleJob = new HashMap<String, SimpleJob>();
            HashMap jobId_simpleJobStaTimList = new HashMap();
            jobId_simpleJob = new HashMap();
            rowSet = this.getRowSetByShareCenterID(ctx, shareCenterID, true, true);
            this.parseRowSet(rowSet, jobId_simpleJob, null);
            if (jobId_simpleJob != null && !jobId_simpleJob.isEmpty()) {
                this.calDwellTime(ctx, jobId_simpleJob);
            }
            rowSet = null;
            jobId_simpleJob = new HashMap();
            rowSet = this.getRowSetByShareCenterID(ctx, shareCenterID, true, false);
            this.parseRowSet(rowSet, jobId_simpleJob, null);
            if (jobId_simpleJob != null && !jobId_simpleJob.isEmpty()) {
                this.calDwellTime(ctx, jobId_simpleJob);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _calculateRemTime(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        logger.error((Object)("_calculateReminderTime start " + Thread.currentThread().toString() + " " + System.currentTimeMillis()));
        IRowSet rowSet = null;
        HashMap<String, SimpleJob> jobId_simpleJob = new HashMap<String, SimpleJob>();
        HashMap<String, List<SimpleJobStateTime>> jobId_simpleJobStaTimList = new HashMap<String, List<SimpleJobStateTime>>();
        try {
            HashMap<String, ReminderTimeInfo> jobId_reminderTime = new HashMap();
            rowSet = this.getRowSetByShareCenterID(ctx, shareCenterID, true, true);
            this.parseRowSet(rowSet, jobId_simpleJob, jobId_simpleJobStaTimList);
            jobId_reminderTime = this.getReminderTimeMap(ctx, jobId_simpleJob, jobId_simpleJobStaTimList);
            this.updateDB(ctx, jobId_reminderTime);
            RoleFactory.getLocalInstance(ctx).deleteTempCompelRole();
            logger.error((Object)("_calculateReminderTime end " + Thread.currentThread().toString() + " " + System.currentTimeMillis()));
        }
        finally {
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    @Override
    protected void _calculateQualityTaskReminderTimeNew(Context ctx, String shareCenterID) throws BOSException, EASBizException {
    }

    public class SimpleTask {
        private Timestamp receiveTime;
        private Timestamp planFinishTime;
        private Timestamp systemTime;
        private BigDecimal timeLimit;
        private BigDecimal pauseRecanTime;
        private BigDecimal remindTime;
        private String taskId;
        private String shareCenterId;

        public BigDecimal getPauseRecanTime() {
            return this.pauseRecanTime;
        }

        public void setPauseRecanTime(BigDecimal pauseRecanTime) {
            this.pauseRecanTime = pauseRecanTime;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public Timestamp getReceiveTime() {
            return this.receiveTime;
        }

        public void setReceiveTime(Timestamp receiveTime) {
            this.receiveTime = receiveTime;
        }

        public Timestamp getSystemTime() {
            return this.systemTime;
        }

        public void setSystemTime(Timestamp systemTime) {
            this.systemTime = systemTime;
        }

        public BigDecimal getTimeLimit() {
            return this.timeLimit;
        }

        public void setTimeLimit(BigDecimal timeLimit) {
            this.timeLimit = timeLimit;
        }

        public BigDecimal getRemindTime() {
            return this.remindTime;
        }

        public void setRemindTime(BigDecimal remindTime) {
            this.remindTime = remindTime;
        }

        public void setShareCenterId(String shareCenterId) {
            this.shareCenterId = shareCenterId;
        }

        public String getShareCenterId() {
            return this.shareCenterId;
        }

        public void setPlanFinishTime(Timestamp planFinishTime) {
            this.planFinishTime = planFinishTime;
        }

        public Timestamp getPlanFinishTime() {
            return this.planFinishTime;
        }
    }

    class QualitTask {
        private String taskId;
        private Timestamp planFinishTime;
        private String shareCenterId;
        private BigDecimal pauseTime = BigDecimal.ZERO;
        private BigDecimal rescanTime = BigDecimal.ZERO;
        private BigDecimal timeLimit;

        QualitTask() {
        }

        public BigDecimal getPauseTime() {
            return this.pauseTime;
        }

        public void setPauseTime(BigDecimal pauseTime) {
            this.pauseTime = pauseTime;
        }

        public BigDecimal getRescanTime() {
            return this.rescanTime;
        }

        public void setRescanTime(BigDecimal rescanTime) {
            this.rescanTime = rescanTime;
        }

        public BigDecimal getTimeLimit() {
            return this.timeLimit;
        }

        public void setTimeLimit(BigDecimal timeLimit) {
            this.timeLimit = timeLimit;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public Timestamp getPlanFinishTime() {
            return this.planFinishTime;
        }

        public void setPlanFinishTime(Timestamp planFinishTime) {
            this.planFinishTime = planFinishTime;
        }

        public String getShareCenterId() {
            return this.shareCenterId;
        }

        public void setShareCenterId(String shareCenterId) {
            this.shareCenterId = shareCenterId;
        }
    }

    class QualitTaskTime {
        private String taskId;
        private Timestamp changeTime;
        private String operation;

        QualitTaskTime() {
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public Timestamp getChangeTime() {
            return this.changeTime;
        }

        public void setChangeTime(Timestamp changeTime) {
            this.changeTime = changeTime;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }

    private class SimpleJobStateTime {
        private Timestamp changeTime;
        private String oldJobState;
        private String newJobState;
        private String shareCenterID;

        public SimpleJobStateTime() {
        }

        public SimpleJobStateTime(Timestamp changeTime, String oldJobState, String newJobState) {
            this.changeTime = changeTime;
            this.oldJobState = oldJobState;
            this.newJobState = newJobState;
        }

        public Timestamp getChangeTime() {
            return this.changeTime;
        }

        public void setChangeTime(Timestamp changeTime) {
            this.changeTime = changeTime;
        }

        public String getOldJobState() {
            return this.oldJobState;
        }

        public void setOldJobState(String oldJobState) {
            this.oldJobState = oldJobState;
        }

        public String getNewJobState() {
            return this.newJobState;
        }

        public void setNewJobState(String newJobState) {
            this.newJobState = newJobState;
        }

        public String getShareCenterID() {
            return this.shareCenterID;
        }

        public void setShareCenterID(String shareCenterID) {
            this.shareCenterID = shareCenterID;
        }
    }

    private class SimpleJob {
        private Timestamp receiveTime;
        private Timestamp createTime;
        private String jobPriority;
        private BigDecimal timeLimit;
        private BigDecimal urgentTimeLimit;
        private BigDecimal taskDuration;
        private BigDecimal tipLimit;
        private BigDecimal priorityValue;
        private String shareCenterID;

        public String getShareCenterID() {
            return this.shareCenterID;
        }

        public void setShareCenterID(String shareCenterID) {
            this.shareCenterID = shareCenterID;
        }

        public SimpleJob() {
        }

        public SimpleJob(Timestamp receiveTime, String jobPriority, BigDecimal timeLimit, BigDecimal urgentTimeLimit, BigDecimal taskDuration, BigDecimal priorityValue) {
            this(receiveTime, jobPriority, timeLimit, urgentTimeLimit, null, taskDuration, priorityValue);
        }

        public SimpleJob(Timestamp receiveTime, String jobPriority, BigDecimal timeLimit, BigDecimal urgentTimeLimit, BigDecimal tipLimit, BigDecimal taskDuration, BigDecimal priorityValue) {
            this(null, receiveTime, jobPriority, timeLimit, urgentTimeLimit, tipLimit, taskDuration, priorityValue);
        }

        public SimpleJob(Timestamp createTime, Timestamp receiveTime, String jobPriority, BigDecimal timeLimit, BigDecimal urgentTimeLimit, BigDecimal tipLimit, BigDecimal taskDuration, BigDecimal priorityValue) {
            this.receiveTime = receiveTime;
            this.createTime = createTime;
            this.jobPriority = jobPriority;
            this.timeLimit = timeLimit;
            this.urgentTimeLimit = urgentTimeLimit;
            this.tipLimit = tipLimit;
            this.taskDuration = taskDuration;
            this.priorityValue = priorityValue;
        }

        public Timestamp getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Timestamp createTime) {
            this.createTime = createTime;
        }

        public Timestamp getReceiveTime() {
            return this.receiveTime;
        }

        public void setReceiveTime(Timestamp receiveTime) {
            this.receiveTime = receiveTime;
        }

        public String getJobPriority() {
            return this.jobPriority;
        }

        public void setJobPriority(String jobPriority) {
            this.jobPriority = jobPriority;
        }

        public BigDecimal getTimeLimit() {
            return this.timeLimit;
        }

        public void setTimeLimit(BigDecimal timeLimit) {
            this.timeLimit = timeLimit;
        }

        public BigDecimal getUrgentTimeLimit() {
            return this.urgentTimeLimit;
        }

        public void setUrgentTimeLimit(BigDecimal urgentTimeLimit) {
            this.urgentTimeLimit = urgentTimeLimit;
        }

        public BigDecimal getTipLimit() {
            return this.tipLimit;
        }

        public void setTipLimit(BigDecimal tipLimit) {
            this.tipLimit = tipLimit;
        }

        public BigDecimal getTaskduration() {
            return this.taskDuration;
        }

        public void setTaskduration(BigDecimal taskduration) {
            this.taskDuration = taskduration;
        }

        public BigDecimal getPriorityValue() {
            return this.priorityValue;
        }

        public void setPriorityValue(BigDecimal priorityValue) {
            this.priorityValue = priorityValue;
        }
    }
}

