/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.ssc.ConsignationTaskTypeEnum;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.RoleBussattrCollection;
import com.kingdee.eas.base.ssc.RoleBussattrInfo;
import com.kingdee.eas.base.ssc.RoleCollection;
import com.kingdee.eas.base.ssc.RoleFactory;
import com.kingdee.eas.base.ssc.RoleInfo;
import com.kingdee.eas.base.ssc.RoleUserCollection;
import com.kingdee.eas.base.ssc.RoleUserFactory;
import com.kingdee.eas.base.ssc.RoleUserInfo;
import com.kingdee.eas.base.ssc.SampleLibraryQualityTaskFactory;
import com.kingdee.eas.base.ssc.app.AbstractRoleControllerBean;
import com.kingdee.eas.base.ssc.tool.FormatUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.base.ssc.tool.SscLogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RoleControllerBean
extends AbstractRoleControllerBean {
    private static final long serialVersionUID = -2244048130384317849L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.RoleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RoleInfo roleInfo = (RoleInfo)model;
        if (StringUtils.isEmpty((String)roleInfo.getShareCenterID())) {
            try {
                String shareCenterId = ShareCenterUtils.getShareCenterIdByCtx(ctx);
                roleInfo.setShareCenterID(shareCenterId);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)("\u901a\u8fc7ctx\u83b7\u53d6\u5171\u4eab\u4e2d\u5fc3ID\u5931\u8d25\uff0cctx\uff1a" + ctx.toString()));
                throw new BOSException("\u5171\u4eab\u4e2d\u5fc3\u6ca1\u6709\u5bf9\u5e94\u7684\u5916\u90e8\u7cfb\u7edf\u7528\u6237\uff01");
            }
        }
        this._checkNameDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RoleBussattrInfo info;
        int i;
        this._checkNameDup(ctx, (IObjectValue)((DataBaseInfo)model));
        this._checkNumberDup(ctx, (IObjectValue)((DataBaseInfo)model));
        RoleInfo roleInfo = this.getRoleInfo(ctx, "select *,bussattr.bussName.*,bussattr.billName.*,roleTypeID.number where id = '" + pk.toString() + "'");
        RoleBussattrCollection bussattrOri = roleInfo.getBussattr();
        RoleBussattrCollection bussattrUpd = ((RoleInfo)model).getBussattr();
        StringBuilder delete = new StringBuilder();
        StringBuilder add = new StringBuilder();
        HashSet<String> oriBuss = new HashSet<String>();
        HashSet<String> updateBuss = new HashSet<String>();
        for (i = 0; i < bussattrOri.size(); ++i) {
            info = bussattrOri.get(i);
            oriBuss.add(info.getBussName() == null ? info.getBillName().getNumber() : info.getBussName().getNumber());
        }
        for (i = 0; i < bussattrUpd.size(); ++i) {
            info = bussattrUpd.get(i);
            updateBuss.add(info.getBussName() == null ? info.getBillName().getNumber() : info.getBussName().getNumber());
        }
        for (String bussid : oriBuss) {
            if (updateBuss.contains(bussid)) continue;
            delete.append(bussid).append(",");
        }
        for (String bussid : updateBuss) {
            if (oriBuss.contains(bussid)) continue;
            add.append(bussid).append(",");
        }
        String deleteName = "            \u5220\u9664\u4efb\u52a1\u7c7b\u578b\uff1a";
        String addName = "             \u65b0\u589e\u4efb\u52a1\u7c7b\u578b\uff1a";
        if (!"ROLE_BIZ".equals(roleInfo.getRoleTypeID().getNumber()) && !"ROLE_BIZADMIN".equals(roleInfo.getRoleTypeID().getNumber())) {
            deleteName = "            \u5220\u9664\u5355\u636e\u7c7b\u578b\uff1a";
            addName = "             \u65b0\u589e\u5355\u636e\u7c7b\u578b\uff1a";
        }
        if (delete.length() > 0) {
            SscLogUtil.saveLogApp(ctx, "\u64cd\u4f5c\u89d2\u8272\uff1a" + roleInfo.getNumber() + deleteName, delete.toString(), "com.kingdee.eas.base.ssc.app.RoleControllerBean._update");
        }
        if (add.length() > 0) {
            SscLogUtil.saveLogApp(ctx, "\u64cd\u4f5c\u89d2\u8272\uff1a" + roleInfo.getNumber() + addName, add.toString(), "com.kingdee.eas.base.ssc.app.RoleControllerBean._update");
        }
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)dataBaseInfo.getString("shareCenterId"), CompareType.EQUALS));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)dataBaseInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("shareCenterID", (Object)dataBaseInfo.getString("shareCenterId"), CompareType.EQUALS));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + " : " + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    @Override
    protected IObjectValue _toWebRoleInfo(Context ctx, IObjectPK pk) throws BOSException {
        RoleInfo roleInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection tSelectColl = new SelectorItemCollection();
        tSelectColl.add(new SelectorItemInfo("id"));
        tSelectColl.add(new SelectorItemInfo("name"));
        tSelectColl.add(new SelectorItemInfo("number"));
        tSelectColl.add(new SelectorItemInfo("description"));
        tSelectColl.add(new SelectorItemInfo("roleTypeID.*"));
        tSelectColl.add(new SelectorItemInfo("bussattr.bussName.id"));
        tSelectColl.add(new SelectorItemInfo("bussattr.bussName.name"));
        tSelectColl.add(new SelectorItemInfo("bussattr.bussName.number"));
        tSelectColl.add(new SelectorItemInfo("bussattr.bussName.billType.*"));
        tSelectColl.add(new SelectorItemInfo("bussattr.bussName.systemAttribute.*"));
        tSelectColl.add(new SelectorItemInfo("bussattr.billName.*"));
        viewInfo.setSelector(tSelectColl);
        FilterInfo filterReLevel = new FilterInfo();
        filterReLevel.appendFilterItem("id", (Object)pk.toString());
        viewInfo.setFilter(filterReLevel);
        RoleCollection roleCollection = RoleFactory.getLocalInstance(ctx).getRoleCollection(viewInfo);
        if (roleCollection != null && roleCollection.size() > 0) {
            roleInfo = roleCollection.get(0);
        }
        return roleInfo;
    }

    @Override
    protected void _deleteAllTempRole(Context ctx) throws BOSException, EASBizException {
        this.deleteTempRoleByNumber(ctx, "addFor%");
    }

    @Override
    protected void _deleteTempCompelRole(Context ctx) throws BOSException, EASBizException {
        this.deleteTempRoleByNumber(ctx, "addForCompel%");
    }

    @Override
    protected void _deleteTempConsignRole(Context ctx) throws BOSException, EASBizException {
        this.deleteTempRoleByNumber(ctx, "addForConsign%");
    }

    private void deleteTempRoleByNumber(Context ctx, String number) throws BOSException, EASBizException {
        FilterInfo rolefilter = new FilterInfo();
        rolefilter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.LIKE));
        RoleCollection roleColl = this.getRoleCollection(ctx, EntityViewInfo.getInstance((FilterInfo)rolefilter, null, null));
        int len = roleColl.size();
        for (int i = 0; i < len; ++i) {
            RoleInfo roleInfo = roleColl.get(i);
            String roleId = roleInfo.getId().toString();
            RoleBussattrCollection rbc = roleInfo.getBussattr();
            ArrayList<String> rbIds = new ArrayList<String>();
            for (int k = 0; k < rbc.size(); ++k) {
                rbIds.add(rbc.get(k).getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("roleID.id", (Object)roleId));
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("userID.*");
            view.setSelector(sic);
            RoleUserCollection ruc = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
            if (rbIds.size() <= 0) continue;
            for (int j = 0; j < ruc.size(); ++j) {
                RoleUserInfo ruInfo = ruc.get(j);
                String userId = ruInfo.getUserID().getId().toString();
                boolean isNotDeleteRole = true;
                if ("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=".equals(roleInfo.getRoleTypeID().getId().toString())) {
                    isNotDeleteRole = this.existUnProcessShareJob(ctx, rbIds, roleId, userId);
                } else if ("BqMHsn0QTrafsG4XPzjMpC0WZ4A=".equals(roleInfo.getRoleTypeID().getId().toString())) {
                    isNotDeleteRole = this.existUnProcessCheckJoB(ctx, rbIds, roleId, userId, ConsignationTaskTypeEnum.qualityJob);
                } else if ("o9Taq/+5QSKDMQrAQo+1uS0WZ4A=".equals(roleInfo.getRoleTypeID().getId().toString())) {
                    isNotDeleteRole = this.existUnProcessCheckJoB(ctx, rbIds, roleId, userId, ConsignationTaskTypeEnum.spotCheckJob);
                }
                if (isNotDeleteRole) continue;
                FilterInfo rufilter = new FilterInfo();
                rufilter.getFilterItems().add(new FilterItemInfo("roleID.id", (Object)roleId));
                rufilter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
                RoleUserFactory.getLocalInstance(ctx).delete(rufilter);
            }
        }
    }

    private boolean existUnProcessShareJob(Context ctx, List<String> roleBussIds, String roleId, String userId) throws BOSException, EASBizException {
        FilterInfo jobfilter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select j.fid from t_ssc_job j ");
        sql.append(" inner join T_SSC_RoleBussattr rb on j.FBussAttrIDID = rb.FBussNameID");
        sql.append(" and rb.fid in " + FormatUtils.list2Sql(roleBussIds));
        sql.append(" inner join t_ssc_roleuser ru on rb.FParentID = ru.FRoleIDID and j.FPERSONNELIDID = ru.fuseridid");
        sql.append(" where rb.FParentID ='" + roleId + "'");
        sql.append(" and j.fpersonnelidid ='" + userId + "'");
        jobfilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return JobFactory.getLocalInstance(ctx).exists(jobfilter);
    }

    private boolean existUnProcessCheckJoB(Context ctx, List<String> roleBussIds, String roleId, String userId, ConsignationTaskTypeEnum taskType) throws BOSException, EASBizException {
        FilterInfo jobfilter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select st.fid from T_SSC_SampleLibraryQualityTask st ");
        sql.append(" inner join T_SSC_RoleBussattr rb on st.fbilltypeid = rb.fbillnameid");
        sql.append(" and rb.fid in " + FormatUtils.list2Sql(roleBussIds));
        sql.append(" inner join t_ssc_roleuser ru on rb.FParentID = ru.FRoleIDID and st.FEXAMINERID = ru.fuseridid");
        sql.append(" inner join T_SSC_SampleLibrary sl on st.FPARENTID = sl.fid");
        sql.append(" where rb.FParentID ='" + roleId + "'");
        sql.append(" and st.FEXAMINERID ='" + userId + "'");
        sql.append(" and st.FTASKSTATE ='2'");
        if (ConsignationTaskTypeEnum.qualityJob.equals((Object)taskType)) {
            sql.append(" and sl.FCHECKTYPE = '20'");
        } else if (ConsignationTaskTypeEnum.spotCheckJob.equals((Object)taskType)) {
            sql.append(" and sl.FCHECKTYPE = '10'");
        }
        jobfilter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return SampleLibraryQualityTaskFactory.getLocalInstance(ctx).exists(jobfilter);
    }
}

