/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.ssc.BillTypeFactory;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.JobHisInfo;
import com.kingdee.eas.base.ssc.SatisfactionSettingEntryFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingFactory;
import com.kingdee.eas.base.ssc.SatisfactionSettingInfo;
import com.kingdee.eas.base.ssc.app.AbstractSatisfactionDataFilterFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SatisfactionDataFilterFacadeControllerBean
extends AbstractSatisfactionDataFilterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SatisfactionDataFilterFacadeControllerBean");

    @Override
    protected boolean _isNeedToSatisfactionTaskByJobhis(Context ctx, JobHisInfo jobHisInfo) throws BOSException, EASBizException {
        String isSatisfaction = ParamManager.getParamValue((Context)ctx, (IObjectPK)H.PK(jobHisInfo.getShareCenterID().getId().toString()), (String)"SSC_SatisfactionControl");
        if (!"true".equals(isSatisfaction)) {
            return false;
        }
        BillTypeInfo billTypeInfo = jobHisInfo.getBussAttrID().getBillType();
        if (billTypeInfo == null) {
            BussinessAttributeInfo bussinessAttributeInfo = BussinessAttributeFactory.getLocalInstance(ctx).getBussinessAttributeInfo(H.PK(jobHisInfo.getBussAttrID().getId().toString()));
            billTypeInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(bussinessAttributeInfo.getBillType().getId().toString()));
        }
        try {
            String billTypeID = billTypeInfo.getId().toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billtypeName", (Object)billTypeID));
            boolean hasBill = SatisfactionSettingEntryFactory.getLocalInstance(ctx).exists(filterInfo);
            if (!hasBill) {
                return false;
            }
            ArrayList<String> billTypeIds = new ArrayList<String>();
            billTypeIds.add(billTypeID);
            String baseSql = " select j.fid  from t_ssc_jobhis j inner join T_SSC_DynValueHis DV on j.fid=DV.Fjobidid inner join t_ssc_dynamicattribute DT on DV.Fdynamicidid=DT.Fid where j.fid=?";
            Map map = this.getFilteringSql(ctx, billTypeIds, baseSql, jobHisInfo.getShareCenterID().getId().toString());
            logger.info((Object)("---map " + (map == null ? "" : map.toString())));
            String tarSql = (String)map.get(billTypeIds.get(0));
            tarSql = tarSql.replaceAll("\\?", " '" + jobHisInfo.getId().toString() + "' ");
            logger.info((Object)("---tarSql " + (tarSql == null ? "" : tarSql)));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(" /*dialect*/ " + tarSql));
            return rs.next();
        }
        catch (Exception e) {
            logger.error((Object)"SQLException--SatisfactionDataFilterFacadeControllerBean", (Throwable)e);
            return false;
        }
    }

    private Map getFilteringSql(Context ctx, List billTypeIds, String baseSql, String shareCenterId) throws BOSException, EASBizException {
        SatisfactionSettingInfo satisfactionSettingInfo = SatisfactionSettingFactory.getLocalInstance(ctx).getValueBySCOrg(H.PK(shareCenterId));
        if (satisfactionSettingInfo != null) {
            HashMap<String, String> result = null;
            try {
                result = new HashMap<String, String>();
                for (Object btid : billTypeIds) {
                    result.put(btid.toString(), this.getSql(ctx, btid.toString(), shareCenterId, baseSql));
                    logger.info((Object)("-----&&****\u5355\u636e\u7c7b\u578bID\uff1a" + btid.toString() + "  SQL: " + baseSql));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return result;
        }
        NumericExceptionSubItem item = new NumericExceptionSubItem("satisfactionSetting is null!", "\u8bf7\u5148\u914d\u7f6e\u6ee1\u610f\u5ea6\u8bbe\u7f6e!");
        throw new EASBizException(item);
    }

    private String getSql(Context ctx, String billTypeId, String shareCenterId, String baseSql) throws EASBizException, BOSException, SQLException {
        String sql = "SELECT DFR.FID,DFR.FLEFTBRACKET,DFR.FPROPERTY,DFR.FCOMPARISONOPER,DFR.FCOMPARISONVALUE,DFR.FRIGHTBRACKET,DFR.FLOGICALCONDITION,DFR.FPROPERTYTYPE FROM T_SSC_SatisfactionDFRE DFR INNER JOIN T_SSC_SatisfactionSE CP ON DFR.FPARENTID = CP.FdataFilterRule INNER JOIN T_SSC_SatisfactionS CPS ON CPS.FID = CP.FParentID WHERE CPS.FSCOrg = '" + shareCenterId + "' and CP.FbilltypeName = '" + billTypeId + "' order by DFR.FSEQ ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String leftBracket = null;
        String property = null;
        String comparisonOper = null;
        String comparisonValue = null;
        String rightBracket = null;
        String logicalCondition = null;
        String propertyType = null;
        StringBuffer dynCondition = new StringBuffer();
        ArrayList<String> comparisonValues = new ArrayList<String>();
        String querySql = baseSql = " " + baseSql.toUpperCase();
        while (rowSet.next()) {
            leftBracket = rowSet.getString("FLEFTBRACKET");
            property = rowSet.getString("FPROPERTY");
            comparisonOper = rowSet.getString("FCOMPARISONOPER");
            comparisonValue = rowSet.getString("FCOMPARISONVALUE");
            rightBracket = rowSet.getString("FRIGHTBRACKET");
            logicalCondition = rowSet.getString("FLOGICALCONDITION");
            propertyType = rowSet.getString("FPROPERTYTYPE");
            if (comparisonOper != null) {
                comparisonOper = comparisonOper.toUpperCase().trim();
            }
            dynCondition.append(leftBracket == null ? "" : leftBracket);
            if ("1".equals(propertyType)) {
                dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDIGIVALUE ").append(comparisonOper).append(" ").append(Double.parseDouble(comparisonValue)).append(" ] ");
            } else if ("2".equals(propertyType)) {
                dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & subString${DV.FDINAMICVALUE,1,10 subString$} ").append(comparisonOper).append(" '").append(comparisonOper).append("' ] ");
            } else {
                if ("<>".equals(comparisonOper)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE <> '^' or DV.FDINAMICVALUE IS NULL] ]");
                } else if ("NOT LIKE".equals(comparisonOper)) {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & [DV.FDINAMICVALUE NOT LIKE '%^%' or DV.FDINAMICVALUE IS NULL] ]");
                } else {
                    dynCondition.append(" [DT.FNUMBER = '").append(property).append("' & DV.FDINAMICVALUE ").append(comparisonOper);
                    if ("IN".equals(comparisonOper) || "NOT IN".equals(comparisonOper)) {
                        dynCondition.append(" ['^'] ");
                    } else if ("LIKE".equals(comparisonOper)) {
                        dynCondition.append(" '%^%'");
                    } else {
                        dynCondition.append(" '^'");
                    }
                    dynCondition.append(" ] ");
                }
                comparisonValues.add(comparisonValue);
            }
            dynCondition.append(rightBracket == null ? "" : rightBracket);
            if (rowSet.isLast()) continue;
            if (StringUtils.isEmpty((String)logicalCondition)) {
                dynCondition.append("AND");
                continue;
            }
            dynCondition.append(logicalCondition.toUpperCase());
        }
        ArrayList<SQLInfo> sqlInfos = new ArrayList<SQLInfo>();
        this.parseDynamicCondition(dynCondition.toString(), sqlInfos);
        querySql = this.generateSQLByInfo(baseSql, sqlInfos);
        int i = 0;
        while (querySql.indexOf("^") > -1) {
            querySql = querySql.replaceFirst("\\^", (String)comparisonValues.get(i));
            ++i;
        }
        querySql = querySql.replace("subString${", "subStr(");
        querySql = querySql.replace("subString$}", ")");
        return querySql;
    }

    private void parseDynamicCondition(String dynSql, List<SQLInfo> infos) {
        if ("".equals(dynSql.trim())) {
            return;
        }
        int leftBracketPoint = dynSql.indexOf("(");
        int andPoint = dynSql.indexOf("AND");
        int orPoint = dynSql.indexOf("OR");
        if (leftBracketPoint > -1) {
            if (andPoint > -1) {
                if (leftBracketPoint < andPoint) {
                    if (orPoint > -1) {
                        if (leftBracketPoint < orPoint) {
                            this.parseBracket(dynSql, leftBracketPoint, infos);
                        } else {
                            this.parseOr(dynSql, orPoint, infos);
                        }
                    } else {
                        this.parseBracket(dynSql, leftBracketPoint, infos);
                    }
                } else if (orPoint > -1) {
                    if (andPoint < orPoint) {
                        this.parseAnd(dynSql, andPoint, infos);
                    } else {
                        this.parseOr(dynSql, orPoint, infos);
                    }
                } else {
                    this.parseAnd(dynSql, andPoint, infos);
                }
            } else if (orPoint > -1) {
                if (leftBracketPoint < orPoint) {
                    this.parseBracket(dynSql, leftBracketPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseBracket(dynSql, leftBracketPoint, infos);
            }
        } else if (andPoint > -1) {
            if (orPoint > -1) {
                if (andPoint < orPoint) {
                    this.parseAnd(dynSql, andPoint, infos);
                } else {
                    this.parseOr(dynSql, orPoint, infos);
                }
            } else {
                this.parseAnd(dynSql, andPoint, infos);
            }
        } else if (orPoint > -1) {
            this.parseOr(dynSql, orPoint, infos);
        } else {
            SQLInfo info = new SQLInfo();
            info.setSql(dynSql);
            infos.add(info);
            return;
        }
    }

    private String generateSQLByInfo(String baseSql, List<SQLInfo> sqlInfos) {
        if (sqlInfos.isEmpty()) {
            return baseSql;
        }
        StringBuffer allSql = new StringBuffer("(");
        StringBuffer tmpSql = null;
        String joinType = null;
        String infoSql = null;
        for (SQLInfo info : sqlInfos) {
            joinType = info.getJoinType();
            infoSql = info.getSql();
            joinType = "AND".equals(joinType) ? " INTERSECT " : ("OR".equals(joinType) ? ") UNION (" : "");
            if (infoSql.indexOf("AND") > -1) {
                allSql.append("(");
                ArrayList<SQLInfo> tempInfos = new ArrayList<SQLInfo>();
                infoSql = infoSql.substring(1, infoSql.length() - 1);
                this.parseDynamicCondition(infoSql, tempInfos);
                allSql.append(this.generateSQLByInfo(baseSql, tempInfos).replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
                continue;
            }
            tmpSql = new StringBuffer("(");
            tmpSql.append(baseSql);
            if (baseSql.indexOf("WHERE") > -1) {
                tmpSql.append(" AND ");
            } else {
                tmpSql.append(" WHERE ");
            }
            tmpSql.append(infoSql.replaceAll("&", "AND").replaceAll("\\[", "(").replaceAll("\\]", ")")).append(")").append(joinType);
            allSql.append(tmpSql);
        }
        return allSql.append(")").toString();
    }

    private void parseBracket(String dynSql, int leftBracketPoint, List<SQLInfo> infos) {
        int nextPoint = dynSql.indexOf(")");
        String temp = dynSql.substring(leftBracketPoint, nextPoint + 1);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length(), dynSql.length());
            int andJoinPoint = dynSql.indexOf("AND");
            int orJoinPoint = dynSql.indexOf("OR");
            if (andJoinPoint > -1) {
                if (orJoinPoint > -1) {
                    if (andJoinPoint < orJoinPoint) {
                        info.setJoinType("AND");
                        infos.add(info);
                        dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    } else {
                        info.setJoinType("OR");
                        infos.add(info);
                        dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                        this.parseDynamicCondition(dynSql, infos);
                    }
                } else {
                    info.setJoinType("AND");
                    infos.add(info);
                    dynSql = dynSql.substring(andJoinPoint + 3, dynSql.length());
                    this.parseDynamicCondition(dynSql, infos);
                }
            } else if (orJoinPoint > -1) {
                info.setJoinType("OR");
                infos.add(info);
                dynSql = dynSql.substring(orJoinPoint + 2, dynSql.length());
                this.parseDynamicCondition(dynSql, infos);
            }
        } else {
            infos.add(info);
        }
    }

    private void parseAnd(String dynSql, int andPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, andPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("AND");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 3, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    private void parseOr(String dynSql, int orPoint, List<SQLInfo> infos) {
        String temp = dynSql.substring(0, orPoint);
        SQLInfo info = new SQLInfo();
        info.setSql(temp);
        info.setJoinType("OR");
        infos.add(info);
        if (temp.length() < dynSql.length()) {
            dynSql = dynSql.substring(temp.length() + 2, dynSql.length());
            this.parseDynamicCondition(dynSql, infos);
        }
    }

    class SQLInfo {
        private String sql;
        private String joinType;

        SQLInfo() {
        }

        public String getSql() {
            return this.sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public String getJoinType() {
            return this.joinType;
        }

        public void setJoinType(String joinType) {
            this.joinType = joinType;
        }

        public String toString() {
            return "SQL: " + this.sql + "\r\nJoinType: " + this.joinType;
        }
    }
}

