/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BillTypeCfgFactory;
import com.kingdee.eas.base.ssc.BillTypeCfgInfo;
import com.kingdee.eas.base.ssc.BillTypeInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.JobClassificationEnum;
import com.kingdee.eas.base.ssc.RoleUserCollection;
import com.kingdee.eas.base.ssc.RoleUserFactory;
import com.kingdee.eas.base.ssc.RoleUserInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.UserCollection;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.app.AbstractSingleLoginFacadeControllerBean;
import com.kingdee.eas.base.ssc.common.SscJobConfig;
import com.kingdee.eas.base.ssc.tool.JobPoolUtils;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SingleLoginFacadeControllerBean
extends AbstractSingleLoginFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.SingleLoginFacadeControllerBean");
    private final String ROLE_BIZ = "F68lZzqpRWC1K1nV8ZYPgS0WZ4A=";
    private final String ROLE_BIZADMIN = "hEw8bwRNR8qPRPajcUdX4C0WZ4A=";
    private final String ROLE_AUDIT = "BqMHsn0QTrafsG4XPzjMpC0WZ4A=";
    private final String ROLE_QUALITY = "dH8LikDSRvuYwxTuw5HhRC0WZ4A=";
    private final String ROLE_LATER = "o9Taq/+5QSKDMQrAQo+1uS0WZ4A=";
    private final String ROLE_RECHECKADMIN = "6Wn1FlPySgCeSKzwlcjYqy0WZ4A=";

    @Override
    protected String _getUipk(Context ctx, String userId) throws BOSException, EASBizException {
        String sql = new StringBuffer().append(" select FUrl from T_SSC_RoleTypeResource RTResource").append(" inner join T_SSC_RoleType RoleType").append(" on RTResource.FRoleTypeIDID = RoleType.FID").append(" inner join T_SSC_Role Role").append(" on RoleType.FID = Role.FRoleTypeIDID").append(" inner join T_SSC_RoleUser RoleUser").append(" on Role.FID = RoleUser.FRoleIDID").append(" inner join T_SSC_User SSCUser").append(" on RoleUser.FUserIDID = SSCUser.FID").append(" where SSCUser.FID = ?").toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
        try {
            if (rs.next()) {
                return rs.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected boolean _isSystemAdmin(Context ctx, String userId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)"kJw0DLomSVOY7eNhPIIKSi0WZ4A="));
        view.setFilter(filter);
        RoleUserCollection coll = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        return coll != null && coll.size() != 0;
    }

    @Override
    protected List _getUserBussAttr(Context ctx, String userId) throws BOSException, EASBizException {
        ArrayList<BussinessAttributeInfo> bussAttrList = new ArrayList<BussinessAttributeInfo>();
        DataBaseInfo scInfo = ShareCenterUtils.getShareCenterInfo(ctx);
        if (scInfo == null || scInfo.getId() == null) {
            throw new SSCException(SSCException.UNKNOW, new Object[]{"\u8bf7\u8054\u7cfb\u5171\u4eab\u96c6\u56e2\u7ba1\u7406\u5458\u8fdb\u884c\u591a\u5171\u4eab\u4e2d\u5fc3\u6a21\u5f0f\u521d\u59cb\u5316\uff01"});
        }
        String shareCenterFilter = ShareCenterUtils.getShareCenterParentIDs(ctx, new StringBuffer(), scInfo != null && scInfo.getId() != null ? scInfo.getId().toString() : null);
        StringBuffer sql = JobPoolUtils.getBussSql(ctx, shareCenterFilter);
        sql.append("order by bussattrnumber asc");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, scInfo.getId().toString()});
            while (rs.next()) {
                String roleTypeId = rs.getString("roletypeid");
                String bussAttrId = rs.getString("bussattrid");
                String bussAttName = rs.getString("bussattrname");
                String bussAttrNumber = rs.getString("bussattrnumber");
                String url = rs.getString("url");
                String billTypeId = rs.getString("billtypeid");
                String billTypeNumber = rs.getString("billtypenumber");
                String billTypeName = rs.getString("billtypename");
                String billTypeSourceId = rs.getString("billtypesourceid");
                int jobClassification = rs.getInt("jobClassification");
                String sysattrId = rs.getString("sysattrId");
                BussinessAttributeInfo newAttr = new BussinessAttributeInfo();
                newAttr.setId(BOSUuid.read((String)bussAttrId));
                newAttr.setName(bussAttName);
                newAttr.setNumber(bussAttrNumber);
                newAttr.setUrl(url);
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)billTypeId));
                billTypeInfo.setName(billTypeName);
                billTypeInfo.setNumber(billTypeNumber);
                BillTypeCfgInfo info = (BillTypeCfgInfo)BillTypeCfgFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(billTypeSourceId));
                billTypeInfo.setBillSourceId(info);
                SystemAttributeInfo sysAttrInfo = new SystemAttributeInfo();
                sysAttrInfo.setId(BOSUuid.read((String)sysattrId));
                billTypeInfo.setSysAttr(sysAttrInfo);
                newAttr.setBillType(billTypeInfo);
                newAttr.setJobClassification(JobClassificationEnum.getEnum(jobClassification));
                String type = this.getType(roleTypeId);
                newAttr.setString("roleType" + type, roleTypeId);
                bussAttrList.add(newAttr);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return bussAttrList;
    }

    private boolean isExists(List bussAttrList, String roleTypeId, String type, String bussAttrId) {
        int size = bussAttrList.size();
        for (int i = 0; i < size; ++i) {
            BussinessAttributeInfo attrInfo = (BussinessAttributeInfo)bussAttrList.get(i);
            if (StringUtils.isEmpty((String)attrInfo.getString("roleType" + type)) || !attrInfo.getString("roleType" + type).equals(roleTypeId) || attrInfo.getId() == null || !attrInfo.getId().toString().equals(bussAttrId)) continue;
            return true;
        }
        return false;
    }

    private String getType(String id) {
        String type = "";
        if (id.equals("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=")) {
            type = "BIZ";
        } else if (id.equals("hEw8bwRNR8qPRPajcUdX4C0WZ4A=")) {
            type = "BIZADMIN";
        } else if (id.equals("BqMHsn0QTrafsG4XPzjMpC0WZ4A=")) {
            type = "AUDIT";
        } else if (id.equals("dH8LikDSRvuYwxTuw5HhRC0WZ4A=")) {
            type = "ADMIN";
        } else if (id.equals("o9Taq/+5QSKDMQrAQo+1uS0WZ4A=")) {
            type = "LATER";
        } else if (id.equals("6Wn1FlPySgCeSKzwlcjYqy0WZ4A=")) {
            type = "RECHECKADMIN";
        }
        return type;
    }

    @Override
    protected String _getSscUserId(Context ctx, String erpUserId) throws BOSException, EASBizException {
        UserInfo userInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("easUserId", (Object)erpUserId));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)1));
        view.setFilter(filter);
        UserCollection userCollection = UserFactory.getLocalInstance(ctx).getUserCollection(view);
        if (userCollection == null || userCollection.size() == 0) {
            return null;
        }
        userInfo = userCollection.get(0);
        return userInfo.getId().toString();
    }

    @Override
    protected Map _getBussAttr2ModelCode(Context ctx) throws BOSException {
        Map<String, String> map = SscJobConfig.getInstance().getBillType2ModelCode();
        return map;
    }

    @Override
    protected Map _getBillType2ModelCodeMap(Context ctx) throws BOSException {
        Map<String, String> map = SscJobConfig.getInstance().getBillType2ModelCode();
        return map;
    }

    @Override
    protected List _getUserBussAttrByRole(Context ctx, String userId, String roleType) throws BOSException {
        ArrayList<BussinessAttributeInfo> bussAttrList = new ArrayList<BussinessAttributeInfo>();
        HashSet<String> bussAttrIdSet = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)roleType));
        sic.add("id");
        sic.add("userID.id");
        sic.add("roleID.id");
        sic.add("roleID.roleTypeID.id");
        sic.add("roleID.bussattr.bussName.id");
        sic.add("roleID.bussattr.bussName.name");
        sic.add("roleID.bussattr.bussName.url");
        sic.add("roleID.bussattr.bussName.number");
        sic.add("roleID.bussattr.bussName.billType.id");
        sic.add("roleID.bussattr.bussName.billType.number");
        sic.add("roleID.bussattr.bussName.billType.name");
        RoleUserCollection roleUserColl = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        if (roleUserColl != null && roleUserColl.size() > 0) {
            for (int i = 0; i < roleUserColl.size(); ++i) {
                RoleUserInfo roleUserInfo = roleUserColl.get(i);
                if (roleUserInfo.getRoleID() == null || roleUserInfo.getRoleID().getBussattr().size() <= 0) continue;
                for (int j = 0; j < roleUserInfo.getRoleID().getBussattr().size(); ++j) {
                    String id;
                    if (roleUserInfo.getRoleID().getBussattr().get(j).getBussName() == null || bussAttrIdSet.contains(id = roleUserInfo.getRoleID().getBussattr().get(j).getBussName().getId().toString())) continue;
                    bussAttrIdSet.add(id);
                    roleUserInfo.getRoleID().getBussattr().get(j).getBussName().setString("roleType", roleUserInfo.getRoleID().getRoleTypeID().getId().toString());
                    bussAttrList.add(roleUserInfo.getRoleID().getBussattr().get(j).getBussName());
                }
            }
        }
        return bussAttrList;
    }

    @Override
    protected void _hasSSCFunctionPermission(Context ctx, String userId, String roleTypeId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("userID.isEnabled", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("userID.id", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("roleID.roleTypeID.id", (Object)roleTypeId));
        sic.add("id");
        RoleUserCollection roleUserColl = RoleUserFactory.getLocalInstance(ctx).getRoleUserCollection(view);
        if (roleUserColl == null || roleUserColl.size() == 0) {
            if ("F68lZzqpRWC1K1nV8ZYPgS0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_BIZ_PERMISSION);
            }
            if ("hEw8bwRNR8qPRPajcUdX4C0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_ADMIN_PERMISSION);
            }
            if ("BqMHsn0QTrafsG4XPzjMpC0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_QMBIZ_PERMISSION);
            }
            if ("dH8LikDSRvuYwxTuw5HhRC0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_QMADMIN_PERMISSION);
            }
            if ("o9Taq/+5QSKDMQrAQo+1uS0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_SMBIZ_PERMISSION);
            }
            if ("6Wn1FlPySgCeSKzwlcjYqy0WZ4A=".equals(roleTypeId)) {
                throw new SSCException(SSCException.NO_SMADMIN_PERMISSION);
            }
        }
    }

    private String getSSCUserId(Context ctx, String sscUserId) throws BOSException, EASBizException {
        UserInfo userInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sscUserId));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isEnabled");
        view.setSelector(sic);
        UserCollection userCollection = UserFactory.getLocalInstance(ctx).getUserCollection(view);
        if (userCollection == null || userCollection.size() == 0) {
            logger.error((Object)"-----can not find sscuser-------");
            throw new SSCException(SSCException.NO_ERP_USER);
        }
        for (int i = 0; i < userCollection.size(); ++i) {
            userInfo = userCollection.get(i);
            if (!userInfo.isIsEnabled()) continue;
            return userInfo.getId().toString();
        }
        throw new SSCException(SSCException.NO_ENABLE_USER);
    }
}

