/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.assign.flow.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryFactory;
import com.kingdee.eas.base.ssc.BussinessAttributeEntryInfo;
import com.kingdee.eas.base.ssc.JobExpireState;
import com.kingdee.eas.base.ssc.JobExtCollection;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobExtInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobPoolingType;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.Operation;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.WorkPressureFactory;
import com.kingdee.eas.base.ssc.app.AssignJobFacadeControllerBean;
import com.kingdee.eas.base.ssc.app.OldJobStateEnum;
import com.kingdee.eas.base.ssc.app.assign.flow.IAssignFlowCallback;
import com.kingdee.eas.base.ssc.app.assign.util.AssignJobUtils;
import com.kingdee.eas.base.ssc.assign.AssignModelInfo;
import com.kingdee.eas.base.ssc.bussiness.bean.JobBean;
import com.kingdee.eas.base.ssc.tool.EqualDivisionUtils;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.tool.SSCDbUtil;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultAssignFlowCallback
implements IAssignFlowCallback {
    private static Logger logger = Logger.getLogger(DefaultAssignFlowCallback.class);
    private static final String APPLICATIONNAME = "\u66f4\u65b0\u5de5\u4f5c\u6d41\u4eba\u5458";
    private static final String THREADPOOLNAME = "\u4efb\u52a1\u5206\u914d\u8c03\u7528\u5de5\u4f5c\u6d41\u63a5\u53e3\u7ebf\u7a0b\u6c60";
    private static volatile ExecutorService executorService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService getPool(Context ctx) {
        if (executorService != null) return executorService;
        Class<DefaultAssignFlowCallback> clazz = DefaultAssignFlowCallback.class;
        synchronized (DefaultAssignFlowCallback.class) {
            ThreadPoolProperties properties;
            if (executorService != null) return executorService;
            DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
            DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
            if (!dynamicThreadPoolProperties.exists(properties = new ThreadPoolBuilder().ctx(ctx).applicationName(APPLICATIONNAME).threadPoolName(ctx.getAIS() + "\uff1b" + THREADPOOLNAME).corePoolSize(10).maximumPoolSize(10).queueCapacity(500).keepAliveTime(Long.valueOf(0L)).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties())) {
                dynamicThreadPoolProperties.getExecutors().add(properties);
            }
            manager.createThreadPoolExecutor(dynamicThreadPoolProperties);
            executorService = manager.getThreadPoolExecutor(APPLICATIONNAME, ctx.getAIS() + "\uff1b" + THREADPOOLNAME);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return executorService;
        }
    }

    @Override
    public String afterFlow(Context ctx, AssignModelInfo modelInfo) throws EASBizException, BOSException {
        long startTime = System.currentTimeMillis();
        JobInfo job = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(modelInfo.getTaskId()));
        Map map = modelInfo.getExtendPropertiesForMap();
        JSONObject result = new JSONObject();
        result.put("result", (Object)false);
        result.put("message", (Object)"");
        UserInfo userInfo = null;
        Operation op = null;
        if (map.get("pullPerson") != null) {
            if (!modelInfo.getAssignee().toString().equals(map.get("pullPerson"))) {
                logger.error((Object)("\u4e0d\u5339\u914d\uff0c\u4efb\u52a1ID\uff1a" + job.getId().toString() + "\uff1b\u5206\u914d\u4eba\uff1a" + modelInfo.getAssignee().toString() + "\uff1b\u62c9\u53d6\u4eba\uff1a" + map.get("pullPerson")));
                result.put("message", (Object)("\u4efb\u52a1\u62c9\u53d6\u5931\u8d25\uff0c\u6700\u7ec8\u5206\u914d\u4eba:" + modelInfo.getAssignee().toString() + "\u548c\u62c9\u53d6\u4eba:" + map.get("pullPerson") + "\u4e0d\u4e00\u81f4\uff01"));
                return result.toJSONString();
            }
            userInfo = UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(modelInfo.getAssignee().toString()));
            op = Operation.ActiveGetTask;
        }
        if (map.get("consigner") != null) {
            job.setConsigner(UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(map.get("consigner").toString())));
        }
        UserInfo user = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)new ObjectUuidPK(modelInfo.getAssignee()));
        ArrayList<JobBean> jobBeanList = new ArrayList<JobBean>();
        this.setAssignUser(ctx, job, user);
        if (this.saveAssignUser(ctx, job)) {
            JobBean jobBean = new JobBean();
            jobBean.setJobInfo(job);
            jobBean.setJobState(job.getJobState());
            jobBean.setUserId(job.getPersonnelID().getUserID());
            jobBeanList.add(jobBean);
            try {
                AssignJobUtils.jobStateTime(ctx, jobBeanList, userInfo, op);
            }
            catch (Exception e) {
                logger.error((Object)"\u4fdd\u5b58\u72b6\u6001\u8ddf\u8e2a\u8868\u5931\u8d25\uff01", (Throwable)e);
            }
            long endTime = System.currentTimeMillis();
            logger.error((Object)("\u66f4\u65b0job\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms"));
            try {
                this.getPool(ctx).submit(new NoticeOtherServiceRunnable().setAttribute(ctx, jobBeanList));
            }
            catch (Exception e) {
                logger.error((Object)("\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u9519\u8bef\uff1agetPool(ctx) = " + (this.getPool(ctx) == null ? "null" : this.getPool(ctx).toString())), (Throwable)e);
            }
            result.put("result", (Object)true);
        }
        return result.toJSONString();
    }

    public JobInfo setAssignUser(Context ctx, JobInfo job, UserInfo user) throws EASBizException, BOSException {
        job.setPersonnelID(user);
        job.setJobPoolingType(JobPoolingType.Operating);
        job.setReceiveTime(new Timestamp(new Date().getTime()));
        this.setJobSate(ctx, job);
        BigDecimal timeDuration = this.getTimeByIds(ctx, job.getBussAttrID().getId().toString(), job.getJoblevel().getId().toString(), job.getShareCenterID().getId().toString());
        job.setRemainderTime(timeDuration);
        job.setIsExpired(false);
        job.setExpireState(JobExpireState.Normal);
        return job;
    }

    private void setJobSate(Context ctx, JobInfo job) {
        job.setJobState(JobState.Normal);
        if (job.getOldJobState() == OldJobStateEnum.paues) {
            job.setJobState(JobState.Pause);
        } else if (job.getOldJobState() == OldJobStateEnum.rescan) {
            job.setJobState(JobState.ReScan);
        } else if (job.getOldJobState() == OldJobStateEnum.imageReCan) {
            job.setJobState(JobState.REUPLOAD_IMAGE);
        } else {
            logger.error((Object)("job'billId is" + job.getBillID()));
            String sql = "SELECT FIMAGESTATE  FROM t_wsc_billimagemap where FBILLID = ?";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{job.getBillID()});
                if (rowSet.next() && "3".equals(rowSet.getString(1))) {
                    job.setJobState(JobState.ReScan);
                }
            }
            catch (Exception e) {
                logger.error((Object)"query fail but logic is nomarl", (Throwable)e);
            }
        }
    }

    private BigDecimal getTimeByIds(Context ctx, String BussinessAttributeId, String jobLevelId, String shareCenterID) throws EASBizException, BOSException {
        shareCenterID = shareCenterID == null ? "" : shareCenterID;
        BigDecimal value = new BigDecimal(48);
        BussinessAttributeEntryInfo entryInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)BussinessAttributeId));
        filter.getFilterItems().add(new FilterItemInfo("jobLevelName.id", (Object)jobLevelId));
        view.setFilter(filter);
        SelectorItemCollection selectors = new SelectorItemCollection();
        view.setSelector(selectors);
        BussinessAttributeEntryCollection attCollection = BussinessAttributeEntryFactory.getLocalInstance(ctx).getBussinessAttributeEntryCollection(view);
        if (attCollection != null) {
            if (attCollection.size() == 1) {
                entryInfo = attCollection.get(0);
                value = entryInfo.getTaskDuration();
            } else if (attCollection.size() > 1) {
                entryInfo = attCollection.get(0);
                value = entryInfo.getTaskDuration();
                int size = attCollection.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = attCollection.get(i);
                    if (!shareCenterID.equals(entryInfo.getShareCenterId())) continue;
                    value = entryInfo.getTaskDuration();
                    break;
                }
            }
        }
        return value;
    }

    public boolean saveAssignUser(Context ctx, JobInfo job) {
        try {
            job.setAssignCount(job.getAssignCount() + 1);
            String sql = "update t_ssc_job set FPERSONNELIDID = ? where fid = ? and FPERSONNELIDID is null";
            int count = SSCDbUtil.executeUpdate(ctx, sql, new Object[]{job.getPersonnelID().getId().toString(), job.getId().toString()});
            logger.error((Object)("\u5206\u914d\u4efb\u52a1Id\uff1a" + job.getId().toString() + "\uff1b\u5206\u914d\u4ebaId\uff1a" + job.getPersonnelID().getId().toString() + "\uff1b\u6267\u884c\u7ed3\u679ccount\uff1a" + count));
            if (count != 0) {
                JobFactory.getLocalInstance(ctx).save((CoreBaseInfo)job);
                String groupId = this.getGroupIdByUserId(ctx, job.getPersonnelID().getId().toString());
                JobExtCollection jobExtCollection = JobExtFactory.getLocalInstance(ctx).getJobExtCollection("select id where job.id = '" + job.getId().toString() + "'");
                if (jobExtCollection != null && jobExtCollection.size() > 0) {
                    JobExtInfo jobExtInfo = jobExtCollection.get(0);
                    sql = "update t_ssc_jobext set FGroupId = ? where fid = ?";
                    SSCDbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{groupId, jobExtInfo.getId().toString()});
                }
                this.updateWorkPressure(ctx, job);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u66f4\u65b0\u5904\u7406\u4eba\u5931\u8d25\uff01", (Throwable)e);
        }
        return false;
    }

    public String getGroupIdByUserId(Context ctx, String userId) {
        try {
            if (UserGroupFactory.getLocalInstance(ctx).exists("where user.id='" + userId + "'")) {
                UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + userId + "'");
                String groupId = userGroupInfo.getGroup().getId().toString();
                return groupId;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6groupId\u5931\u8d25\uff01userId\uff1a" + userId), (Throwable)e);
        }
        return "";
    }

    private void updateWorkPressure(Context ctx, JobInfo job) {
        try {
            if (EqualDivisionUtils.isEqualDivision(ctx, job.getShareCenterID().getId().toString())) {
                UserInfo userInfo;
                String personId = "";
                if (null != job.getConsigner() && StringUtils.isNotBlank((String)job.getConsigner().getId().toString())) {
                    personId = job.getConsigner().getId().toString();
                }
                if (null != job.getPersonnelID() && StringUtils.isNotBlank((String)job.getPersonnelID().getId().toString())) {
                    personId = job.getPersonnelID().getId().toString();
                }
                if ((userInfo = AssignJobFacadeControllerBean.userMap.get(job.getShareCenterID().getId().toString() + personId)) == null) {
                    userInfo = UserFactory.getLocalInstance(ctx).getUserInfo("select id, approvecoe where id = '" + personId + "'");
                }
                BigDecimal approvecoe = userInfo.getApproveCoe() == null ? new BigDecimal(1) : userInfo.getApproveCoe();
                BigDecimal workpress = job.getStandardCoe().divide(approvecoe, 4, 4);
                logger.error((Object)("\u4efb\u52a1ID\uff1a" + job.getId().toString() + "\uff1b\u5904\u7406\u4eba\uff1a" + job.getPersonnelID().getId().toString() + "\uff1b\u589e\u52a0\u5de5\u4f5c\u538b\u529b\uff1a" + workpress));
                WorkPressureFactory.getLocalInstance(ctx).add(personId, workpress);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u66f4\u65b0\u5de5\u4f5c\u538b\u529b\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"\u66f4\u65b0\u5de5\u4f5c\u538b\u529b\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    class NoticeOtherServiceRunnable
    implements Runnable {
        List<JobBean> jobBeanList;
        Context ctx;

        NoticeOtherServiceRunnable() {
        }

        public NoticeOtherServiceRunnable setAttribute(Context ctx, List<JobBean> jobBeanList) {
            this.jobBeanList = jobBeanList;
            this.ctx = ctx;
            return this;
        }

        @Override
        public void run() {
            try {
                AssignJobUtils.sendTask(this.ctx, this.jobBeanList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

