/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditCheckpointInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentAuditOriDataCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentAuditOriDataFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentAuditOriDataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgRelationEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgRelationEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentShowTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.EntryRelationInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.WrongDataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.SQLInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.DataSetTransfer;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.rule.RuleTransfer;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointLogUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.Constant;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CheckPointManager {
    private static Logger logger = Logger.getLogger(CheckPointManager.class);
    private static volatile CheckPointManager pointManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CheckPointManager getCheckPointManager() {
        if (pointManager != null) return pointManager;
        Class<CheckPointManager> clazz = CheckPointManager.class;
        synchronized (CheckPointManager.class) {
            if (pointManager != null) return pointManager;
            pointManager = new CheckPointManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return pointManager;
        }
    }

    public RuleEntryInfo execute(Context ctx, RuleEntryInfo ruleEntryInfo, IntelligentAuditExecuteRuleEntryInfo entryInfo) throws BOSException, EASBizException {
        if (entryInfo == null) {
            return ruleEntryInfo;
        }
        ruleEntryInfo.setEntryInfo(entryInfo);
        ruleEntryInfo.setResult(false);
        DataInfo fieldValue = this.getFieldValue(ctx, ruleEntryInfo, entryInfo);
        DataInfo valueValue = this.getValueValue(ctx, ruleEntryInfo, entryInfo);
        CompareManager compareManager = CompareManager.getCompareManager();
        ruleEntryInfo = compareManager.executeRule(ctx, ruleEntryInfo, fieldValue, valueValue);
        return ruleEntryInfo;
    }

    private DataInfo getFieldValue(Context ctx, RuleEntryInfo ruleEntryInfo, IntelligentAuditExecuteRuleEntryInfo entryInfo) throws EASBizException, BOSException {
        String compareFieldEntity = entryInfo.getCompareFieldEntity();
        String jobId = ruleEntryInfo.getJobInfo().getId().toString();
        CompareManager compareManager = CompareManager.getCompareManager();
        DataInfo filedValue = !StringUtils.isEmpty((String)compareFieldEntity) ? compareManager.getExprRealValue(ctx, ruleEntryInfo, compareFieldEntity) : CheckPointUtils.genFieldModelDataInfo(entryInfo.getCompareField(), entryInfo.getCompareField());
        CheckPointLogUtils.executeLogRecord(ctx, jobId, "\u5b57\u6bb5:" + (StringUtils.isEmpty((String)compareFieldEntity) ? entryInfo.getCompareField() : compareFieldEntity) + ",\u503c:" + filedValue, "CompareManager.executeRule");
        return filedValue;
    }

    private DataInfo getValueValue(Context ctx, RuleEntryInfo ruleEntryInfo, IntelligentAuditExecuteRuleEntryInfo entryInfo) throws EASBizException, BOSException {
        String compareValueEntity = entryInfo.getCompareValueEntity();
        String jobId = ruleEntryInfo.getJobInfo().getId().toString();
        CompareManager compareManager = CompareManager.getCompareManager();
        DataInfo valueValue = !StringUtils.isEmpty((String)compareValueEntity) ? compareManager.getExprRealValue(ctx, ruleEntryInfo, compareValueEntity) : CheckPointUtils.genFieldModelDataInfo(entryInfo.getCompareValue(), entryInfo.getCompareValue());
        CheckPointLogUtils.executeLogRecord(ctx, jobId, "\u5b57\u6bb5:" + (StringUtils.isEmpty((String)compareValueEntity) ? entryInfo.getCompareValue() : compareValueEntity) + ",\u503c:" + valueValue, "CompareManager.executeRule");
        return valueValue;
    }

    public RuleEntryInfo prepareData(Context ctx, IntelligentAuditCheckpointInfo info, JobInfo jobInfo) throws EASBizException, BOSException {
        Long start = System.nanoTime();
        RuleTransfer ruleTransfer = new RuleTransfer();
        RuleEntryInfo ruleEntryInfo = ruleTransfer.transferExecuteRule(ctx, info);
        ruleEntryInfo.setJobInfo(jobInfo);
        ruleEntryInfo.setDataSetInfo(info.getDataSet());
        ruleEntryInfo.setCheckpointInfo(info);
        DataSetTransfer dataSetTransfer = new DataSetTransfer();
        SQLInfo sqlInfo = dataSetTransfer.transferToSQL(ctx, ruleEntryInfo, null, false);
        if (sqlInfo != null) {
            this.transferSqlInfoToSql(ctx, info, jobInfo, start, ruleEntryInfo, sqlInfo);
        }
        return ruleEntryInfo;
    }

    protected void transferSqlInfoToSql(Context ctx, IntelligentAuditCheckpointInfo info, JobInfo jobInfo, Long start, RuleEntryInfo ruleEntryInfo, SQLInfo sqlInfo) throws BOSException {
        String[] selectItems;
        String entityalias = ruleEntryInfo.getDataSetInfo().getEntityalias();
        Map<String, String> formulaColumn = ruleEntryInfo.getFormulaColumn();
        StringBuilder columns = new StringBuilder();
        Collection<String> values = formulaColumn.values();
        String fromItem = sqlInfo.getFromItem();
        StringBuilder selectItem = sqlInfo.getSelectItem();
        for (String column : values) {
            if (!fromItem.contains(" " + entityalias + " ") && column.startsWith(entityalias)) continue;
            columns.append(column + ",");
        }
        if (columns.length() == 0) {
            return;
        }
        columns.setCharAt(columns.length() - 1, ' ');
        selectItem.append((CharSequence)columns);
        HashSet<String> idColumns = new HashSet<String>();
        for (String selects : selectItems = selectItem.toString().split(",")) {
            String fidColumn;
            String[] column = selects.split("\\.");
            String string = column[0] + "." + "FID";
            if (!values.contains(string)) {
                idColumns.add("," + string);
            }
            if (!column[0].contains("ENTRY") || values.contains(fidColumn = ((String)column[0]).substring(0, ((String)column[0]).indexOf("XX") + 2) + "." + "FID")) continue;
            idColumns.add("," + fidColumn);
        }
        StringBuilder ids = new StringBuilder();
        for (String idColumn : idColumns) {
            ids.append(idColumn);
        }
        selectItem.append((CharSequence)ids);
        ruleEntryInfo.setSqlInfo(sqlInfo);
        Long end = System.nanoTime();
        CheckpointEntryFilterCollection entryFilters = ruleEntryInfo.getCheckpointInfo().getEntryFilters();
        if (entryFilters != null && entryFilters.size() > 0) {
            CheckPointUtils.filterSqlEntry(ctx, ruleEntryInfo);
        }
        Map<String, Boolean> entryHasData = ruleEntryInfo.getSqlInfo().getEntryHasData();
        for (Map.Entry entry : entryHasData.entrySet()) {
            String[] selectItems1;
            String tableAlias = (String)entry.getKey();
            Boolean hasData = (Boolean)entry.getValue();
            for (String selects : selectItems1 = selectItem.toString().split(",")) {
                if (!selects.contains(tableAlias) || hasData.booleanValue()) continue;
                int i = selectItem.indexOf(selects);
                selectItem.delete(i, i + selects.length());
                selectItem.insert(i, "null \"" + selects + "\"");
            }
        }
        String sql = "select top 2000 " + sqlInfo.toString();
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ruleEntryInfo.setiRowSet(iRowSet);
        CheckPointLogUtils.executeLogRecord(ctx, jobInfo.getId().toString(), "SQL\u8f6c\u6362\u8017\u65f6\uff1a" + TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS) + "\u6beb\u79d2,\u68c0\u67e5\u70b9:" + info.getName() + "\u6570\u636e\u96c6ID:" + info.getDataSet().getId().toString() + ",\u6570\u636e\u91cf:" + iRowSet.size() + ",SQL:" + sql, "CheckPointManager.prepareData");
    }

    public void saveCheckPointShowData(Context ctx, JobInfo jobInfo, IntelligentAuditCheckpointCollection iapColl) {
        String jobId = jobInfo.getId().toString();
        try {
            if (!CheckPointUtils.isSmartWorkMode(ctx, jobId)) {
                logger.error((Object)("\u8ba1\u7b97\u667a\u80fd\u68c0\u67e5\u70b9---\u5c55\u793a\u6570\u636e---\u4efb\u52a1\u7c7b\u578b\u672a\u542f\u7528\u5de5\u5355\u6a21\u5f0f--jobId;[" + jobId + "]"));
                return;
            }
            if (iapColl != null && iapColl.size() > 0) {
                JSONObject data = new JSONObject();
                CoreBaseCollection coreBase = new CoreBaseCollection();
                IntelligentAuditOriDataCollection oriDataCollection = IntelligentAuditOriDataFactory.getLocalInstance(ctx).getIntelligentAuditOriDataCollection("select jobId,id,value,intelligentAuditCheckid.id where jobId = '" + jobId + "'");
                ArrayList<String> checkPointIds = new ArrayList<String>();
                int len = iapColl.size();
                for (int i = 0; i < len; ++i) {
                    IntelligentAuditCheckpointInfo checkpointInfo = iapColl.get(i);
                    checkPointIds.add(checkpointInfo.getId().toString());
                }
                Map<String, IntelligentDataShowCfgCollection> checkDetail_dataShowCfg_Map = CheckPointUtils.getIntelligentDataShowCfgCollectionByCheckpointId(ctx, checkPointIds);
                int len2 = iapColl.size();
                for (int i = 0; i < len2; ++i) {
                    IntelligentAuditCheckpointInfo checkpointInfo = iapColl.get(i);
                    try {
                        IntelligentDataShowCfgCollection showCfgEntrys = checkDetail_dataShowCfg_Map.get(checkpointInfo.getId().toString());
                        if (showCfgEntrys == null) continue;
                        checkpointInfo.put("showCfgEntrys", (Object)showCfgEntrys);
                        ArrayList<IntelligentDataShowCfgFieldEntryInfo> headColumnList = new ArrayList<IntelligentDataShowCfgFieldEntryInfo>();
                        HashMap<String, List<IntelligentDataShowCfgFieldEntryInfo>> entryMap = new HashMap<String, List<IntelligentDataShowCfgFieldEntryInfo>>();
                        RuleEntryInfo ruleEntryInfo = this.prepareData(ctx, checkpointInfo, jobInfo);
                        ruleEntryInfo.setBillValue(jobInfo.get("billValue-app") == null ? null : (IObjectValue)jobInfo.get("billValue-app"));
                        JSONObject cardObj = new JSONObject();
                        int len1 = showCfgEntrys.size();
                        for (int j = 0; j < len1; ++j) {
                            IntelligentDataShowCfgInfo showCfgInfo = showCfgEntrys.get(j);
                            IntelligentDataShowCfgFieldEntryCollection showCfgFieldEntry = (IntelligentDataShowCfgFieldEntryCollection)((Object)showCfgInfo.get("filedentry-app"));
                            int len22 = showCfgFieldEntry.size();
                            for (int k = 0; k < len22; ++k) {
                                IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = showCfgFieldEntry.get(k);
                                if (IntelligentShowTypeEnum.showTableHead.equals((Object)fieldEntryInfo.getShowType())) {
                                    headColumnList.add(fieldEntryInfo);
                                    continue;
                                }
                                String entryTitle = showCfgInfo.getTableTitle();
                                if (!entryMap.containsKey(entryTitle)) {
                                    entryMap.put(entryTitle, new ArrayList());
                                }
                                ((List)entryMap.get(entryTitle)).add(fieldEntryInfo);
                            }
                            cardObj.put(showCfgInfo.getTableTitle(), (Object)j);
                        }
                        data.put("CARD", (Object)cardObj);
                        String headOriData = this.getHeadOriData(ctx, jobInfo, headColumnList, ruleEntryInfo);
                        data.put("HEAD", (Object)headOriData);
                        Map<String, List<TableModelInfo>> entryOriData = this.getEntryOriData(ctx, jobInfo, entryMap, ruleEntryInfo);
                        String entryData = this.mergeTableData(ctx, entryOriData, showCfgEntrys, jobInfo, ruleEntryInfo);
                        data.put("ENTRY", (Object)entryData);
                        IntelligentAuditOriDataInfo info = new IntelligentAuditOriDataInfo();
                        boolean infoExists = false;
                        for (int j = 0; oriDataCollection != null && j < oriDataCollection.size(); ++j) {
                            if (!checkpointInfo.getId().toString().equals(oriDataCollection.get(j).getIntelligentAuditCheckid().getId().toString())) continue;
                            info = oriDataCollection.get(j);
                            info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                            infoExists = true;
                            break;
                        }
                        if (!infoExists) {
                            info.setJobId(jobId);
                            info.setIntelligentAuditCheckid(checkpointInfo);
                            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        }
                        info.setValue(data.toJSONString());
                        coreBase.add((CoreBaseInfo)info);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)(e.getMessage() + "**" + checkpointInfo.getId() + "**" + checkpointInfo.getName()), (Throwable)e);
                    }
                }
                IntelligentAuditOriDataFactory.getLocalInstance(ctx).save(coreBase);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String mergeTableData(Context ctx, Map<String, List<TableModelInfo>> entryOriData, IntelligentDataShowCfgCollection showCfgEntrys, JobInfo jobInfo, RuleEntryInfo ruleEntryInfo) {
        if (entryOriData == null || entryOriData.isEmpty()) {
            return "";
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<WrongDataInfo> wrongDataInfos = null;
        if (CompareManager.wrongData.containsKey(jobInfo.getId().toString())) {
            wrongDataInfos = CompareManager.wrongData.get(jobInfo.getId().toString());
        }
        int len1 = showCfgEntrys.size();
        for (int j = 0; j < len1; ++j) {
            IntelligentDataShowCfgInfo showCfgInfo = showCfgEntrys.get(j);
            HashMap<String, List<TableModelInfo>> map1 = new HashMap<String, List<TableModelInfo>>();
            HashMap<String, List<EntryRelationInfo>> relationMap = new HashMap<String, List<EntryRelationInfo>>();
            IntelligentDataShowCfgFieldEntryCollection showCfgFieldEntry = (IntelligentDataShowCfgFieldEntryCollection)((Object)showCfgInfo.get("filedentry-app"));
            JSONArray baseData = new JSONArray();
            JSONArray merData = new JSONArray();
            JSONObject extData = new JSONObject();
            JSONObject jb = null;
            int len2 = showCfgFieldEntry.size();
            for (int k = 0; k < len2; ++k) {
                IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = showCfgFieldEntry.get(k);
                if (IntelligentShowTypeEnum.showTableHead.equals((Object)fieldEntryInfo.getShowType())) continue;
                String key = fieldEntryInfo.getEntryName();
                String fieldAlias = fieldEntryInfo.getFieldAlias();
                String cardName = fieldEntryInfo.get("t-app").toString();
                int seq = fieldEntryInfo.getSeq();
                if (!map1.containsKey(key)) {
                    map1.put(key, new ArrayList());
                }
                if (entryOriData.containsKey(cardName + seq + fieldAlias)) {
                    ((List)map1.get(key)).addAll((Collection)entryOriData.get(cardName + seq + fieldAlias));
                }
                if (wrongDataInfos != null) {
                    for (WrongDataInfo wrongDataInfo : wrongDataInfos) {
                        if (!wrongDataInfo.getCheckId().equals(ruleEntryInfo.getCheckpointInfo().getId().toString()) || !wrongDataInfo.getwIdSet().contains(fieldAlias)) continue;
                        extData.put("w-app", (Object)true);
                    }
                }
                if (CheckPointUtils.hasFunction(fieldAlias)) {
                    String columnNames = fieldAlias.substring(fieldAlias.indexOf("(") + 1, fieldAlias.lastIndexOf(")"));
                    String[] fields = new String[]{fieldAlias};
                    String[] names = new String[]{fieldEntryInfo.getDisplayName()};
                    String[] seqs = new String[]{String.valueOf(fieldEntryInfo.get("s-app"))};
                    for (int z = 0; z < Constant.SEQFUNCNAMES.length; ++z) {
                        if (fieldAlias.indexOf(Constant.SEQFUNCNAMES[z]) <= -1) continue;
                        fields = columnNames.split(",");
                        names = fieldEntryInfo.getDisplayName().split(",");
                        seqs = String.valueOf(fieldEntryInfo.get("s-app")).split(",");
                        break;
                    }
                    if (seqs.length == 1) {
                        fields = new String[]{columnNames};
                    }
                    for (int i = 0; i < fields.length; ++i) {
                        jb = new JSONObject();
                        jb.put(fields[i], (Object)(names.length > i ? names[i] : ""));
                        jb.put("s-app", (Object)Integer.parseInt(seqs[i].trim()));
                        baseData.add((Object)jb);
                    }
                    continue;
                }
                jb = new JSONObject();
                jb.put(fieldAlias, (Object)fieldEntryInfo.getDisplayName());
                jb.put("s-app", (Object)seq);
                baseData.add((Object)jb);
            }
            if (map1.isEmpty()) continue;
            result.put(showCfgInfo.getTableTitle() + "-base", baseData);
            result.put(showCfgInfo.getTableTitle() + "-ext", extData);
            Map<String, List<TableModelInfo>> map_sameEntry = this.mergeSameTableData(map1);
            if (showCfgInfo.get("relationentry-app") != null) {
                IntelligentDataShowCfgRelationEntryCollection relationEntry = (IntelligentDataShowCfgRelationEntryCollection)((Object)showCfgInfo.get("relationentry-app"));
                int len3 = relationEntry.size();
                for (int h = 0; h < len3; ++h) {
                    IntelligentDataShowCfgRelationEntryInfo relationInfo = relationEntry.get(h);
                    String keys = relationInfo.getFieldEntryName() + "=" + relationInfo.getValueEntryName();
                    if (!relationMap.containsKey(keys)) {
                        relationMap.put(keys, new ArrayList());
                    }
                    List infoList = (List)relationMap.get(keys);
                    infoList.add(new EntryRelationInfo(relationInfo.getFieldEntryName(), relationInfo.getFieldAlias(), relationInfo.getValueEntryName(), relationInfo.getValueAlias()));
                    relationMap.put(keys, infoList);
                    merData.add((Object)relationInfo.getFieldAlias());
                    merData.add((Object)relationInfo.getValueAlias());
                }
                List<TableModelInfo> map_allEntry = this.mergeDiffTableData(relationMap, map_sameEntry);
                result.put(showCfgInfo.getTableTitle() + "-mer", merData);
                result.put(showCfgInfo.getTableTitle(), map_allEntry);
                continue;
            }
            for (Map.Entry<String, List<TableModelInfo>> entry : map_sameEntry.entrySet()) {
                result.put(showCfgInfo.getTableTitle(), entry.getValue());
            }
        }
        return JSONObject.toJSONString(result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    private List<TableModelInfo> mergeDiffTableData(Map<String, List<EntryRelationInfo>> relationMap, Map<String, List<TableModelInfo>> map_sameEntry) {
        List<TableModelInfo> map_Entry = new ArrayList<TableModelInfo>();
        if (!relationMap.isEmpty()) {
            for (Map.Entry<String, List<EntryRelationInfo>> entry : relationMap.entrySet()) {
                String[] entryNames = entry.getKey().split("=");
                List<EntryRelationInfo> relationInfos = entry.getValue();
                List<TableModelInfo> tableModelInfos1 = map_sameEntry.get(entryNames[0]);
                List<TableModelInfo> tableModelInfos2 = map_sameEntry.get(entryNames[1]);
                for (TableModelInfo tableModelInfo : tableModelInfos1) {
                    tableModelInfo.setEntryName(entryNames[0]);
                }
                for (TableModelInfo tableModelInfo : tableModelInfos2) {
                    tableModelInfo.setEntryName(entryNames[1]);
                }
                if (map_Entry.size() > 0) {
                    TableModelInfo tableModelInfo = (TableModelInfo)map_Entry.get(0);
                    if (tableModelInfo.getEntryName().contains(entryNames[0])) {
                        tableModelInfos1 = map_Entry;
                    }
                    if (tableModelInfo.getEntryName().contains(entryNames[1])) {
                        tableModelInfos2 = map_Entry;
                    }
                }
                map_Entry = this.mergeDiff0(tableModelInfos1, tableModelInfos2, relationInfos);
            }
            return map_Entry;
        }
        for (Map.Entry<String, List<TableModelInfo>> entry : map_sameEntry.entrySet()) {
            map_Entry.addAll((Collection<TableModelInfo>)entry.getValue());
        }
        return map_Entry;
    }

    /*
     * WARNING - void declaration
     */
    private List<TableModelInfo> mergeDiff0(List<TableModelInfo> tableModelInfos1, List<TableModelInfo> tableModelInfos2, List<EntryRelationInfo> relationInfos) {
        void var9_14;
        ArrayList<TableModelInfo> result = new ArrayList<TableModelInfo>();
        if (tableModelInfos1.isEmpty()) {
            return tableModelInfos2;
        }
        if (tableModelInfos2.isEmpty()) {
            return tableModelInfos1;
        }
        String newEntryName = tableModelInfos1.get(0).getEntryName() + "," + tableModelInfos2.get(0).getEntryName() + ",";
        HashMap<String, String> emptyData_table1 = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : tableModelInfos1.get(0).getCv().entrySet()) {
            emptyData_table1.put(entry.getKey(), "");
        }
        HashMap<String, String> emptyData_table2 = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : tableModelInfos2.get(0).getCv().entrySet()) {
            emptyData_table2.put(entry.getKey(), "");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (EntryRelationInfo relationInfo : relationInfos) {
            hashSet.add(relationInfo.getField_left() + "=" + relationInfo.getField_right());
        }
        int n = tableModelInfos1.size() - 1;
        while (var9_14 >= 0) {
            TableModelInfo tableModelInfo1 = tableModelInfos1.get((int)var9_14);
            boolean isMatch = false;
            for (int j = tableModelInfos2.size() - 1; j >= 0; --j) {
                TableModelInfo tableModelInfo2 = tableModelInfos2.get(j);
                if (!this.isRelationSuccess(tableModelInfo1, tableModelInfo2, relationInfos)) continue;
                TableModelInfo tableModelInfo = new TableModelInfo();
                tableModelInfo.setW(tableModelInfo1.isW() || tableModelInfo2.isW());
                tableModelInfo.setId(BOSUuid.isValid((String)tableModelInfo1.getId(), (boolean)true) ? tableModelInfo1.getId() : tableModelInfo1.getId() + j);
                HashMap<String, Object> cv = new HashMap<String, Object>(tableModelInfo1.getCv());
                cv.putAll(tableModelInfo2.getCv());
                tableModelInfo.setCv(cv);
                tableModelInfo.setEntryName(newEntryName);
                result.add(tableModelInfo);
                tableModelInfos2.remove(j);
                isMatch = true;
                break;
            }
            if (!isMatch) {
                tableModelInfo1.getCv().putAll(emptyData_table2);
                boolean isNeedPadding = this.isNeedPadding(result, hashSet, tableModelInfo1, "left");
                if (isNeedPadding) {
                    for (String f : hashSet) {
                        String[] expr = f.split("=");
                        tableModelInfo1.getCv().put(expr[1], tableModelInfo1.getCv().get(expr[0]));
                    }
                }
                tableModelInfo1.setEntryName(newEntryName);
                tableModelInfo1.setId(BOSUuid.isValid((String)tableModelInfo1.getId(), (boolean)true) ? tableModelInfo1.getId() : tableModelInfo1.getId() + (int)var9_14);
                result.add(tableModelInfo1);
            }
            --var9_14;
        }
        for (TableModelInfo tableModelInfo : tableModelInfos2) {
            tableModelInfo.getCv().putAll(emptyData_table1);
            boolean isNeedPadding = this.isNeedPadding(result, hashSet, tableModelInfo, "right");
            if (isNeedPadding) {
                for (String f : hashSet) {
                    String[] expr = f.split("=");
                    tableModelInfo.getCv().put(expr[0], tableModelInfo.getCv().get(expr[1]));
                }
            }
            tableModelInfo.setEntryName(newEntryName);
            result.add(tableModelInfo);
        }
        return result;
    }

    private boolean isNeedPadding(List<TableModelInfo> result, Set<String> field, TableModelInfo tableModelInfo, String pos) {
        boolean isNeedPadding = false;
        Map<String, Object> cv1 = tableModelInfo.getCv();
        StringBuilder leftCurrentValue = new StringBuilder();
        StringBuilder rightCurrentValue = new StringBuilder();
        for (String f : field) {
            String[] expr = f.split("=");
            leftCurrentValue.append(cv1.get(expr[0]));
            rightCurrentValue.append(cv1.get(expr[1]));
        }
        String leftCurrentValueString = leftCurrentValue.toString();
        String rightCurrentValueString = rightCurrentValue.toString();
        for (TableModelInfo tableModelInfo1 : result) {
            Map<String, Object> cv = tableModelInfo1.getCv();
            StringBuilder leftNewValue = new StringBuilder();
            StringBuilder rightNewValue = new StringBuilder();
            for (String f : field) {
                String[] expr = f.split("=");
                leftNewValue.append(cv.get(expr[0]));
                rightNewValue.append(cv.get(expr[1]));
            }
            if ("left".equals(pos)) {
                if (!leftCurrentValueString.equals(leftNewValue.toString()) || rightNewValue.length() == 0) continue;
                isNeedPadding = true;
                break;
            }
            if (!"right".equals(pos) || !rightCurrentValueString.equals(rightNewValue.toString()) || leftNewValue.length() == 0) continue;
            isNeedPadding = true;
            break;
        }
        return isNeedPadding;
    }

    private boolean isHasRepateData(List<TableModelInfo> tableModelInfos1, TableModelInfo tableModelInfo1, int i, Set<String> field) {
        StringBuilder value = new StringBuilder();
        for (String f : field) {
            value.append(tableModelInfo1.getCv().get(f));
        }
        String v = value.toString();
        for (int k = 0; k < i; ++k) {
            StringBuilder newValue = new StringBuilder();
            TableModelInfo tableModelInfo = tableModelInfos1.get(k);
            for (String f : field) {
                newValue.append(tableModelInfo.getCv().get(f));
            }
            if (!newValue.toString().equals(v)) continue;
            return true;
        }
        return false;
    }

    private boolean isRelationSuccess(TableModelInfo tableModelInfo1, TableModelInfo tableModelInfo2, List<EntryRelationInfo> relationInfos) {
        boolean result = true;
        Map<String, Object> cv1 = tableModelInfo1.getCv();
        Map<String, Object> cv2 = tableModelInfo2.getCv();
        for (EntryRelationInfo relationInfo : relationInfos) {
            if (tableModelInfo1.getEntryName().contains(relationInfo.getEntryname_left())) {
                if (CheckPointUtils.compareObject(cv1.get(relationInfo.getField_left()), cv2.get(relationInfo.getField_right())) == 0) continue;
                result = false;
                continue;
            }
            if (CheckPointUtils.compareObject(cv1.get(relationInfo.getField_right()), cv2.get(relationInfo.getField_left())) == 0) continue;
            result = false;
        }
        return result;
    }

    public Map<String, List<TableModelInfo>> mergeSameTableData(Map<String, List<TableModelInfo>> map) {
        HashMap<String, List<TableModelInfo>> map1_New = new HashMap<String, List<TableModelInfo>>();
        for (Map.Entry<String, List<TableModelInfo>> entry : map.entrySet()) {
            TableModelInfo tableModelInfo;
            String rid;
            HashMap<String, TableModelInfo> key = new HashMap<String, TableModelInfo>();
            List<TableModelInfo> tableModelInfos = entry.getValue();
            ArrayList<TableModelInfo> fieldModels = new ArrayList<TableModelInfo>();
            for (TableModelInfo modelInfo : tableModelInfos) {
                rid = modelInfo.getId();
                if ("temp".equals(entry.getKey()) && modelInfo.getCv().size() == 1 && modelInfo.getCv().keySet().iterator().next().split("\\.").length <= 2) {
                    fieldModels.add(modelInfo);
                    continue;
                }
                if (!key.containsKey(rid)) {
                    key.put(rid, modelInfo);
                    continue;
                }
                tableModelInfo = (TableModelInfo)key.get(rid);
                tableModelInfo.getCv().putAll(modelInfo.getCv());
                tableModelInfo.setW(tableModelInfo.isW() || modelInfo.isW());
            }
            if (key.isEmpty()) {
                fieldModels.clear();
                for (TableModelInfo modelInfo : tableModelInfos) {
                    rid = modelInfo.getId();
                    if (!key.containsKey(rid)) {
                        key.put(rid, modelInfo);
                        continue;
                    }
                    tableModelInfo = (TableModelInfo)key.get(rid);
                    tableModelInfo.getCv().putAll(modelInfo.getCv());
                    tableModelInfo.setW(tableModelInfo.isW() || modelInfo.isW());
                }
            }
            ArrayList<TableModelInfo> modelInfoList = new ArrayList<TableModelInfo>();
            for (TableModelInfo value : key.values()) {
                if (!fieldModels.isEmpty()) {
                    for (TableModelInfo temp : fieldModels) {
                        value.getCv().putAll(temp.getCv());
                    }
                }
                modelInfoList.add(value);
            }
            map1_New.put(entry.getKey(), modelInfoList);
        }
        return map1_New;
    }

    private Map<String, List<TableModelInfo>> getEntryOriData(Context ctx, JobInfo jobInfo, Map<String, List<IntelligentDataShowCfgFieldEntryInfo>> entryMap, RuleEntryInfo ruleEntryInfo) throws BOSException, EASBizException {
        HashMap<String, List<TableModelInfo>> jb = new HashMap<String, List<TableModelInfo>>();
        if (entryMap == null || entryMap.isEmpty()) {
            return jb;
        }
        CompareManager cm = CompareManager.getCompareManager();
        List<WrongDataInfo> wrongDataInfos = null;
        if (CompareManager.wrongData.containsKey(jobInfo.getId().toString())) {
            wrongDataInfos = CompareManager.wrongData.get(jobInfo.getId().toString());
        }
        String checkpointId = ruleEntryInfo.getCheckpointInfo().getId().toString();
        for (Map.Entry<String, List<IntelligentDataShowCfgFieldEntryInfo>> m : entryMap.entrySet()) {
            for (IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo : m.getValue()) {
                String fieldAlias = fieldEntryInfo.getFieldAlias();
                int seq = fieldEntryInfo.getSeq();
                String key = fieldEntryInfo.get("t-app").toString() + seq + fieldAlias;
                DataInfo exprRealValue = cm.getExprRealValue(ctx, ruleEntryInfo, fieldAlias);
                List<TableModelInfo> tableModels = exprRealValue.getTableModels();
                int len = tableModels.size();
                for (int i = 0; i < len; ++i) {
                    TableModelInfo tableModelInfo = tableModels.get(i);
                    if (wrongDataInfos != null) {
                        for (WrongDataInfo wrongDataInfo : wrongDataInfos) {
                            if (!wrongDataInfo.getCheckId().equals(checkpointId) || !wrongDataInfo.getwIdSet().contains(tableModelInfo.getId())) continue;
                            tableModelInfo.setW(true);
                        }
                    }
                    if (tableModelInfo.getId().contains("sumgroupby")) {
                        String rid = tableModelInfo.getId().substring(tableModelInfo.getId().indexOf("sumgroupby") + "sumgroupby".length()) + i;
                        tableModelInfo.setId(rid);
                    }
                    Map<String, Object> cv = tableModelInfo.getCv();
                    for (Map.Entry<String, Object> entry : cv.entrySet()) {
                        if (entry.getValue() != null && !entry.getValue().equals("null")) continue;
                        cv.put(entry.getKey(), "");
                    }
                }
                jb.put(key, tableModels);
            }
        }
        return jb;
    }

    private String getHeadOriData(Context ctx, JobInfo jobInfo, List<IntelligentDataShowCfgFieldEntryInfo> headColumnList, RuleEntryInfo ruleEntryInfo) throws BOSException, EASBizException {
        JSONArray jb = new JSONArray();
        CompareManager cm = CompareManager.getCompareManager();
        String checkpointId = ruleEntryInfo.getCheckpointInfo().getId().toString();
        for (IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo : headColumnList) {
            String fieldAlias = fieldEntryInfo.getFieldAlias();
            DataInfo exprRealValue = cm.getExprRealValue(ctx, ruleEntryInfo, fieldAlias);
            FieldModelInfo fieldModel = null;
            List<FieldModelInfo> fieldModels = exprRealValue.getFieldModels();
            if (fieldModels != null) {
                for (FieldModelInfo fieldModelInfo : fieldModels) {
                    if (!fieldModelInfo.getF().equals(fieldAlias)) continue;
                    fieldModel = fieldModelInfo;
                }
            }
            if (fieldModel == null) {
                List<TableModelInfo> tableModels = exprRealValue.getTableModels();
                if (tableModels != null && tableModels.size() > 0) {
                    fieldModel = new FieldModelInfo();
                    Map<String, Object> cv = tableModels.get(0).getCv();
                    fieldModel.setF(fieldAlias);
                    fieldModel.setV(cv.get(fieldAlias) == null ? cv.values().toArray()[0] : cv.get(fieldAlias));
                } else {
                    fieldModel = new FieldModelInfo();
                    fieldModel.setF(fieldAlias);
                    fieldModel.setV("");
                }
            }
            boolean isWrong = false;
            if (CompareManager.wrongData.containsKey(jobInfo.getId().toString())) {
                List<WrongDataInfo> wrongDataInfos = CompareManager.wrongData.get(jobInfo.getId().toString());
                block2: for (WrongDataInfo wrongDataInfo : wrongDataInfos) {
                    if (!wrongDataInfo.getCheckId().equals(checkpointId)) continue;
                    for (String expr : wrongDataInfo.getwIdSet()) {
                        if (!expr.contains(exprRealValue.getExpr())) continue;
                        isWrong = true;
                        continue block2;
                    }
                }
            }
            JSONObject obj = new JSONObject();
            obj.put(fieldModel.getF(), fieldModel.getV() == null ? "" : fieldModel.getV());
            obj.put("w-app", (Object)isWrong);
            obj.put("t-app", (Object)fieldEntryInfo.getString("t-app"));
            obj.put("s-app", fieldEntryInfo.getSeq() != 0 ? Integer.valueOf(fieldEntryInfo.getSeq()) : ((String)fieldEntryInfo.get("s-app")).trim());
            obj.put("n-app", (Object)fieldEntryInfo.getDisplayName());
            jb.add((Object)obj);
        }
        return jb.toJSONString();
    }
}

