/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.comparetype;

import com.kingdee.eas.base.ssc.app.checkpointext.ExecutionRuleConditionEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.FieldModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.Constant;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCompareType {
    protected Logger logger = Logger.getLogger(this.getClass());

    public boolean compare(String compareType, DataInfo compareField, DataInfo compareValue, ExecutionRuleConditionEnum conditionEnum) throws EASBizException {
        Map<String, Object> fieldMap = this.getRealMapData(compareField);
        Map<String, Object> valueMap = this.getRealMapData(compareValue);
        if (fieldMap.isEmpty()) {
            return false;
        }
        boolean isCompareById = false;
        if (compareField.getAttrs().get("comparebyid") != null && compareField.getAttrs().get("comparebyid").equals(Boolean.TRUE) && compareValue.getAttrs().get("comparebyid") != null && compareValue.getAttrs().get("comparebyid").equals(Boolean.TRUE)) {
            isCompareById = true;
        }
        boolean result = !ExecutionRuleConditionEnum.anyonePass.equals((Object)conditionEnum);
        block0: for (Map.Entry<String, Object> m : fieldMap.entrySet()) {
            boolean oneResult = false;
            if ("is_not_null".equals(compareType) || "is_null".equals(compareType)) {
                oneResult = this.compare0(conditionEnum, m, null);
                result = this.isResult(conditionEnum, result, oneResult);
            } else {
                for (Map.Entry<String, Object> v : valueMap.entrySet()) {
                    if (isCompareById) {
                        String mid = m.getKey();
                        String vid = v.getKey();
                        if (mid.contains("sumgroupby") && vid.contains("sumgroupby")) {
                            mid = mid.substring(mid.indexOf("sumgroupby") + "sumgroupby".length());
                            vid = vid.substring(vid.indexOf("sumgroupby") + "sumgroupby".length());
                        }
                        if (!mid.equals(vid)) continue;
                        oneResult = this.compare0(conditionEnum, m, v.getValue());
                    } else {
                        oneResult = this.compare0(conditionEnum, m, v.getValue());
                    }
                    result = this.isResult(conditionEnum, result, oneResult);
                }
            }
            if (oneResult) continue;
            if (ModelTypeEnum.Table.equals((Object)compareField.getType())) {
                List<TableModelInfo> tableModels = compareField.getTableModels();
                for (TableModelInfo tableModel : tableModels) {
                    if (!tableModel.getId().equals(m.getKey())) continue;
                    tableModel.setW(true);
                    continue block0;
                }
                continue;
            }
            List<FieldModelInfo> fieldModels = compareField.getFieldModels();
            for (FieldModelInfo fieldModel : fieldModels) {
                if (!fieldModel.getF().equals(m.getKey())) continue;
                fieldModel.setW(true);
            }
        }
        return result;
    }

    private Map<String, Object> getRealMapData(DataInfo info) {
        HashMap<String, Object> fieldMap;
        if (ModelTypeEnum.Table.equals((Object)info.getType())) {
            List<TableModelInfo> tableModels = info.getTableModels();
            fieldMap = new HashMap<String, Object>(tableModels.size());
            for (TableModelInfo tableModel : tableModels) {
                Map<String, Object> cv = tableModel.getCv();
                if (CheckPointUtils.hasFunction(info.getExpr())) {
                    String columnNames = info.getExpr().substring(info.getExpr().indexOf("(") + 1, info.getExpr().lastIndexOf(")"));
                    String key = null;
                    for (int k = 0; k < Constant.MAPGETVALUE.length; ++k) {
                        if (!info.getExpr().contains(Constant.MAPGETVALUE[k])) continue;
                        key = columnNames;
                        break;
                    }
                    fieldMap.put(tableModel.getId(), cv.get(key == null ? columnNames.split(",")[0] : key));
                    continue;
                }
                fieldMap.put(tableModel.getId(), cv.get(info.getExpr()));
            }
        } else {
            List<FieldModelInfo> fieldModels = info.getFieldModels();
            fieldMap = new HashMap(fieldModels.size());
            for (FieldModelInfo fieldModel : fieldModels) {
                fieldMap.put(fieldModel.getF(), fieldModel.getV());
            }
        }
        return fieldMap;
    }

    private boolean compare0(ExecutionRuleConditionEnum conditionEnum, Map.Entry<String, Object> m, Object value) {
        boolean result = true;
        if (this.getCompareResult(m, value)) {
            if (ExecutionRuleConditionEnum.anyonePass.equals((Object)conditionEnum)) {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    private boolean isResult(ExecutionRuleConditionEnum conditionEnum, boolean result, boolean oneResult) {
        if (ExecutionRuleConditionEnum.anyonePass.equals((Object)conditionEnum) && oneResult) {
            result = oneResult;
        }
        if (ExecutionRuleConditionEnum.allPass.equals((Object)conditionEnum) && !oneResult) {
            result = oneResult;
        }
        return result;
    }

    protected abstract boolean getCompareResult(Map.Entry<String, Object> var1, Object var2);

    protected int compareObject(Object o1, Object o2) {
        return CheckPointUtils.compareObject(o1, o2);
    }
}

