/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.compare.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.data.IData;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.DataInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.ModelTypeEnum;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.info.TableModelInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.SQLInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SqlData
implements IData {
    protected Logger logger = Logger.getLogger(this.getClass());
    private String column;

    public SqlData(String column) {
        this.column = column;
    }

    @Override
    public DataInfo getData(Context ctx, RuleEntryInfo ruleEntryInfo) throws BOSException, EASBizException {
        ArrayList<TableModelInfo> modelInfoList = new ArrayList<TableModelInfo>();
        IRowSet iRowSet = ruleEntryInfo.getiRowSet();
        Map<String, String> formulaColumn = ruleEntryInfo.getFormulaColumn();
        SQLInfo sqlInfo = ruleEntryInfo.getSqlInfo();
        StringBuilder selectItem = sqlInfo.getSelectItem();
        String[] selects = selectItem.toString().split(",");
        for (int i = 0; i < selects.length; ++i) {
            if (!selects[i].contains("null ")) continue;
            selects[i] = selects[i].replace("null", "").replace("\"", "").trim();
        }
        String[] columnSplit = this.column.split(",");
        LinkedHashMap<Integer, String> columnIndexMap = new LinkedHashMap<Integer, String>();
        int idIndex = -1;
        for (String s : columnSplit) {
            if (!s.contains("{$")) continue;
            String columnName = formulaColumn.get(s);
            int columnIndex = this.getArrayIndex(selects, columnName);
            if (columnIndex == -1) {
                throw new EASBizException(new NumericExceptionSubItem("XX", "\u627e\u4e0d\u5230column:" + s.replace("$", "") + ";columnName:" + columnName + "\u5b57\u6bb5\u5bf9\u5e94\u7684\u4e0b\u6807\uff0c\u5e94\u8be5\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u4e2a\u95ee\u9898..."));
            }
            columnIndexMap.put(++columnIndex, s);
            String[] split = columnName.split("\\.");
            if (idIndex == -1 || split.length > 1) {
                idIndex = this.getIdColumnIndex(selects, split[0]) + 1;
            }
            if (idIndex != 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u627e\u4e0d\u5230column:" + s + ";idColumn:" + split[0] + "\u5b57\u6bb5\u5bf9\u5e94\u7684\u4e0b\u6807\uff0c\u5e94\u8be5\u4e0d\u4f1a\u51fa\u73b0\u8fd9\u4e2a\u95ee\u9898..."));
        }
        try {
            iRowSet.beforeFirst();
            while (iRowSet.next()) {
                String fid;
                if (idIndex == -1 || StringUtils.isEmpty((CharSequence)iRowSet.getString(idIndex)) || this.isIncludeList(modelInfoList, fid = iRowSet.getString(idIndex))) continue;
                TableModelInfo modelInfo = new TableModelInfo();
                modelInfo.setId(fid);
                for (Map.Entry entry : columnIndexMap.entrySet()) {
                    modelInfo.getCv().put((String)entry.getValue(), iRowSet.getString(((Integer)entry.getKey()).intValue()));
                }
                modelInfoList.add(modelInfo);
            }
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u83b7\u53d6\u6570\u636e\u5931\u8d25\u3002iRowSet\uff1a" + (iRowSet == null ? "null" : Integer.valueOf(iRowSet.size()))), (Throwable)e);
        }
        DataInfo info = new DataInfo();
        info.setTableModels(modelInfoList);
        info.setType(ModelTypeEnum.Table);
        return info;
    }

    private boolean isIncludeList(List<TableModelInfo> modelInfoList, String fid) {
        boolean result = false;
        int len = modelInfoList.size();
        for (int i = 0; i < len; ++i) {
            TableModelInfo tableModelInfo = modelInfoList.get(i);
            if (!fid.equals(tableModelInfo.getId())) continue;
            result = true;
            break;
        }
        return result;
    }

    private int getIdColumnIndex(String[] selects, String alias) throws EASBizException {
        String idColumn = "";
        idColumn = alias.contains("ENTRY") ? alias.substring(0, alias.indexOf("XX") + 2) : alias.substring(0, 2);
        int idIndex = this.getArrayIndex(selects, idColumn + "." + "FID");
        return idIndex;
    }

    private int getArrayIndex(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].trim().equals(value.trim())) continue;
            return i;
        }
        return -1;
    }
}

