/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetFactory;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.RuleEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.SQLInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.EntryColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.EntryColumnJoinEntryColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.EntryColumnJoinValue;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.HeadColumnJoinEntryColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.HeadColumnJoinHeadColumn;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.HeadColumnJoinValue;
import com.kingdee.eas.base.ssc.app.checkpointext.transfer.dataset.IColumn;
import com.kingdee.eas.base.ssc.tool.checkpointext.DataSetUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.EntityAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DataSetTransfer {
    private static Logger logger = Logger.getLogger(DataSetTransfer.class);
    public static final Pattern pattern1 = Pattern.compile("( join | Join | jOin | joiN | joIn | JOIN )(.*?)( on | ON | On | oN )");

    public SQLInfo transferToSQL(Context ctx, RuleEntryInfo ruleEntryInfo, String billId, boolean isCheck) throws BOSException, EASBizException {
        CheckpointDataSetInfo info = ruleEntryInfo.getDataSetInfo();
        if (info == null || !isCheck && info.getId() == null) {
            return null;
        }
        if (!isCheck) {
            info = CheckpointDataSetFactory.getLocalInstance(ctx).getCheckpointDataSetInfo("select *, entrys.* where id = '" + info.getId().toString() + "' ");
        }
        CheckpointDataSetEntryCollection entry = info.getEntrys();
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(info.getEntity()));
        DataTableInfo table = entityObjectInfo.getTable();
        String associativeEntity = info.getAssociativeentity();
        if (StringUtils.isEmpty((CharSequence)associativeEntity)) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u5173\u8054\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String[] associatives = associativeEntity.split(",");
        String firstAssociativesAlias = associatives[0].split(" ")[1];
        this.verifyEntrys(info);
        SQLInfo sqlInfo = new SQLInfo();
        ruleEntryInfo.setSqlInfo(sqlInfo);
        Map<String, String> associativeTableName = ruleEntryInfo.getAliasTableName();
        sqlInfo.setFromItem(" from  " + associativeTableName.get(firstAssociativesAlias) + "  " + firstAssociativesAlias + " ");
        if (entry != null && entry.size() > 0) {
            int len = entry.size();
            for (int i = 0; i < len; ++i) {
                CheckpointDataSetEntryInfo entryInfo = entry.get(i);
                String compareFieldAlias = entryInfo.getCompareFieldAlias();
                String compareValueAlias = entryInfo.getCompareValueAlias();
                String compareField = entryInfo.getCompareField();
                String compareValue = entryInfo.getCompareValue();
                if (!compareField.contains("{$") || !compareValue.contains("{$") || !compareFieldAlias.equals(info.getEntityalias()) && !compareValueAlias.equals(info.getEntityalias())) continue;
                sqlInfo.setFromItem(" from " + table.getName() + " " + info.getEntityalias() + " ");
                break;
            }
        }
        this.getJoinAndWhereItem(ctx, ruleEntryInfo);
        this.formatJoinSql(sqlInfo, associativeTableName);
        String fromItem = sqlInfo.getFromItem();
        if (fromItem.contains(" " + info.getEntityalias() + " ")) {
            String billID = "";
            billID = !StringUtils.isEmpty((CharSequence)billId) ? billId : (StringUtils.isEmpty((CharSequence)ruleEntryInfo.getJobInfo().getSscBillID()) ? ruleEntryInfo.getJobInfo().getBillID() : ruleEntryInfo.getJobInfo().getSscBillID());
            sqlInfo.getWhere_entityItem().append(" and " + info.getEntityalias() + "." + "FID" + " = '" + billID + "' ");
        }
        return sqlInfo;
    }

    protected void getJoinAndWhereItem(Context ctx, RuleEntryInfo ruleEntryInfo) throws EASBizException, BOSException {
        IColumn iColumn = null;
        CheckpointDataSetEntryCollection entryCollection = ruleEntryInfo.getDataSetInfo().getEntrys();
        int len = entryCollection.size();
        for (int i = 0; i < len; ++i) {
            CheckpointDataSetEntryInfo entryInfo = entryCollection.get(i);
            String compareField = entryInfo.getCompareField();
            String compareValue = entryInfo.getCompareValue();
            if (compareField.contains("{$") && compareValue.contains("{$")) {
                if (compareField.contains(".") && !compareValue.contains(".") || compareValue.contains(".") && !compareField.contains(".")) {
                    iColumn = new HeadColumnJoinEntryColumn();
                } else if (!compareField.contains(".") && !compareValue.contains(".")) {
                    iColumn = new HeadColumnJoinHeadColumn();
                } else if (compareField.contains(".") && compareValue.contains(".")) {
                    iColumn = new EntryColumnJoinEntryColumn();
                }
                assert (iColumn != null);
                iColumn.getJoinItem(ctx, ruleEntryInfo, entryInfo);
                continue;
            }
            this.getWhereItem(ctx, ruleEntryInfo, entryInfo);
        }
        if (ruleEntryInfo.getCheckpointInfo() != null) {
            ArrayList<EntityAdapter> adapter = new ArrayList<EntityAdapter>();
            IntelligentAuditExecuteRuleEntryCollection executeRuleEntryCollection = ruleEntryInfo.getCheckpointInfo().getExecuteRule();
            adapter.addAll(DataSetUtils.getEntityAdapterByRuleEntry(executeRuleEntryCollection));
            IntelligentDataShowCfgCollection showCfgCollection = ruleEntryInfo.getCheckpointInfo().getShowCfgEntrys();
            adapter.addAll(DataSetUtils.getEntityAdapterByShowCfg(ctx, showCfgCollection));
            CheckpointEntryFilterCollection entryFilters = ruleEntryInfo.getCheckpointInfo().getEntryFilters();
            adapter.addAll(DataSetUtils.getEntityAdapterByEntryFilter(ctx, entryFilters));
            ArrayList adapterNew = new ArrayList(new HashSet(adapter));
            for (int i = 0; i < adapterNew.size(); ++i) {
                iColumn = new EntryColumn(((EntityAdapter)adapterNew.get(i)).getField(), ((EntityAdapter)adapterNew.get(i)).getAlias());
                iColumn.getJoinItem(ctx, ruleEntryInfo, null);
            }
        }
    }

    private void getWhereItem(Context ctx, RuleEntryInfo ruleEntryInfo, CheckpointDataSetEntryInfo entryInfo) throws EASBizException, BOSException {
        String compareField = entryInfo.getCompareField();
        IColumn iColumn = null;
        iColumn = compareField.contains(".") ? new EntryColumnJoinValue() : new HeadColumnJoinValue();
        iColumn.getJoinItem(ctx, ruleEntryInfo, entryInfo);
    }

    private void formatJoinSql(SQLInfo sqlInfo, Map<String, String> associativeTableName) {
        String fromItem = sqlInfo.getFromItem();
        String[] fromAlias = fromItem.trim().split(" ");
        String alias = fromAlias[fromAlias.length - 1];
        List<String> joinList = sqlInfo.getJoinList();
        LinkedHashMap<String, List<String>> newJoinMap = new LinkedHashMap<String, List<String>>();
        ArrayList<String> list = new ArrayList<String>();
        list.add(alias);
        for (int flag = 10; list.size() > 0 && joinList.size() > 0 && flag > 0; --flag) {
            int sqlSize = joinList.size();
            for (int j = 0; j < list.size(); ++j) {
                String m = (String)list.get(j);
                for (int i = 0; i < joinList.size(); ++i) {
                    if (!this.sortJoinSql(list, m, newJoinMap, joinList.get(i))) continue;
                    joinList.remove(i);
                    --i;
                    if (j - 1 < 0) {
                        j = list.size() - 1;
                        continue;
                    }
                    --j;
                }
            }
            if (sqlSize != joinList.size()) continue;
            String s = joinList.get(0);
            String s2 = s.substring(s.indexOf("on ") + 3, s.length());
            String[] column = s2.split("=");
            String alias1 = column[1].split("\\.")[0].trim();
            list.clear();
            list.add(alias1);
        }
        sqlInfo.getJoinList().clear();
        for (Map.Entry m : newJoinMap.entrySet()) {
            sqlInfo.getJoinList().addAll((Collection)m.getValue());
        }
        List<String> newJoinList = this.mergeJoinSql(sqlInfo.getJoinList(), associativeTableName, alias);
        sqlInfo.getJoinList().clear();
        sqlInfo.getJoinList().addAll(newJoinList);
    }

    private List<String> mergeJoinSql(List<String> list, Map<String, String> associativeTableName, String fromAlias) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> orderList = new ArrayList<String>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(fromAlias, "");
        orderList.add(fromAlias);
        for (String string : list) {
            Matcher matcher = pattern1.matcher(string);
            while (matcher.find()) {
                String s1 = matcher.group(2).trim();
                String key = s1.split(" ")[1];
                String s2 = string.substring(string.indexOf("on ") + 3, string.length());
                if (map.containsKey(key)) {
                    String s3;
                    String[] column = s2.split("[=|!=|>|>=|<|<=]");
                    String alias0 = column[0].split("\\.")[0].trim();
                    String alias1 = "";
                    alias1 = StringUtils.isEmpty((CharSequence)column[1]) && column.length > 2 ? column[2].split("\\.")[0].trim() : column[1].split("\\.")[0].trim();
                    if (!map.containsKey(alias0)) {
                        map.put(alias0, s2);
                        orderList.add(alias0);
                        continue;
                    }
                    if (!map.containsKey(alias1)) {
                        map.put(alias1, s2);
                        orderList.add(alias1);
                        continue;
                    }
                    if (orderList.indexOf(alias0) > orderList.indexOf(alias1)) {
                        s3 = (String)map.get(alias0);
                        s3 = s3 + " and " + s2;
                        map.put(alias0, s3);
                        continue;
                    }
                    s3 = (String)map.get(alias1);
                    s3 = s3 + " and " + s2;
                    map.put(alias1, s3);
                    continue;
                }
                map.put(key, s2);
                orderList.add(key);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
            result.add(" left join " + associativeTableName.get(entry.getKey()) + " " + (String)entry.getKey() + " on " + (String)entry.getValue() + " ");
        }
        return result;
    }

    private boolean sortJoinSql(List<String> list, String alias, Map<String, List<String>> newJoinList, String s) {
        Matcher matcher;
        if ((s.contains(" " + alias + ".") || s.contains("%" + alias + ".")) && (matcher = pattern1.matcher(s)).find()) {
            String trim = matcher.group(2).trim();
            String key = trim.split(" ")[1];
            if (!newJoinList.containsKey(key)) {
                newJoinList.put(key, new ArrayList());
            }
            newJoinList.get(key).add(s);
            list.add(key);
            list.remove(alias);
            return true;
        }
        return false;
    }

    private void verifyEntrys(CheckpointDataSetInfo info) throws EASBizException {
        CheckpointDataSetEntryCollection entrys = info.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            String[] entitys = info.getAssociativeentity().split(",");
            if (info.getAssociativeentity().contains(",")) {
                HashMap<String, Set<String>> aliasMap = new HashMap<String, Set<String>>(entitys.length + 1);
                int len = entrys.size();
                for (int i = 0; i < len; ++i) {
                    CheckpointDataSetEntryInfo entryInfo = entrys.get(i);
                    String compareField = entryInfo.getCompareField();
                    String compareFieldAlias = entryInfo.getCompareFieldAlias();
                    String compareValue = entryInfo.getCompareValue();
                    String compareValueAlias = entryInfo.getCompareValueAlias();
                    if (!compareField.contains("$") || !compareValue.contains("$")) continue;
                    if (!aliasMap.containsKey(compareFieldAlias)) {
                        aliasMap.put(compareFieldAlias, new HashSet());
                    }
                    Set set1 = (Set)aliasMap.get(compareFieldAlias);
                    set1.add(compareValueAlias);
                    aliasMap.put(compareFieldAlias, set1);
                    if (!aliasMap.containsKey(compareValueAlias)) {
                        aliasMap.put(compareValueAlias, new HashSet());
                    }
                    Set set2 = (Set)aliasMap.get(compareValueAlias);
                    set2.add(compareFieldAlias);
                    aliasMap.put(compareValueAlias, set2);
                }
                Map.Entry next = aliasMap.entrySet().iterator().next();
                HashSet<String> countSet = new HashSet<String>();
                this.count((String)next.getKey(), aliasMap, (Set)aliasMap.get(next.getKey()), countSet, new HashSet<String>());
                if (countSet.size() < entitys.length) {
                    throw new EASBizException(new NumericExceptionSubItem("XX", "\u5173\u8054\u5b9e\u4f53\u4e4b\u95f4\u6216\u8005\u5173\u8054\u5b9e\u4f53\u4e0e\u5f53\u524d\u5b9e\u4f53\u5fc5\u987b\u6709\u5173\u8054\u5173\u7cfb"));
                }
            }
        }
    }

    private void count(String alias, Map<String, Set<String>> aliasMap, Set<String> set, Set<String> newSet, Set<String> alreadySet) {
        if (set == null) {
            return;
        }
        newSet.addAll(set);
        newSet.add(alias);
        if (alreadySet.contains(alias)) {
            return;
        }
        alreadySet.add(alias);
        for (String s : set) {
            Set<String> set1 = aliasMap.get(s);
            this.count(s, aliasMap, set1, newSet, alreadySet);
        }
    }
}

