/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.app.erp.check.impl.BaseCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceAmountUtil;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceUtil;
import java.math.BigDecimal;
import java.util.Map;

public class InvoiceTotalAmountInspection
extends BaseCheckService {
    @Override
    public Map<String, String> check(Map map) {
        String billId = this.getBillId(map);
        Context ctx = (Context)map.get("ctx");
        try {
            BigDecimal invoiceTotalAmount = InvoiceAmountUtil.getInvoicesTotalAmount(ctx, billId);
            if (null == invoiceTotalAmount) {
                return this.printLogAndReturnMap("true", null, null);
            }
            BigDecimal billTotalAmount = InvoiceUtil.getTotalAmount(map);
            if (invoiceTotalAmount.compareTo(billTotalAmount) == -1) {
                String msg = "\u53d1\u7968\u603b\u91d1\u989d\u4e3a\uff1a" + invoiceTotalAmount.setScale(2, 4) + "\uff0c\u5c0f\u4e8e\u5355\u636e\u603b\u91d1\u989d\uff01";
                return this.printLogAndReturnMap("false", msg, null);
            }
        }
        catch (CheckException e) {
            String msg = "\u53d1\u7968\u603b\u91d1\u989d\u68c0\u67e5-" + e.getMessage();
            String errorCode = "ctx:" + ctx.toString() + ",billId:" + billId + "," + e.getCause().getMessage();
            return this.printLogAndReturnMap("false", msg, errorCode);
        }
        return this.printLogAndReturnMap("true", null, null);
    }
}

