/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app.erp.check.impl.taxi;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.check.exception.CheckException;
import com.kingdee.eas.base.ssc.app.erp.check.impl.BaseCheckService;
import com.kingdee.eas.base.ssc.app.erp.check.util.InvoiceUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TaxiInvoiceDateInspection
extends BaseCheckService {
    @Override
    public Map<String, String> check(Map map) {
        String billId = this.getBillId(map);
        Context ctx = (Context)map.get("ctx");
        try {
            List<Map<String, String>> invoiceList = InvoiceUtil.getTaixInvoices(ctx, billId);
            if (invoiceList.isEmpty()) {
                return this.printLogAndReturnMap("true", null, null);
            }
            for (Map<String, String> invoice : invoiceList) {
                if (StringUtils.isBlank((CharSequence)invoice.get("invoiceDate"))) {
                    throw new CheckException("invoiceDate\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
                }
                if (StringUtils.isBlank((CharSequence)invoice.get("TimeGetOn"))) {
                    throw new CheckException("TimeGetOn\u5b57\u6bb5\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
                }
                if (!StringUtils.isBlank((CharSequence)invoice.get("invoiceNo"))) continue;
                throw new CheckException("\u53d1\u7968\u53f7\u4e3a\u7a7a\uff01", "param:" + invoice.get("id").toString());
            }
            Map<String, Date> dateMap = InvoiceUtil.getStartAndEndDate(map);
            ArrayList<String> exceptionInvoiceList = new ArrayList<String>();
            for (Map<String, String> invoice : invoiceList) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date taixDate = sdf.parse(invoice.get("invoiceDate"));
                    if (!taixDate.before(dateMap.get("startDate")) && !taixDate.after(dateMap.get("endDate"))) continue;
                    exceptionInvoiceList.add(invoice.get("invoiceNo"));
                }
                catch (ParseException e) {
                    throw new CheckException("\u65e5\u671f\u7c7b\u578b\u8f6c\u6362\u9519\u8bef\uff01", "param:" + invoice.get("invoiceDate"));
                }
            }
            if (!exceptionInvoiceList.isEmpty()) {
                String msg = "\u7684\u58eb\u53d1\u7968" + ((Object)exceptionInvoiceList).toString() + "\u65e5\u671f\u4e0d\u5728\u4e1a\u52a1\u65e5\u671f\u8303\u56f4\u5185!";
                return this.printLogAndReturnMap("false", msg, null);
            }
        }
        catch (CheckException e) {
            String msg = "\u7684\u58eb\u7968\u4e58\u5750\u65e5\u671f\u68c0\u67e5-" + e.getMessage();
            String errorCode = "ctx:" + ctx.toString() + ",billId:" + billId + "," + e.getCause().getMessage();
            return this.printLogAndReturnMap("false", msg, errorCode);
        }
        return this.printLogAndReturnMap("true", null, null);
    }
}

