/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common.script;

import com.kingdee.eas.base.ssc.common.script.ScriptConstant;
import com.kingdee.eas.base.ssc.common.script.Word;
import com.kingdee.eas.base.ssc.common.script.custom.ScriptEngineUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;

public class WordGenerator
implements ScriptConstant {
    private String script;
    private int index = 0;
    private int len;
    private boolean isEnd = false;
    private static final char[] varAbleChar = new char[]{'_', '.'};

    WordGenerator(String script) {
        if (StringUtils.isEmpty((String)script)) {
            this.isEnd = true;
        } else {
            this.script = script;
            this.len = script.length();
        }
    }

    public Word nextWord() throws EASBizException {
        if (this.isEnd) {
            return null;
        }
        Word wd = new Word();
        char c = this.script.charAt(this.index++);
        wd.getWord().append(c);
        switch (c) {
            case '(': {
                wd.setType(0);
                break;
            }
            case ')': {
                wd.setType(4);
                break;
            }
            case '<': 
            case '>': {
                char cb = c;
                wd.setType(2);
                c = this.script.charAt(this.index);
                if (c == '=') {
                    wd.getWord().append(c);
                    ++this.index;
                    break;
                }
                if (c != '>' || cb != '<') break;
                wd.getWord().append(c);
                ++this.index;
                break;
            }
            case '!': {
                wd.setType(2);
                c = this.script.charAt(this.index);
                if (c != '=') break;
                wd.getWord().append(c);
                ++this.index;
                break;
            }
            case '=': {
                wd.setType(2);
                c = this.script.charAt(this.index);
                if (c != '=') {
                    throw new EASBizException(new NumericExceptionSubItem("", "script comparison operators error!"));
                }
                wd.getWord().append(c);
                ++this.index;
                break;
            }
            case '\'': {
                this.wordIsVal(wd, true);
                break;
            }
            case '|': {
                wd.setType(5);
                if (this.script.charAt(this.index) == '|') {
                    wd.getWord().append("|");
                    ++this.index;
                    break;
                }
                throw new EASBizException(new NumericExceptionSubItem("", "script logic(|) operators error!"));
            }
            case '&': {
                wd.setType(5);
                if (this.script.charAt(this.index) == '&') {
                    wd.getWord().append("&");
                    ++this.index;
                    break;
                }
                throw new EASBizException(new NumericExceptionSubItem("", "script logic(&) operators error!"));
            }
            default: {
                if (c >= '0' && c <= '9') {
                    this.wordIsVal(wd, false);
                    break;
                }
                if (c == '_' || this.isEnglishChar(c)) {
                    this.wardIsVar(wd);
                    break;
                }
                if (this.isSpaceChar(c)) {
                    if (this.wordIsCustomCMP(wd)) break;
                    this.wordIsSpace(wd);
                    break;
                }
                throw new EASBizException(new NumericExceptionSubItem("", "script parse type error!"));
            }
        }
        if (this.index >= this.len) {
            this.isEnd = true;
        }
        return wd;
    }

    private boolean wordIsCustomCMP(Word wd) {
        int tmpIndex = 0;
        for (int i = 0; i < ScriptEngineUtil.customScriptMethods.length; ++i) {
            String customKeyWordSub = ScriptEngineUtil.customScriptMethods[i].getKeyWord().substring(1);
            String scriptSubStr = "";
            for (tmpIndex = this.index; tmpIndex < this.len && this.isSpaceChar(this.script.charAt(tmpIndex)); ++tmpIndex) {
            }
            int endIndex = tmpIndex + customKeyWordSub.length();
            scriptSubStr = this.script.substring(tmpIndex);
            if (!scriptSubStr.startsWith(customKeyWordSub)) continue;
            wd.setWord(new StringBuffer(ScriptEngineUtil.customScriptMethods[i].getKeyWord()));
            wd.setType(2);
            this.index = endIndex;
            return true;
        }
        return false;
    }

    private void wordIsSpace(Word wd) {
        while (this.index < this.len && this.isSpaceChar(this.script.charAt(this.index))) {
            ++this.index;
        }
        wd.getWord().setCharAt(0, ' ');
        wd.setType(6);
    }

    private boolean isSpaceChar(char c) {
        return c == ' ';
    }

    private void wardIsVar(Word wd) {
        wd.setType(1);
        while (this.index < this.len && this.isVarChar(this.script.charAt(this.index))) {
            wd.getWord().append(this.script.charAt(this.index));
            ++this.index;
        }
    }

    private boolean isVarChar(char c) {
        return this.isEnglishChar(c) || this.isNumber(c) || this.isVarAbleChar(c);
    }

    private boolean isEnglishChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private void wordIsVal(Word wd, boolean isStr) throws EASBizException {
        wd.setType(3);
        if (!isStr) {
            if (this.index >= this.len) {
                return;
            }
            boolean pointed = false;
            boolean isIntact = true;
            char c = this.script.charAt(this.index);
            while (this.index < this.len && (this.isNumber(c) || c == '.')) {
                if (c == '.') {
                    if (pointed) break;
                    pointed = true;
                    isIntact = false;
                } else {
                    isIntact = true;
                }
                wd.getWord().append(c);
                if (++this.index >= this.len) break;
                c = this.script.charAt(this.index);
            }
            if (!isIntact) {
                throw new EASBizException(new NumericExceptionSubItem("", "parse number error!"));
            }
        } else {
            char c = this.script.charAt(this.index);
            while (c != '\'' && this.index < this.len) {
                wd.getWord().append(c);
                ++this.index;
                if (this.index == this.len) {
                    throw new EASBizException(new NumericExceptionSubItem("", "script is not legal!"));
                }
                c = this.script.charAt(this.index);
            }
            wd.getWord().append('\'');
            ++this.index;
        }
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isVarAbleChar(char c) {
        for (int i = 0; i < varAbleChar.length; ++i) {
            if (c != varAbleChar[i]) continue;
            return true;
        }
        return false;
    }
}

