/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.common.script.custom;

import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CustomScriptMethod {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.common.script.custom.CustomScriptMethod");
    protected static final String DECOLLATOR = " ";
    protected static final String BIGGER = ">";
    protected static final String BIGGER_OR_EQUALS = ">=";
    protected static final String LESS = "<";
    protected static final String LESS_OR_EQUALS = "<=";
    protected static final String EQUALS = "==";
    protected static final String NOT_EQUALS_1 = "!=";
    protected static final String NOT_EQUALS_2 = "<>";
    protected static final String AND_1 = " and ";
    protected static final String AND_2 = "&&";
    protected static final String OR_1 = " or ";
    protected static final String OR_2 = "||";
    protected static final String LEFT_BRACKET = "(";
    protected static final String RIGHT_BRACKET = ")";
    protected static final String[] DEFAULT_KEYWORDS = new String[]{" ", ">", ">=", "<", "<=", "==", "!=", "<>", " and ", "&&", " or ", "||", "(", ")"};
    protected final String keyWord;

    protected CustomScriptMethod(String keyWord) {
        if (!this.checkWord(keyWord)) {
            logger.error((Object)"\u521d\u59cb\u5316\u81ea\u5b9a\u4e49\u65b9\u6cd5\u5f02\u5e38!\u81ea\u5b9a\u4e49\u5173\u952e\u5b57,\u5fc5\u987b\u4ee5\u4e00\u4e2a\u7a7a\u683c\u6253\u5934,\u4e14\u4ee5\u4e00\u4e2a\u7a7a\u683c\u7ed3\u5c3e!");
            throw new IllegalArgumentException("\u81ea\u5b9a\u4e49\u5173\u952e\u5b57,\u5fc5\u987b\u4ee5\u4e00\u4e2a\u7a7a\u683c\u6253\u5934,\u4e14\u4ee5\u4e00\u4e2a\u7a7a\u683c\u7ed3\u5c3e!");
        }
        this.keyWord = keyWord;
        this.inntChangeScriptInstanceMap();
    }

    private boolean checkWord(String keyWord) {
        return keyWord.charAt(0) == ' ' && keyWord.charAt(keyWord.length() - 1) == ' ' && keyWord.charAt(1) != ' ' && keyWord.charAt(keyWord.length() - 2) != ' ';
    }

    public String getKeyWord() {
        return this.keyWord;
    }

    protected abstract void inntChangeScriptInstanceMap();

    protected abstract Map<String, ChangeScript> getChangeScriptInstanceMap();

    public String changeCustomScript(String scriptEngineName, String script) {
        Map<String, ChangeScript> map = this.getChangeScriptInstanceMap();
        if (map == null || map.isEmpty()) {
            return script;
        }
        ChangeScript impl = map.get(scriptEngineName);
        if (impl == null) {
            return script;
        }
        return impl.changeCustomScript(script);
    }

    protected abstract class ReplaceRule {
        protected static final String PARAM = "{i}";
        protected static final String INDEX = "i";
        protected final String REPLACE_RULE = this.initReplace_rule();

        protected ReplaceRule() {
        }

        protected abstract String initReplace_rule();

        protected String replace(String ... params) {
            if (this.REPLACE_RULE == null) {
                return null;
            }
            String result = this.REPLACE_RULE;
            for (int i = 0; i < params.length; ++i) {
                result = result.replace(this.getParamPlaceholder(i), params[i]);
            }
            return result;
        }

        protected String getParamPlaceholder(int index) {
            return PARAM.replace(INDEX, index + "");
        }
    }

    protected class ChangeScript {
        private Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.tool.script.CustomScriptMethod$ChangeScript");
        protected static final String SCRIPT_KEY = "script";
        protected static final String INDEX_KEY = "start_index";
        protected final String scriptEngineName;
        protected final ReplaceRule replaceRule;

        protected ChangeScript(String scriptEngineName, ReplaceRule replaceRule) {
            this.scriptEngineName = scriptEngineName;
            this.replaceRule = replaceRule;
        }

        protected String changeCustomScript(String script) {
            if (StringUtils.isEmpty((String)script)) {
                return null;
            }
            int keyWord_last_index = script.lastIndexOf(CustomScriptMethod.this.keyWord);
            int start_index = 0;
            int safetyFlag = 0;
            while (start_index <= keyWord_last_index && safetyFlag <= 1) {
                Map<String, Object> map = this.replaceMethod(start_index, script);
                script = map.get(SCRIPT_KEY).toString();
                start_index = (Integer)map.get(INDEX_KEY);
                if (start_index != (keyWord_last_index = script.lastIndexOf(CustomScriptMethod.this.keyWord))) continue;
                ++safetyFlag;
            }
            if (safetyFlag > 1) {
                this.logger.error((Object)"\u811a\u672c\u66ff\u6362\u53ef\u80fd\u51fa\u73b0\u6b7b\u5faa\u73af,\u88ab\u7ec8\u6b62,\u6700\u7ec8\u7684\u811a\u672c\u53ef\u80fd\u6267\u884c\u4e0d\u6b63\u5e38!");
            }
            return script;
        }

        protected Map<String, Object> replaceMethod(int start_index, String script) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put(SCRIPT_KEY, script);
            int nextKeyWordIndex = script.indexOf(CustomScriptMethod.this.keyWord, start_index);
            nextKeyWordIndex = nextKeyWordIndex == -1 ? script.length() : nextKeyWordIndex;
            map.put(INDEX_KEY, nextKeyWordIndex);
            if (nextKeyWordIndex == script.length()) {
                return map;
            }
            String preParam = this.getPreParam(nextKeyWordIndex, script);
            String afterParam = this.getAfterParam(nextKeyWordIndex + CustomScriptMethod.this.keyWord.length(), script);
            int oldStrIndex_start = script.lastIndexOf(preParam, nextKeyWordIndex);
            int oldStrIndex_end = script.indexOf(afterParam, nextKeyWordIndex + CustomScriptMethod.this.keyWord.length()) + afterParam.length();
            String replaceOldStr = script.substring(oldStrIndex_start, oldStrIndex_end);
            String replaceNewStr = this.replaceRule.replace(preParam, afterParam);
            String newScript = script.replace(replaceOldStr, replaceNewStr);
            map.put(SCRIPT_KEY, newScript);
            map.put(INDEX_KEY, start_index);
            return map;
        }

        protected String getPreParam(int index, String script) {
            String temp = script.substring(0, index).trim();
            int start_index = 0;
            for (int i = 0; i < DEFAULT_KEYWORDS.length; ++i) {
                int temp_start_index = temp.lastIndexOf(DEFAULT_KEYWORDS[i]);
                if (temp_start_index > -1) {
                    temp_start_index += DEFAULT_KEYWORDS[i].length();
                }
                start_index = temp_start_index > start_index ? temp_start_index : start_index;
            }
            int keyWord_index = temp.lastIndexOf(CustomScriptMethod.this.keyWord);
            if (keyWord_index > -1) {
                keyWord_index += CustomScriptMethod.this.keyWord.length();
            }
            start_index = keyWord_index > start_index ? keyWord_index : start_index;
            return temp.substring(start_index);
        }

        protected String getAfterParam(int index, String script) {
            String temp = script.substring(index, script.length()).trim();
            int end_index = temp.length();
            for (int i = 0; i < DEFAULT_KEYWORDS.length; ++i) {
                int temp_end_index = temp.indexOf(DEFAULT_KEYWORDS[i]);
                if (temp_end_index <= -1) continue;
                end_index = end_index > temp_end_index ? temp_end_index : end_index;
            }
            int keyWord_index = temp.indexOf(CustomScriptMethod.this.keyWord);
            if (keyWord_index > -1) {
                end_index = end_index > keyWord_index ? keyWord_index : end_index;
            }
            return temp.substring(0, end_index);
        }
    }
}

