/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.quartz.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.JobFactory;
import com.kingdee.eas.base.ssc.JobInfo;
import com.kingdee.eas.base.ssc.JobPoolingType;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.JobStateTimeFactory;
import com.kingdee.eas.base.ssc.JobStateTimeInfo;
import com.kingdee.eas.base.ssc.OrgInfo;
import com.kingdee.eas.base.ssc.SystemAttributeCollection;
import com.kingdee.eas.base.ssc.SystemAttributeFactory;
import com.kingdee.eas.base.ssc.SystemAttributeInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.bussiness.bean.JobBean;
import com.kingdee.eas.base.ssc.common.ConstantUtil;
import com.kingdee.eas.base.ssc.common.MapUtil;
import com.kingdee.eas.base.ssc.external.TransferFlowSend;
import com.kingdee.eas.base.ssc.quartz.entity.PersonnelTaskNumber;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class QuartzJobServiceImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.quartz.service.impl.QuartzJobServiceImpl");

    public synchronized void assignJobs(Context ctx) throws Exception {
        logger.info((Object)"assignJobs in quartzjobServiceImp ...");
        CoreBaseCollection jobList = new CoreBaseCollection();
        ArrayList<JobBean> jobBeanList = new ArrayList<JobBean>();
        JobInfo job = null;
        JobBean jobBean = null;
        String sysID = "";
        String busID = "";
        BussinessAttributeInfo busInfo = null;
        PersonnelTaskNumber personnelTaskNumber = null;
        String fsubject = "";
        OrgInfo orgInfo = null;
        int minNumber = 0;
        int maxNumber = 0;
        try {
            List<JobInfo> list = this.queryUnassginJob(ctx);
            if (list != null && list.size() > 0) {
                int i;
                HashMap<JobInfo, Map> maps = new HashMap<JobInfo, Map>(list.size());
                for (i = 0; i < list.size(); ++i) {
                    job = list.get(i);
                    SelectorItemCollection selectorColl = new SelectorItemCollection();
                    selectorColl.add("*");
                    selectorColl.add("bussAttrID.id");
                    selectorColl.add("bussAttrID.number");
                    selectorColl.add("bussAttrID.name");
                    job = JobFactory.getLocalInstance(ctx).getJobInfo((IObjectPK)new ObjectUuidPK(job.getId()), selectorColl);
                    list.set(i, job);
                    logger.info((Object)("job...is......" + job + "...jobid is..." + job.getId()));
                    fsubject = job.getSubject();
                    logger.info((Object)("fsubject is ......" + fsubject));
                    orgInfo = job.getOrgID();
                    busInfo = job.getBussAttrID();
                    Map map = this.loadPersonToOrgPerson(ctx, busInfo, orgInfo);
                    maps.put(job, map);
                }
                for (i = 0; i < list.size(); ++i) {
                    UserInfo userInfo;
                    job = list.get(i);
                    logger.info((Object)("job...is......" + job + "...jobid is..." + job.getId()));
                    String jobID = job.getId().toString();
                    logger.info((Object)("job id is ......" + jobID));
                    SystemAttributeInfo systemAttributeInfo = this.getSystemAttributeByJob(ctx, jobID);
                    sysID = systemAttributeInfo.getId().toString();
                    minNumber = systemAttributeInfo.getMinNumber();
                    maxNumber = systemAttributeInfo.getMaxNumber();
                    Map map = (Map)maps.get(job);
                    if (map == null) continue;
                    Object obj = map.get("buss" + busID);
                    logger.info((Object)("getPersonNumber by bussId,obj is..." + obj));
                    if (obj == null) {
                        logger.error((Object)("\u4efb\u52a1ID: " + job.getId() + ", \u4e3b\u9898\uff1a" + job.getSubject() + "\uff0c\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002"));
                        continue;
                    }
                    personnelTaskNumber = (PersonnelTaskNumber)obj;
                    if (personnelTaskNumber == null) continue;
                    logger.info((Object)("begin to assign job to person......sysID is....." + sysID));
                    int opertingTaskCount = personnelTaskNumber.getLestOperatingJobCount();
                    logger.error((Object)("regulation..." + minNumber + "max is" + maxNumber));
                    if (opertingTaskCount < minNumber) {
                        logger.info((Object)"opertingTaskCount < regulation.getMinNumber()......");
                        userInfo = new UserInfo();
                        userInfo.setId(BOSUuid.read((String)personnelTaskNumber.getLestOperatingJobPersonID()));
                        job.setPersonnelID(userInfo);
                        personnelTaskNumber = null;
                    } else if (personnelTaskNumber.getOperatedJobCount() + opertingTaskCount < maxNumber) {
                        logger.info((Object)"into else...... ");
                        userInfo = new UserInfo();
                        userInfo.setId(BOSUuid.read((String)personnelTaskNumber.getLestOperatingJobPersonID()));
                        job.setPersonnelID(userInfo);
                        personnelTaskNumber = null;
                    } else {
                        logger.error((Object)("\u4efb\u52a1ID: " + job.getId() + ", \u4e3b\u9898\uff1a" + job.getSubject() + "\uff0c\u81ea\u52a8\u5206\u914d\u5931\u8d25\u3002"));
                        continue;
                    }
                    job.setJobPoolingType(JobPoolingType.Operating);
                    job.setJobState(JobState.Normal);
                    job.setCreateTime(new Timestamp(new Date().getTime()));
                    jobList.add((CoreBaseInfo)job);
                    jobBean = new JobBean();
                    jobBean.setJobInfo(job);
                    jobBean.setJobState(JobState.Normal);
                    jobBean.setUserId(job.getPersonnelID().getId().toString());
                    jobBeanList.add(jobBean);
                }
                JobFactory.getLocalInstance(ctx).save(jobList);
                this.jobStateTime(ctx, jobBeanList);
                this.sendTask(ctx, jobBeanList);
                logger.info((Object)("save jobList over,jobList is......" + jobList));
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private List<JobInfo> queryUnassginJob(Context ctx) throws Exception {
        ArrayList<JobInfo> jobIDsList = new ArrayList<JobInfo>();
        String selectJobsSql = "select fid from T_SSC_Job where FJobPoolingType = '1'";
        int maxPool = Integer.valueOf(MapUtil.getValue(ConstantUtil.MAXPOOL));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectJobsSql, (int)0, (int)maxPool);
        JobInfo job = null;
        while (rowSet != null && rowSet.next()) {
            job = new JobInfo();
            job.setId(BOSUuid.read((String)rowSet.getString("fid")));
            jobIDsList.add(job);
        }
        return jobIDsList;
    }

    public Map loadPersonToOrgPerson(Context ctx, BussinessAttributeInfo busInfo, OrgInfo orgInfo) throws Exception {
        PersonnelTaskNumber personnelTaskNumber = null;
        HashMap<String, PersonnelTaskNumber> map = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select ro.FOrgIDID,ru.FUserIDID, ");
        sql.append(" (select count(j.fid) from t_ssc_job j  ");
        sql.append(" where j.FPersonnelIDID = ru.FUSERIDID and j.FJobPoolingType = '2'  ");
        sql.append(" ) as operatingCount, ");
        sql.append(" (select count(j.fid) from t_ssc_jobhis j ");
        sql.append(" where j.FPersonnelIDID = ru.FUSERIDID and j.FJobPoolingType = '3' ");
        sql.append(" ) as operatedCount ");
        sql.append(" from (select role.fid,role.FRoleTypeIDID,rb.fbussnameid from T_SSC_RoleBussattr rb inner join  t_ssc_role role on role.fid= rb.fparentid ) tem ");
        sql.append(" left outer join T_SSC_RoleOrg ro on ro.FRoleIDID = tem.fid ");
        sql.append(" left outer join T_SSC_RoleUser ru on ru.FRoleIDID = tem.fid ");
        sql.append(" where tem.fbussnameid = ? ");
        sql.append(" and ro.FOrgIDID = ?  ");
        sql.append(" order by operatingCount ");
        Statement ps = null;
        ResultSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{busInfo.getId().toString(), orgInfo.getId().toString()});
            if (rs != null && rs.next()) {
                map = new HashMap<String, PersonnelTaskNumber>();
                personnelTaskNumber = new PersonnelTaskNumber();
                personnelTaskNumber.setLestOperatingJobCount(rs.getInt("operatingCount"));
                personnelTaskNumber.setLestOperatingJobPersonID(rs.getString("FUserIDID"));
                personnelTaskNumber.setOperatedJobCount(rs.getInt("operatedCount"));
                map.put("buss" + busInfo.getId().toString(), personnelTaskNumber);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        finally {
            logger.info((Object)"getPersonTaskCountByOrgNumber over...");
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new Exception(e);
            }
        }
        return map;
    }

    private SystemAttributeInfo getSystemAttributeByJob(Context ctx, String jobID) {
        SystemAttributeInfo systemAttributeInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FSysAttrID                                       ");
        sql.append(" from T_SSC_BussinessAttribute ba                        ");
        sql.append(" left outer join T_SSC_Job j on j.FBussAttrIDID = ba.fid ");
        sql.append(" where j.fid = '").append(jobID).append("'");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        view.setFilter(filter);
        try {
            SystemAttributeCollection systemAttributeCollection = SystemAttributeFactory.getLocalInstance(ctx).getSystemAttributeCollection(view);
            if (systemAttributeCollection != null && systemAttributeCollection.size() > 0) {
                systemAttributeInfo = systemAttributeCollection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return systemAttributeInfo;
    }

    public void jobStateTime(Context ctx, List<JobBean> jobBeanList) throws Exception {
        try {
            if (jobBeanList != null && jobBeanList.size() > 0) {
                JobBean jobBean = null;
                CoreBaseCollection jobstatetimeList = new CoreBaseCollection();
                for (int i = 0; i < jobBeanList.size(); ++i) {
                    jobBean = jobBeanList.get(i);
                    if (jobBean == null) continue;
                    JobStateTimeInfo jobstatetime = new JobStateTimeInfo();
                    jobstatetime.setJobID(jobBean.getJobInfo());
                    jobstatetime.setNewJobState(jobBean.getJobState());
                    jobstatetime.setOldJobState(jobBean.getJobState());
                    jobstatetime.setChangeTime(new Timestamp(new Date().getTime()));
                    jobstatetimeList.add((CoreBaseInfo)jobstatetime);
                }
                JobStateTimeFactory.getLocalInstance(ctx).addnew(jobstatetimeList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void sendTask(Context ctx, List<JobBean> jobBeanList) throws Exception {
        try {
            if (jobBeanList != null && jobBeanList.size() > 0) {
                JobBean job = null;
                JobInfo jobInfo = null;
                for (int i = 0; i < jobBeanList.size(); ++i) {
                    job = jobBeanList.get(i);
                    if (job == null || (jobInfo = job.getJobInfo()) == null) continue;
                    String FassignId = jobInfo.getAssignId();
                    String solution = jobInfo.getSolution();
                    String dataCenter = jobInfo.getDataCenter();
                    String useID = job.getUserId();
                    logger.debug((Object)"transfer interface begin-----------");
                    logger.debug((Object)("transfer interface send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                    TransferFlowSend TransferFlowSend1 = new TransferFlowSend();
                    boolean sendOk = TransferFlowSend1.sendTask(ctx, jobInfo, solution, dataCenter, FassignId, useID);
                    logger.debug((Object)("FassignId------------" + FassignId));
                    logger.debug((Object)("solution--------------" + solution));
                    logger.debug((Object)("dataCenter--------------" + dataCenter));
                    logger.debug((Object)("useID------------" + useID));
                    if (!sendOk) {
                        logger.error((Object)("transfer interface not send--" + FassignId + "--" + solution + "--" + dataCenter + "--" + useID));
                    }
                    logger.debug((Object)"transfer interface end-----------");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new Exception(ex);
        }
    }
}

