/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.OnGuardTimeFactory;
import com.kingdee.eas.base.ssc.OnGuardTimeInfo;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.UserGroupFactory;
import com.kingdee.eas.base.ssc.UserGroupInfo;
import com.kingdee.eas.base.ssc.UserInfo;
import com.kingdee.eas.base.ssc.tool.DateUtil;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.base.ssc.workDate.TimeIgnoretDate;
import com.kingdee.eas.base.ssc.workDate.WorkDateUtil;
import com.kingdee.eas.base.ssc.workDate.WorkTime;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OnGuardTimeReport {
    private static Logger logger = Logger.getLogger(OnGuardTimeReport.class);

    public void execute(Context ctx, String curDay) {
        try {
            String sql = "select top 1 Fdate, FCreateTime from T_SSC_OnGuardTime order by FDate desc";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(rs.getDate("Fdate"));
                String createTimeStr = new SimpleDateFormat("yyyy-MM-dd").format(rs.getDate("FCreateTime"));
                if (!curDay.equals(dateStr) && dateStr.equals(createTimeStr)) {
                    this.doExecute(ctx, dateStr, true);
                }
            }
            this.doExecute(ctx, curDay, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void doExecute(Context ctx, String curDay, boolean isLastTime) throws BOSException, SQLException {
        String shareCenter = " SELECT distinct fshareCenterId FROM t_ssc_user ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)shareCenter);
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(rs.getString("fshareCenterId"));
        }
        String delete = " DELETE FROM t_ssc_onGuardTime WHERE fdate >= {ts'" + curDay + "'} ";
        DbUtil.execute((Context)ctx, (String)delete);
        for (int i = 0; i < list.size(); ++i) {
            this.executeWorkTime(ctx, (String)list.get(i), curDay, isLastTime);
        }
    }

    private void executeWorkTime(Context ctx, String shareCenterId, String curDay, boolean isLastTime) {
        try {
            ArrayList<UserState> list;
            WorkDateUtil util = WorkDateUtil.getInstance(ctx, shareCenterId, true);
            Date executeDate = DateUtil.parseDate(curDay);
            long systemCurrentTime = System.currentTimeMillis();
            String userDimissionSTable = "";
            if (isLastTime) {
                systemCurrentTime = executeDate.getTime() + 86400000L;
                userDimissionSTable = "t_ssc_userdstatetimeHIS";
            } else {
                systemCurrentTime = System.currentTimeMillis();
                userDimissionSTable = "T_SSC_UserDimissionStateTime";
            }
            WorkTime workTime = util.getWorkTimeInfo();
            TimeIgnoretDate startTimestampAM = workTime.getStartTimestampAM();
            TimeIgnoretDate endTimestampAM = workTime.getEndTimestampAM();
            TimeIgnoretDate startTimestampPM = workTime.getStartTimestampPM();
            TimeIgnoretDate endTimestampPM = workTime.getEndTimestampPM();
            StringBuffer buffer = new StringBuffer();
            buffer.append(" SELECT uds.FUSERID USERID, uds.FCHANGETIME CHANGETIME, uds.FDIMISSIONSTATE state  FROM ");
            buffer.append(userDimissionSTable);
            buffer.append(" uds inner join t_ssc_user users  ");
            buffer.append(" on uds.FUSERID = users.FID  ");
            buffer.append(" where  uds.FCHANGETIME > {ts'" + curDay + " 00:00:00'} and uds.FCHANGETIME <= {ts'" + curDay + " 23:59:59'} ");
            buffer.append(" and users.FSHARECENTERID =? ");
            buffer.append(" group by  uds.FUSERID, uds.FCHANGETIME, uds.FDIMISSIONSTATE  order by  uds.FUSERID asc, uds.FCHANGETIME asc  ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{shareCenterId});
            HashMap userStateMap = new HashMap();
            HashMap<String, List<UserState>> userUnWorkStateMap = new HashMap<String, List<UserState>>();
            HashMap<String, UserJobComp> userJbCompMap = new HashMap<String, UserJobComp>();
            String beforeState = "";
            while (rs.next()) {
                String userId = rs.getString("userId");
                Timestamp timeStamp = rs.getTimestamp("CHANGETIME");
                String state = rs.getString("state");
                if (!userJbCompMap.containsKey(userId)) {
                    this.addUserJobComp(userJbCompMap, userId);
                }
                if (userStateMap.containsKey(userId)) {
                    if (beforeState.equalsIgnoreCase(state)) continue;
                    List userStateList = (List)userStateMap.get(userId);
                    userStateList.add(new UserState(userId, timeStamp, state));
                } else {
                    beforeState = "";
                    list = new ArrayList<UserState>();
                    if ("0".equals(state)) continue;
                    UserState userState = new UserState(userId, timeStamp, state);
                    list.add(userState);
                    userStateMap.put(userId, list);
                }
                beforeState = state;
            }
            Set userIdSet = userStateMap.keySet();
            for (String userId : userIdSet) {
                list = (ArrayList<UserState>)userStateMap.get(userId);
                ArrayList<UserState> morning = new ArrayList<UserState>();
                ArrayList<UserState> afternoon = new ArrayList<UserState>();
                boolean beforeMorning = false;
                boolean beforeAfternoon = false;
                for (int i = 0; i < list.size(); ++i) {
                    if (((UserState)list.get(i)).getTimeStamp().before(this.getTimeStamp(executeDate, startTimestampAM))) {
                        beforeMorning = true;
                        beforeAfternoon = true;
                    }
                    if (((UserState)list.get(i)).getTimeStamp().after(this.getTimeStamp(executeDate, startTimestampAM)) && ((UserState)list.get(i)).getTimeStamp().before(this.getTimeStamp(executeDate, endTimestampAM))) {
                        morning.add((UserState)list.get(i));
                        beforeAfternoon = true;
                    }
                    if (((UserState)list.get(i)).getTimeStamp().after(this.getTimeStamp(executeDate, endTimestampAM)) && ((UserState)list.get(i)).getTimeStamp().before(this.getTimeStamp(executeDate, startTimestampPM))) {
                        beforeAfternoon = true;
                    }
                    if (!((UserState)list.get(i)).getTimeStamp().after(this.getTimeStamp(executeDate, startTimestampPM)) || !((UserState)list.get(i)).getTimeStamp().before(this.getTimeStamp(executeDate, endTimestampPM))) continue;
                    afternoon.add((UserState)list.get(i));
                }
                if (morning.size() == 0) {
                    if (beforeMorning && !new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, startTimestampAM))) {
                        if ("1".equals(((UserState)list.get(list.size() - 1)).getState()) && new Timestamp(systemCurrentTime).after(this.getTimeStamp(executeDate, startTimestampAM)) && new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, endTimestampAM))) {
                            morning.add(new UserState(userId, this.getTimeStamp(executeDate, startTimestampAM), "1"));
                            morning.add(new UserState(userId, new Timestamp(systemCurrentTime), "0"));
                        } else if ("1".equals(((UserState)list.get(list.size() - 1)).getState())) {
                            morning.add(new UserState(userId, this.getTimeStamp(executeDate, startTimestampAM), "1"));
                            morning.add(new UserState(userId, this.getTimeStamp(executeDate, endTimestampAM), "0"));
                        }
                    }
                } else if (morning.size() > 0) {
                    if ("0".equals(((UserState)morning.get(0)).getState())) {
                        morning.add(0, new UserState(userId, this.getTimeStamp(executeDate, startTimestampAM), "1"));
                    }
                    if ("1".equals(((UserState)morning.get(morning.size() - 1)).getState())) {
                        if (new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, endTimestampAM))) {
                            morning.add(new UserState(userId, new Timestamp(systemCurrentTime), "0"));
                        } else {
                            morning.add(new UserState(userId, this.getTimeStamp(executeDate, endTimestampAM), "0"));
                        }
                    }
                }
                if (afternoon.size() == 0) {
                    if (beforeAfternoon) {
                        if ("1".equals(((UserState)list.get(list.size() - 1)).getState()) && new Timestamp(systemCurrentTime).after(this.getTimeStamp(executeDate, startTimestampPM)) && new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, endTimestampPM))) {
                            afternoon.add(new UserState(userId, this.getTimeStamp(executeDate, startTimestampPM), "1"));
                            afternoon.add(new UserState(userId, new Timestamp(systemCurrentTime), "0"));
                        } else if (!new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, startTimestampPM)) && "1".equals(((UserState)list.get(list.size() - 1)).getState())) {
                            afternoon.add(new UserState(userId, this.getTimeStamp(executeDate, startTimestampPM), "1"));
                            afternoon.add(new UserState(userId, this.getTimeStamp(executeDate, endTimestampPM), "0"));
                        }
                    }
                } else if (afternoon.size() > 0) {
                    if ("0".equals(((UserState)afternoon.get(0)).getState())) {
                        afternoon.add(0, new UserState(userId, this.getTimeStamp(executeDate, startTimestampPM), "1"));
                    }
                    if ("1".equals(((UserState)afternoon.get(afternoon.size() - 1)).getState())) {
                        if (new Timestamp(systemCurrentTime).before(this.getTimeStamp(executeDate, endTimestampPM))) {
                            afternoon.add(new UserState(userId, new Timestamp(systemCurrentTime), "0"));
                        } else {
                            afternoon.add(new UserState(userId, this.getTimeStamp(executeDate, endTimestampPM), "0"));
                        }
                    }
                }
                this.add2UnWorkStateMap(userUnWorkStateMap, userId, morning, afternoon);
            }
            this.getUserComplJob(ctx, shareCenterId, util, userJbCompMap, curDay);
            this.getExtData(ctx, shareCenterId, util, userJbCompMap, curDay);
            this.getSatifiedTask(ctx, shareCenterId, util, userJbCompMap, curDay);
            this.getUserTask(ctx, userJbCompMap, curDay, shareCenterId);
            this.getJobTaskInfo(ctx, userJbCompMap, curDay, shareCenterId);
            this.getUserstandard(ctx, userJbCompMap, curDay, shareCenterId);
            Set set = userJbCompMap.keySet();
            for (String userId : set) {
                List userStateList = (List)userStateMap.get(userId);
                long allOnWork = 0L;
                long allUnWork = 0L;
                if (userStateList == null) continue;
                for (int i = 0; i < userStateList.size(); ++i) {
                    if (i == userStateList.size() - 1 && "1".equals(((UserState)userStateList.get(userStateList.size() - 1)).getState())) {
                        allOnWork += ((UserState)userStateList.get(i)).getTimeStamp().getTime();
                        allUnWork += systemCurrentTime;
                        continue;
                    }
                    if ("1".equals(((UserState)userStateList.get(i)).getState())) {
                        allOnWork += ((UserState)userStateList.get(i)).getTimeStamp().getTime();
                        continue;
                    }
                    allUnWork += ((UserState)userStateList.get(i)).getTimeStamp().getTime();
                }
                double allTime = (double)(allUnWork - allOnWork) / 3600000.0;
                ((UserJobComp)userJbCompMap.get(userId)).setOnWorkTime(new BigDecimal(allTime));
            }
            Set setUnWork = userUnWorkStateMap.keySet();
            for (String userId : setUnWork) {
                List userUnWorkStateList = (List)userUnWorkStateMap.get(userId);
                long allOnWork = 0L;
                long allUnWork = 0L;
                if (userUnWorkStateList == null) continue;
                for (int i = 0; i < userUnWorkStateList.size(); ++i) {
                    if (i == userUnWorkStateList.size() - 1 && "1".equals(((UserState)userUnWorkStateList.get(userUnWorkStateList.size() - 1)).getState()) && !util.isWorkTime(new Date()).booleanValue()) {
                        allOnWork += ((UserState)userUnWorkStateList.get(i)).getTimeStamp().getTime();
                        continue;
                    }
                    if ("1".equals(((UserState)userUnWorkStateList.get(i)).getState())) {
                        allOnWork += ((UserState)userUnWorkStateList.get(i)).getTimeStamp().getTime();
                        continue;
                    }
                    allUnWork += ((UserState)userUnWorkStateList.get(i)).getTimeStamp().getTime();
                }
                double unTime = (double)(allUnWork - allOnWork) / 3600000.0;
                ((UserJobComp)userJbCompMap.get(userId)).setUnWorkTime(new BigDecimal(unTime));
            }
            Set userJbCompSet = userJbCompMap.keySet();
            Iterator userJbCompIt = userJbCompSet.iterator();
            CoreBaseCollection colls = new CoreBaseCollection();
            while (userJbCompIt.hasNext()) {
                try {
                    String userId = (String)userJbCompIt.next();
                    UserJobComp comp = (UserJobComp)userJbCompMap.get(userId);
                    OnGuardTimeInfo onGuardTimeInfo = new OnGuardTimeInfo();
                    onGuardTimeInfo.setUser(UserFactory.getLocalInstance(ctx).getUserInfo(H.PK(userId)));
                    UserGroupInfo userGroupInfo = UserGroupFactory.getLocalInstance(ctx).getUserGroupInfo("where user.id='" + userId + "'");
                    if (userGroupInfo != null) {
                        onGuardTimeInfo.setGroup(userGroupInfo.getGroup());
                    }
                    onGuardTimeInfo.setStanfardSum(new BigDecimal(comp.getStanfardSum()));
                    onGuardTimeInfo.setQualityStanfard(new BigDecimal(comp.getQualityStanfard()));
                    onGuardTimeInfo.setSampleStanfard(new BigDecimal(comp.getSampleStanfard()));
                    onGuardTimeInfo.setWorkDay(comp.getWorkDay());
                    onGuardTimeInfo.setStatifiedTask(comp.getStatifiedTask());
                    onGuardTimeInfo.setUnsatifiedTask(comp.getUnsatifiedTask());
                    onGuardTimeInfo.setUnqualityTask(comp.getUnqualityTask());
                    onGuardTimeInfo.setQualityTask(comp.getQualityTask());
                    onGuardTimeInfo.setSampleTask(comp.getSampleTask());
                    onGuardTimeInfo.setCallBackTask(comp.getCallBackTask());
                    onGuardTimeInfo.setCallBackedTask(comp.getCallBackedTask());
                    onGuardTimeInfo.setPassTask(comp.getPassTask());
                    onGuardTimeInfo.setUnpassTask(comp.getUnpassTask());
                    onGuardTimeInfo.setRescanTask(comp.getRescanTask());
                    onGuardTimeInfo.setPauseTask(comp.getPauseTask());
                    onGuardTimeInfo.setShareCenterId(shareCenterId);
                    onGuardTimeInfo.setWorkHours(comp.getUnWorkTime());
                    onGuardTimeInfo.setWorkTask(comp.getJobCountOnWork());
                    onGuardTimeInfo.setOverTimeHours(comp.getOnWorkTime().subtract(comp.getUnWorkTime()));
                    onGuardTimeInfo.setOverTimeTask(comp.getJobCountUnWork());
                    onGuardTimeInfo.setDate(DateUtil.parseDate(curDay));
                    colls.add((CoreBaseInfo)onGuardTimeInfo);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            OnGuardTimeFactory.getLocalInstance(ctx).save(colls);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void getExtData(Context ctx, String shareCenterId, WorkDateUtil util, Map<String, UserJobComp> userJbCompMap, String curDay) throws Exception {
        WorkDateUtil workDateUtil = WorkDateUtil.getInstance(ctx, shareCenterId, false);
        Boolean isWorkDay = workDateUtil.isWorkDay(new Date());
        Set<Map.Entry<String, UserJobComp>> entries = userJbCompMap.entrySet();
        for (Map.Entry<String, UserJobComp> entry : entries) {
            UserJobComp userJobComp = entry.getValue();
            if (isWorkDay.booleanValue()) {
                userJobComp.setWorkDay(true);
                continue;
            }
            userJobComp.setWorkDay(false);
        }
    }

    private void getSatifiedTask(Context ctx, String shareCenterId, WorkDateUtil util, Map<String, UserJobComp> userJbCompMap, String curDay) {
        String sql = "SELECT b.FID ,a.FEVALUATERESULT   FROM T_SSC_SatisfactionBillInquire a left join  T_SSC_USER b on a.FCREATORID = b.FEASUSERID where a.FEVALUATEOFDATE >= {ts'" + curDay + "' } and a.fshareCenterId = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{shareCenterId});
            HashMap<String, Boolean> userFlag = new HashMap<String, Boolean>();
            while (rs.next()) {
                String userId = rs.getString("FID");
                String evaluateResult = rs.getString("FEVALUATERESULT");
                UserJobComp userJobComp = null;
                if (userJbCompMap.containsKey(userId)) {
                    userJobComp = userJbCompMap.get(userId);
                } else {
                    userJobComp = new UserJobComp();
                    userJobComp.setUserId(userId);
                    userJbCompMap.put(userId, userJobComp);
                }
                if (!userFlag.containsKey(userId)) {
                    userJobComp.setStatifiedTask(0);
                    userJobComp.setUnsatifiedTask(0);
                }
                userFlag.put(userId, true);
                if (("0".equals(evaluateResult) || "1".equals(evaluateResult) || "2".equals(evaluateResult)) && userJbCompMap.containsKey(userId)) {
                    userJobComp.setStatifiedTask(userJobComp.getStatifiedTask() + 1);
                }
                if (!"3".equals(evaluateResult) && !"4".equals(evaluateResult) || !userJbCompMap.containsKey(userId)) continue;
                userJobComp.setUnsatifiedTask(userJobComp.getUnsatifiedTask() + 1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void getJobTaskInfo(Context ctx, Map<String, UserJobComp> userJbCompMap, String curDay, String shareCenterId) {
        StringBuffer buf = new StringBuffer("");
        buf.append(" SELECT count(*) as sum,job.FPERSONNELIDID,ths.FNEWJOBSTATE ");
        buf.append(" FROM T_SSC_JOBHIS job inner join T_SSC_JobStaTimHis ths  ");
        buf.append(" on job.fid = ths.FJOBIDID  ");
        buf.append(" where ths.FCREATETIME > {ts'" + curDay + "'} and  fshareCenterId = ?  and FNEWJOBSTATE\t IN ('0','1','3','4','6')  ");
        buf.append("  group by ths.FNEWJOBSTATE,job.FPERSONNELIDID");
        try {
            IRowSet userJobMap = DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (Object[])new Object[]{shareCenterId});
            while (userJobMap.next()) {
                String userId = userJobMap.getString("FPERSONNELIDID");
                String jobState = userJobMap.getString("FNEWJOBSTATE");
                int sum = userJobMap.getInt("sum");
                UserJobComp userJobComp = null;
                if (userJbCompMap.containsKey(userId)) {
                    userJobComp = userJbCompMap.get(userId);
                } else {
                    userJobComp = new UserJobComp();
                    userJobComp.setUserId(userId);
                    userJbCompMap.put(userId, userJobComp);
                }
                if ("6".equals(jobState)) {
                    userJobComp.setCallBackTask(sum);
                    continue;
                }
                if ("3".equals(jobState)) {
                    userJobComp.setPassTask(sum);
                    continue;
                }
                if ("4".equals(jobState)) {
                    userJobComp.setUnpassTask(sum);
                    continue;
                }
                if ("0".equals(jobState)) {
                    userJobComp.setPauseTask(sum);
                    continue;
                }
                if (!"1".equals(jobState)) continue;
                userJobComp.setRescanTask(sum);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        StringBuffer sql = new StringBuffer("");
        sql.append(" SELECT count(*) as sum,job.FCREATORNUMBER,ths.FNEWJOBSTATE ");
        sql.append(" FROM T_SSC_JOBHIS job inner join T_SSC_JobStaTimHis ths  ");
        sql.append(" on job.fid = ths.FJOBIDID  ");
        sql.append(" where ths.FCREATETIME > {ts'" + curDay + "'} and  fshareCenterId = ?  and FNEWJOBSTATE IN ('6')  ");
        sql.append("  group by ths.FNEWJOBSTATE,job.FCREATORNUMBER");
        try {
            IRowSet userJobMap = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{shareCenterId});
            while (userJobMap.next()) {
                String createNumber = userJobMap.getString("FCREATORNUMBER");
                UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo("select id where number='" + createNumber + "'");
                String userId = userInfo.getId().toString();
                String jobState = userJobMap.getString("FNEWJOBSTATE");
                int sum = userJobMap.getInt("sum");
                UserJobComp userJobComp = null;
                if (userJbCompMap.containsKey(userId)) {
                    userJobComp = userJbCompMap.get(userId);
                } else {
                    userJobComp = new UserJobComp();
                    userJobComp.setUserId(userId);
                    userJbCompMap.put(userId, userJobComp);
                }
                if (!"6".equals(jobState)) continue;
                userJobComp.setCallBackedTask(sum);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Deprecated
    public void getJobUserTask(Context ctx, Map<String, UserJobComp> userJbCompMap, String curDay, String shareCenterId) throws BOSException {
        StringBuffer sql = new StringBuffer("");
        sql.append("  select JOB.FJOBSTATE,\n         JOB.FPERSONNELIDID,\n         EXT.FrescanTask,\n         EXT.FpauseTask\n    FROM T_SSC_JOBHIS JOB\n   INNER JOIN T_SSC_JOBHISEXT EXT\n      ON JOB.FID = EXT.FJOBID").append(" WHERE FCOMPLETETME >= {ts'" + curDay + "'} and  fshareCenterId = ?  and FJOBSTATE IN ('6','3','4')");
        try {
            IRowSet userJobMap = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{shareCenterId});
            HashMap<String, Boolean> userFlag = new HashMap<String, Boolean>();
            while (userJobMap.next()) {
                String userId = userJobMap.getString("FPERSONNELIDID");
                String jobState = userJobMap.getString("FJOBSTATE");
                int rescanTask = userJobMap.getInt("FrescanTask");
                int pauseTask = userJobMap.getInt("FpauseTask");
                UserJobComp userJobComp = null;
                if (userJbCompMap.containsKey(userId)) {
                    userJobComp = userJbCompMap.get(userId);
                } else {
                    userJobComp = new UserJobComp();
                    userJobComp.setUserId(userId);
                    userJbCompMap.put(userId, userJobComp);
                }
                if (!userFlag.containsKey(userId)) {
                    userJobComp.setCallBackTask(0);
                    userJobComp.setPassTask(0);
                    userJobComp.setUnpassTask(0);
                    userJobComp.setRescanTask(0);
                    userJobComp.setPauseTask(0);
                }
                userFlag.put(userId, true);
                if ("6".equals(jobState)) {
                    userJobComp.setCallBackTask(userJobComp.getCallBackTask() + 1);
                } else if ("3".equals(jobState)) {
                    userJobComp.setPassTask(userJobComp.getPassTask() + 1);
                } else {
                    userJobComp.setUnpassTask(userJobComp.getUnpassTask() + 1);
                }
                userJobComp.setRescanTask(userJobComp.getRescanTask() + rescanTask);
                userJobComp.setPauseTask(userJobComp.getPauseTask() + pauseTask);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void getUserstandard(Context ctx, Map<String, UserJobComp> userJbCompMap, String curDay, String shareCenterId) throws BOSException, SQLException {
        String QualitySql = "select count(1) sum ,a.FBILLTYPEID,a.fexaminerid ,b.fchecktype ,e.fstandardcoefficient from T_SSC_SampleLibraryQualityTask a left join T_SSC_SampleLibrary b on a.FPARENTID = b.fid  left join T_SSC_CheckScheme c on b.FCHECKSCHEMEID = c.fid left join T_SSC_BillType d on a.FBILLTYPEID = d.FID   LEFT join T_SSC_BillTypeExt e on e.FBILLTYPEID  = d.FID   where 1=1  and a.FCOMPLETEDATE  is not null  and a.FALLOTDATE >= {ts'" + curDay + "' } and a.FCOMPLETEDATE  is not null and  e.FSHARECENTERID = ? GROUP BY a.FEXAMINERID,b.fcheckType,a.fcheckresult,a.FBILLTYPEID,e.FSTANDARDCOEFFICIENT";
        IRowSet QualityRS = DbUtil.executeQuery((Context)ctx, (String)QualitySql, (Object[])new Object[]{shareCenterId});
        HashMap<String, Integer> userTaskMap = new HashMap<String, Integer>();
        while (QualityRS.next()) {
            String userId = QualityRS.getString("fexaminerid");
            int sum = QualityRS.getInt("sum");
            int checkType = QualityRS.getInt("fcheckType");
            String standardcoefficient = QualityRS.getString("fstandardcoefficient");
            if (userTaskMap.containsKey(userId + "-" + checkType)) {
                userTaskMap.put(userId + "-" + checkType, (Integer)userTaskMap.get(userId + "-" + checkType) + sum * Integer.valueOf(standardcoefficient));
            } else {
                userTaskMap.put(userId + "-" + checkType, sum * Integer.valueOf(standardcoefficient));
            }
            UserJobComp userJobComp = null;
            if (!userJbCompMap.containsKey(userId)) continue;
            userJobComp = userJbCompMap.get(userId);
            if (20 == checkType) {
                userJobComp.setQualityStanfard((Integer)userTaskMap.get(userId + "-" + checkType));
                continue;
            }
            userJobComp.setSampleStanfard((Integer)userTaskMap.get(userId + "-" + checkType));
        }
    }

    private void getUserTask(Context ctx, Map<String, UserJobComp> userJbCompMap, String curDay, String shareCenterId) throws BOSException, SQLException {
        String QualitySql = "select count(1) sum ,a.fexaminerid ,b.fchecktype ,a.fcheckresult from T_SSC_SampleLibraryQualityTask a left join T_SSC_SampleLibrary b on a.FPARENTID = b.fid  left join T_SSC_CheckScheme c on b.FCHECKSCHEMEID = c.fid  where 1=1  and a.FCOMPLETEDATE  is not null  and b.FCloseLibraryTime >= {ts'" + curDay + "' } and  c.FSHARECENTERID = ? GROUP BY a.FEXAMINERID,b.fcheckType,a.fcheckresult";
        IRowSet QualityRS = DbUtil.executeQuery((Context)ctx, (String)QualitySql, (Object[])new Object[]{shareCenterId});
        HashMap map = new HashMap();
        while (QualityRS.next()) {
            String userId = QualityRS.getString("fexaminerid");
            int sum = QualityRS.getInt("sum");
            int checkType = QualityRS.getInt("fcheckType");
            String checkresult = QualityRS.getString("fcheckresult");
            UserJobComp userJobComp = null;
            if (userJbCompMap.containsKey(userId)) {
                userJobComp = userJbCompMap.get(userId);
            } else {
                userJobComp = new UserJobComp();
                userJobComp.setUserId(userId);
                userJobComp.setQualityTask(0);
                userJobComp.setSampleTask(0);
                userJbCompMap.put(userId, userJobComp);
            }
            if (20 == checkType) {
                userJobComp.setQualityTask(userJobComp.getQualityTask() + sum);
                if (!"0".equals(checkresult)) continue;
                userJobComp.setUnqualityTask(userJobComp.getUnqualityTask() + sum);
                continue;
            }
            userJobComp.setSampleTask(userJobComp.getSampleTask() + sum);
        }
    }

    private void getUserComplJob(Context ctx, String shareCenterId, WorkDateUtil util, Map<String, UserJobComp> userJbCompMap, String curDay) throws BOSException, SQLException {
        String jobSQL = " SELECT FID,FPERSONNELIDID,FCOMPLETETME,FSTANDARDCOE FROM t_ssc_jobhis where FCOMPLETETME > {ts'" + curDay + "'} and fshareCenterId = ? AND FAutoApprove=0  order by FPERSONNELIDID desc ";
        IRowSet jobRS = DbUtil.executeQuery((Context)ctx, (String)jobSQL, (Object[])new Object[]{shareCenterId});
        while (jobRS.next()) {
            UserJobComp userJobComp;
            String userId = jobRS.getString("FPERSONNELIDID");
            Timestamp completetime = jobRS.getTimestamp("FCOMPLETETME");
            int standardcode = jobRS.getInt("FSTANDARDCOE");
            if (userJbCompMap.containsKey(userId)) {
                userJobComp = userJbCompMap.get(userId);
                if (util.isWorkTime(completetime).booleanValue()) {
                    userJobComp.addOnWorkCount();
                } else {
                    userJobComp.addUnWorkCount();
                }
                userJobComp.setStanfardSum(userJobComp.getStanfardSum() + standardcode);
                continue;
            }
            userJobComp = new UserJobComp();
            userJobComp.setUserId(userId);
            if (util.isWorkTime(completetime).booleanValue()) {
                userJobComp.addOnWorkCount();
            } else {
                userJobComp.addUnWorkCount();
            }
            userJobComp.setStanfardSum(userJobComp.getStanfardSum() + standardcode);
        }
    }

    private void addUserJobComp(Map<String, UserJobComp> userJbCompMap, String userId) {
        UserJobComp userJobComp = new UserJobComp();
        userJobComp.setUserId(userId);
        userJbCompMap.put(userId, userJobComp);
    }

    private void add2UnWorkStateMap(Map<String, List<UserState>> userUnWorkStateMap, String userId, List<UserState> morning, List<UserState> afternoon) {
        ArrayList<UserState> userUnWorkStateList = new ArrayList<UserState>();
        userUnWorkStateList.addAll(morning);
        userUnWorkStateList.addAll(afternoon);
        userUnWorkStateMap.put(userId, userUnWorkStateList);
    }

    private Timestamp getTimeStamp(Date date, TimeIgnoretDate tgDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, tgDate.getHour());
        calendar.set(12, tgDate.getMinute());
        calendar.set(13, tgDate.getSecond());
        return new Timestamp(calendar.getTime().getTime());
    }

    private class UserJobComp {
        private String userId;
        private int jobCountOnWork = 0;
        private int jobCountUnWork = 0;
        private int stanfardSum = 0;
        private int qualityTask = 0;
        private int sampleTask = 0;
        private int callBackTask = 0;
        private int callBackedTask = 0;
        private int passTask = 0;
        private int unpassTask = 0;
        private int unqualityTask = 0;
        private int unsatifiedTask = 0;
        private int statifiedTask = 0;
        private Boolean workDay = false;
        private int pauseTask = 0;
        private int rescanTask = 0;
        private BigDecimal onWorkTime = BigDecimal.ZERO;
        private BigDecimal unWorkTime = BigDecimal.ZERO;
        private int qualityStanfard = 0;
        private int sampleStanfard = 0;

        private UserJobComp() {
        }

        public void addOnWorkCount() {
            ++this.jobCountOnWork;
        }

        public void addUnWorkCount() {
            ++this.jobCountUnWork;
        }

        public void setJobCountOnWork(int jobCountOnWork) {
            this.jobCountOnWork = jobCountOnWork;
        }

        public void setJobCountUnWork(int jobCountUnWork) {
            this.jobCountUnWork = jobCountUnWork;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public BigDecimal getOnWorkTime() {
            return this.onWorkTime;
        }

        public void setOnWorkTime(BigDecimal onWorkTime) {
            this.onWorkTime = onWorkTime;
        }

        public BigDecimal getUnWorkTime() {
            return this.unWorkTime;
        }

        public void setUnWorkTime(BigDecimal unWorkTime) {
            this.unWorkTime = unWorkTime;
        }

        public int getJobCountOnWork() {
            return this.jobCountOnWork;
        }

        public int getJobCountUnWork() {
            return this.jobCountUnWork;
        }

        public Boolean getWorkDay() {
            return this.workDay;
        }

        public int getQualityTask() {
            return this.qualityTask;
        }

        public int getSampleTask() {
            return this.sampleTask;
        }

        public int getCallBackTask() {
            return this.callBackTask;
        }

        public int getPassTask() {
            return this.passTask;
        }

        public int getUnpassTask() {
            return this.unpassTask;
        }

        public int getUnqualityTask() {
            return this.unqualityTask;
        }

        public int getUnsatifiedTask() {
            return this.unsatifiedTask;
        }

        public int getStatifiedTask() {
            return this.statifiedTask;
        }

        public int getPauseTask() {
            return this.pauseTask;
        }

        public int getRescanTask() {
            return this.rescanTask;
        }

        public void setStanfardSum(int stanfardSum) {
            this.stanfardSum = stanfardSum;
        }

        public int getStanfardSum() {
            return this.stanfardSum;
        }

        public void setQualityTask(int qualityTask) {
            this.qualityTask = qualityTask;
        }

        public void setSampleTask(int sampleTask) {
            this.sampleTask = sampleTask;
        }

        public void setCallBackTask(int callBackTask) {
            this.callBackTask = callBackTask;
        }

        public void setPassTask(int passTask) {
            this.passTask = passTask;
        }

        public void setUnpassTask(int unpassTask) {
            this.unpassTask = unpassTask;
        }

        public void setUnqualityTask(int unqualityTask) {
            this.unqualityTask = unqualityTask;
        }

        public void setUnsatifiedTask(int unsatifiedTask) {
            this.unsatifiedTask = unsatifiedTask;
        }

        public void setStatifiedTask(int statifiedTask) {
            this.statifiedTask = statifiedTask;
        }

        public void setWorkDay(Boolean workDay) {
            this.workDay = workDay;
        }

        public void setPauseTask(int pauseTask) {
            this.pauseTask = pauseTask;
        }

        public void setRescanTask(int rescanTask) {
            this.rescanTask = rescanTask;
        }

        public int getCallBackedTask() {
            return this.callBackedTask;
        }

        public void setCallBackedTask(int callBackedTask) {
            this.callBackedTask = callBackedTask;
        }

        public int getQualityStanfard() {
            return this.qualityStanfard;
        }

        public void setQualityStanfard(int qualityStanfard) {
            this.qualityStanfard = qualityStanfard;
        }

        public int getSampleStanfard() {
            return this.sampleStanfard;
        }

        public void setSampleStanfard(int sampleStanfard) {
            this.sampleStanfard = sampleStanfard;
        }
    }

    private class UserState {
        private String userId;
        private Timestamp timeStamp;
        private String state;

        public UserState() {
        }

        public UserState(String userId, Timestamp timeStamp, String state) {
            this.userId = userId;
            this.timeStamp = timeStamp;
            this.state = state;
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public Timestamp getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(Timestamp timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }
}

