/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.report;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.SscReportConfigCollection;
import com.kingdee.eas.base.ssc.SscReportConfigFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WPQuantityStatisticalProcess {
    private static Logger logger = Logger.getLogger(WPQuantityStatisticalProcess.class);
    private static Map<String, String> billTypeEntry = new HashMap<String, String>();
    private static Map<String, String> dblinkMap = new HashMap<String, String>();
    public static String DPLOY_TYPE_UNION = "0";
    public static String DPLOY_TYPE_INDEPENDENT = "1";

    public boolean execute(Context ctx) throws EASBizException, BOSException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(" SELECT distinct bt.FID fid,bt.FName_l2 billtypeName,btc.fNumber FBILLSOURCE,ed.FID  EXTENDERPId,ed.Fnumber number,ed.FIMPLECLASS FIMPLECLASS ,cf.FDEPLOYTYPE FDEPLOYTYPE  FROM T_SSC_JOBHIS his inner join T_SSC_BUSSINESSATTRIBUTE ba on his.FBUSSATTRIDID =ba.fid ");
        sBuffer.append(" inner join T_SSC_BILLTYPE bt on ba.FBILLTYPEID =bt.fid  ");
        sBuffer.append(" inner join T_SSC_BILLTYPEcfg btc on bt.FBILLSOURCEidid = btc.fid ");
        sBuffer.append(" inner join T_SSC_SYSTEMATTRIBUTE st on bt.FSYSATTRID  = st.fid ");
        sBuffer.append(" inner join T_SSC_EXTENDERP ed on st.FEXTENDERPID = ed.fid ");
        sBuffer.append(" inner join T_SSC_EXTENDERPcfg cf on ed.FID =cf.fextenderpid ");
        sBuffer.append(" union ");
        sBuffer.append(" SELECT distinct bt.FID fid,bt.FName_l2 billtypeName,btc.fNumber FBILLSOURCE,ed.FID  EXTENDERPId,ed.Fnumber number,ed.FIMPLECLASS FIMPLECLASS,cf.FDEPLOYTYPE FDEPLOYTYPE FROM T_SSC_JOB his inner join T_SSC_BUSSINESSATTRIBUTE ba on his.FBUSSATTRIDID =ba.fid ");
        sBuffer.append(" inner join T_SSC_BILLTYPE bt on ba.FBILLTYPEID =bt.fid ");
        sBuffer.append(" inner join T_SSC_BILLTYPEcfg btc on bt.FBILLSOURCEidid = btc.fid ");
        sBuffer.append(" inner join T_SSC_SYSTEMATTRIBUTE st on bt.FSYSATTRID  = st.fid ");
        sBuffer.append(" inner join T_SSC_EXTENDERP ed on st.FEXTENDERPID = ed.fid ");
        sBuffer.append(" inner join T_SSC_EXTENDERPcfg cf on ed.FID =cf.fextenderpid ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sBuffer.toString());
            ArrayList billTypeList = new ArrayList();
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String billTypeId = rs.getString("fid");
                String billtypeName = rs.getString("billtypeName");
                String fbillsource = rs.getString("FBILLSOURCE");
                String billEntry = "";
                try {
                    billEntry = this.getBillTypeEntry(ctx, fbillsource);
                }
                catch (Exception e) {
                    logger.error((Object)(e.getMessage() + "get BillTypeEntry error "));
                    continue;
                }
                String fimpleclass = rs.getString("FIMPLECLASS");
                String extenderpid = rs.getString("EXTENDERPId");
                String number = rs.getString("number");
                String fdeploytype = rs.getInt("FDEPLOYTYPE") + "";
                map.put("billTypeId", billTypeId);
                map.put("billtypeName", billtypeName);
                map.put("fbillsource", fbillsource);
                map.put("billEntry", billEntry);
                map.put("fimpleclass", fimpleclass);
                map.put("extenderpid", extenderpid);
                map.put("number", number);
                map.put("fdeploytype", fdeploytype);
                billTypeList.add(map);
            }
            int maxLevel = this.getJobPoolMaxLevel(ctx);
            List<String> shareCenterList = this.getShareCenterList(ctx);
            for (int i = 0; i < billTypeList.size(); ++i) {
                try {
                    for (int j = 0; j < shareCenterList.size(); ++j) {
                        String shareCenterId = shareCenterList.get(j);
                        Map map = (Map)billTypeList.get(i);
                        String deploytype = (String)map.get("fdeploytype");
                        String billTypeId = (String)map.get("billTypeId");
                        String billtypeName = (String)map.get("billtypeName");
                        int willComing = 0;
                        int beingImage1 = 0;
                        int beingImage2 = 0;
                        int bussiness = 0;
                        if (deploytype.toString().equalsIgnoreCase(DPLOY_TYPE_UNION)) {
                            willComing = this.getForthcoming(ctx, (String)map.get("billEntry"), "", shareCenterId);
                            beingImage1 = this.getImageingUn2SSC(ctx, (String)map.get("billEntry"), "", shareCenterId);
                            beingImage2 = this.getImageingHas2SSC(ctx, (String)map.get("billEntry"), "", shareCenterId);
                            bussiness = willComing - beingImage1;
                        } else {
                            String dblink = "";
                            try {
                                dblink = this.getERPDblink(ctx, (String)map.get("number"));
                            }
                            catch (Exception e) {
                                logger.error((Object)(e.getMessage() + "get ERPDblink error "));
                                continue;
                            }
                            willComing = this.getForthcoming(ctx, (String)map.get("billEntry"), dblink, shareCenterId);
                            beingImage1 = this.getImageingUn2SSC(ctx, (String)map.get("billEntry"), dblink, shareCenterId);
                            beingImage2 = this.getImageingHas2SSC(ctx, (String)map.get("billEntry"), dblink, shareCenterId);
                            bussiness = willComing - beingImage1;
                        }
                        List<Integer> list = this.getBillJobPoolCount(ctx, billTypeId, maxLevel, shareCenterId);
                        this.insert2Table(ctx, billTypeId, billtypeName, bussiness, beingImage1 + beingImage2, list, maxLevel, shareCenterId);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return false;
    }

    private List<String> getShareCenterList(Context ctx) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer s = new StringBuffer();
        s.append(" select distinct fshareCenterId from t_ssc_job union  select distinct fshareCenterId from t_ssc_jobhis");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)s.toString());
        while (rs.next()) {
            String shareCenterId = rs.getString("fshareCenterId");
            if (StringUtils.isEmpty((String)shareCenterId)) continue;
            list.add(shareCenterId);
        }
        return list;
    }

    private void insert2Table(Context ctx, String billTypeId, String billTypeName, int bussiness, int beingImage, List<Integer> list, int maxLevel, String shareCenterId) throws BOSException {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(" INSERT INTO T_SSC_NumStatisticalProcess (");
        sBuffer.append("fshareCenterId,FBillTypeId,FBillTypeName,FBussApprove,FImageUpload,fcreatetime,");
        sBuffer.append(this.getInsertFiledKey(maxLevel));
        sBuffer.append("FSscPause, FSscRescan, FID) VALUES (");
        sBuffer.append("'" + shareCenterId + "',");
        sBuffer.append("'" + billTypeId + "',");
        sBuffer.append("'" + billTypeName + "',");
        sBuffer.append(bussiness + ",");
        sBuffer.append(beingImage + ",");
        sBuffer.append("{ts'" + this.getToDayString() + "'},");
        sBuffer.append(this.getInsertFiledValue(list));
        sBuffer.append(" newbosid('0432D5EA') ) ");
        logger.error((Object)sBuffer.toString());
        DbUtil.execute((Context)ctx, (String)sBuffer.toString());
    }

    private String getToDayString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }

    private String getInsertFiledValue(List<Integer> list) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 1; i <= list.size(); ++i) {
            sBuffer.append(list.get(i - 1) + ",");
        }
        return sBuffer.toString();
    }

    private String getInsertFiledKey(int maxLevel) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 1; i <= maxLevel; ++i) {
            sBuffer.append(" FSscToAssign" + i + ", ");
            sBuffer.append(" FSscApprove" + i + ", ");
        }
        return sBuffer.toString();
    }

    private int getJobPoolMaxLevel(Context ctx) throws Exception {
        String maxLevelSql = "select max(flevel) maxLevel from t_ssc_job";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)maxLevelSql);
        if (rs.next()) {
            return rs.getInt(1);
        }
        throw new EASBizException(new NumericExceptionSubItem("1", "get SSC jobPool maxLevel error"));
    }

    private List<Integer> getBillJobPoolCount(Context ctx, String billType, int maxLevel, String shareCenter) throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(" SELECT  ");
        sBuffer.append(this.getRoundCount(maxLevel));
        sBuffer.append(" count(case when job.FJOBSTATE ='0' and job.FJOBPOOLINGTYPE ='2' then 0 end) apuse, ");
        sBuffer.append(" count(case when job.FJOBSTATE ='1' and job.FJOBPOOLINGTYPE ='2' then 0 end) rescan ");
        sBuffer.append(" FROM T_SSC_JOB job inner join T_SSC_BUSSINESSATTRIBUTE buss on job.FBUSSATTRIDID =buss.fid ");
        sBuffer.append(" inner join T_SSC_BILLTYPE bill on buss.FBILLTYPEID =bill.fid ");
        sBuffer.append(" where job.fshareCenterId = '" + shareCenter + "'");
        sBuffer.append(" and bill.FID = ?  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sBuffer.toString(), (Object[])new Object[]{billType});
        if (rs.next()) {
            for (int i = 1; i <= maxLevel; ++i) {
                list.add(rs.getInt(2 * i - 1));
                list.add(rs.getInt(2 * i));
            }
            list.add(rs.getInt("apuse"));
            list.add(rs.getInt("rescan"));
        }
        return list;
    }

    private String getRoundCount(int muxLevel) {
        StringBuffer sBuffer = new StringBuffer();
        for (int i = 1; i <= muxLevel; ++i) {
            sBuffer.append(" count(case when job.FJOBPOOLINGTYPE ='1' and job.FLEVEL =" + i + " then 0 end) toAssign" + i + ", ");
            sBuffer.append(" count(case when job.FJOBPOOLINGTYPE ='2' and job.FLEVEL =" + i + " then 0 end) approve" + i + ", ");
        }
        return sBuffer.toString();
    }

    private String getERPDblink(Context ctx, String number) throws BOSException {
        SscReportConfigCollection cfg;
        if (dblinkMap != null && dblinkMap.size() == 0 && (cfg = SscReportConfigFactory.getLocalInstance(ctx).getSscReportConfigCollection(" where keyName like %DBLINK%")) != null && cfg.size() > 0) {
            for (int i = 0; i < cfg.size(); ++i) {
                if (cfg.get(i).getValue().startsWith("@")) {
                    dblinkMap.put(cfg.get(i).getNumber(), cfg.get(i).getValue());
                    continue;
                }
                dblinkMap.put(cfg.get(i).getNumber(), "@" + cfg.get(i).getValue().trim());
            }
        }
        return dblinkMap.get(number);
    }

    private int getImageingUn2SSC(Context ctx, String entry, String dblink, String shareCenter) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("  ");
        sBuffer.append(" SELECT count(1) ");
        sBuffer.append("   FROM (SELECT distinct FPROCINSTID ");
        sBuffer.append("           FROM (SELECT FPROCINSTID, FPROCDEFID ");
        sBuffer.append("                   FROM T_WFR_ASSIGN" + dblink + "  where FBILLENTITY = ? ");
        sBuffer.append("                 UNION all ");
        sBuffer.append("                 SELECT FPROCINSTID, FPROCDEFID ");
        sBuffer.append("                   FROM T_WFR_ASSIGNDETAIL" + dblink + "  where FBILLENTITY = ?) TEMP ");
        sBuffer.append("          WHERE FPROCDEFID in ");
        sBuffer.append("                (select a.fProcDefid ");
        sBuffer.append("                   from T_WFR_Assign" + dblink + " a, t_ssc_job j ");
        sBuffer.append("                  where a.FASSIGNID = j.fassignid  and a.FBILLENTITY = ? and j.fshareCenterId='" + shareCenter + "'");
        sBuffer.append("                 union all ");
        sBuffer.append("                select a.fProcDefid ");
        sBuffer.append("                  from T_WFR_Assigndetail" + dblink + " a, t_ssc_jobhis j ");
        sBuffer.append("                  where a.FASSIGNID = j.fassignid and a.FBILLENTITY = ? and j.fshareCenterId = '" + shareCenter + "')) t ");
        sBuffer.append("  where FPROCINSTID not in (SELECT FPROCLNSTID ");
        sBuffer.append("                              FROM t_ssc_job where fshareCenterId = '" + shareCenter + "'");
        sBuffer.append("                            union all ");
        sBuffer.append("                            SELECT FPROCLNSTID ");
        sBuffer.append("                              FROM t_ssc_jobhis where fshareCenterId = '" + shareCenter + "') ");
        sBuffer.append("    and FPROCINSTID in ");
        sBuffer.append("        (SELECT FPROCINSTID ");
        sBuffer.append("           FROM T_WFR_Assign" + dblink + " ");
        sBuffer.append("          WHERE FBIZFUNCTION = 'WsscCommonFunction' ");
        sBuffer.append("            AND FBIZOPERATION = 'afterImageReadyHandler' and FBILLENTITY =? ) ");
        int forthcoming = 0;
        try {
            logger.info((Object)(sBuffer.toString() + "--entry:" + entry));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sBuffer.toString(), (Object[])new Object[]{entry, entry, entry, entry, entry});
            if (rs.next()) {
                forthcoming = rs.getInt(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return forthcoming;
    }

    private int getImageingHas2SSC(Context ctx, String entry, String dblink, String shareCenter) {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("  ");
        sBuffer.append(" SELECT count(1) ");
        sBuffer.append("   FROM (SELECT distinct FPROCINSTID ");
        sBuffer.append("           FROM (SELECT FPROCINSTID, FPROCDEFID ");
        sBuffer.append("                   FROM T_WFR_ASSIGN" + dblink + "  where FBILLENTITY =?  ");
        sBuffer.append("                 UNION all ");
        sBuffer.append("                 SELECT FPROCINSTID, FPROCDEFID ");
        sBuffer.append("                   FROM T_WFR_ASSIGNDETAIL" + dblink + " where FBILLENTITY =? ) TEMP ");
        sBuffer.append("          WHERE FPROCDEFID in ");
        sBuffer.append("                (select a.fProcDefid ");
        sBuffer.append("                   from T_WFR_Assign" + dblink + " a, t_ssc_job j ");
        sBuffer.append("                  where a.FASSIGNID = j.fassignid  and  a.FBILLENTITY =? and j.fshareCenterId = '" + shareCenter + "'");
        sBuffer.append("                 union all ");
        sBuffer.append("                 select a.fProcDefid ");
        sBuffer.append("                   from T_WFR_Assigndetail" + dblink + " a, t_ssc_jobhis j ");
        sBuffer.append("                  where a.FASSIGNID = j.fassignid and  a.FBILLENTITY =? and j.fshareCenterId = '" + shareCenter + "')) t ");
        sBuffer.append("  where FPROCINSTID in (SELECT FPROCLNSTID FROM t_ssc_jobhis where fshareCenterId = '" + shareCenter + "') ");
        sBuffer.append("    and FPROCINSTID in ");
        sBuffer.append("        (SELECT FPROCINSTID ");
        sBuffer.append("           FROM T_WFR_Assign" + dblink + " ");
        sBuffer.append("          WHERE FBIZFUNCTION = 'WsscCommonFunction' ");
        sBuffer.append("            AND FBIZOPERATION = 'afterImageReadyHandler') ");
        int forthcoming = 0;
        try {
            logger.info((Object)(sBuffer.toString() + "--entry:" + entry));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sBuffer.toString(), (Object[])new Object[]{entry, entry, entry, entry});
            if (rs.next()) {
                forthcoming = rs.getInt(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return forthcoming;
    }

    private String getBillTypeEntry(Context ctx, String fbillsource) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append(" SELECT top 1 his.FBILLID  FROM T_SSC_JOBHIS his inner join T_SSC_BUSSINESSATTRIBUTE bus on his.FBUSSATTRIDID =bus.fid ");
        buf.append(" inner join T_SSC_BILLTYPE bill on bus.FBILLTYPEID = bill.FID");
        buf.append(" inner join T_SSC_BILLTYPEcfg btc on bill.FBILLSOURCEIDID = btc.FID where btc.FNUMBER = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString(), (Object[])new Object[]{fbillsource});
        if (rs.next()) {
            String billID = rs.getString("FBILLID");
            String className = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(BOSUuid.read((String)billID).getType()).getRealFullName();
            billTypeEntry.put(fbillsource, className);
        }
        return billTypeEntry.get(fbillsource);
    }

    private int getForthcoming(Context ctx, String entry, String dblink, String shareCenter) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT count(1) FROM (");
        sb.append(" SELECT distinct FPROCINSTID FROM (");
        sb.append(" SELECT FPROCINSTID,FPROCDEFID FROM T_WFR_ASSIGN" + dblink + "  where FBILLENTITY =? ");
        sb.append(" UNION all ");
        sb.append(" SELECT FPROCINSTID,FPROCDEFID FROM T_WFR_ASSIGNDETAIL" + dblink + "  where FBILLENTITY =? ");
        sb.append(" ) TEMP");
        sb.append(" WHERE FPROCDEFID in(");
        sb.append(" select a.fProcDefid from T_WFR_Assign" + dblink + " a,t_ssc_job j");
        sb.append(" where a.FASSIGNID = j.fassignid  and a.FBILLENTITY =? and j.fshareCenterId ='" + shareCenter + "' ");
        sb.append(" union all ");
        sb.append(" select a.fProcDefid from T_WFR_Assigndetail" + dblink + " a,t_ssc_jobhis j");
        sb.append(" where a.FASSIGNID = j.fassignid and a.FBILLENTITY =? and j.fshareCenterId ='" + shareCenter + "' ");
        sb.append(" )");
        sb.append(" ) t");
        sb.append(" where FPROCINSTID not in(");
        sb.append(" SELECT FPROCLNSTID FROM t_ssc_job where fshareCenterId = '" + shareCenter + "'");
        sb.append(" union all ");
        sb.append(" SELECT FPROCLNSTID FROM t_ssc_jobhis  where fshareCenterId = '" + shareCenter + "'");
        sb.append(" )");
        int forthcoming = 0;
        try {
            logger.info((Object)(sb.toString() + "--entry:" + entry));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{entry, entry, entry, entry});
            if (rs.next()) {
                forthcoming = rs.getInt(1);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return forthcoming;
    }
}

