/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.aopTool;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.SystemPropertyUtils;

public class AopManager {
    public static String ASPECT = "org.aspectj.lang.annotation.Aspect";
    public static String POINTCUT = "org.aspectj.lang.annotation.Pointcut";
    public static String BEFORE = "org.aspectj.lang.annotation.Before";
    public static String AFTER = "org.aspectj.lang.annotation.After";
    public static String AFTERRETURNING = "org.aspectj.lang.annotation.AfterReturning";
    public static volatile Map<String, String> pointCutValue = new LinkedHashMap<String, String>();
    public static Map<String, LinkedHashMap<Method, String>> pointCutMethod = new LinkedHashMap<String, LinkedHashMap<Method, String>>();
    public static Map<String, Object> pointCutObject = new HashMap<String, Object>();

    public static void reloadAnnotion(String basePackage) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        try {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage)) + "/*.class";
            Resource[] resources = resourcePatternResolver.getResources(packageSearchPath);
            for (int i = 0; i < resources.length; ++i) {
                MetadataReader metadataReader;
                Resource resource = resources[i];
                if (!resource.isReadable() || !(metadataReader = metadataReaderFactory.getMetadataReader(resource)).getAnnotationMetadata().getAnnotationTypes().contains(ASPECT)) continue;
                AnnotationMetadata metaReader = metadataReader.getAnnotationMetadata();
                String classname = metaReader.getClassName();
                Class<?> forName = Class.forName(classname);
                Object pointObject = forName.newInstance();
                Class<?> readerClass = metaReader.getClass();
                Field field = readerClass.getDeclaredField("methodMetadataSet");
                ReflectionUtils.makeAccessible((Field)field);
                LinkedHashSet param = (LinkedHashSet)field.get(metaReader);
                for (Object o : param) {
                    AopManager.processMethod(o, classname, pointObject);
                }
                boolean bl = false;
            }
        }
        catch (Exception ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
    }

    private static void processMethod(Object o, String className, Object pointObject) throws Exception {
        Class<?> aClass = o.getClass();
        Field name = aClass.getDeclaredField("name");
        Field attributeMap = aClass.getDeclaredField("attributeMap");
        String methodName = (String)name.get(o);
        LinkedHashMap annotions = (LinkedHashMap)attributeMap.get(o);
        if (annotions.containsKey(POINTCUT)) {
            String execut = (String)((Map)annotions.get(POINTCUT)).get("value");
            int begin = execut.indexOf("execution(");
            int end = execut.lastIndexOf(")");
            pointCutValue.put(className + "." + methodName, execut.substring(begin + 10, end));
            pointCutObject.put(className + "." + methodName, pointObject);
        } else if (annotions.containsKey(BEFORE)) {
            String ponit = (String)((Map)annotions.get(BEFORE)).get("value");
            ponit = ponit.substring(0, ponit.length() - 2);
            String key = className + "." + ponit;
            if (pointCutValue.containsKey(key)) {
                if (pointCutMethod.containsKey(key)) {
                    Map maps = pointCutMethod.get(key);
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class);
                    maps.put(method, BEFORE);
                } else {
                    LinkedHashMap<Method, String> map = new LinkedHashMap<Method, String>();
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class);
                    map.put(method, BEFORE);
                    pointCutMethod.put(key, map);
                }
            }
        } else if (annotions.containsKey(AFTER)) {
            String ponit = (String)((Map)annotions.get(AFTER)).get("value");
            ponit = ponit.substring(0, ponit.length() - 2);
            String key = className + "." + ponit;
            if (pointCutValue.containsKey(key)) {
                if (pointCutMethod.containsKey(key)) {
                    Map maps = pointCutMethod.get(key);
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class);
                    maps.put(method, AFTER);
                } else {
                    LinkedHashMap<Method, String> map = new LinkedHashMap<Method, String>();
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class);
                    map.put(method, AFTER);
                    pointCutMethod.put(key, map);
                }
            }
        } else if (annotions.containsKey(AFTERRETURNING)) {
            String ponit = (String)((Map)annotions.get(AFTERRETURNING)).get("value");
            ponit = ponit.substring(0, ponit.length() - 2);
            String key = className + "." + ponit;
            if (pointCutValue.containsKey(key)) {
                if (pointCutMethod.containsKey(key)) {
                    Map maps = pointCutMethod.get(key);
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class, Object.class);
                    maps.put(method, AFTERRETURNING);
                } else {
                    LinkedHashMap<Method, String> map = new LinkedHashMap<Method, String>();
                    Method method = pointObject.getClass().getDeclaredMethod(methodName, JoinPoint.class, Object.class);
                    map.put(method, AFTERRETURNING);
                    pointCutMethod.put(key, map);
                }
            }
        }
    }
}

