/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.checkpointext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CheckPointLogUtils {
    private static Logger logger = Logger.getLogger(CheckPointLogUtils.class);
    private static volatile ExecutorService executorService = null;

    private static synchronized void getPool(Context ctx) {
        if (executorService == null) {
            ThreadPoolProperties properties;
            String applicationName = "\u5171\u4eab\u68c0\u67e5\u70b9";
            String threadPoolName = ctx.getAIS() + "\u68c0\u67e5\u70b9\u6267\u884c\u8fc7\u7a0b\u8bb0\u5f55";
            DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
            DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
            if (!dynamicThreadPoolProperties.exists(properties = new ThreadPoolBuilder().ctx(ctx).applicationName(applicationName).threadPoolName(threadPoolName).corePoolSize(2).maximumPoolSize(5).queueCapacity(200).keepAliveTime(Long.valueOf(0L)).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties())) {
                dynamicThreadPoolProperties.getExecutors().add(properties);
            }
            manager.createThreadPoolExecutor(dynamicThreadPoolProperties);
            executorService = manager.getThreadPoolExecutor(applicationName, threadPoolName);
        }
    }

    public static void executeLogRecord(Context ctx, String jobid, String data, String methodName) {
        if (executorService == null) {
            CheckPointLogUtils.getPool(ctx);
        }
        executorService.execute(new CheckpointProcessRecodeThread(ctx, jobid, data, methodName));
    }

    static class CheckpointProcessRecodeThread
    extends Thread {
        private Context ctx;
        private String jobid;
        private String data;
        private String methodName;

        public CheckpointProcessRecodeThread(Context ctx, String jobid, String data, String methodName) {
            this.ctx = ctx;
            this.jobid = jobid;
            this.data = data;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            String sql = "INSERT INTO T_SSC_IntelligentExecuteRecord( Fjobid,FData,FmethodName,FCreateTime) VALUES (?,?,?,? )";
            try {
                DbUtil.execute((Context)this.ctx, (String)sql, (Object[])new Object[]{this.jobid, this.data, this.methodName, new Timestamp(new Date().getTime())});
            }
            catch (BOSException e) {
                logger.error((Object)("insert execute record fail![jobid:" + this.jobid + ",data:" + this.data + ",methodNamae:" + this.methodName + "]"));
            }
        }
    }
}

