/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.checkpointext;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryCollection;
import com.kingdee.eas.base.ssc.IntelligentAuditExecuteRuleEntryInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointDataSetInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.CheckpointEntryFilterInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryCollection;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgFieldEntryInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.IntelligentDataShowCfgInfo;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.CompareManager;
import com.kingdee.eas.base.ssc.app.checkpointext.compare.function.CustomerFunction;
import com.kingdee.eas.base.ssc.tool.SSCCompareUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.CheckPointUtils;
import com.kingdee.eas.base.ssc.tool.checkpointext.EntityAdapter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSetUtils {
    public static Map<String, String> getAssociativeAliasNameByTableName(Context ctx, CheckpointDataSetInfo info) throws EASBizException {
        String[] entitys;
        HashMap<String, String> associativeTableName = new HashMap<String, String>();
        String associativeEntity = info.getAssociativeentity();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)associativeEntity)) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u5173\u8054\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        for (String entity : entitys = associativeEntity.split(",")) {
            String[] s = entity.split(" ");
            String value = s[0].substring(0, s[0].lastIndexOf("."));
            if (entity.contains(".entity")) {
                EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(value));
                associativeTableName.put(objectInfo.getTable().getName(), s[1]);
                continue;
            }
            if (entity.contains(".table")) {
                associativeTableName.put(value, s[1]);
                continue;
            }
            if (!entity.contains(".query")) continue;
        }
        return associativeTableName;
    }

    public static Map<String, Map<String, String>> getAllTableNameAndEntityName(Context ctx, CheckpointDataSetInfo info, IntelligentAuditExecuteRuleEntryCollection entryCollection, IntelligentDataShowCfgCollection showCfgCollection, CheckpointEntryFilterCollection entryFilters) throws EASBizException, BOSException {
        String[] entitys;
        HashMap<String, String> associativeTableName = new HashMap<String, String>();
        HashMap<String, String> associativeAliasEntity = new HashMap<String, String>();
        String associativeEntity = info.getAssociativeentity();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)associativeEntity)) {
            throw new EASBizException(new NumericExceptionSubItem("XX", "\u5173\u8054\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        for (String entity : entitys = associativeEntity.split(",")) {
            String[] s = entity.split(" ");
            String value = s[0].substring(0, s[0].lastIndexOf("."));
            associativeAliasEntity.put(s[1], s[0]);
            if (entity.contains(".entity")) {
                EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(value));
                associativeTableName.put(s[1], objectInfo.getTable().getName());
                continue;
            }
            if (entity.contains(".table")) {
                associativeTableName.put(s[1], value);
                continue;
            }
            if (!entity.contains(".query")) continue;
        }
        associativeAliasEntity.put(info.getEntityalias(), info.getEntity() + ".entity");
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(info.getEntity()));
        associativeTableName.put(info.getEntityalias(), objectInfo.getTable().getName());
        ArrayList<EntityAdapter> adapterList = new ArrayList<EntityAdapter>();
        adapterList.addAll(DataSetUtils.getEntityAdapterByDataSetEntry(info.getEntrys()));
        adapterList.addAll(DataSetUtils.getEntityAdapterByRuleEntry(entryCollection));
        adapterList.addAll(DataSetUtils.getEntityAdapterByShowCfg(ctx, showCfgCollection));
        adapterList.addAll(DataSetUtils.getEntityAdapterByEntryFilter(ctx, entryFilters));
        ArrayList adapterNew = new ArrayList(new HashSet(adapterList));
        for (int i = 0; i < adapterNew.size(); ++i) {
            EntityAdapter adapter = (EntityAdapter)adapterNew.get(i);
            DataSetUtils.getEntityAndTableName(ctx, i, adapter.getAlias(), adapter.getField(), associativeTableName, associativeAliasEntity);
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        result.put("tablename-app", associativeTableName);
        result.put("entityname-app", associativeAliasEntity);
        return result;
    }

    private static void getEntityAndTableName(Context ctx, int i, String alias, String field, Map<String, String> associativeTableName, Map<String, String> associativeAliasEntity) {
        Matcher matcher = CompareManager.pattern1.matcher(field);
        String s = associativeAliasEntity.get(alias);
        String entity = s.substring(0, s.lastIndexOf("."));
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)new MetaDataPK(entity));
        while (matcher.find()) {
            String entityColumn = matcher.group(1);
            String[] fields = entityColumn.split("\\.");
            int len1 = fields.length;
            for (int j = 0; j < len1; ++j) {
                String f1 = fields[j];
                PropertyInfo propertyInfo = objectInfo.getPropertyByName(f1);
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                RelationshipInfo relationship = ((LinkPropertyInfo)propertyInfo).getRelationship();
                EntityObjectInfo childObjectInfo = relationship.getSupplierObject();
                String isEntry = "";
                if (propertyInfo.getMappingField() == null) {
                    isEntry = "ENTRY";
                }
                String newAlias = alias.toUpperCase() + isEntry + i + "" + j + "XX";
                String tableName = childObjectInfo.getTable().getName();
                if (associativeTableName.containsValue(tableName)) {
                    for (Map.Entry<String, String> m : associativeTableName.entrySet()) {
                        if (!m.getValue().equals(tableName)) continue;
                        if (!m.getKey().startsWith(alias)) {
                            associativeTableName.put(newAlias, tableName);
                        } else {
                            newAlias = m.getKey();
                        }
                        break;
                    }
                } else {
                    associativeTableName.put(newAlias, tableName);
                }
                String fullName = childObjectInfo.getFullName() + ".entity";
                if (associativeAliasEntity.containsValue(fullName)) {
                    for (Map.Entry<String, String> m : associativeAliasEntity.entrySet()) {
                        if (!m.getValue().equals(fullName)) continue;
                        if (!m.getKey().startsWith(alias)) {
                            associativeAliasEntity.put(newAlias, fullName);
                        } else {
                            newAlias = m.getKey();
                        }
                        break;
                    }
                } else {
                    associativeAliasEntity.put(newAlias, fullName);
                }
                objectInfo = childObjectInfo;
                alias = newAlias;
            }
        }
    }

    public static List<EntityAdapter> getEntityAdapterByDataSetEntry(CheckpointDataSetEntryCollection entrys) {
        ArrayList<EntityAdapter> adapterList = new ArrayList<EntityAdapter>();
        if (entrys == null) {
            return adapterList;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            CheckpointDataSetEntryInfo entryInfo = entrys.get(i);
            if (entryInfo.getCompareField().contains("{$") && entryInfo.getCompareField().contains(".")) {
                adapterList.add(new EntityAdapter(entryInfo.getCompareFieldAlias(), entryInfo.getCompareField()));
            }
            if (!entryInfo.getCompareValue().contains("{$") || !entryInfo.getCompareValue().contains(".")) continue;
            adapterList.add(new EntityAdapter(entryInfo.getCompareValueAlias(), entryInfo.getCompareValue()));
        }
        return adapterList;
    }

    public static List<EntityAdapter> getEntityAdapterByRuleEntry(IntelligentAuditExecuteRuleEntryCollection entrys) {
        ArrayList<EntityAdapter> adapterList = new ArrayList<EntityAdapter>();
        if (entrys == null) {
            return adapterList;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            IntelligentAuditExecuteRuleEntryInfo entryInfo = entrys.get(i);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryInfo.getCompareFieldEntity()) && entryInfo.getCompareFieldEntity().contains("{$")) {
                adapterList.addAll(DataSetUtils.parseExpr(entryInfo.getCompareFieldEntity()));
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryInfo.getCompareValueEntity()) || !entryInfo.getCompareValueEntity().contains("{$")) continue;
            adapterList.addAll(DataSetUtils.parseExpr(entryInfo.getCompareValueEntity()));
        }
        return adapterList;
    }

    public static List<EntityAdapter> getEntityAdapterByShowCfg(Context ctx, IntelligentDataShowCfgCollection showCfgCollection) throws BOSException {
        ArrayList<EntityAdapter> adapterList = new ArrayList<EntityAdapter>();
        if (showCfgCollection == null) {
            return adapterList;
        }
        for (int i = 0; i < showCfgCollection.size(); ++i) {
            IntelligentDataShowCfgInfo entryInfo = showCfgCollection.get(i);
            IntelligentDataShowCfgFieldEntryCollection showCfgFieldEntry = (IntelligentDataShowCfgFieldEntryCollection)((Object)entryInfo.get("filedentry-app"));
            for (int j = 0; j < showCfgFieldEntry.size(); ++j) {
                IntelligentDataShowCfgFieldEntryInfo fieldEntryInfo = showCfgFieldEntry.get(j);
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldEntryInfo.getFieldAlias()) || !fieldEntryInfo.getFieldAlias().contains("{$")) continue;
                adapterList.addAll(DataSetUtils.parseExpr(fieldEntryInfo.getFieldAlias()));
            }
        }
        return adapterList;
    }

    public static List<EntityAdapter> getEntityAdapterByEntryFilter(Context ctx, CheckpointEntryFilterCollection entryFilters) throws BOSException {
        ArrayList<EntityAdapter> adapterList = new ArrayList<EntityAdapter>();
        if (entryFilters == null) {
            return adapterList;
        }
        for (int i = 0; i < entryFilters.size(); ++i) {
            CheckpointEntryFilterInfo entryInfo = entryFilters.get(i);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryInfo.getCompareFieldAlias()) && entryInfo.getCompareFieldAlias().contains("{$")) {
                adapterList.addAll(DataSetUtils.parseExpr(entryInfo.getCompareFieldAlias()));
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entryInfo.getCompareValueAlias()) || !entryInfo.getCompareValueAlias().contains("{$")) continue;
            adapterList.addAll(DataSetUtils.parseExpr(entryInfo.getCompareValueAlias()));
        }
        return adapterList;
    }

    private static List<EntityAdapter> parseExpr(String columnExpr) {
        List<EntityAdapter> list = new ArrayList<EntityAdapter>();
        if (!CompareManager.pattern5.matcher(columnExpr).matches() && CompareManager.pattern4.matcher(columnExpr).find()) {
            Map<Integer, String> exprFormula = CheckPointUtils.dealExprFormula(columnExpr);
            for (Map.Entry<Integer, String> m : exprFormula.entrySet()) {
                String value = m.getValue().trim();
                if (CheckPointUtils.isNumeric(value) || CompareManager.pattern4.matcher(value).find()) continue;
                if (CheckPointUtils.hasFunction(value)) {
                    list = DataSetUtils.parseFunctionExpr(columnExpr);
                    continue;
                }
                list.add(new EntityAdapter(value.substring(0, value.indexOf(".")), value.substring(value.indexOf(".") + 1, value.length())));
            }
        } else if (CheckPointUtils.hasFunction(columnExpr)) {
            list = DataSetUtils.parseFunctionExpr(columnExpr);
        } else {
            list.add(new EntityAdapter(columnExpr.substring(0, columnExpr.indexOf(".")), columnExpr.substring(columnExpr.indexOf(".") + 1, columnExpr.length())));
        }
        return list;
    }

    private static List<EntityAdapter> parseFunctionExpr(String columnExpr) {
        ArrayList<EntityAdapter> list = new ArrayList<EntityAdapter>(5);
        if (CheckPointUtils.hasFunction(columnExpr)) {
            for (Map.Entry<String, Pattern> m1 : CustomerFunction.funtionReg.entrySet()) {
                if (!columnExpr.toLowerCase().contains(m1.getKey().toLowerCase() + "(")) continue;
                Matcher matcher = m1.getValue().matcher(columnExpr);
                while (matcher.find()) {
                    String[] columnNames;
                    String columnName = matcher.group(1);
                    for (String name : columnNames = columnName.split(",")) {
                        if (name.indexOf("$") <= -1) continue;
                        EntityAdapter adapter = new EntityAdapter(name.substring(0, name.indexOf(".")), name.substring(name.indexOf(".") + 1, name.length()));
                        list.add(adapter);
                    }
                }
            }
        }
        return list;
    }

    public static void jugeDataSetEntrys(Context ctx, CheckpointDataSetInfo info) throws SSCException {
        String associativeentity = info.getAssociativeentity();
        int associatCount = associativeentity.split(",").length;
        if (associatCount > 1) {
            CheckpointDataSetEntryCollection entrys = info.getEntrys();
            ArrayList<String[]> list = new ArrayList<String[]>();
            for (int i = 0; i < entrys.size(); ++i) {
                CheckpointDataSetEntryInfo entryInfo = entrys.get(i);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryInfo.getCompareFieldAlias()) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryInfo.getCompareValueAlias())) continue;
                if (entryInfo.getCompareFieldAlias().equals(entryInfo.getCompareValueAlias())) {
                    throw new SSCException(SSCException.UNKNOW, new Object[]{"\u5173\u8054\u5173\u7cfb\u7684\u6bd4\u8f83\u5b57\u6bb5\u4e0d\u80fd\u9009\u540c\u4e00\u5b9e\u4f53\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u7b2c" + (i + 1) + "\u884c"});
                }
                list.add(new String[]{entryInfo.getCompareFieldAlias(), entryInfo.getCompareValueAlias()});
            }
            if (list.isEmpty()) {
                throw new SSCException(SSCException.UNKNOW, new Object[]{"\u5173\u8054\u5b9e\u4f53\u4e4b\u95f4\u5fc5\u987b\u6709\u5173\u8054\u5173\u7cfb"});
            }
            Set<String> currentAssoiateRelation = DataSetUtils.getAssoiateRelation(info.getEntityalias(), list);
            Set<String> assoiateRelation = DataSetUtils.getAssoiateRelation(list.get(0)[0], list);
            if (!(currentAssoiateRelation.isEmpty() && assoiateRelation.size() == associatCount - 1 || currentAssoiateRelation.size() == associatCount)) {
                throw new SSCException(SSCException.UNKNOW, new Object[]{"\u5173\u8054\u5b9e\u4f53\u4e4b\u95f4\u5fc5\u987b\u6709\u5173\u8054\u5173\u7cfb"});
            }
        }
    }

    private static Set<String> getAssoiateRelation(String key, List<String[]> relatives) {
        HashSet<String> set = new HashSet<String>();
        int flag = relatives.size();
        block0: while (flag > 0) {
            --flag;
            for (int i = 0; i < relatives.size(); ++i) {
                String[] relative = relatives.get(i);
                if (relative[0].equals(relative[1])) continue;
                String existRelative = "";
                String judgeRelative = "";
                if (key.equals(relative[0]) || set.contains(relative[0])) {
                    existRelative = relative[0];
                    judgeRelative = relative[1];
                } else if (key.equals(relative[1]) || set.contains(relative[1])) {
                    existRelative = relative[1];
                    judgeRelative = relative[0];
                }
                if (existRelative == "" || judgeRelative == "" || !key.equals(existRelative) && (!set.contains(existRelative) || key.equals(judgeRelative)) || set.contains(judgeRelative)) continue;
                set.add(judgeRelative);
                continue block0;
            }
        }
        return set;
    }

    public static String formatWhereSqlByCompareType(String comparetype, String value) {
        StringBuilder result = new StringBuilder();
        if ("==".equals(comparetype)) {
            if (!value.contains(".") && SSCCompareUtils.isDataNumber(value)) {
                value = "{ts '" + value + "'}";
            }
            result.append(" = '" + value + "'");
        } else if ("!=".equals(comparetype)) {
            if (!value.contains(".") && SSCCompareUtils.isDataNumber(value)) {
                value = "{ts '" + value + "'}";
            }
            result.append(" != '" + value + "'");
        } else {
            return DataSetUtils.formatByCompareType(comparetype, value);
        }
        return result.toString();
    }

    public static String formatByCompareType(String comparetype, String value) {
        StringBuilder result = new StringBuilder();
        if ("is_null".equals(comparetype)) {
            result.append(" is null ");
            return result.toString();
        }
        if (StringUtils.isEmpty((String)value)) {
            value = "";
        }
        if (!value.contains(".") && SSCCompareUtils.isDataNumber(value)) {
            value = "{ts '" + value + "'}";
        }
        if ("==".equals(comparetype)) {
            result.append(" = " + value);
        } else if ("!=".equals(comparetype)) {
            result.append(" != " + value);
        } else if (">".equals(comparetype)) {
            result.append(" > " + value);
        } else if ("<".equals(comparetype)) {
            result.append(" < " + value);
        } else if (">=".equals(comparetype)) {
            result.append(" >= " + value);
        } else if ("<=".equals(comparetype)) {
            result.append(" <= " + value);
        } else if ("like".equals(comparetype)) {
            result.append(" like '%" + value + "%' ");
        } else if ("not_like".equals(comparetype) || "not_like".equals(comparetype)) {
            result.append(" not like '%" + value + "%' ");
        } else if ("leftLike".equals(comparetype)) {
            result.append(" like '" + value + "%' ");
        } else if ("not_leftLike".equals(comparetype)) {
            result.append(" not like '" + value + "%' ");
        } else if ("rightLike".equals(comparetype)) {
            result.append(" like '%" + value + "' ");
        } else if ("not_rightLike".equals(comparetype)) {
            result.append(" not like '%" + value + "' ");
        } else if ("is_not_null".equals(comparetype)) {
            result.append(" is not null ");
        }
        result.append(" ");
        return result.toString();
    }
}

