/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.tool.report;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.JobExtFactory;
import com.kingdee.eas.base.ssc.JobState;
import com.kingdee.eas.base.ssc.tool.report.AnalysisData;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

@Deprecated
public class Analysis
implements Runnable {
    public static HashMap<String, String> bosTypeMap = null;
    public static final String JOB = "job";
    public static final String BILL = "bill";
    public static final String USER = "user";
    public static final String T_SSC_BillAnalysis = "T_SSC_BillAnalysis";
    public static final String T_SSC_UserAnalysis = "T_SSC_UserAnalysis";
    public static final String T_SSC_JobHisExt = "T_SSC_JobHisExt";
    public static final String T_SSC_JobExt = "T_SSC_JobExt";
    public Logger logger = Logger.getLogger(Analysis.class);
    private String name;
    private String uuid;
    private AnalysisData analysisData;
    private Map<Thread, AnalysisData> threadData = new HashMap<Thread, AnalysisData>();
    private Context ctx = null;

    public Analysis(String name, AnalysisData analysisData, String uuid, Context ctx) {
        this.name = name;
        this.analysisData = analysisData;
        this.uuid = uuid;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        if (this.name.equals(JOB)) {
            this.executeJob(this.analysisData, this.uuid);
        } else if (this.name.equals(BILL)) {
            this.executeBill(this.analysisData, this.uuid);
        } else if (this.name.equals(USER)) {
            this.executeUser(this.analysisData, this.uuid);
        }
    }

    private Boolean executeJob(AnalysisData analysisData, String uuid) {
        if (analysisData == null) {
            this.logger.error((Object)("\u6267\u884c\u4efb\u52a1\u76d1\u63a7\u6570\u636e\u4e3a\u7a7a\uff01id\u4e3a:" + uuid));
            return false;
        }
        if (null != analysisData.getData()) {
            if (analysisData.getOperateType() == JobState.Pause || analysisData.getOperateType() == JobState.ReScan) {
                this.decideInsertOrUpdate(analysisData.getData(), T_SSC_JobExt, uuid);
            }
        } else {
            this.logger.error((Object)("\u65e0\u53ef\u6267\u884c\u7684\u76d1\u63a7\u6570\u636e!id\u4e3a" + uuid));
            return false;
        }
        this.decideInsertOrUpdate(analysisData.getData(), T_SSC_JobHisExt, uuid);
        return true;
    }

    private Boolean executeBill(AnalysisData analysisData, String uuid) {
        if (analysisData == null) {
            this.logger.error((Object)("\u6267\u884c\u4efb\u52a1\u76d1\u63a7\u6570\u636e\u4e3a\u7a7a\uff01id\u4e3a:" + uuid));
            return false;
        }
        if (null == analysisData.getData()) {
            this.logger.error((Object)("\u65e0\u53ef\u6267\u884c\u7684\u76d1\u63a7\u6570\u636e!id\u4e3a" + uuid));
            return false;
        }
        Set<Map.Entry<String, String>> entrySet = analysisData.getData().entrySet();
        this.decideInsertOrUpdate(analysisData.getData(), T_SSC_BillAnalysis, uuid);
        return true;
    }

    private Boolean executeUser(AnalysisData analysisData, String uuid) {
        if (analysisData == null) {
            this.logger.error((Object)("\u6267\u884c\u4efb\u52a1\u76d1\u63a7\u6570\u636e\u4e3a\u7a7a\uff01id\u4e3a:" + uuid));
            return false;
        }
        if (null == analysisData.getData()) {
            this.logger.error((Object)("\u65e0\u53ef\u6267\u884c\u7684\u76d1\u63a7\u6570\u636e!id\u4e3a" + uuid));
            return false;
        }
        Set<Map.Entry<String, String>> entrySet = analysisData.getData().entrySet();
        this.decideInsertOrUpdate(analysisData.getData(), T_SSC_UserAnalysis, uuid);
        return true;
    }

    private String constructInsert(Map<String, String> map, String tableName) {
        if (map.entrySet() == null) {
            return "";
        }
        StringBuffer sbField = new StringBuffer(" ( ");
        StringBuffer sbValue = new StringBuffer(" ( ");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            if (null == fieldValue || null == fieldName) continue;
            if ("false".equals(fieldValue) || "fasle".equals(fieldValue)) {
                fieldValue = "0";
            } else if ("true".equals(fieldValue)) {
                fieldValue = "1";
            }
            sbField.append("f" + fieldName + ",");
            if (fieldValue.contains("ts")) {
                sbValue.append(fieldValue + ",");
                continue;
            }
            sbValue.append("'" + fieldValue + "',");
        }
        String bosType = bosTypeMap.get(tableName);
        String fid = BOSUuid.create((String)"6566FAB3").toString();
        sbField.append("fid,");
        sbValue.append("'" + fid + "',");
        String sbFields = sbField.substring(0, sbField.length() - 1) + ")";
        String sbValues = sbValue.substring(0, sbValue.length() - 1) + ")";
        StringBuffer insertSql = new StringBuffer("");
        insertSql.append("insert into " + tableName + " ");
        insertSql.append(sbFields);
        insertSql.append("values");
        insertSql.append(sbValues);
        return insertSql.toString();
    }

    private String constructUpdate(Map<String, String> map, String tableName, String uuid) {
        if (map.entrySet() == null) {
            return "";
        }
        String fidName = "";
        if (T_SSC_BillAnalysis.equals(tableName)) {
            fidName = "fbillId";
        } else if (T_SSC_UserAnalysis.equals(tableName)) {
            fidName = "fuserId";
        } else if (T_SSC_JobHisExt.equals(tableName) || T_SSC_JobExt.equals(tableName)) {
            fidName = "fjobId";
        }
        StringBuffer updateSql = new StringBuffer("UPDATE " + tableName + " SET ");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            if ("false".equals(fieldValue)) {
                fieldValue = "0";
            } else if ("true".equals(fieldValue)) {
                fieldValue = "1";
            }
            if (!fieldValue.contains("ts")) {
                fieldValue = "'" + fieldValue + "'";
            }
            updateSql.append(" f" + fieldName + " = " + fieldValue + ",");
        }
        updateSql = updateSql.deleteCharAt(updateSql.length() - 1);
        updateSql.append("WHERE " + fidName + " = '" + uuid + "'");
        return updateSql.toString();
    }

    private Boolean decideInsertOrUpdate(Map<String, String> map, String tableName, String uuid) {
        StringBuffer sql = new StringBuffer(" ");
        if (T_SSC_BillAnalysis.equals(tableName)) {
            sql.append("select 1 from T_SSC_BillAnalysis where fbillid = '" + uuid + "' ");
        } else if (T_SSC_JobHisExt.equals(tableName)) {
            sql.append("select 1 from T_SSC_JobHisExt where fjobid = '" + uuid + "' ");
        } else if (T_SSC_JobExt.equals(tableName)) {
            sql.append("select 1 from T_SSC_JobExt where fjobid = '" + uuid + "' ");
        }
        Context ctx = this.ctx;
        try {
            String executeSql = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            executeSql = rs.next() ? this.constructUpdate(map, tableName, uuid) : this.constructInsert(map, tableName);
            if (JobExtFactory.getLocalInstance(ctx).getJobExtCollection("where job = '" + uuid + "'").isEmpty()) {
                executeSql = executeSql.replaceAll(T_SSC_JobExt, T_SSC_JobHisExt);
            }
            DbUtil.execute((Context)ctx, (String)executeSql);
        }
        catch (Exception e) {
            this.logger.error((Object)"\u6821\u9a8c\u68c0\u67e5\u6267\u884c\u5931\u8d25\uff01");
            return false;
        }
        return true;
    }

    static {
        bosTypeMap = new HashMap();
        bosTypeMap.put(T_SSC_BillAnalysis, "6566FAB3");
        bosTypeMap.put(T_SSC_JobHisExt, "923CCA9C");
        bosTypeMap.put(T_SSC_JobHisExt, "E3B97BD4");
    }
}

