/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.session.IRemoteSessionManager;
import com.kingdee.bos.framework.session.ISessionManager;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.usermonitor.KickOutMsgInfo;
import com.kingdee.eas.base.usermonitor.UMRegistryCollection;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorException;
import com.kingdee.eas.base.usermonitor.UserMonitorSettingInfo;
import com.kingdee.eas.base.usermonitor.app.UserMonitorThread;
import com.kingdee.eas.base.usermonitor.app.UserRegistryDBUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ClusterServiceFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.app.IClusterService;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserMonitorRegistryManager {
    private static Logger logger = Logger.getLogger((String)UserMonitorRegistryManager.class.getName());
    private static UserMonitorRegistryManager instance = null;
    private HashMap regInfoMap = new HashMap();
    private static final String SOLUNTION_NAME = "eas";
    private static final String RESOURCE_COMMON = "com.kingdee.eas.base.usermonitor.UserMonitorCommonResource";
    private static final String RESOURCE_SERVER = "com.kingdee.eas.base.usermonitor.UserMonitorServerResource";
    private static final String LOGIN_TYPE = "LOGIN_TYPE";
    private static final String SEND_TICKOUT_MESSAGE = "needSendTickoutMessage";
    protected UserMonitorThread monitorThread = null;
    public long maxIdleTimeInMinutes = 60L;
    private long preAlarmMinutes = 3L;
    private long portalTimerMinutes = 3L;
    public boolean isMonitorUserAction = true;
    private boolean isMonitorPortal = true;
    private UserRegistryDBUtil urDbUtil = new UserRegistryDBUtil();
    private static final String IS_MONITOR_PORTAL = "isMonitorPortal";
    private static final String FILE_NAME = System.getProperty("eas.deploy") + File.separator + "portalConfig" + File.separator + "isMonitorPortal.properties";

    private UserMonitorRegistryManager() {
    }

    public static synchronized UserMonitorRegistryManager getInstance() {
        if (instance == null) {
            instance = new UserMonitorRegistryManager();
            instance.initIsMonitorPortal(instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIsMonitorPortal(UserMonitorRegistryManager instance) {
        File file = new File(FILE_NAME);
        if (!file.exists()) {
            return;
        }
        Properties props = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            props.load(is);
            String isMonitorPortalStr = (String)props.get(IS_MONITOR_PORTAL);
            if (isMonitorPortalStr != null && !StringUtil.isEmpty((String)isMonitorPortalStr.trim())) {
                instance.isMonitorPortal = Boolean.valueOf(isMonitorPortalStr.trim());
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    private boolean isCluster() {
        IClusterService cs = ClusterServiceFactory.getLocalInstance();
        return cs.isCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAddnew(UMRegistryInfo info) throws EASBizException {
        if (info == null) {
            throw new UserMonitorException(UserMonitorException.UMREGISTRY_INFO_IS_NULL);
        }
        if (info.getId() == null || info.getId().trim().equals("")) {
            throw new UserMonitorException(UserMonitorException.SESSION_ID_IS_NULL);
        }
        if (info.getClientIPAddress() == null || info.getClientIPAddress().trim().equals("")) {
            info.setClientIPAddress("0.0.0.0");
        }
        if (info.getUserName() == null || info.getUserName().trim().equals("")) {
            throw new UserMonitorException(UserMonitorException.USER_NAME_IS_NULL);
        }
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            if (this.regInfoMap.get(info.getId()) != null) {
                UserMonitorException e = new UserMonitorException(UserMonitorException.SESSION_ID_ALREADY_EXIST);
                logger.warn((Object)e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addnew(Context ctx, UMRegistryInfo info) throws EASBizException {
        this.checkAddnew(info);
        Date currentTime = new Date();
        info.setLoginTime(currentTime);
        info.setLastOperateTime(currentTime);
        info.setFinished(true);
        this.setUserMonitorUILoginType(ctx, info);
        if (this.isMonitorUserAction && (this.monitorThread == null || this.monitorThread.isStopped())) {
            this.monitorThread = new UserMonitorThread();
            this.monitorThread.start();
        }
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            if (!this.regInfoMap.containsKey(info.getId())) {
                this.regInfoMap.put(info.getId(), info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getCollection() throws EASBizException {
        UMRegistryCollection regs = new UMRegistryCollection();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo reg : this.regInfoMap.values()) {
                regs.add(reg);
            }
        }
        return regs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getCollectionByDataCenter(String dataCenterName) throws EASBizException {
        UMRegistryCollection regs = new UMRegistryCollection();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo reg : this.regInfoMap.values()) {
                if (!reg.getDataCenterName().equalsIgnoreCase(dataCenterName)) continue;
                regs.add(reg);
            }
        }
        return regs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getCollectionByOrgRange(String dataCenterName, List orgList) throws EASBizException {
        UMRegistryCollection regs = new UMRegistryCollection();
        if (orgList == null || orgList.isEmpty()) {
            return regs;
        }
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo reg : this.regInfoMap.values()) {
                String ctrlUnitId;
                if (!reg.getDataCenterName().equalsIgnoreCase(dataCenterName) || !orgList.contains(ctrlUnitId = reg.getCurrentCtrlUnitId())) continue;
                regs.add(reg);
            }
        }
        return regs;
    }

    public void sendMsgAndKickOut(Context ctx, String dataCenter, String solution, List<KickOutMsgInfo> msgs) throws BOSException, EASBizException {
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        ArrayList<String> kickOutCtxID = new ArrayList<String>();
        int j = msgs.size();
        for (int i = 0; i < j; ++i) {
            KickOutMsgInfo msgInfo = msgs.get(i);
            if (this.needSendTickoutMessage(ctx)) {
                this.sendKickoutMsg(msgInfo, dataCenter, solution);
            }
            String sessionId = msgInfo.getGUIUserId() == null ? msgInfo.getBeKickUserCtxID() : msgInfo.getGUIUserId();
            this.deleteSessionAndUserMonitorInfo(sessionId, true);
            if (kickOutCtxID.contains(sessionId)) continue;
            logger.info((Object)"UserMonitorUI releaseLicenseBySessionID begin");
            try {
                LicenseSrvFactory.getInstance().releaseLicenseBySessionID(sessionId);
                kickOutCtxID.add(sessionId);
            }
            catch (LicenseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            logger.info((Object)"UserMonitorUI releaseLicenseBySessionID success");
        }
    }

    private void sendKickoutMsg(KickOutMsgInfo kickOutMsgInfo, String dataCenter, String solution) {
        try {
            Message warningMsg = this.createMessage(dataCenter, solution, kickOutMsgInfo);
            if (warningMsg != null) {
                SenderAgent senderAgent = SenderAgent.getSenderAgent();
                if (senderAgent.getState() != 1) {
                    senderAgent.start();
                }
                senderAgent.sendMessage(warningMsg);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send kickout message!", (Throwable)e);
        }
    }

    private Message createMessage(String dataCenter, String solution, KickOutMsgInfo msgInfo) throws EASBizException {
        UMRegistryInfo receiver = (UMRegistryInfo)this.getValue(msgInfo.getBeKickUserCtxID());
        if (receiver == null) {
            logger.warn((Object)"can't find reveiver");
            return null;
        }
        Message message = MessageFactory.newMessage((String)"kingdee.usermonitor");
        message.setStringHeader("databaseCenter", dataCenter);
        message.setStringHeader("solution", solution);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        Map<Locale, String> locale2MsgContent = this.buildMsgContent();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            message.setLocaleStringHeader("title", StringUtils.cnulls((String)ResourceBase.getString((String)RESOURCE_SERVER, (String)"kickOut", (Locale)curLocale)), curLocale);
            message.setLocaleStringHeader("body", StringUtils.cnulls((String)this.replaceRegularExpression(locale2MsgContent.get(curLocale), msgInfo)), curLocale);
            message.setLocaleStringHeader("sender", StringUtils.cnulls((String)msgInfo.getKickUserName()), curLocale);
            message.setLocaleStringHeader("initiatorName", StringUtils.cnulls((String)msgInfo.getKickUserName()), curLocale);
        }
        message.setStringHeader("receiver", receiver.getUserId());
        message.setStringHeader("sourceID", msgInfo.getBeKickUserCtxID());
        return message;
    }

    private Map<Locale, String> buildMsgContent() {
        HashMap<Locale, String> locale2MsgContent = new HashMap<Locale, String>();
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            locale2MsgContent.put(curLocale, ResourceBase.getString((String)RESOURCE_COMMON, (String)"kickOutMsg", (Locale)curLocale));
        }
        return locale2MsgContent;
    }

    private String replaceRegularExpression(String sourceMsg, KickOutMsgInfo msgInfo) {
        return MessageFormat.format(sourceMsg, msgInfo.getBeKickUserName(), msgInfo.getKickIP(), msgInfo.getKickUserName(), new Date().toString());
    }

    private void checkUpdate(UMRegistryInfo info) throws EASBizException {
        if (info == null) {
            throw new UserMonitorException(UserMonitorException.UMREGISTRY_INFO_IS_NULL);
        }
        if (info.getId() == null || info.getId().trim().equals("")) {
            throw new UserMonitorException(UserMonitorException.SESSION_ID_IS_NULL);
        }
        Object obj = null;
        obj = this.regInfoMap.get(info.getId());
        if (obj == null || !(obj instanceof UMRegistryInfo)) {
            throw new UserMonitorException(UserMonitorException.SESSION_ID_NOT_EXIST);
        }
        String oldID = ((UMRegistryInfo)obj).getId();
        if (oldID == null || oldID.trim().equals("") || !oldID.equals(info.getId())) {
            if (oldID == null || oldID.trim().equals("")) {
                oldID = "null";
            }
            throw new UserMonitorException(UserMonitorException.SERVER_REGISTRY_INVALID, new Object[]{info.getId(), oldID});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastOperate(UMRegistryInfo info) throws EASBizException {
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            this.checkUpdate(info);
            UMRegistryInfo old = (UMRegistryInfo)this.regInfoMap.get(info.getId());
            old.setCurrentMainBizUnitName(info.getCurrentMainBizUnitName());
            old.setCurrentCtrlUnitId(info.getCurrentCtrlUnitId());
            old.setLastOperateTime(this.getCurrentTime());
            old.setCurrentMainBizUnitName(info.getCurrentMainBizUnitName());
            old.setCurrentCtrlUnitId(info.getCurrentCtrlUnitId());
            old.setOpenWindowTitle(info.getOpenWindowTitle());
            old.setActionName(info.getActionName());
            old.setActionDescription(info.getActionDescription());
            old.setFinished(info.isFinished());
            old.setSendMsg(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastOperateTime(String id) throws EASBizException {
        Date date = this.getCurrentTime();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            UMRegistryInfo old = (UMRegistryInfo)this.regInfoMap.get(id);
            if (old != null) {
                old.setLastOperateTime(date);
                old.setSendMsg(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTimerLastOperateTime(String id) throws EASBizException {
        Date date = this.getCurrentTime();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            UMRegistryInfo old = (UMRegistryInfo)this.regInfoMap.get(id);
            if (old != null) {
                old.setTimerLastUpdateTime(date);
            }
        }
    }

    public void update(UMRegistryInfo info) throws EASBizException {
        this.updateLastOperate(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectValue getValue(String id) throws EASBizException {
        if (id == null || id.trim().equals("")) {
            throw new UserMonitorException(UserMonitorException.SESSION_ID_IS_NULL);
        }
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            return (UMRegistryInfo)this.regInfoMap.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSessionAndUserMonitorInfo(String sessionId, Boolean isForce) throws UserMonitorException {
        logger.error((Object)("=======UserMonitorRegistryManager.deleteSessionAndUserMonitorInfo:" + Thread.currentThread().getStackTrace()));
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new UserMonitorException(UserMonitorException.SESSION_ID_IS_NULL);
        }
        this.removeSession(sessionId);
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            if (this.regInfoMap.get(sessionId) != null) {
                this.regInfoMap.remove(sessionId);
                if (this.regInfoMap.size() == 0) {
                    this.monitorThread.stopThread();
                    this.monitorThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByIPs(String[] ips) throws EASBizException, BOSException {
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (int i = 0; i < ips.length; ++i) {
                for (UMRegistryInfo info : this.regInfoMap.values()) {
                    if (!ips[i].equalsIgnoreCase(info.getClientIPAddress())) continue;
                    this.deleteSessionAndUserMonitorInfo(info.getId(), null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(String sessionId) {
        try {
            logger.error((Object)("=======UserMonitorRegistryManager.removeSession:" + Thread.currentThread().getStackTrace()));
            if (StringUtils.isEmpty((String)sessionId)) {
                throw new UserMonitorException(UserMonitorException.SESSION_ID_IS_NULL);
            }
            UMRegistryInfo reg = null;
            HashMap hashMap = this.regInfoMap;
            synchronized (hashMap) {
                if (this.regInfoMap.get(sessionId) != null) {
                    reg = (UMRegistryInfo)this.regInfoMap.get(sessionId);
                }
            }
            if (reg != null) {
                if (SessionManager.getInstance().getSession(sessionId) != null) {
                    SessionManager.getInstance().removeSession(sessionId);
                } else {
                    IRemoteSessionManager remoteSessionManager = (IRemoteSessionManager)BOSObjectFactory.createRemoteObject((String)reg.getLoginServerURL(), (String)"com.kingdee.bos.framework.session.RemoteSessionManager", IRemoteSessionManager.class);
                    remoteSessionManager.removeSession(sessionId);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Date getCurrentTime() throws EASBizException {
        return new Date();
    }

    public boolean isUserOnline(String dcName, String userName) throws EASBizException {
        return this.findUser(dcName, userName) != null;
    }

    public UMRegistryInfo findUser(String dcName, String userName) throws EASBizException {
        List userList = this.findUsers(dcName, userName);
        if (userList != null && !userList.isEmpty()) {
            return (UMRegistryInfo)userList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findUsers(String dcName, String userName) throws EASBizException {
        ArrayList<UMRegistryInfo> userList = new ArrayList<UMRegistryInfo>();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            Iterator iter = this.regInfoMap.values().iterator();
            boolean isGUIOrPortalLoginType = false;
            boolean isUnkowLoginType = false;
            while (iter.hasNext()) {
                UMRegistryInfo info = (UMRegistryInfo)iter.next();
                if (!info.getUserName().equalsIgnoreCase(userName) || !info.getDataCenterName().equalsIgnoreCase(dcName)) continue;
                isGUIOrPortalLoginType = this.isGUIOrPortalLoginType(info);
                isUnkowLoginType = this.isUnknowLoginType(info);
                if (!isGUIOrPortalLoginType && !isUnkowLoginType) continue;
                userList.add(info);
            }
        }
        return userList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<UMRegistryInfo> getSessionsIdleTooLong() {
        ArrayList<UMRegistryInfo> sessionList = new ArrayList<UMRegistryInfo>();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo info : this.regInfoMap.values()) {
                if (this.isPortalLoginType(info) && info.getTimerLastUpdateTime() != null && (System.currentTimeMillis() - info.getTimerLastUpdateTime().getTime()) / 60000L > this.portalTimerMinutes) {
                    info.setSendMsg(true);
                    sessionList.add(info);
                    continue;
                }
                Date lastOperateTime = info.getLastOperateTime();
                if (System.currentTimeMillis() - lastOperateTime.getTime() <= (this.maxIdleTimeInMinutes - this.preAlarmMinutes) * 60L * 1000L || this.isPortalLoginType(info) && !this.isMonitorPortal) continue;
                sessionList.add(info);
            }
        }
        return sessionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageToUser(Context ctx, String sessionId, Map senderMap, Map msgTopicMap, Map msgContentMap) throws EASBizException {
        SenderAgent senderAgent;
        String userId = null;
        Context context = null;
        String ais = null;
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            if (!this.regInfoMap.containsKey(sessionId)) {
                throw new UserMonitorException(UserMonitorException.SEND_MSG_FAIL);
            }
            userId = ((UMRegistryInfo)this.regInfoMap.get(sessionId)).getUserId();
            ais = ((UMRegistryInfo)this.regInfoMap.get(sessionId)).getDataCenterName();
        }
        SessionInfo session = SessionManager.getInstance().getSession(sessionId);
        if (session != null) {
            context = session.getContext();
        }
        Message stopMessage = this.createMessage(context, sessionId, userId, senderMap, msgTopicMap, msgContentMap);
        if (context == null) {
            stopMessage.setStringHeader("databaseCenter", ais);
            stopMessage.setStringHeader("solution", SOLUNTION_NAME);
        }
        if ((senderAgent = SenderAgent.getSenderAgent()).getState() != 1) {
            senderAgent.start();
        }
        senderAgent.sendMessage(stopMessage);
    }

    private Message createMessage(Context context, String sessionid, String userId, Map senderMap, Map msgTopicMap, Map msgContentMap) {
        Message message = MessageFactory.newMessage((String)"kingdee.usermonitor");
        if (context != null) {
            message.setStringHeader("databaseCenter", context.getAIS());
            message.setStringHeader("solution", context.getSolution());
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        LanguageInfo[] allLanguage = MutilLangeToolForParam.getLanuageInfo();
        for (int i = 0; i < allLanguage.length; ++i) {
            Locale curLocale = allLanguage[i].getLocale();
            message.setLocaleStringHeader("title", StringUtils.cnulls(msgTopicMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("body", StringUtils.cnulls(msgContentMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("sender", StringUtils.cnulls(senderMap.get(curLocale)), curLocale);
            message.setLocaleStringHeader("initiatorName", StringUtils.cnulls(senderMap.get(curLocale)), curLocale);
        }
        message.setStringHeader("receiver", userId);
        message.setStringHeader("sourceID", sessionid);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserMonitorSetting(UserMonitorSettingInfo setInfo) throws UserMonitorException {
        long newTime = setInfo.getIdleTime();
        boolean newMonitorUserAction = setInfo.isMonitorUserAction();
        if (this.maxIdleTimeInMinutes != newTime || this.isMonitorUserAction != newMonitorUserAction) {
            ConfigurationItem item = Configuration.getInstance().getConfigItem("UserMonitor");
            if (item == null) {
                throw new UserMonitorException(UserMonitorException.SETUP_FAIL);
            }
            try {
                UserMonitorRegistryManager userMonitorRegistryManager = this;
                synchronized (userMonitorRegistryManager) {
                    String idleTimeStr = String.valueOf(newTime);
                    String monitorUserActionStr = String.valueOf(newMonitorUserAction);
                    item.setProperty("idleTime", idleTimeStr);
                    item.setProperty("monitorUserAction", monitorUserActionStr);
                    Configuration.getInstance().store();
                    this.maxIdleTimeInMinutes = newTime;
                    this.isMonitorUserAction = newMonitorUserAction;
                    HashMap hashMap = this.regInfoMap;
                    synchronized (hashMap) {
                        if (this.isMonitorUserAction) {
                            if (this.regInfoMap.size() > 0 && (this.monitorThread == null || this.monitorThread.isStopped() || !this.monitorThread.isAlive())) {
                                this.monitorThread = new UserMonitorThread();
                                this.monitorThread.start();
                            }
                        } else if (this.monitorThread != null) {
                            this.monitorThread.stopThread();
                            this.monitorThread = null;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new UserMonitorException(UserMonitorException.SETUP_FAIL);
            }
        }
    }

    public UserMonitorSettingInfo getUserMonitorSetting() {
        UserMonitorSettingInfo info = new UserMonitorSettingInfo();
        info.setIdleTime(this.maxIdleTimeInMinutes);
        info.setMonitorUserAction(this.isMonitorUserAction);
        return info;
    }

    public boolean needSendTickoutMessage(Context ctx) throws EASBizException, BOSException {
        try {
            String isSendTickoutMessageValue = ParamManager.getParamValue((Context)ctx, null, (String)SEND_TICKOUT_MESSAGE);
            if (isSendTickoutMessageValue != null && !isSendTickoutMessageValue.isEmpty()) {
                boolean isSendTickoutMessage = Boolean.parseBoolean(isSendTickoutMessageValue);
                return isSendTickoutMessage;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get parameter 'needSendTickoutMessage'", (Throwable)e);
        }
        try {
            String sql = "SELECT   param.fnumber number,   param.fdefaultval_l2 defaultval,   item.fvalue_l2 value from T_BAS_PARAM param left join T_BAS_PARAMITEM item on param.fid=item.fkeyid where param.fnumber='needSendTickoutMessage'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String value = rowSet.getString("value");
                if (value != null && !value.isEmpty()) {
                    return Boolean.parseBoolean(value);
                }
                String defaultValue = rowSet.getString("defaultVal");
                if (defaultValue == null || defaultValue.isEmpty()) continue;
                return Boolean.parseBoolean(defaultValue);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get parameter by executing sql!", (Throwable)e);
        }
        return false;
    }

    public void setMsgPriorityHighToMid(String sessionId) {
        Context context = null;
        try {
            context = ContextUtils.getContextFromSessionNoException();
            if (context != null) {
                MessageCenterFactory.getLocalInstance((Context)context).setTimeOutMsgHighTomid(sessionId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExists(String id) {
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            if (this.regInfoMap.get(id) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortalUserExists(String id) {
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            UMRegistryInfo info = (UMRegistryInfo)this.regInfoMap.get(id);
            if (info != null && this.isPortalLoginType(info)) {
                return true;
            }
        }
        return false;
    }

    public boolean isMonitorPortal() throws EASBizException {
        return this.isMonitorPortal;
    }

    public void updateIsMonitorPortal(boolean isMonitorPortal) throws EASBizException {
        this.isMonitorPortal = isMonitorPortal;
        this.persistPortalInfo(isMonitorPortal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistPortalInfo(boolean isMonitorPortal) {
        Properties props = new Properties();
        props.put(IS_MONITOR_PORTAL, String.valueOf(isMonitorPortal));
        File file = new File(FILE_NAME);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            props.store(os, null);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObjectCollection getCollectionUsingOrgRange(Context ctx, String dataCenterName) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dataCenterName)) {
            return this.getCollection();
        }
        UMRegistryCollection regs = new UMRegistryCollection();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            Map<String, UMRegistryCollection> registryInfos = this.getRegistryInfosInDC(dataCenterName);
            if (registryInfos != null) {
                OrgRangeCollection coll = this.getCUIdByOrgRange(ctx, registryInfos.keySet());
                if (coll == null || coll.size() == 0) {
                    return regs;
                }
                for (int i = 0; i < coll.size(); ++i) {
                    OrgRangeInfo rangeInfo = coll.get(i);
                    regs.addCollection(registryInfos.get(rangeInfo.getOrg().getId().toString()));
                }
            }
            String msg = Arrays.toString(this.regInfoMap.values().toArray());
            logger.error((Object)("loggererror,getCollectionUsingOrgRange:" + msg));
            System.out.println("system,getCollectionUsingOrgRange:" + msg);
        }
        return regs;
    }

    private OrgRangeCollection getCUIdByOrgRange(Context ctx, Set<String> ctrlUnitIds) throws BOSException {
        OrgRangeCollection coll = null;
        if (ctrlUnitIds == null || ctrlUnitIds.size() == 0) {
            return coll;
        }
        EntityViewInfo viewInfo = this.buildEntityViewInfo(ctx, ctrlUnitIds);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        coll = iOrgRange.getOrgRangeCollection(viewInfo);
        return coll;
    }

    private EntityViewInfo buildEntityViewInfo(Context ctx, Set<String> ctrlUnitIds) {
        assert (ctrlUnitIds != null && ctrlUnitIds.size() > 0);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userPK = userInfo.getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("org.id"));
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userPK, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(10), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org.id", ctrlUnitIds, CompareType.INCLUDE));
        return viewInfo;
    }

    private Map<String, UMRegistryCollection> getRegistryInfosInDC(String dataCenterName) {
        HashMap<String, UMRegistryCollection> result = new HashMap<String, UMRegistryCollection>();
        if (!StringUtils.isEmpty((String)dataCenterName)) {
            for (UMRegistryInfo reg : this.regInfoMap.values()) {
                if (!reg.getDataCenterName().equalsIgnoreCase(dataCenterName)) continue;
                String ctrlUnitId = reg.getCurrentCtrlUnitId();
                if (result.get(ctrlUnitId) == null) {
                    UMRegistryCollection registryInfos = new UMRegistryCollection();
                    registryInfos.add(reg);
                    result.put(ctrlUnitId, registryInfos);
                    continue;
                }
                ((UMRegistryCollection)((Object)result.get(ctrlUnitId))).add(reg);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameNamePortalUserExists(String dataCenter, String userName, String sessionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)dataCenter) || StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)sessionId)) {
            logger.error((Object)"dataCenter||userName||sessionId none of them can be null.");
            throw new BOSException("dataCenter||userName||sessionId none of them can be null.");
        }
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo info : this.regInfoMap.values()) {
                if (!info.getUserName().equalsIgnoreCase(userName) || !info.getDataCenterName().equalsIgnoreCase(dataCenter) || !info.getId().equals(sessionId)) continue;
                return false;
            }
            for (UMRegistryInfo info : this.regInfoMap.values()) {
                if (!info.getUserName().equalsIgnoreCase(userName) || !info.getDataCenterName().equalsIgnoreCase(dataCenter) || info.getId().equals(sessionId)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getServerAndUserNumberMap() throws BOSException, EASBizException {
        logger.error((Object)"UserMonitorJMX<<<<<<<<<<<<:into UserMonitorRegistryManager.getServerAndUserNumberMap");
        UMRegistryCollection regCol = new UMRegistryCollection();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            for (UMRegistryInfo info : this.regInfoMap.values()) {
                regCol.add(info);
            }
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int size = regCol.size();
        for (int i = 0; i < size; ++i) {
            UMRegistryInfo info = regCol.get(i);
            String url = info.getLoginServerURL();
            Integer number = (Integer)ret.get(url);
            logger.error((Object)("UserMonitorJMX<<<<<<<<<<<<:url:" + url + " number:" + number));
            number = number == null ? new Integer(1) : Integer.valueOf(number + 1);
            ret.put(info.getLoginServerURL(), number);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOverLicenseCount(Context ctx, String userNumber, String dcNumber, String contextId) {
        block13: {
            try {
                logger.error((Object)("+++++++++++++++++LicenseSrvAgentFactory.getLocalInstance(ctx).isRegister(): " + LicenseSrvAgentFactory.getLocalInstance((Context)ctx).isRegister()));
                if (!LicenseSrvAgentFactory.getLocalInstance((Context)ctx).isRegister()) {
                    return false;
                }
                boolean isAdminOrUser = false;
                String userId = ctx.getCaller().toString();
                if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(userId)) {
                    isAdminOrUser = true;
                }
                LoginType currentUserLoginType = this.getUserLoginType(ctx);
                List sameUsers = this.findUsers(ctx.getAIS(), ctx.getUserName());
                if (isAdminOrUser) {
                    int count = 0;
                    for (UMRegistryInfo user : sameUsers) {
                        if (!this.isGUIOrPortalLoginType(user)) continue;
                        ++count;
                    }
                    if (count > 3) {
                        return true;
                    }
                    break block13;
                }
                UMRegistryInfo caller = null;
                HashMap hashMap = this.regInfoMap;
                synchronized (hashMap) {
                    caller = (UMRegistryInfo)this.regInfoMap.get(ctx.getContextID());
                }
                String callerIp = null;
                if (caller != null) {
                    callerIp = caller.getClientIPAddress();
                }
                if (callerIp == null) {
                    callerIp = ctx.getClientHostIP();
                }
                if (callerIp == null) {
                    logger.warn((Object)("Encountered with null client ip address: " + ctx.toString()));
                    return false;
                }
                return this.commonUserOver(callerIp, currentUserLoginType, sameUsers);
            }
            catch (Exception e) {
                logger.error((Object)"Error occurred while checking whether it is overLicenseCount:", (Throwable)e);
            }
        }
        return false;
    }

    private boolean commonUserOver(String ipCurrentCaller, LoginType loginTypeCurrentCaller, List<UMRegistryInfo> sameUserInReg) {
        LoginType loginTypeInReg = null;
        String ipInReg = null;
        int guiCount = 0;
        int portalCountOtherIP = 0;
        int portalCount = 0;
        if (LoginType.PORTAL.equals((Object)loginTypeCurrentCaller)) {
            for (UMRegistryInfo userInReg : sameUserInReg) {
                if (!this.isGUIOrPortalLoginType(userInReg)) continue;
                loginTypeInReg = this.intToLoginType(userInReg.getLoginType());
                ipInReg = userInReg.getClientIPAddress();
                String userName = userInReg.getUserName();
                if (LoginType.PORTAL.equals((Object)loginTypeInReg)) {
                    ++portalCount;
                }
                if (!LoginType.GUI.equals((Object)loginTypeInReg) || ipInReg.equals(ipCurrentCaller)) continue;
                ++guiCount;
            }
            if (guiCount >= 2) {
                return true;
            }
            if (portalCount > 1) {
                return true;
            }
        } else if (LoginType.GUI.equals((Object)loginTypeCurrentCaller)) {
            for (UMRegistryInfo userInReg : sameUserInReg) {
                if (!this.isGUIOrPortalLoginType(userInReg)) continue;
                loginTypeInReg = this.intToLoginType(userInReg.getLoginType());
                ipInReg = userInReg.getClientIPAddress();
                String userName = userInReg.getUserName();
                if (LoginType.GUI.equals((Object)loginTypeInReg) && !ipInReg.equals(ipCurrentCaller)) {
                    return true;
                }
                if (LoginType.GUI.equals((Object)loginTypeInReg) && ipInReg.equals(ipCurrentCaller)) {
                    ++guiCount;
                }
                if (!LoginType.PORTAL.equals((Object)loginTypeInReg) || ipInReg.equals(ipCurrentCaller)) continue;
                ++portalCountOtherIP;
            }
            if (guiCount > 2) {
                return true;
            }
            if (portalCountOtherIP > 1) {
                return true;
            }
        }
        return false;
    }

    public boolean isMobileOrPortalLoginType(SessionInfo sessionInfo) {
        return this.isGUIOrPortalLoginType(sessionInfo.getContext().getContextID());
    }

    public boolean isMobileOrPortalLoginType(UMRegistryInfo registryInfo) {
        return this.isGUIOrPortalLoginType(registryInfo.getId());
    }

    @Deprecated
    public boolean isGUIOrPortalLoginType(String sessionID) {
        Object oLoginType;
        boolean isValidLoginType = false;
        if (StringUtils.isEmpty((String)sessionID)) {
            return isValidLoginType;
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo sessionInfo = manager.getSession(sessionID);
        if (null != sessionInfo && null != (oLoginType = sessionInfo.getContext().get((Object)LOGIN_TYPE)) && oLoginType instanceof LoginType) {
            LoginType loginType = (LoginType)oLoginType;
            isValidLoginType = loginType == LoginType.GUI || loginType == LoginType.PORTAL;
        }
        return isValidLoginType;
    }

    public boolean isGUIOrPortalLoginType(UMRegistryInfo info) {
        LoginType loginType = this.intToLoginType(info.getLoginType());
        return LoginType.GUI.equals((Object)loginType) || LoginType.PORTAL.equals((Object)loginType);
    }

    @Deprecated
    public boolean isUnknowLoginType(String sessionID) {
        boolean isUnknowLoginType = true;
        if (StringUtils.isEmpty((String)sessionID)) {
            return isUnknowLoginType;
        }
        ISessionManager manager = SessionManager.getInstance();
        SessionInfo sessionInfo = manager.getSession(sessionID);
        if (null != sessionInfo) {
            Object oLoginType = sessionInfo.getContext().get((Object)LOGIN_TYPE);
            isUnknowLoginType = null == oLoginType;
        }
        return isUnknowLoginType;
    }

    public boolean isUnknowLoginType(UMRegistryInfo info) {
        LoginType loginType = this.intToLoginType(info.getLoginType());
        return loginType == null;
    }

    private boolean isPortalLoginType(UMRegistryInfo info) {
        LoginType loginType = this.intToLoginType(info.getLoginType());
        return LoginType.PORTAL.equals((Object)loginType);
    }

    private void setUserMonitorUILoginType(Context ctx, UMRegistryInfo info) {
        if (null != ctx) {
            Object oLoginType = ctx.get((Object)LOGIN_TYPE);
            if (null != oLoginType && oLoginType instanceof LoginType) {
                LoginType loginType = (LoginType)oLoginType;
                info.setLoginType(this.loginTypeToInt(loginType));
            }
        } else {
            info.setLoginType(-2);
        }
        logger.error((Object)("user:" + info.getUserName() + ",datacenter:" + info.getDataCenterName() + ",loginType:" + info.getLoginType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginType getUserLoginType(Context ctx) {
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            UMRegistryInfo info = (UMRegistryInfo)this.regInfoMap.get(ctx.getContextID());
            if (info != null) {
                return this.intToLoginType(info.getLoginType());
            }
        }
        Object loginTypeObj = ctx.get((Object)LOGIN_TYPE);
        if (loginTypeObj instanceof Integer) {
            int loginTypeInt = (Integer)loginTypeObj;
            return this.intToLoginType(loginTypeInt);
        }
        if (loginTypeObj instanceof LoginType) {
            return (LoginType)loginTypeObj;
        }
        return null;
    }

    private int loginTypeToInt(LoginType loginType) {
        switch (loginType) {
            case GUI: {
                return 0;
            }
            case PORTAL: {
                return 1;
            }
            case WEBSERVICE: {
                return 2;
            }
            case MOBILE: {
                return 3;
            }
            case OPENAPI: {
                return 4;
            }
        }
        return -1;
    }

    private LoginType intToLoginType(int loginTypeValue) {
        switch (loginTypeValue) {
            case 0: {
                return LoginType.GUI;
            }
            case 1: {
                return LoginType.PORTAL;
            }
            case 2: {
                return LoginType.WEBSERVICE;
            }
            case 3: {
                return LoginType.MOBILE;
            }
            case 4: {
                return LoginType.OPENAPI;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Set> getServerAndUserNumberList() throws BOSException, EASBizException {
        HashMap<String, Set> ret = new HashMap<String, Set>();
        HashMap hashMap = this.regInfoMap;
        synchronized (hashMap) {
            Iterator iter = this.regInfoMap.values().iterator();
            ArrayList msg = new ArrayList();
            while (iter.hasNext()) {
                Set<String> set;
                UMRegistryInfo info = (UMRegistryInfo)iter.next();
                if (ret.containsKey(info.getDataCenterName())) {
                    set = (Set)ret.get(info.getDataCenterName());
                    set.add(info.getUserId());
                    continue;
                }
                set = new HashSet<String>();
                set.add(info.getUserId());
                ret.put(info.getDataCenterName(), set);
            }
        }
        String msg = Arrays.toString(this.regInfoMap.values().toArray());
        logger.error((Object)("loggererror,getServerAndUserNumberList:" + msg));
        System.out.println("system,getServerAndUserNumberList:" + msg);
        return ret;
    }
}

