/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class RemoveBOSSessionListener
implements HttpSessionListener {
    Logger logger = Logger.getLogger((String)RemoveBOSSessionListener.class.getName());

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        if (session != null) {
            Context ctx = this.getBOSContext(session);
            if (ctx != null) {
                String sessionID = ctx.getContextID();
                try {
                    IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                    iUserMonitor.deleteSessionAndUserMonitorInfo(sessionID, null);
                }
                catch (EASBizException e) {
                    this.logger.error((Object)"getRemoteInstance exception...", (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.error((Object)"exception happens...", (Throwable)e);
                }
            } else {
                this.logger.info((Object)"context is null----------RemoveBOSSessionListener");
            }
        } else {
            this.logger.error((Object)"httpSession is null----------RemoveBOSSessionListener");
        }
    }

    private Context getBOSContext(HttpSession session) {
        WebContext webContext;
        Context ctx = (Context)session.getAttribute("pureWebContext");
        if (ctx == null && (webContext = (WebContext)session.getAttribute("easWebContextSessionId")) != null) {
            String sessionID = webContext.getSessionId();
            try {
                ctx = SessionManager.getInstance().getSession(sessionID).getContext();
            }
            catch (Exception e) {
                this.logger.error((Object)("[Eas portal]get eas user server context fails. context is null." + e.getMessage()));
            }
        }
        return ctx;
    }
}

