/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.util.XMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class WeiboBillConfig {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.WeiboBillConfig");
    private static final String CONFIG_FILE = "WeiboBillConfig.xml";
    private static final String BOSTYPE_TAG = "bostype";
    private static List bosTypes = new ArrayList();

    private static void init(String fileName) {
        File configFile = new File(fileName);
        if (configFile.exists()) {
            String file = configFile.getParentFile().getAbsolutePath() + "/" + CONFIG_FILE;
            WeiboBillConfig.load(file);
        } else {
            logger.error((Object)"cann't find the config file!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String file) {
        File configFile = new File(file);
        FileInputStream fileInputStream = null;
        if (configFile.exists()) {
            try {
                fileInputStream = new FileInputStream(configFile);
                Document doc = XMLParser.parseXML((InputStream)fileInputStream);
                WeiboBillConfig.fillBosType(doc.getRootElement());
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"cann't find the config file!");
            }
            catch (JDOMException e) {
                logger.error((Object)"parse config file error!");
            }
            catch (IOException e) {
                logger.error((Object)"config file read error!");
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            logger.error((Object)"cann't find the config file!");
        }
    }

    private static void fillBosType(Element root) {
        List children = root.getChildren(BOSTYPE_TAG);
        for (Element child : children) {
            bosTypes.add(child.getText());
        }
    }

    public static List getWeiboBillList() {
        return bosTypes;
    }

    public static boolean isWeiboBill(String bosType) {
        return true;
    }

    public static void main(String[] args) {
        System.out.println(WeiboBillConfig.getWeiboBillList());
        System.out.println(WeiboBillConfig.isWeiboBill("34D2342C"));
    }

    static {
        String fileName = System.getProperty("portal.config");
        if (fileName == null) {
            logger.error((Object)"cann't find the config file!");
        } else {
            WeiboBillConfig.init(fileName);
        }
        bosTypes.add("E76173AD");
        bosTypes.add("A2CD53CE");
        bosTypes.add("C48A423A");
        bosTypes.add("A4D04D23");
        logger.info((Object)("weibo bill bostypes: " + bosTypes));
    }
}

