/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.billdigest.BillDigestUtil;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.weibo.app.AbstractWeiboBizFacadeControllerBean;
import com.kingdee.eas.base.weibo.app.WeiboAppDAO;
import com.kingdee.eas.base.weibo.app.WeiboGlobal;
import com.kingdee.eas.base.weibo.app.WeiboServiceBuilder;
import com.kingdee.eas.base.weibo.util.TokenSecureUtil;
import com.kingdee.eas.base.weibo.util.WeiboUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import weibo4j.Activity;
import weibo4j.ActivityComment;
import weibo4j.Comment;
import weibo4j.Feed;
import weibo4j.Group;
import weibo4j.Status;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.http.ImageItem;
import weibo4j.http.Response;

public class WeiboBizFacadeControllerBean
extends AbstractWeiboBizFacadeControllerBean {
    private static final long serialVersionUID = -8945923278189104070L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.WeiboBizFacadeControllerBean");

    private Weibo getWeibo(Context ctx, boolean isNew) {
        if (isNew) {
            return WeiboServiceBuilder.getFeedWeibo(ctx);
        }
        return WeiboServiceBuilder.getFeedCachedWeibo(ctx);
    }

    private Weibo getWeiboNoToken(Context ctx) {
        return WeiboServiceBuilder.getFeedWeiboNoToken(ctx);
    }

    private Weibo getWeibo(Context ctx) {
        return this.getWeibo(ctx, false);
    }

    private Weibo getAdminWeibo(Context ctx) {
        return WeiboServiceBuilder.getAdminWeibo(ctx);
    }

    private boolean isWeiboBill(Context ctx, String billId) {
        return true;
    }

    private boolean isWeiboBosType(Context ctx, String bosType) {
        return true;
    }

    private String getSubscriberEmails(Context ctx, String userIds) throws BOSException {
        try {
            return WeiboAppDAO.getWeiboEmailsByUserIds(ctx, userIds);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cuserIds\uff1a" + userIds), (Throwable)e);
            return "";
        }
    }

    @Override
    protected boolean _feedExist(Context ctx, String billId) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        boolean exist = false;
        try {
            exist = weibo.streamFeedExist(billId);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5224\u65ad\u5355\u636e\u662f\u5426\u5b58\u5728\u5fae\u535aFeed\u51fa\u9519", (Throwable)e);
        }
        return exist;
    }

    @Override
    protected Map _getFeedUnread(Context ctx, String billIds, String type) throws BOSException, EASBizException {
        billIds = WeiboUtil.encodeBillId(billIds);
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        String email = this.getSubscriberEmails(ctx, ctx.getCaller().toString());
        if (StringUtils.isEmpty((String)email)) {
            logger.error((Object)"\u5f53\u524d\u7528\u6237\u7684\u5fae\u535a\u90ae\u7bb1\u4e3a\u7a7a");
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            weibo.setUserId(email);
            return weibo.getStreamUnread(billIds, type, true);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u5355\u636e\u7684\u5fae\u535a\u672a\u8bfb\u6761\u6570\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    private boolean isWeiboEnable(Context ctx) {
        String enable = WeiboGlobal.getEnable(ctx);
        return Boolean.valueOf(enable);
    }

    @Override
    protected boolean _postMessage(Context ctx, String billId, String userId, String verb, String content) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        String email = "";
        if (!StringUtils.isEmpty((String)userId) && StringUtils.isEmpty((String)(email = this.getSubscriberEmails(ctx, userId)))) {
            logger.info((Object)("\u7528\u6237\u90ae\u7bb1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u5fae\u535a\u4fe1\u606f\u672a\u53d1\u9001, userId: " + userId));
            return false;
        }
        Weibo weibo = this.getWeiboNoToken(ctx);
        if (weibo == null) {
            return false;
        }
        try {
            if (userId != null && !userId.equals("")) {
                weibo.setUserId(email);
                logger.info((Object)("postTextStreamMessage:" + content));
                return weibo.postTextStreamMessage(billId, content);
            }
            weibo = this.getAdminWeibo(ctx);
            logger.info((Object)("postStreamMessage:" + content));
            return weibo.postStreamMessage(billId, email, verb, content);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u5e03\u5355\u636e\u7684\u5fae\u535a\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _subscribeFeed(Context ctx, String billId, String userIds) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        String email = this.getSubscriberEmails(ctx, userIds);
        if (StringUtils.isEmpty((String)email)) {
            logger.info((Object)("\u7528\u6237\u90ae\u7bb1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u5fae\u535a\u672a\u5173\u6ce8, userIds: " + userIds));
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return false;
        }
        String domain = WeiboGlobal.getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)("EAS\u7ed1\u5b9a\u7684\u5fae\u535a\u57df\u540d\u4e3a\u7a7a\uff0c\u5fae\u535a\u5355\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01\u6570\u636e\u4e2d\u5fc3\uff1a" + ctx.getAIS()));
            return false;
        }
        weibo.setBaseURL(weibo.getBaseURL() + domain + "/");
        try {
            return weibo.subscribeStreamFeed(billId, email);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5173\u6ce8\u5355\u636e\u7684\u5fae\u535aFeed\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _checkSubscribeFeed(Context ctx, String billId, String userId) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        String email = this.getSubscriberEmails(ctx, userId);
        if (StringUtils.isEmpty((String)email)) {
            logger.info((Object)("\u7528\u6237\u90ae\u7bb1\u8d26\u53f7\u4e3a\u7a7a, userId: " + userId));
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return false;
        }
        String domain = WeiboGlobal.getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)("EAS\u7ed1\u5b9a\u7684\u5fae\u535a\u57df\u540d\u4e3a\u7a7a\uff0c\u5fae\u535a\u5355\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01\u6570\u636e\u4e2d\u5fc3\uff1a" + ctx.getAIS()));
            return false;
        }
        weibo.setBaseURL(weibo.getBaseURL() + domain + "/");
        try {
            return weibo.checkSubscribe(billId, email);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5fae\u535a\u670d\u52a1\u68c0\u67e5\u5355\u636eFeed\u662f\u5426\u88ab\u5173\u6ce8\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _unSubscribeFeed(Context ctx, String billId, String userIds) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        String email = this.getSubscriberEmails(ctx, userIds);
        if (StringUtils.isEmpty((String)email)) {
            logger.info((Object)("\u7528\u6237\u90ae\u7bb1\u8d26\u53f7\u4e3a\u7a7a, \u672a\u6267\u884c\u5fae\u535a\u53d6\u6d88\u5173\u6ce8\u52a8\u4f5c\uff0cuserIds: " + userIds));
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return false;
        }
        String domain = WeiboGlobal.getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)("EAS\u7ed1\u5b9a\u7684\u5fae\u535a\u57df\u540d\u4e3a\u7a7a\uff0c\u5fae\u535a\u5355\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01\u6570\u636e\u4e2d\u5fc3\uff1a" + ctx.getAIS()));
            return false;
        }
        weibo.setBaseURL(weibo.getBaseURL() + domain + "/");
        try {
            return weibo.unSubscribe(billId, email);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d6\u6d88\u5173\u6ce8\u5355\u636e\u7684\u5fae\u535aFeed\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    private String getBillDigest(Context ctx, String billId) {
        String billDigest = null;
        try {
            billDigest = BillDigestUtil.getDigest((Context)ctx, (String)billId, (String)"wb");
            if (StringUtils.isEmpty((String)billDigest)) {
                billDigest = "<p>\u8be5\u5355\u636e\u5c1a\u672a\u914d\u7f6e\u6458\u8981</p>";
            }
        }
        catch (Exception e1) {
            logger.error((Object)("\u83b7\u53d6\u5355\u636e\u6458\u8981\u51fa\u73b0\u5f02\u5e38\uff0c\u5355\u636eID\u4e3a\uff1a" + billId), (Throwable)e1);
        }
        return billDigest;
    }

    @Override
    protected boolean _updateFeedDigest(Context ctx, String billId) throws BOSException, EASBizException {
        String newBillId = WeiboUtil.encodeBillId(billId);
        if (!this._isShowBillWeibo(ctx, billId)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.updateStreamFeedMetas(newBillId, "", "", "", this.getBillDigest(ctx, billId), "", "");
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5fae\u535a\u670d\u52a1\u66f4\u65b0\u5355\u636e\u6458\u8981\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _isShowBillWeibo(Context ctx, String billId) throws BOSException {
        return this.isWeiboEnable(ctx) && this.isWeiboBill(ctx, billId);
    }

    @Override
    protected boolean _createFeed(Context ctx, String billId, String billCreatorName, String billNumber, String state) throws BOSException, EASBizException {
        Weibo weibo;
        String subscriberEmails;
        String newBillId = WeiboUtil.encodeBillId(billId);
        if (!this._isShowBillWeibo(ctx, billId)) {
            return false;
        }
        if (StringUtils.isEmpty((String)state)) {
            state = "\u8fdb\u884c\u4e2d";
        }
        if (StringUtils.isEmpty((String)(subscriberEmails = this.getSubscriberEmails(ctx, ctx.getCaller().toString())))) {
            logger.info((Object)"\u5f53\u524d\u7528\u6237\u7684\u5fae\u535a\u8d26\u53f7\u4e3a\u7a7a");
        }
        if ((weibo = this.getWeibo(ctx, true)) == null) {
            return false;
        }
        try {
            boolean isExist = weibo.streamFeedExist(newBillId);
            if (isExist) {
                return weibo.updateStreamFeedMetas(newBillId, "", "", "", this.getBillDigest(ctx, billId), "", "");
            }
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSUuid.read((String)billId).getType());
            return weibo.createStreamFeed(newBillId, "", StringUtils.cnulls((String)entity.getAlias()), StringUtils.cnulls((String)entity.getAlias()) + StringUtils.cnulls((String)billNumber), StringUtils.cnulls((String)billCreatorName), StringUtils.cnulls((String)billNumber), StringUtils.cnulls((String)this.getBillDigest(ctx, billId)), state);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u521b\u5efa\u5355\u636e\u7684\u5fae\u535aFeed\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _updateFeedState(Context ctx, String billId, String state) throws BOSException, EASBizException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.updateStreamFeedMetas(billId, "", "", "", "", state, "started");
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5fae\u535a\u670d\u52a1\u66f4\u65b0\u5355\u636e\u6458\u8981\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    @Override
    protected String _getBindEmailByPersonId(Context ctx, String personId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        String[] weiboInfo = null;
        try {
            weiboInfo = WeiboAppDAO.getWeiboInfoByPersonId(ctx, personId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cpersonId:" + personId), (Throwable)e);
        }
        if (weiboInfo != null && !StringUtils.isEmpty((String)weiboInfo[1])) {
            return weiboInfo[1];
        }
        return null;
    }

    @Override
    protected boolean _isBosTypeConfiged(Context ctx, String bosType) throws BOSException, EASBizException {
        return this.isWeiboEnable(ctx) && this.isWeiboBosType(ctx, bosType);
    }

    @Override
    protected boolean _deleteActivity(Context ctx, String activityId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.deleteActivity(activityId);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u5220\u9664\u6587\u672c\u7c7b\u578b\u7684activity\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _postCommentToActivity(Context ctx, String activityId, String replyCommentId, String content) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.postCommentToActivity(activityId, replyCommentId, content);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u5e03\u5bf9activity\u8bc4\u8bba\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected boolean _postTextStreamMessage(Context ctx, String billId, String content) throws BOSException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.postTextStreamMessage(billId, content);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u5e03\u6587\u672c(\u5fae\u535a)\u7c7b\u578b\u7684activity\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected Activity _streamActivityDetail(Context ctx, String activityId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            Activity activity = weibo.streamActivityDetail(activityId);
            if (activity != null && activity.target != null) {
                activity.target = WeiboUtil.decodeBillId(activity.target);
            }
            return activity;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6activity\u8be6\u60c5\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamCommentsTimeline(Context ctx, int page, int count, String activityId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<ActivityComment> result = weibo.streamCommentsTimeline(activityId, page, count);
            return result;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u8bc4\u8bba\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Feed _streamFeedDetail(Context ctx, String billId) throws BOSException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return null;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return null;
        }
        try {
            Feed feed = weibo.streamFeedDetail(billId);
            if (feed != null && feed.targetId != null) {
                feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
            }
            return feed;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6Feed\u8be6\u7ec6\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamFeeds(Context ctx, String userId, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        String email = this.getSubscriberEmails(ctx, userId);
        if (StringUtils.isEmpty((String)email)) {
            logger.info((Object)("\u7528\u6237\u90ae\u7bb1\u8d26\u53f7\u4e3a\u7a7a, userId: " + userId));
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            List<Feed> list = weibo.streamFeeds(weiboUserId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u8ba2\u9605\u7684Feed\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamMentionsTimeline(Context ctx, int page, int count, String userId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            List<Activity> list = weibo.streamMentionsTimeline(weiboUserId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Activity activity = list.get(i);
                    if (activity == null || activity.target == null) continue;
                    activity.target = WeiboUtil.decodeBillId(activity.target);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u63d0\u53ca\u6211\u7684activity\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamTargetTimeline(Context ctx, String billId, int page, int count) throws BOSException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Activity> list = weibo.streamTargetTimeline(billId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Activity activity = list.get(i);
                    if (activity == null || activity.target == null) continue;
                    activity.target = WeiboUtil.decodeBillId(activity.target);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6Feed\u4e0bactivity\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamUserTimeline(Context ctx, int page, int count, String userId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            List<Activity> list = weibo.streamUserTimeline(weiboUserId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Activity activity = list.get(i);
                    if (activity == null || activity.target == null) continue;
                    activity.target = WeiboUtil.decodeBillId(activity.target);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237activity\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _uploadTextStreamMessage(Context ctx, String billId, String content, byte[] fileBytes, String fileName) throws BOSException {
        if (!this._isShowBillWeibo(ctx, billId = WeiboUtil.encodeBillId(billId))) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            String fileDir = System.getProperty("java.io.tmpdir");
            File file = this.saveFile(fileBytes, fileDir, fileName);
            return weibo.uploadTextStreamMessage(billId, content, file);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u5e03\u5e26\u9644\u4ef6\u7684\u6587\u672c(\u5fae\u535a)\u7c7b\u578b\u7684activity\u51fa\u9519", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"\u53d1\u5e03\u5e26\u9644\u4ef6\u7684\u6587\u672c(\u5fae\u535a)\u7c7b\u578b\u7684activity\u51fa\u9519,\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveFile(byte[] fileBytes, String fileDir, String fileName) throws IOException {
        if (!fileDir.endsWith("\\") && !fileDir.endsWith("/")) {
            fileDir = fileDir + "/";
        }
        File file = new File(fileDir + fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(fileBytes);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    @Override
    protected List _searchUsers(Context ctx, String q) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            return weibo.searchUsers(q);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u641c\u7d22\u7528\u6237\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamMySendTimeline(Context ctx, String userId, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            List<Activity> list = weibo.streamMySendTimeline(weiboUserId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Activity activity = list.get(i);
                    if (activity == null || activity.target == null) continue;
                    activity.target = WeiboUtil.decodeBillId(activity.target);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u6211\u53d1\u7684activity\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _streamReplyToMeTimeline(Context ctx, String userId, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            List<Activity> list = weibo.streamReplyToMeTimeline(weiboUserId, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Activity activity = list.get(i);
                    if (activity == null || activity.target == null) continue;
                    activity.target = WeiboUtil.decodeBillId(activity.target);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u56de\u590d\u6211\u7684activity\u5217\u8868\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    protected String _getWeiboIdbyUserId(Context ctx, String userId) throws BOSException {
        String[] weiboIds = null;
        try {
            weiboIds = WeiboAppDAO.getWeiboInfoByUserId(ctx, userId);
        }
        catch (SQLException e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u5fae\u535a\u8d26\u53f7\u51fa\u9519\uff0cuserId:" + userId), (Throwable)e);
        }
        String weiboId = "";
        if (weiboIds != null && !StringUtils.isEmpty((String)weiboIds[0])) {
            weiboId = weiboIds[0];
        } else if (weiboIds != null && weiboIds.length > 1) {
            weiboId = this.getWeiboUserId(ctx, weiboIds[1]);
        }
        return weiboId;
    }

    private String getWeiboUserId(Context ctx, String email) {
        if (StringUtils.isEmpty((String)email)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx);
        weibo.setUserId(email);
        try {
            User user = weibo.verifyCredentials();
            if (user != null) {
                return user.getId();
            }
        }
        catch (WeiboException e) {
            logger.error((Object)("\u5fae\u535a\u670d\u52a1\u9a8c\u8bc1\u7528\u6237\u5931\u8d25\uff0cemail:" + email), (Throwable)e);
        }
        return null;
    }

    @Override
    protected long _streamCommentUnread(Context ctx) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return 0L;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return 0L;
        }
        try {
            return weibo.streamCommentUnread();
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u8bc4\u8bba\u672a\u8bfb\u6570\u51fa\u9519", (Throwable)e);
            return 0L;
        }
    }

    @Override
    protected long _streamMentionUnread(Context ctx) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return 0L;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return 0L;
        }
        try {
            return weibo.streamMentionUnread();
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u63d0\u53ca\u672a\u8bfb\u6570\u51fa\u9519", (Throwable)e);
            return 0L;
        }
    }

    @Override
    protected boolean _addFeedParticipant(Context ctx, String userId, String targetId, String participantIds) throws BOSException {
        targetId = WeiboUtil.encodeBillId(targetId);
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            return weibo.addFeedParticipant(weiboUserId, targetId, participantIds);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u6dfb\u52a0Feed\u53c2\u4e0e\u4eba\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected List _feedDynamicTimeline(Context ctx, String categoryName, int activityCount, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Feed> list = weibo.feedDynamicTimeline(categoryName, true, activityCount, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u7ec4\u4ef6\u4e3b\u9875\u9762-\u52a8\u6001\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _feedRelatedDoc(Context ctx, String userId, String targetId, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            return weibo.feedRelatedDoc(weiboUserId, targetId, page, count);
        }
        catch (WeiboException e) {
            logger.error((Object)"feed\u76f8\u5173\u6587\u6863\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _feedSubscribeTimeline(Context ctx, String categoryName, int activityCount, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Feed> list = weibo.feedSubscribeTimeline(categoryName, true, activityCount, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u7ec4\u4ef6\u4e3b\u9875\u9762-\u5173\u6ce8\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _getFeedParticipants(Context ctx, String userId, String targetId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            return weibo.getFeedParticipants(weiboUserId, targetId);
        }
        catch (WeiboException e) {
            logger.error((Object)"Feed\u53c2\u4e0e\u4eba\u5217\u8868\uff0c\u6240\u6709\u8ba2\u9605\u8be5Feed\u7684\u7528\u6237\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _hotStreamFeedsRecently(Context ctx, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Feed> list = weibo.hotStreamFeedsRecently(count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u6700\u8fd1\u70ed\u95e8feed\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _feedCompletedTimeline(Context ctx, String categoryName, int activityCount, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Feed> list = weibo.feedCompletedTimeline(categoryName, activityCount, page, count);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u7ec4\u4ef6\u4e3b\u9875\u9762-\u5df2\u5b8c\u6210\uff0c\u5305\u62ec\u6211\u53c2\u4e0e\u548c\u6211\u8ba2\u9605\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _modifyFeedTitle(Context ctx, String targetId, String title) throws BOSException {
        targetId = WeiboUtil.encodeBillId(targetId);
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            return weibo.modifyFeedTitle(targetId, title);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u4fee\u6539feed\u7684Title\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    @Override
    protected Map _userAllUnread(Context ctx) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        if (!this.checkToken(weibo)) {
            return null;
        }
        try {
            return weibo.userAllUnread(true);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u53c2\u4e0e\u6216\u5173\u6ce8\u7684\u6240\u6709feed\u7684\u5fae\u535a\u672a\u8bfb\u6570\uff0c\u88ab\u8bc4\u8bba\u672a\u8bfb\u6570\uff0c\u88ab\u63d0\u53ca\u672a\u8bfb\u6570\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Comment _commentGroup(Context ctx, String groupId, String sid, String cid, String comment) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            return weibo.commentGroup(groupId, sid, cid, comment);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u8bc4\u8bba\u5c0f\u7ec4\u5fae\u535a\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _getJoinedGroups(Context ctx, String userId, int page, int count) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            return weibo.getJoinedGroups(userId, page, count);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u53c2\u4e0e\u7684\u5c0f\u7ec4\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Status _updateGroupStatus(Context ctx, String groupId, String status) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            return weibo.updateGroupStatus(groupId, status);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u9001\u5c0f\u7ec4\u5fae\u535a\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Status _uploadGroupStatus(Context ctx, String groupId, String status, ImageItem item) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        String email = this.getSubscriberEmails(ctx, ctx.getCaller().toString());
        if (StringUtils.isEmpty((String)email)) {
            logger.error((Object)"\u5f53\u524d\u7528\u6237\u7684\u5fae\u535a\u90ae\u7bb1\u4e3a\u7a7a");
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            weibo.setUserId(email);
            return weibo.uploadGroupStatus(groupId, status, item);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u53d1\u9001\u5e26\u56fe\u7247\u7684\u5c0f\u7ec4\u5fae\u535a\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _feedDynamicTimelineOnlyUnread(Context ctx, String categoryName, int activityCount, int page, int count, boolean onlyUnread) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        if (!this.checkToken(weibo)) {
            return null;
        }
        try {
            List<Feed> list = weibo.feedDynamicTimelineOnlyUnread(categoryName, activityCount, true, page, count, onlyUnread);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u7ec4\u4ef6\u4e3b\u9875\u9762-\u52a8\u6001-\u53ea\u663e\u793a\u672a\u8bfb\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List _feedSubscribeTimelineOnlyUnread(Context ctx, String categoryName, int activityCount, int page, int count, boolean onlyUnread) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            List<Feed> list = weibo.feedSubscribeTimelineOnlyUnread(categoryName, activityCount, page, count, onlyUnread, true);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Feed feed = list.get(i);
                    if (feed == null || feed.targetId == null) continue;
                    feed.targetId = WeiboUtil.decodeBillId(feed.targetId);
                }
            }
            return list;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u7ec4\u4ef6\u4e3b\u9875\u9762-\u5173\u6ce8-\u53ea\u663e\u793a\u672a\u8bfb\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected Status _uploadGroupStatus4GUI(Context ctx, String groupId, String status, byte[] file, String fileName) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        String email = this.getSubscriberEmails(ctx, ctx.getCaller().toString());
        if (StringUtils.isEmpty((String)email)) {
            logger.error((Object)"\u5f53\u524d\u7528\u6237\u7684\u5fae\u535a\u90ae\u7bb1\u4e3a\u7a7a");
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            ImageItem item = new ImageItem("pic", file);
            weibo.setUserId(email);
            return weibo.uploadGroupStatus(groupId, status, item);
        }
        catch (Exception e) {
            logger.error((Object)"\u53d1\u9001\u5e26\u56fe\u7247\u7684\u5c0f\u7ec4\u5fae\u535aforGUI\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _addGroupMember2(Context ctx, String communityId, String groupId, String userId, String token, String tokenSecret) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        weibo.setToken(token, TokenSecureUtil.decode(tokenSecret));
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            weibo.switch2Community(communityId);
            weibo.addGroupMember(groupId, weiboUserId);
            weibo.switch2Company();
        }
        catch (WeiboException e) {
            logger.error((Object)"\u6dfb\u52a0\u5230\u5c0f\u7ec4\u51fa\u9519", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean _addUserToCommunity3(Context ctx, String communityId, String userId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return false;
        }
        String email = this.getSubscriberEmails(ctx, userId);
        try {
            Response response = weibo.addUserToCommunity2(communityId, email);
        }
        catch (Exception e) {
            logger.error((Object)"\u6dfb\u52a0\u7528\u6237\u5230\u793e\u533a\u51fa\u9519", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected List _getJoinedGroups2(Context ctx, String userId, int page, int count, String communityId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return null;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return null;
        }
        try {
            weibo.switch2Community(communityId);
            List<Group> result = weibo.getJoinedGroups(userId, page, count);
            weibo.switch2Company();
            return result;
        }
        catch (WeiboException e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u53c2\u4e0e\u7684\u5c0f\u7ec4\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean _addGroupMember(Context ctx, String groupId, String userId) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getAdminWeibo(ctx);
        if (weibo == null) {
            return false;
        }
        String weiboUserId = this._getWeiboIdbyUserId(ctx, userId);
        try {
            weibo.addGroupMember(groupId, weiboUserId);
        }
        catch (WeiboException e) {
            logger.error((Object)"\u6dfb\u52a0\u5230\u5c0f\u7ec4\u51fa\u9519", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean _addUserToCommunity2(Context ctx, String communityId, String email) throws BOSException {
        if (!this.isWeiboEnable(ctx)) {
            return false;
        }
        Weibo weibo = this.getWeibo(ctx, true);
        if (weibo == null) {
            return false;
        }
        try {
            weibo.setUserId(email);
            Response response = weibo.addUserToCommunity2(communityId, email);
        }
        catch (Exception e) {
            logger.error((Object)"\u6dfb\u52a0\u7528\u6237\u5230\u793e\u533a\u51fa\u9519", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected boolean _doCooperate(Context ctx, String billId, String title, String userId, String weiboUsers, String content, byte[] fileContent, String fileName) throws BOSException, EASBizException {
        logger.info((Object)("doCooperate:billId=" + billId + ",title=" + title + ",userId=" + userId + ",weiboUsers=" + weiboUsers + ",content=" + content + ",fileName=" + fileName));
        this._modifyFeedTitle(ctx, billId, title);
        if (weiboUsers != null && !weiboUsers.equals("")) {
            this._addFeedParticipant(ctx, userId, billId, weiboUsers);
        }
        this._subscribeFeed(ctx, billId, userId);
        if (fileName != null && !fileName.equals("")) {
            this._uploadTextStreamMessage(ctx, billId, content, fileContent, fileName);
        } else {
            this._postTextStreamMessage(ctx, billId, content);
        }
        this._updateFeedState(ctx, billId, "\u8fdb\u884c\u4e2d");
        return true;
    }

    private boolean checkToken(Weibo weibo) {
        return weibo.isSetToken;
    }
}

