/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.weibo.app.WeiboAccessInfo;
import com.kingdee.eas.base.weibo.app.WeiboAppDAO;
import com.kingdee.eas.base.weibo.app.WeiboGlobal;
import com.kingdee.eas.base.weibo.util.TokenSecureUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import weibo4j.Weibo;

public class WeiboServiceBuilder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.WeiboServiceBuilder");
    private static Map<String, Weibo> weiboPool = new HashMap<String, Weibo>();
    private static final String FEED = "FEED";

    protected static Weibo getWeibo(Context ctx) {
        WeiboServiceBuilder.setWeiboAppInfo(ctx);
        Weibo weibo = new Weibo(ctx, null, null);
        return weibo;
    }

    private static void setWeiboAppInfo(Context ctx) {
        if (StringUtils.isEmpty((String)Weibo.CONSUMER_KEY)) {
            Weibo.CONSUMER_KEY = WeiboGlobal.getAppKey(ctx);
        }
        if (StringUtils.isEmpty((String)Weibo.CONSUMER_SECRET)) {
            Weibo.CONSUMER_SECRET = TokenSecureUtil.decode(WeiboGlobal.getAppSecret(ctx));
        }
    }

    protected static Weibo getFeedWeibo(Context ctx) {
        WeiboAccessInfo accessInfo;
        Weibo weibo = WeiboServiceBuilder.getWeibo(ctx);
        String domain = WeiboGlobal.getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)("EAS\u7ed1\u5b9a\u7684\u5fae\u535a\u57df\u540d\u4e3a\u7a7a\uff0c\u5fae\u535a\u5355\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01\u6570\u636e\u4e2d\u5fc3\uff1a" + ctx.getAIS()));
            return null;
        }
        weibo.setBaseURL(weibo.getBaseURL() + domain + "/");
        try {
            String currPersonId = WeiboServiceBuilder.getCurrentPersonId(ctx);
            logger.info((Object)("currPersonId=" + currPersonId));
            accessInfo = WeiboAppDAO.getAccessInfo(ctx, currPersonId);
        }
        catch (Exception e) {
            logger.error((Object)"getFeedWeibo\u83b7\u53d6AccessToken\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            accessInfo = new WeiboAccessInfo();
        }
        if (accessInfo.getToken() != null) {
            logger.info((Object)("token=" + accessInfo.getToken() + ",tokenSecret=" + TokenSecureUtil.decode(accessInfo.getTokenSecret())));
            weibo.setToken(accessInfo.getToken(), TokenSecureUtil.decode(accessInfo.getTokenSecret()));
        }
        return weibo;
    }

    protected static Weibo getFeedWeiboNoToken(Context ctx) {
        Weibo weibo = WeiboServiceBuilder.getWeibo(ctx);
        String domain = WeiboGlobal.getDomain(ctx);
        if (StringUtils.isEmpty((String)domain)) {
            logger.error((Object)("EAS\u7ed1\u5b9a\u7684\u5fae\u535a\u57df\u540d\u4e3a\u7a7a\uff0c\u5fae\u535a\u5355\u636e\u670d\u52a1\u4e0d\u53ef\u7528\uff01\u6570\u636e\u4e2d\u5fc3\uff1a" + ctx.getAIS()));
            return null;
        }
        weibo.setBaseURL(weibo.getBaseURL() + domain + "/");
        return weibo;
    }

    private static String getCurrentPersonId(Context ctx) {
        String personId = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo.getPerson() != null) {
            personId = userInfo.getPerson().getId().toString();
        }
        return personId;
    }

    protected static Weibo getFeedCachedWeibo(Context ctx) {
        Weibo weibo = weiboPool.get(WeiboServiceBuilder.getFeedAISKey(ctx));
        if (weibo == null && (weibo = WeiboServiceBuilder.getFeedWeibo(ctx)) != null) {
            weiboPool.put(WeiboServiceBuilder.getFeedAISKey(ctx), weibo);
        }
        return weibo;
    }

    private static String getFeedAISKey(Context ctx) {
        return FEED + ctx.getAIS();
    }

    protected static Weibo getAdminWeibo(Context ctx) {
        String[] tokens;
        try {
            tokens = WeiboAppDAO.getWeiboAdminToken(ctx);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6Token\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            tokens = new String[3];
        }
        if (StringUtils.isEmpty((String)tokens[0])) {
            logger.error((Object)"\u83b7\u53d6Token\u4fe1\u606f\u51fa\u9519,\u53ef\u80fdEAS\u4e0e\u5fae\u535a\u5c1a\u672a\u5efa\u7acb\u7ed1\u5b9a\u5173\u7cfb");
        }
        Weibo weibo = WeiboServiceBuilder.getWeibo(ctx);
        weibo.setUserId(tokens[0]);
        weibo.setOAuthAccessToken(tokens[1], TokenSecureUtil.decode(tokens[2]));
        return weibo;
    }
}

