/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.uiframe.client.ui.web20.statistics.StatisticsUtil;
import com.kingdee.eas.base.weibo.EcaFacadeFactory;
import com.kingdee.eas.base.weibo.IEcaFacade;
import com.kingdee.eas.base.weibo.util.XTAppService;
import com.kingdee.eas.common.EASBizException;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;

public class SocialBizUtil {
    public static final String CLIENT_TAG = "HTTP_CLIENT_USER_TAG";

    public static boolean checkIsOpen() throws BOSException, EASBizException {
        return SocialBizUtil.checkIsOpen(null);
    }

    public static boolean checkIsOpen(Context ctx) throws BOSException, EASBizException {
        IEcaFacade ecaFacade = null;
        ecaFacade = ctx == null ? EcaFacadeFactory.getRemoteInstance() : EcaFacadeFactory.getLocalInstance(ctx);
        return ecaFacade.checkIsOpen();
    }

    public static String sendMessage(String userId, String toUsers, String content) throws BOSException, EASBizException {
        XTAppService service = XTAppService.getInstance();
        Map map = service.login(userId);
        HttpClient client = (HttpClient)map.get(CLIENT_TAG);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] users = toUsers.split(";");
        if (users.length > 1) {
            HashMap<String, String[]> gMap = new HashMap<String, String[]>();
            gMap.put("userIds", users);
            String jsonContent = service.createGroup(client, gMap);
            String groupId = SocialBizUtil.getGroupId(jsonContent);
            params.put("groupId", groupId);
        } else {
            params.put("toUserId", users[0]);
        }
        params.put("msgType", "2");
        params.put("content", content);
        params.put("msgLen", content.getBytes().length);
        SocialBizUtil.sendGuiStatistics("9", userId);
        return service.send(client, params);
    }

    public static String sendFile(String userId, String toUsers, File file) throws BOSException, EASBizException {
        XTAppService service = XTAppService.getInstance();
        Map map = service.login(userId);
        HttpClient client = (HttpClient)map.get(CLIENT_TAG);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] users = toUsers.split(";");
        if (users.length > 1) {
            HashMap<String, String[]> gMap = new HashMap<String, String[]>();
            gMap.put("userIds", users);
            String jsonContent = service.createGroup(client, gMap);
            String groupId = SocialBizUtil.getGroupId(jsonContent);
            params.put("groupId", groupId);
        } else {
            params.put("toUserId", users[0]);
        }
        params.put("msgType", "4");
        params.put("msgLen", file.length());
        SocialBizUtil.sendGuiStatistics("10", userId);
        return service.sendFile(client, params, file);
    }

    public static String sendMessageFile(String userId, String toUsers, String content, File file) throws BOSException, EASBizException {
        String result = "";
        XTAppService service = XTAppService.getInstance();
        Map map = service.login(userId);
        HttpClient client = (HttpClient)map.get(CLIENT_TAG);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] users = toUsers.split(";");
        if (users.length > 1) {
            HashMap<String, String[]> gMap = new HashMap<String, String[]>();
            gMap.put("userIds", users);
            String jsonContent = service.createGroup(client, gMap);
            String groupId = SocialBizUtil.getGroupId(jsonContent);
            params.put("groupId", groupId);
        } else {
            params.put("toUserId", users[0]);
        }
        if (content != null && !"".equals(content)) {
            params.put("msgType", "2");
            params.put("content", content);
            params.put("msgLen", content.getBytes().length);
            SocialBizUtil.sendGuiStatistics("9", userId);
            result = service.send(client, params);
        }
        if (file != null) {
            params.put("msgType", "4");
            params.put("msgLen", file.length());
            SocialBizUtil.sendGuiStatistics("10", userId);
            result = service.sendFile(client, params, file);
        }
        return result;
    }

    public static List searchUser(String userId, String word) throws BOSException, EASBizException {
        XTAppService service = XTAppService.getInstance();
        Map map = service.login(userId);
        String loginResult = (String)map.get("HTTP_CLIENT_USER_RESULT");
        System.out.println("loginResult:" + loginResult);
        HttpClient client = (HttpClient)map.get(CLIENT_TAG);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("word", word);
        params.put("begin", "0");
        params.put("count", "10");
        try {
            return service.searchUser(client, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getGroupId(String jsonContent) {
        try {
            JSONObject jo = new JSONObject(jsonContent);
            return jo.getJSONObject("data").getString("groupId");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void sendGuiStatistics(String type, String userId) {
        StringBuffer message = new StringBuffer();
        message.append(userId);
        message.append(",");
        message.append("4");
        message.append(",");
        message.append(type);
        message.append(",");
        message.append(new Date().getTime());
        System.out.println("sendGuiStatistics:" + message.toString());
        StatisticsUtil.send((int)2, (String)message.toString());
    }

    public static String getXTAgentUrl() throws BOSException, EASBizException {
        IEcaFacade ecaFacade = null;
        ecaFacade = EcaFacadeFactory.getRemoteInstance();
        HashMap hm = ecaFacade.getInitConfig();
        return (String)hm.get("xtAgentUrl");
    }

    public static void main(String[] args) {
    }
}

