/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.util.Arrays;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class IDs
extends WeiboResponse {
    private int[] ids;
    private long previousCursor;
    private long nextCursor;
    private static final long serialVersionUID = -6585026560164704953L;
    private static String[] ROOT_NODE_NAMES = new String[]{"id_list", "ids"};

    IDs(Response res) throws WeiboException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        IDs.ensureRootNodeNameIs(ROOT_NODE_NAMES, elem);
        NodeList idlist = elem.getElementsByTagName("id");
        this.ids = new int[idlist.getLength()];
        for (int i = 0; i < idlist.getLength(); ++i) {
            try {
                this.ids[i] = Integer.parseInt(idlist.item(i).getFirstChild().getNodeValue());
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new WeiboException("Weibo API returned malformed response: " + elem, nfe);
            }
        }
        this.previousCursor = IDs.getChildLong("previous_cursor", elem);
        this.nextCursor = IDs.getChildLong("next_cursor", elem);
    }

    IDs(Response res, Weibo w) throws WeiboException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            this.previousCursor = json.getLong("previous_cursor");
            this.nextCursor = json.getLong("next_cursor");
            if (!json.isNull("ids")) {
                JSONArray jsona = json.getJSONArray("ids");
                int size = jsona.length();
                this.ids = new int[size];
                for (int i = 0; i < size; ++i) {
                    this.ids[i] = jsona.getInt(i);
                }
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.ids);
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDs{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

