/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weibo4j.ListObjectWapper;
import weibo4j.User;
import weibo4j.Weibo;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.http.Response;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class ListObject
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 4208232205515192208L;
    private long id;
    private String name;
    private String fullName;
    private String slug;
    private String description;
    private String uri;
    private int subscriberCount;
    private int memberCount;
    private String mode;
    private User user;

    ListObject(Response res, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, res.asDocument().getDocumentElement(), weibo);
    }

    ListObject(Response res, Element elem, Weibo weibo) throws WeiboException {
        super(res);
        this.init(res, elem, weibo);
    }

    ListObject(JSONObject json) throws WeiboException {
        try {
            this.id = json.getLong("id");
            this.name = json.getString("name");
            this.fullName = json.getString("full_name");
            this.slug = json.getString("slug");
            this.description = json.getString("description");
            this.subscriberCount = json.getInt("subscriber_count");
            this.memberCount = json.getInt("member_count");
            this.uri = json.getString("uri");
            this.mode = json.getString("mode");
            if (!json.isNull("user")) {
                this.user = new User(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    private void init(Response res, Element elem, Weibo weibo) throws WeiboException {
        ListObject.ensureRootNodeNameIs("list", elem);
        this.id = ListObject.getChildLong("id", elem);
        this.name = ListObject.getChildText("name", elem);
        this.fullName = ListObject.getChildText("full_name", elem);
        this.slug = ListObject.getChildText("slug", elem);
        this.description = ListObject.getChildText("description", elem);
        this.subscriberCount = ListObject.getChildInt("subscriber_count", elem);
        this.memberCount = ListObject.getChildInt("member_count", elem);
        this.uri = ListObject.getChildText("uri", elem);
        this.mode = ListObject.getChildText("mode", elem);
        NodeList statuses = elem.getElementsByTagName("user");
        if (statuses.getLength() != 0) {
            Element userElem = (Element)statuses.item(0);
            this.user = new User(res, userElem, weibo);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    public void setSubscriberCount(int subscriberCount) {
        this.subscriberCount = subscriberCount;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    public void setMemberCount(int memberCount) {
        this.memberCount = memberCount;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    static ListObjectWapper constructListObjects(Response res, Weibo weibo) throws WeiboException {
        Document doc = res.asDocument();
        if (ListObject.isRootNodeNilClasses(doc)) {
            return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
        }
        try {
            ListObject.ensureRootNodeNameIs("lists_list", doc);
            Element root = doc.getDocumentElement();
            NodeList list = root.getElementsByTagName("lists");
            int length = list.getLength();
            if (length == 0) {
                return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
            }
            Element listsRoot = (Element)list.item(0);
            list = listsRoot.getElementsByTagName("list");
            length = list.getLength();
            ArrayList<ListObject> lists = new ArrayList<ListObject>(length);
            for (int i = 0; i < length; ++i) {
                Element status = (Element)list.item(i);
                lists.add(new ListObject(res, status, weibo));
            }
            long previousCursor = ListObject.getChildLong("previous_curosr", root);
            long nextCursor = ListObject.getChildLong("next_curosr", root);
            if (nextCursor == -1L) {
                nextCursor = ListObject.getChildLong("nextCurosr", root);
            }
            return new ListObjectWapper(lists, previousCursor, nextCursor);
        }
        catch (WeiboException te) {
            if (ListObject.isRootNodeNilClasses(doc)) {
                return new ListObjectWapper(new ArrayList<ListObject>(0), 0L, 0L);
            }
            throw te;
        }
    }

    static ListObjectWapper constructListObjects(Response res) throws WeiboException {
        JSONObject jsonLists = res.asJSONObject();
        try {
            JSONArray list = jsonLists.getJSONArray("lists");
            int size = list.length();
            ArrayList<ListObject> listObjects = new ArrayList<ListObject>(size);
            for (int i = 0; i < size; ++i) {
                listObjects.add(new ListObject(list.getJSONObject(i)));
            }
            long previousCursor = jsonLists.getLong("previous_curosr");
            long nextCursor = jsonLists.getLong("next_cursor");
            if (nextCursor == -1L) {
                nextCursor = jsonLists.getLong("nextCursor");
            }
            return new ListObjectWapper(listObjects, previousCursor, nextCursor);
        }
        catch (JSONException jsone) {
            throw new WeiboException(jsone);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof ListObject && ((ListObject)obj).id == this.id;
    }

    public String toString() {
        return "ListObject{id=" + this.id + ", name='" + this.name + '\'' + ", fullName='" + this.fullName + '\'' + ", slug='" + this.slug + '\'' + ", description='" + this.description + '\'' + ", subscriberCount=" + this.subscriberCount + ", memberCount=" + this.memberCount + ", mode='" + this.mode + "', uri='" + this.uri + '\'' + ", user='" + this.user.toString() + "'}";
    }
}

