/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.workflow.WSContext;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.IImageHandleTask;
import com.kingdee.eas.base.wssc.ImageHandleTaskEntryInfo;
import com.kingdee.eas.base.wssc.ImageHandleTaskFactory;
import com.kingdee.eas.base.wssc.ImageHandleTaskInfo;
import com.kingdee.eas.base.wssc.ImageLogFactory;
import com.kingdee.eas.base.wssc.ImageLogInfo;
import com.kingdee.eas.base.wssc.ImageOperation;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.PhoneSysType;
import com.kingdee.eas.base.wssc.SSCUnitInfo;
import com.kingdee.eas.base.wssc.WSSCException;
import com.kingdee.eas.base.wssc.app.AbstractBillImageFacadeControllerBean;
import com.kingdee.eas.base.wssc.app.SSCImageHandler;
import com.kingdee.eas.base.wssc.app.imagehandler.CoupletImageHandler;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceUtil;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.AEServiceException;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.GuosenWSProxy;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.params.GuosenParamsHelper;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysFactory;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysHelper;
import com.kingdee.eas.base.wssc.image.helper.newInterface.IImageOnlyUrl;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageList;
import com.kingdee.eas.base.wssc.image.pojo.BillImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.ImageStateParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RejectBillInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2RescanInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2SendNoteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSys2getScanHomeInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysArchive;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysCreateJobInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDeleteInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysDestroyInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysGetBillImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysSynVoucherInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysToAppParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysUploadInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewInfo;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewOnPhoneInfo;
import com.kingdee.eas.base.wssc.image.pojo.RescanImageInfo;
import com.kingdee.eas.base.wssc.imageNew.helper.NoticeImageSysFactory_New;
import com.kingdee.eas.base.wssc.imageNew.interfaces.IBillImage;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByBillID;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByBillIDImpl;
import com.kingdee.eas.base.wssc.imageNew.interfaces.impl.BillImageByNOImpl;
import com.kingdee.eas.base.wssc.imageNew.pojo.BillFiledOrgTypeInfo;
import com.kingdee.eas.base.wssc.imageNew.util.Configure;
import com.kingdee.eas.base.wssc.imageNew.util.ImageLogUtil;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageConfig;
import com.kingdee.eas.base.wssc.imageNew.util.MultiImageManager;
import com.kingdee.eas.base.wssc.imageNew.util.WSSCImageUtils;
import com.kingdee.eas.base.wssc.synImage.ImageStateSynFactory;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.base.wssc.util.WorkFlowUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.tools.ResultMsg;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class BillImageFacadeControllerBean
extends AbstractBillImageFacadeControllerBean {
    private static final long serialVersionUID = 2857523080247738441L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.BillImageFacadeControllerBean");
    private static SSCImageHandler imageHandler = new SSCImageHandler();
    static final String SUCCESS = "1";
    private Map<String, String> billNum_ImageMap = null;
    public static String EAS_IMAGE_PICTURE_URL_TAIL_VALUE = "/SiitFrameWs/services/AutoImageCenter.ws?wsdl";
    public static String EAS_IMAGE_PICTURE_URL_TAIL_VALUE_OLD = "/imageWS/services/ImageService.asmx?wsdl";

    @Override
    protected String _genImageNumber(Context ctx, String bosType, String billID) throws BOSException {
        String imageNumber = null;
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
            bosType = uuidPK.getObjectType().toString();
            billImageMapInfo = new BillImageMapInfo();
            billImageMapInfo.setBosType(bosType);
            billImageMapInfo.setBillID(billID);
            Map<String, String> map = this.generateImageNumber(ctx, bosType, billID, null);
            imageNumber = map.get("imageNumber");
            billImageMapInfo.setImageNumber(imageNumber);
            billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            billImageMapInfo.setSimpleName(map.get("billNumber"));
            boolean enableMultiImage = Configure.enableMultiImage(ctx);
            if (enableMultiImage) {
                billImageMapInfo.setImageSysId(map.get("imageSysId"));
            }
            billImageMap.addnew((CoreBaseInfo)billImageMapInfo);
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                this.noticImageSysCreateScanJob(ctx, billImageMapInfo);
            } else if ("FPY".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type")) || "XH".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                final BillImageMapInfo finalBillImageMapInfo = billImageMapInfo;
                final Context ctxx = ctx;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BillImageFacadeControllerBean.this.noticImageSysCreateScanJob(ctxx, finalBillImageMapInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }).start();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageNumber;
    }

    protected String getImageSysId(Context ctx, String bosType, IObjectValue billValue) throws BOSException, EASBizException {
        return MultiImageManager.getImageSysId(ctx, bosType, billValue);
    }

    protected Map<String, String> generateImageNumber(Context ctx, String bosType, String billID, String billNumber) throws BOSException {
        if (this.billNum_ImageMap != null) {
            return this.billNum_ImageMap;
        }
        boolean enableMultiImage = Configure.enableMultiImage(ctx);
        String imageNumber = null;
        String imageSysId = "";
        BOSObjectType type = BOSObjectType.create((String)bosType);
        try {
            IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billID));
            if (billValue != null && billValue.get("number") != null) {
                if (StringUtils.isEmpty((String)billNumber)) {
                    billNumber = billValue.get("number").toString();
                }
                if (enableMultiImage) {
                    imageSysId = this.getImageSysId(ctx, bosType, billValue);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String billTypeCode = null;
        String imagePrefix = null;
        Map billShortCodeMap = null;
        if (enableMultiImage) {
            imagePrefix = MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.prefix");
            String billShortCode = MultiImageConfig.getPropertiesValue(ctx, imageSysId, "billshortcode");
            billShortCodeMap = WSSCImageUtils.getBillShortCodeMap(ctx, billShortCode);
        } else {
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            imagePrefix = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "imagePrefix");
            billShortCodeMap = WebServiceConfig.getBillShortCodeMap(ctx, sscNumber);
        }
        if (StringUtils.isEmpty((String)imagePrefix)) {
            imagePrefix = "";
        }
        billTypeCode = (billTypeCode = (String)billShortCodeMap.get(bosType)) == null ? "" : billTypeCode;
        String billNum = "";
        try {
            billNum = BillImageFacadeFactory.getLocalInstance(ctx).transformBillNumber(billNumber);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        imageNumber = imagePrefix + billTypeCode + billNum;
        this.billNum_ImageMap = new HashMap<String, String>();
        this.billNum_ImageMap.put("billNumber", billNumber);
        this.billNum_ImageMap.put("imageNumber", imageNumber);
        this.billNum_ImageMap.put("imagePrefix", imagePrefix);
        if (enableMultiImage) {
            this.billNum_ImageMap.put("imageSysId", imageSysId);
        }
        return this.billNum_ImageMap;
    }

    @Override
    protected String _getImageNumber(Context ctx, String bosType, String billID) throws BOSException {
        try {
            return this._createBillImageMapInfo(ctx, bosType, billID, null);
        }
        catch (EASBizException e) {
            logger.error((Object)("_getImageNumber error billId = " + billID + " bosType = " + bosType), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _updateImageState(Context ctx, String bosType, String billID, ImageStateEnum imageState) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)SafeFilterUtils.vaildLog(msg));
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        billImageMapInfo.setImageState(imageState);
        try {
            billImageMap.update((IObjectPK)new ObjectUuidPK(billImageMapInfo.getId()), (CoreBaseInfo)billImageMapInfo);
            if (!StringUtils.isEmpty((String)billImageMapInfo.getExtendBillID())) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fextendbillid", billImageMapInfo.getExtendBillID());
                map.put("fimagestate", imageState.getValue());
                logger.error((Object)("ready to syn,params =" + map.toString()));
                ImageStateSynFactory.getHelperInstance(ctx, billImageMapInfo.getExtendName()).synImageStateTriggerUpdate(ctx, map);
            }
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ImageStateEnum _getImageState(Context ctx, String bosType, String billID) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg.toString());
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return billImageMapInfo.getImageState();
    }

    @Override
    protected String _getImageURL(Context ctx, String bosType, String billID) throws BOSException {
        String imageUrl = "";
        try {
            imageUrl = this._getImageURL(ctx, billID, false);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageUrl;
    }

    @Override
    protected String _updateImageURL(Context ctx, String bosType, String billID) throws BOSException {
        return this._updateImageURL(ctx, billID, false);
    }

    @Override
    protected SSCUnitInfo _getSscUnit(Context ctx, String bosType, String billID) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add("*");
        selectorColl.add("sscUnit.*");
        view.setSelector(selectorColl);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw null;
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return billImageMapInfo.getSscUnit();
    }

    @Override
    protected String _getBillIDbyImageNo(Context ctx, String imageNo) throws BOSException {
        String billID = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNo));
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItem);
        view.setSorter(sorterItemCollection);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "imageNo: " + imageNo + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        for (int i = 0; i < billImageMapCollection.size(); ++i) {
            billImageMapInfo = billImageMapCollection.get(i);
            billID = billImageMapInfo.getBillID();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            BOSUuid uuid = BOSUuid.read((String)billID);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            if (iDynamicObject.exists(uuid.getType(), (IObjectPK)pk)) break;
            billImageMapInfo.setDescription("\u5173\u8054\u7684\u5355\u636eID\u4e0d\u5b58\u5728!");
            try {
                billImageMap.update((IObjectPK)pk, (CoreBaseInfo)billImageMapInfo);
            }
            catch (Exception e) {
                logger.error((Object)"update billImageMap's description exception,Ignore this exception!", (Throwable)e);
            }
            if (i != billImageMapCollection.size() - 1) continue;
            String msg = "imageNo: " + imageNo + " not exist valid billID.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        return billID;
    }

    @Override
    protected String _getScanHomeUrl(Context ctx, String personId, String location, boolean allowShowAnnotation, boolean allowHideMask, boolean allowEditAnnotationMask, String language) throws BOSException, EASBizException {
        String scanHomeUrl = null;
        try {
            NoticeImageSys2getScanHomeInfo scanHomeInfo = new NoticeImageSys2getScanHomeInfo();
            scanHomeInfo.setPersonId(personId);
            scanHomeInfo.setScanLocation(location);
            scanHomeInfo.setAllowShowAnnotation(allowShowAnnotation);
            scanHomeInfo.setAllowHideMask(allowHideMask);
            scanHomeInfo.setAllowEditAnnotationMask(allowEditAnnotationMask);
            scanHomeInfo.setLanguage(language);
            scanHomeUrl = this._getScanHomeUrl(ctx, scanHomeInfo);
        }
        catch (ImageSystemException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u626b\u63cf\u9996\u9875\u51fa\u73b0\u5f02\u5e38\uff01" + e), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return scanHomeUrl;
    }

    @Override
    protected String _getScanHomeUrl(Context ctx, NoticeImageSys2getScanHomeInfo scanHomeInfo) throws BOSException, EASBizException {
        String scanHomeUrl = null;
        try {
            if (Configure.enableMultiImage(ctx)) {
                String imageNO = scanHomeInfo.getBarCode();
                if ("TCZT".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, imageNO, "image.system.type"))) {
                    scanHomeInfo.setPersonId(ctx.getCaller() + "");
                }
                return NoticeImageSysFactory_New.getInstance(ctx, imageNO).getScanHomeUrl(scanHomeInfo);
            }
            if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, "image.system.type"))) {
                scanHomeInfo.setPersonId(ctx.getCaller() + "");
            }
            scanHomeUrl = NoticeImageSysFactory.getInstance().getScanHomeUrl(scanHomeInfo);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u626b\u63cf\u9996\u9875\u51fa\u73b0\u5f02\u5e38\uff01" + e), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
        return scanHomeUrl;
    }

    @Override
    protected String _getImageFlowURL(Context ctx, String billID) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        String bosType = uuidPK.getObjectType().toString();
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        String imageNumber = billImageMapInfo.getImageNumber();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            imageURL = this.wsInvokeGetImageFlowUrl(ctx, imageNumber, personId, billID);
        }
        catch (AEServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw new BOSException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageURL;
    }

    private String wsInvokeGetImageFlowUrl(Context ctx, String imageNumber, String personId, String billId) throws RemoteException, ServiceException, Exception {
        GuosenParamsHelper guosenParamsHelper = new GuosenParamsHelper();
        Params params = guosenParamsHelper.buildBillFlowPathParams(imageNumber, personId);
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
        GuosenWSProxy proxy = new GuosenWSProxy(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image"));
        List<ResultMsg> list = proxy.invokeWS(params);
        return list.get(0).getSuccess();
    }

    @Override
    protected String _getImageURL(Context ctx, String billID, boolean isCanRescan) throws BOSException, EASBizException {
        if (!BOSUuid.isValid((String)billID, (boolean)true)) {
            logger.error((Object)("billID:" + billID + " not exists"));
            throw new ImageSystemException(ImageSystemException.IMAGENO_INVALIDBILL);
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        String bosType = uuidPK.getObjectType().toString();
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            throw new ImageSystemException(ImageSystemException.IMAGEMAP_NODATA);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        if (this.isShowImage(billImageMapInfo.getImageState())) {
            imageURL = this._updateImageURL(ctx, billID, isCanRescan);
        }
        return imageURL;
    }

    private boolean isShowImage(ImageStateEnum imageState) {
        return ImageStateEnum.HAS_IMAGE.equals((Object)imageState) || ImageStateEnum.REUPLOAD_IMAGE.equals((Object)imageState) || ImageStateEnum.RESCAN_IAMGE.equals((Object)imageState);
    }

    private boolean isHasImageInfoInImageSys(ImageStateEnum imageState) {
        return !ImageStateEnum.NO_IMAGE.equals((Object)imageState);
    }

    @Override
    protected String _updateImageURL(Context ctx, String billID, boolean isCanRescan) throws BOSException {
        logger.error((Object)("billID:" + billID + ";isCanRescan:" + isCanRescan));
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        String bosType = uuidPK.getObjectType().toString();
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        if (this.isShowImage(billImageMapInfo.getImageState())) {
            String imageNumber = billImageMapInfo.getImageNumber();
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String personName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            String viewUser = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            logger.error((Object)("\u83b7\u53d6\u5f71\u50cfURL\u7684\u5165\u53c2\u4e3a\uff1apersonID=" + personId + "imageNumber=" + imageNumber + "allowShowAnnotation=true,allowHideMask=true,allowEditAnnotationMask=true,language=zh-CN"));
            try {
                NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
                viewPhotoInfo.setBarCode(imageNumber);
                viewPhotoInfo.setAllowRescan(isCanRescan);
                viewPhotoInfo.setViewPersonId(personId);
                viewPhotoInfo.setViewPersonName(personName);
                viewPhotoInfo.setViewUserNumber(viewUser);
                viewPhotoInfo.setCtx(ctx);
                String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
                if (Configure.enableMultiImage(ctx)) {
                    BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNumber);
                    imageURL = NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).viewPhoto(viewPhotoInfo);
                    logger.error((Object)("\u5f71\u50cfURL " + imageURL));
                } else {
                    imageURL = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhoto(viewPhotoInfo);
                    logger.error((Object)("\u5f71\u50cfURL " + imageURL));
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return imageURL;
    }

    @Override
    protected String _saveBillImages(Context ctx, List billImageList) throws BOSException {
        if (Configure.enableMultiImage(ctx)) {
            return this.synVoucherMulitImage(ctx, billImageList);
        }
        logger.error((Object)("VoucherFile saveBillImages start : voucherCount = " + billImageList.size()));
        NoticeImageSysHelper helper = null;
        Iterator itor = billImageList.iterator();
        NoticeImageSysSynVoucherInfo synVoucherInfo = new NoticeImageSysSynVoucherInfo();
        synVoucherInfo.setCtx(ctx);
        String imageNumber = "";
        HashMap result = new HashMap();
        HashMap<String, String> successMapResult = new HashMap<String, String>();
        HashMap<String, String> failMapResult = new HashMap<String, String>();
        HashSet<String> idSet = new HashSet<String>();
        while (itor.hasNext()) {
            Object object = itor.next();
            if (!(object instanceof BillImageInfo)) {
                String message = "\u4f20\u9012\u7684\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01object:" + object;
                throw new BOSException(message);
            }
            BillImageInfo billImageInfo = (BillImageInfo)object;
            idSet.add(billImageInfo.getBillId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("billID", idSet, CompareType.INCLUDE));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(view);
        HashMap<String, BillImageMapInfo> imagemap = new HashMap<String, BillImageMapInfo>();
        if (billImageMapCollection != null) {
            imagemap = new HashMap(billImageMapCollection.size());
            for (int i = 0; i < billImageMapCollection.size(); ++i) {
                imagemap.put(billImageMapCollection.get(i).getBillID(), billImageMapCollection.get(i));
            }
        }
        for (Object object : billImageList) {
            BillImageInfo billImageInfo = (BillImageInfo)object;
            if (billImageInfo.getImageMap().size() == 0) {
                logger.error((Object)("Error_saveBillImages:imageCount=0 voucherID=" + billImageInfo.getBillId()));
                continue;
            }
            imageNumber = this.getBillImageNumber(ctx, null, billImageInfo, imagemap);
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billImageInfo.getBillId());
            if (helper == null) {
                helper = NoticeImageSysFactory.getInstance(ctx, sscNumber);
            }
            billImageInfo.setImageNumber(imageNumber);
            NoticeImageSysUploadInfo uploadInfo = new NoticeImageSysUploadInfo();
            uploadInfo.setCtx(ctx);
            uploadInfo.setBillImageInfo(billImageInfo);
            String isSuccess = "-2";
            try {
                isSuccess = helper.imageUpload(uploadInfo);
            }
            catch (ImageSystemException e) {
                failMapResult.put(billImageInfo.getBillId(), StringUtils.isEmpty((String)e.getMessage()) ? "null" : e.getMessage().substring(0, 500));
                logger.error((Object)"\u51ed\u8bc1\u4e0a\u4f20\u5f71\u50cf\u5f02\u5e38!", (Throwable)((Object)e));
            }
            if (!SUCCESS.equals(isSuccess)) {
                if (!failMapResult.containsKey(billImageInfo.getBillId())) {
                    failMapResult.put(billImageInfo.getBillId(), "");
                }
                logger.error((Object)"\u51ed\u8bc1\u4e0a\u4f20\u5f71\u50cf\u5931\u8d25!\u65e0\u89c6,\u7ee7\u7eed\u5faa\u73af");
                continue;
            }
            successMapResult.put(billImageInfo.getBillId(), "");
            synVoucherInfo.getBillImageInfos().add(billImageInfo);
        }
        try {
            if (helper != null) {
                String s = helper.synVoucherInfo(synVoucherInfo);
                successMapResult.put("synVoucher", s);
            } else {
                logger.error((Object)("helper\u4e3a\u7a7a\u8bf4\u660e\u4f20\u8fdb\u6765\u4fe1\u606f\u4e3a\u7a7a!billImageList:" + billImageList));
            }
        }
        catch (ImageSystemException e) {
            logger.error((Object)("\u51ed\u8bc1\u5f52\u6863,\u540c\u6b65\u51ed\u8bc1\u4fe1\u606fImageSystemException\u5f02\u5e38,\u629b\u51fa,\u8f93\u51fa\u6808\u5806:" + (Object)((Object)e)), (Throwable)((Object)e));
            throw new BOSException((Throwable)((Object)e));
        }
        result.put("success", successMapResult);
        result.put("fail", failMapResult);
        logger.error((Object)"VoucherFile saveBillImages end ");
        logger.error((Object)JSONUtils.convertObjectToJson((Context)ctx, result));
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private String synVoucherMulitImage(Context ctx, List billImageList) throws BOSException {
        logger.error((Object)("VoucherFile synVoucherMulitImage start : voucherCount = " + billImageList.size()));
        NoticeImageSysHelper helper_new = null;
        HashMap result = new HashMap();
        HashMap<String, String> successMapResult = new HashMap<String, String>();
        HashMap<String, String> failMapResult = new HashMap<String, String>();
        HashMap<String, NoticeImageSysSynVoucherInfo> cacheMap = new HashMap<String, NoticeImageSysSynVoucherInfo>();
        Iterator itor = billImageList.iterator();
        NoticeImageSysSynVoucherInfo synVoucherInfo = new NoticeImageSysSynVoucherInfo();
        String imageNumber = "";
        while (itor.hasNext()) {
            BillImageMapInfo info;
            Object object = itor.next();
            if (!(object instanceof BillImageInfo)) {
                String message = "\u4f20\u9012\u7684\u53c2\u6570\u7c7b\u578b\u9519\u8bef\uff01object:" + object;
                throw new BOSException(message);
            }
            BillImageInfo billImageInfo = (BillImageInfo)object;
            if (billImageInfo.getImageMap().size() == 0) {
                logger.error((Object)("Error_synVoucherMulitImage:imageCount=0 voucherID=" + billImageInfo.getBillId()));
                continue;
            }
            imageNumber = this.getBillImageNumber(ctx, null, billImageInfo);
            try {
                info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNumber);
            }
            catch (EASBizException e1) {
                logger.error((Object)(" synVoucherMulitImage" + (Object)((Object)e1)));
                throw new BOSException((Throwable)e1);
            }
            helper_new = NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId());
            billImageInfo.setImageNumber(imageNumber);
            NoticeImageSysUploadInfo uploadInfo = new NoticeImageSysUploadInfo();
            uploadInfo.setBillImageInfo(billImageInfo);
            String isSuccess = "-2";
            try {
                isSuccess = helper_new.imageUpload(uploadInfo);
            }
            catch (ImageSystemException e) {
                failMapResult.put(billImageInfo.getBillId(), StringUtils.isEmpty((String)e.getMessage()) ? "null" : e.getMessage().substring(0, 500));
                logger.error((Object)"\u51ed\u8bc1\u4e0a\u4f20\u5f71\u50cf\u5f02\u5e38!", (Throwable)((Object)e));
            }
            if (!SUCCESS.equals(isSuccess)) {
                if (!failMapResult.containsKey(billImageInfo.getBillId())) {
                    failMapResult.put(billImageInfo.getBillId(), "");
                }
                logger.error((Object)"\u51ed\u8bc1\u4e0a\u4f20\u5f71\u50cf\u5931\u8d25!\u65e0\u89c6,\u7ee7\u7eed\u5faa\u73af");
                continue;
            }
            successMapResult.put(billImageInfo.getBillId(), "");
            if (cacheMap.containsKey(info.getImageSysId())) {
                ((NoticeImageSysSynVoucherInfo)cacheMap.get(info.getImageSysId())).getBillImageInfos().add(billImageInfo);
                continue;
            }
            synVoucherInfo = new NoticeImageSysSynVoucherInfo();
            synVoucherInfo.getBillImageInfos().add(billImageInfo);
            cacheMap.put(info.getImageSysId(), synVoucherInfo);
        }
        try {
            Set imageSysSet = cacheMap.keySet();
            for (String imageSysId : imageSysSet) {
                NoticeImageSysSynVoucherInfo nsvInfo = (NoticeImageSysSynVoucherInfo)cacheMap.get(imageSysId);
                if (helper_new == null) {
                    logger.error((Object)"this is null although is never happen...maybe,if you see this,please check code");
                    successMapResult.put("synVoucher", "");
                    continue;
                }
                String s = helper_new.synVoucherInfo(nsvInfo);
                successMapResult.put("synVoucher", s);
            }
        }
        catch (ImageSystemException e) {
            logger.error((Object)("synVoucherMulitImage \u51ed\u8bc1\u5f52\u6863,\u540c\u6b65\u51ed\u8bc1\u4fe1\u606fImageSystemException\u5f02\u5e38,\u629b\u51fa,\u8f93\u51fa\u6808\u5806:" + (Object)((Object)e)), (Throwable)((Object)e));
            throw new BOSException((Throwable)((Object)e));
        }
        result.put("success", successMapResult);
        result.put("fail", failMapResult);
        logger.error((Object)" synVoucherMulitImage VoucherFile saveBillImages end ");
        logger.error((Object)JSONUtils.convertObjectToJson((Context)ctx, result));
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    @Override
    protected boolean _deleteBillImage(Context ctx, String imageNumber, String billType, String userAccount, String remark) throws BOSException {
        boolean result = true;
        String imageSysId = null;
        String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageNumber);
        try {
            String ip = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.ip");
            String port = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.port");
            if (!StringUtils.isEmpty((String)ip) && !StringUtils.isEmpty((String)port)) {
                BillImageMapInfo info;
                boolean isConnectImage = false;
                IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                entityViewInfo.setFilter(filter);
                BillImageMapCollection billImageMap = iBillImageMap.getBillImageMapCollection(entityViewInfo);
                if (billImageMap != null && billImageMap.size() != 0 && !(info = billImageMap.get(0)).getImageState().getValue().equals("0")) {
                    isConnectImage = true;
                }
                logger.error((Object)("isConnectImage\uff1a" + isConnectImage));
                if (isConnectImage) {
                    NoticeImageSysDeleteInfo deleteInfo = new NoticeImageSysDeleteInfo();
                    deleteInfo.setBarCode(imageNumber);
                    deleteInfo.setBillType(billType);
                    deleteInfo.setUserName(userAccount);
                    deleteInfo.setMessage(remark);
                    NoticeImageSysHelper helper = null;
                    if (Configure.enableMultiImage(ctx)) {
                        imageSysId = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapInfo("where imageNumber = '" + imageNumber + "'").getImageSysId();
                        helper = NoticeImageSysFactory_New.getInstance(ctx, imageSysId);
                    } else {
                        helper = NoticeImageSysFactory.getInstance(ctx, sscNumber);
                    }
                    ImageLogUtil.writeInvokeLog(ctx, imageNumber, ImageOperation.destroyImage, deleteInfo.toString());
                    result = SUCCESS.equals(helper.deleteImage(deleteInfo));
                    if (result) {
                        iBillImageMap.delete(filter);
                    }
                }
            }
        }
        catch (Exception e) {
            result = false;
            logger.error((Object)("_deleteBillImage failure" + imageSysId));
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected String _createImagePaths(Context ctx, String[] imageNumber, String billType, String userAccount, String userName) throws BOSException {
        return this._createImagePaths(ctx, imageNumber, billType, userAccount, userName, false);
    }

    private String _createImagePaths(Context ctx, String[] imageNumber, String billType, String userAccount, String userName, boolean isApp) throws BOSException {
        int i;
        EntityViewInfo viewInfo;
        try {
            HashSet<String> imageNumberSet = new HashSet<String>();
            for (String image : imageNumber) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)image)) continue;
                imageNumberSet.add(image);
            }
            viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("imageNumber", imageNumberSet, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            viewInfo.setSelector(sic);
            BillImageMapCollection collection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(viewInfo);
            StringBuilder builder = new StringBuilder();
            for (i = 0; collection != null && i < collection.size(); ++i) {
                if (ImageStateEnum.HAS_IMAGE.equals((Object)collection.get(i).getImageState()) || ImageStateEnum.REUPLOAD_IMAGE.equals((Object)collection.get(i).getImageState())) {
                    builder.append(collection.get(i).getImageNumber()).append(";");
                    continue;
                }
                logger.error((Object)"_createImagePaths imageNumber has no image");
            }
            if (builder.length() > 0) {
                builder.setLength(builder.length() - 1);
                imageNumber = builder.toString().split(";");
            } else {
                logger.error((Object)"builder is null");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String result = "";
        try {
            viewInfo = new EntityViewInfo();
            viewInfo.setFilter(new FilterInfo());
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("imageNumber", new HashSet(Arrays.asList((Object[])imageNumber)), CompareType.INCLUDE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("imageState", (Object)ImageStateEnum.NO_IMAGE, CompareType.NOTEQUALS));
            BillImageMapCollection coll = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(viewInfo);
            if (coll.size() == 0) {
                throw new ImageSystemException(ImageSystemException.IMAGEMAP_NODATA);
            }
            NoticeImageSysViewInfo[] viewPhotoInfos = new NoticeImageSysViewInfo[coll.size()];
            String viewPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            for (int i2 = 0; i2 < coll.size(); ++i2) {
                viewPhotoInfos[i2] = new NoticeImageSysViewInfo();
                viewPhotoInfos[i2].setBarCode(coll.get(i2).getImageNumber());
                viewPhotoInfos[i2].setViewPersonName(userName);
                viewPhotoInfos[i2].setViewPersonId(viewPersonId);
                viewPhotoInfos[i2].setViewUserNumber(userAccount);
                viewPhotoInfos[i2].setType(billType);
                viewPhotoInfos[i2].setCtx(ctx);
            }
            NoticeImageSysViewOnPhoneInfo[] viewPhotoInfosOnP = new NoticeImageSysViewOnPhoneInfo[coll.size()];
            for (i = 0; i < viewPhotoInfosOnP.length; ++i) {
                viewPhotoInfosOnP[i] = new NoticeImageSysViewOnPhoneInfo();
                viewPhotoInfosOnP[i].setBarCode(coll.get(i).getImageNumber());
                viewPhotoInfosOnP[i].setViewPersonName(userName);
                viewPhotoInfosOnP[i].setViewPersonId(viewPersonId);
                viewPhotoInfosOnP[i].setViewUserNumber(userAccount);
                viewPhotoInfosOnP[i].setType(billType);
                viewPhotoInfosOnP[i].setCtx(ctx);
            }
            if (Configure.enableMultiImage(ctx)) {
                String imageSysId = coll.get(0).getImageSysId();
                for (int i3 = 1; i3 < coll.size(); ++i3) {
                    if (imageSysId.equals(coll.get(i3).getImageSysId())) continue;
                    throw new ImageSystemException(ImageSystemException.IMAGE_TOMANYTYPE);
                }
                logger.error((Object)("imageSysId:" + imageSysId));
                if (isApp) {
                    logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\uff0cviewPhotoInfosOnP\uff1a" + viewPhotoInfosOnP.toString()));
                    result = NoticeImageSysFactory_New.getInstance(ctx, imageSysId).viewPhotosOnPhone(viewPhotoInfosOnP);
                } else {
                    logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\uff0cviewPhotoInfos\uff1a" + viewPhotoInfos.toString()));
                    result = NoticeImageSysFactory_New.getInstance(ctx, imageSysId).viewPhotos(viewPhotoInfos);
                }
                logger.error((Object)("NoticeImageSysFactory_New viewPhotos result[" + result + "]"));
            } else {
                String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, this.getBillIDbyImageNo(ctx, imageNumber[0]));
                logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\uff0csscNumber:" + sscNumber));
                if (isApp) {
                    logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\uff0cviewPhotoInfosOnP\uff1a" + viewPhotoInfosOnP.toString()));
                    result = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhotosOnPhone(viewPhotoInfosOnP);
                } else {
                    logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\uff0cviewPhotoInfos\uff1a" + viewPhotoInfos.toString()));
                    result = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhotos(viewPhotoInfos);
                }
                logger.error((Object)("\u51ed\u8bc1\u67e5\u770b\u5f71\u50cf\u5730\u5740\uff1a" + result));
            }
        }
        catch (ImageSystemException e1) {
            logger.error((Object)("\u6279\u91cf\u8c03\u9605\u5f71\u50cf\u5f02\u5e38!" + (Object)((Object)e1)));
            throw new BOSException((Throwable)((Object)e1));
        }
        catch (Exception e) {
            logger.error((Object)("\u6279\u91cf\u8c03\u9605\u5f71\u50cf\u5f02\u5e38!" + e));
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean _deleteBillImageByBillID(Context ctx, String billId, String billType, String userAccount, String remark) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
        String bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("imageNumber"));
        view.setSelector(sic);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            logger.error((Object)"_deleteBillImageByBillID cannot getBillImageMapCollection by billId ");
            return false;
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return this._deleteBillImage(ctx, billImageMapInfo.getImageNumber(), billType, userAccount, remark);
    }

    @Override
    protected String _createImagePathsByBillID(Context ctx, Set idSet, String billType, String userAccount, String userName) throws BOSException {
        String result = null;
        if (idSet == null || idSet.size() == 0) {
            logger.error((Object)"_createImagePathsByBillID param idSet is null");
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)idSet, CompareType.INCLUDE));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            logger.error((Object)"_createImagePathsByBillID cannot getBillImageMapCollection by idSet ");
        } else {
            String[] imageNumber = new String[billImageMapCollection.size()];
            for (int i = 0; i < billImageMapCollection.size(); ++i) {
                imageNumber[i] = billImageMapCollection.get(i).getImageNumber();
            }
            result = this._createImagePaths(ctx, imageNumber, billType, userAccount, userName);
        }
        return result;
    }

    @Override
    protected String _destroyBillImage(Context ctx, String billID) throws BOSException {
        String result = SUCCESS;
        ImageStateEnum imageStateEnum = this.getImageState(ctx, null, billID);
        if (imageStateEnum == null) {
            logger.info((Object)("\u5355\u636e\uff1a" + SafeFilterUtils.vaildLog(billID) + " \u4e0d\u5b58\u5728\u5f71\u50cf\u72b6\u6001\u3002"));
            result = "0";
            return result;
        }
        String imageNo = this._getImageNumber(ctx, null, billID);
        try {
            result = WebServiceUtil.getImageServiceInstance().destroyBillImage(imageNo);
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            ImageStateParamInfo imageStateParamInfo = new ImageStateParamInfo();
            imageStateParamInfo.setImageNo(imageNo);
            BaseImageList baseList = new BaseImageList();
            baseList.addImageList(imageStateParamInfo);
            result = imageHandler.invokeTaskCenterServiceDestoryJob(ctx, baseList);
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = "0";
            return result;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = "0";
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result = "0";
            return result;
        }
        this.updateImageState(ctx, null, billID, ImageStateEnum.NO_IMAGE);
        return result;
    }

    private String getBillImageNumber(Context ctx, String bosType, BillImageInfo billImageInfo, Map<String, BillImageMapInfo> imagemap) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billImageInfo.getBillId());
        bosType = uuidPK.getObjectType().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billImageInfo.getBillId()));
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            if (imagemap.containsKey(billImageInfo.getBillId())) {
                billImageMap.delete(filter);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u51ed\u8bc1\u7535\u5b50\u5f52\u6863\u5b58\u5728\u751f\u6210\u5f71\u50cf\u6620\u5c04\u4fe1\u606f--\u5220\u9664\u5386\u53f2\u6620\u5c04\u4fe1\u606f\u9519\u8bef" + e), (Throwable)e);
            throw new BOSException("[\u51ed\u8bc1\u7535\u5b50\u5f52\u6863\u5b58\u5728\u751f\u6210\u5f71\u50cf\u6620\u5c04\u4fe1\u606f--\u5220\u9664\u5386\u53f2\u6620\u5c04\u4fe1\u606f\u9519\u8bef]" + e);
        }
        return this.genBillImageNumber(ctx, bosType, billImageInfo);
    }

    private String getBillImageNumber(Context ctx, String bosType, BillImageInfo billImageInfo) throws BOSException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(billImageInfo.getBillId());
        bosType = uuidPK.getObjectType().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billImageInfo.getBillId()));
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            if (billImageMap.exists(filter)) {
                billImageMap.delete(filter);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u51ed\u8bc1\u7535\u5b50\u5f52\u6863\u5b58\u5728\u751f\u6210\u5f71\u50cf\u6620\u5c04\u4fe1\u606f--\u5220\u9664\u5386\u53f2\u6620\u5c04\u4fe1\u606f\u9519\u8bef" + e), (Throwable)e);
            throw new BOSException("[\u51ed\u8bc1\u7535\u5b50\u5f52\u6863\u5b58\u5728\u751f\u6210\u5f71\u50cf\u6620\u5c04\u4fe1\u606f--\u5220\u9664\u5386\u53f2\u6620\u5c04\u4fe1\u606f\u9519\u8bef]" + e);
        }
        return this.genBillImageNumber(ctx, bosType, billImageInfo);
    }

    private String genBillImageNumber(Context ctx, String bosType, BillImageInfo billImageInfo) throws BOSException {
        String imageNumber = null;
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            ObjectUuidPK uuidPK = new ObjectUuidPK(billImageInfo.getBillId());
            bosType = uuidPK.getObjectType().toString();
            billImageMapInfo = new BillImageMapInfo();
            billImageMapInfo.setBosType(bosType);
            billImageMapInfo.setBillID(billImageInfo.getBillId());
            Map model = billImageInfo.getModel();
            if (model.get("imageNumber") != null && !StringUtils.isEmpty((String)model.get("imageNumber").toString())) {
                imageNumber = model.get("imageNumber").toString();
            } else {
                String imagePrefix = this.generateImageNumber(ctx, bosType, billImageInfo.getBillId(), null).get("imagePrefix");
                String companyNumber = model.get("companyNumber").toString();
                String periodNumber = model.get("periodNumber").toString();
                String voucherType = model.get("voucherType").toString();
                String voucherNo = model.get("VoucherNo").toString();
                imageNumber = imagePrefix + companyNumber + periodNumber + voucherType + voucherNo;
            }
            billImageMapInfo.setImageNumber(imageNumber);
            billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            boolean enableMultiImage = Configure.enableMultiImage(ctx);
            if (enableMultiImage) {
                billImageMapInfo.setImageSysId(this.generateImageNumber(ctx, bosType, billImageInfo.getBillId(), null).get("imageSysId"));
            }
            billImageMap.addnew((CoreBaseInfo)billImageMapInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageNumber;
    }

    @Override
    protected String _createBillImageMapInfo(Context ctx, String bosType, String billID, String billNumber) throws BOSException, EASBizException {
        IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        String imageNumber = null;
        try {
            ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
            bosType = uuidPK.getObjectType().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            BillImageMapCollection billImageMapCollection = iBillImageMap.getBillImageMapCollection(view);
            Map<String, String> map = this.generateImageNumber(ctx, bosType, billID, billNumber);
            if (billImageMapCollection != null && billImageMapCollection.size() > 0) {
                BillImageMapInfo billImageMapInfo = billImageMapCollection.get(0);
                String newImageNumber = map.get("imageNumber");
                if (billNumber != null && !billImageMapInfo.getImageNumber().contains(BillImageFacadeFactory.getLocalInstance(ctx).transformBillNumber(billNumber)) && !newImageNumber.equals(billImageMapInfo.getImageNumber())) {
                    if (billImageMapInfo.getImageState() == ImageStateEnum.HAS_IMAGE || billImageMapInfo.getImageState() == ImageStateEnum.REUPLOAD_IMAGE) {
                        this.deleteImageSystemData(ctx, billID, true);
                    }
                    StringBuffer sql = new StringBuffer();
                    sql.append("update t_wsc_billimagemap set fimagenumber = '").append(newImageNumber).append("' ");
                    sql.append("where fbillid  = '").append(billID).append("'");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("update T_SSC_DynamicValue set FDinamicValue = '").append(newImageNumber).append("' ");
                    sql.append(" where FDynamicIDID = 'eeodQcKeReCFk5b8O7HqeZvLn80=' ");
                    sql.append("   and FJobIDID in (");
                    sql.append("select FID from T_SSC_Job where FBillID = '").append(billID).append("') ");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    sql = new StringBuffer();
                    sql.append("update T_SSC_DynValueHis set FDinamicValue = '").append(newImageNumber).append("' ");
                    sql.append(" where FDynamicIDID = 'eeodQcKeReCFk5b8O7HqeZvLn80=' ");
                    sql.append("   and FJobIDID in (");
                    sql.append("select FID from T_SSC_JobHis where FBillID = '").append(billID).append("') ");
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                    return newImageNumber;
                }
                return billImageMapInfo.getImageNumber();
            }
            imageNumber = map.get("imageNumber");
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
            boolean isExists = iBillImageMap.exists(filter);
            if (isExists) {
                view.setFilter(filter);
                BillImageMapCollection bimColl = iBillImageMap.getBillImageMapCollection(view);
                int size = bimColl.size();
                for (int i = 0; i < size; ++i) {
                    BillImageMapInfo bimInfo = bimColl.get(i);
                    String oldBillId = bimInfo.getBillID();
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)oldBillId)) continue;
                    try {
                        ObjectUuidPK oldUuidPK = new ObjectUuidPK(oldBillId);
                        BOSObjectType type = oldUuidPK.getObjectType();
                        if (iDynamicObject.exists(type, (IObjectPK)new ObjectUuidPK(oldBillId))) {
                            if (bimInfo.getImageState() != null && ImageStateEnum.NO_IMAGE != bimInfo.getImageState()) {
                                throw new WSSCException(WSSCException.IMAGENUMBER_DUPLICATE, new Object[]{imageNumber});
                            }
                            logger.error((Object)"wssc--\u5f71\u50cf\u6620\u5c04\u8868\uff0c\u5f71\u50cf\u7f16\u7801\u91cd\u590d...");
                            String sql = "SELECT 1 FROM t_wsc_billimagemap where FBOSTYPE = ? and FIMAGESTATE != ?";
                            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{type.toString(), "0"});
                            if (!rowSet.next()) continue;
                            if (rowSet.getInt(1) == 0) {
                                logger.error((Object)("wssc--\u5f71\u50cf\u6620\u5c04\u8868\uff0c\u5f71\u50cf\u7f16\u7801\u91cd\u590d...@@...\u66f4\u65b0\u5386\u53f2\u5355\u636e\u5f71\u50cf\u6620\u5c04\u4fe1\u606f[" + oldBillId + "]"));
                                String update = "UPDATE t_wsc_billimagemap SET FIMAGENUMBER = ? WHERE FBILLID =? AND FBOSTYPE = ?";
                                DbUtil.execute((Context)ctx, (String)update, (Object[])new Object[]{type.toString() + bimInfo.getImageNumber(), oldBillId, type.toString()});
                                continue;
                            }
                            throw new WSSCException(WSSCException.IMAGENUMBER_DUPLICATE, new Object[]{imageNumber});
                        }
                        logger.error((Object)("getImageNumber_deleteData_imageNo=" + imageNumber + ",billId=" + oldBillId + ",iamgeState=" + (Object)((Object)bimInfo.getImageState())));
                        if (this.isHasImageInfoInImageSys(bimInfo.getImageState())) {
                            this.deleteSSCAndImageData(ctx, oldBillId, true);
                            continue;
                        }
                        this.deleteSSCAndImageData(ctx, oldBillId, false);
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            BillImageMapInfo billImageMapInfo = new BillImageMapInfo();
            billImageMapInfo.setBosType(bosType);
            billImageMapInfo.setBillID(billID);
            billImageMapInfo.setImageNumber(imageNumber);
            billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            billImageMapInfo.setSimpleName(map.get("billNumber"));
            String imageSysId = "";
            if (Configure.enableMultiImage(ctx)) {
                imageSysId = map.get("imageSysId");
            }
            billImageMapInfo.setImageSysId(imageSysId);
            iBillImageMap.addnew((CoreBaseInfo)billImageMapInfo);
            this.createImgScanJon(ctx, billID, billImageMapInfo, imageSysId);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageNumber;
    }

    protected void createImgScanJon(final Context ctx, String billID, final BillImageMapInfo billImageMapInfo, String imageSysId) throws BOSException, ImageSystemException {
        if (Configure.enableMultiImage(ctx)) {
            if ("TCZT".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.system.type"))) {
                this.noticImageSysCreateScanJob(ctx, billImageMapInfo);
            } else if ("FPY".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.system.type")) || "XH".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.system.type"))) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BillImageFacadeControllerBean.this.noticImageSysCreateScanJob(ctx, billImageMapInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }).start();
            }
        } else {
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                this.noticImageSysCreateScanJob(ctx, billImageMapInfo);
            } else if ("FPY".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type")) || "XH".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BillImageFacadeControllerBean.this.noticImageSysCreateScanJob(ctx, billImageMapInfo);
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                    }
                }).start();
            }
        }
    }

    private void noticImageSysCreateScanJob(Context ctx, BillImageMapInfo billImageMapInfo) throws BOSException, ImageSystemException {
        NoticeImageSysCreateJobInfo createJobInfo = new NoticeImageSysCreateJobInfo();
        createJobInfo.setBillId(billImageMapInfo.getBillID());
        createJobInfo.setBarCode(billImageMapInfo.getImageNumber());
        createJobInfo.setBillCode(billImageMapInfo.getSimpleName());
        createJobInfo.setScanType("2");
        BOSObjectType type = BOSUuid.read((String)billImageMapInfo.getBillID()).getType();
        try {
            createJobInfo.setBillType(type.toString());
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            createJobInfo.setBillTypeName(entityObjectInfo.getAlias());
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            String simpleCode = Configure.getBillOrgFiledTypeSimpleCode(ctx);
            if (!DynamicObjectFactory.getLocalInstance((Context)ctx).exists(type, (IObjectPK)new ObjectUuidPK(billImageMapInfo.getBillID()))) {
                for (int i = 0; i < 20; ++i) {
                    Thread.sleep(1000L);
                    if (DynamicObjectFactory.getLocalInstance((Context)ctx).exists(type, (IObjectPK)new ObjectUuidPK(billImageMapInfo.getBillID()))) break;
                }
            }
            if (!DynamicObjectFactory.getLocalInstance((Context)ctx).exists(type, (IObjectPK)new ObjectUuidPK(billImageMapInfo.getBillID()))) {
                logger.error((Object)"20s delay ,bill info not exits; fpy /imgsys/bill/signPost/erpBillPush error");
                ImageLogInfo logInfo = new ImageLogInfo();
                logInfo.setImageNo(billImageMapInfo.getImageNumber());
                logInfo.setParam("billId:" + billImageMapInfo.getBillID() + ";imageNumber:" + billImageMapInfo.getImageNumber());
                logInfo.setSuccess(false);
                logInfo.setException("20s delay ,bill info not exits; fpy /imgsys/bill/signPost/erpBillPush error");
                ImageLogFactory.getLocalInstance(ctx).writeLog(logInfo);
                return;
            }
            IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billImageMapInfo.getBillID()));
            BillFiledOrgTypeInfo info = WSSCImageUtils.getBillFiledOrgType(ctx, type.toString(), billValue, simpleCode);
            FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getOrgFiledValue()));
            if (fullOrgUnitInfo != null && fullOrgUnitInfo.getNumber() != null) {
                createJobInfo.setOrgNo(fullOrgUnitInfo.getNumber());
                createJobInfo.setOrgName(fullOrgUnitInfo.getName());
            }
            String creatorCode = Configure.getBillImageCachParam(ctx, "creatorCode", "4A44F49F!creator");
            String creatorId = WSSCImageUtils.getBillCreatorID(ctx, billValue, creatorCode, "creator");
            Map<String, String> map = WSSCImageUtils.getPhoneAndEmailAndName(ctx, creatorId);
            createJobInfo.setUserNo(creatorId);
            createJobInfo.setUserName(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("createName")) ? "" : map.get("createName"));
            createJobInfo.setUserNumber(org.apache.commons.lang.StringUtils.isEmpty((String)map.get("createNumber")) ? "" : map.get("createNumber"));
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)createJobInfo.getUserName())) {
                createJobInfo.setUserNo(this.getPersonIdFromCTX(ctx));
                createJobInfo.setUserName(ContextUtil.getCurrentUserInfo((Context)ctx).getName());
                createJobInfo.setUserNumber(ContextUtil.getCurrentUserInfo((Context)ctx).getNumber());
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        try {
            if (Configure.enableMultiImage(ctx)) {
                logger.error((Object)(" enableMultiImage  noticImageSysCreateScanJob [" + billImageMapInfo.getImageSysId() + "]"));
                NoticeImageSysFactory_New.getInstance(ctx, billImageMapInfo.getImageSysId()).noticImageSysCreateScanJob(createJobInfo);
            } else {
                String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, this.getBillIDbyImageNo(ctx, createJobInfo.getBarCode()));
                NoticeImageSysFactory.getInstance(ctx, sscNumber).noticImageSysCreateScanJob(createJobInfo);
            }
        }
        catch (Exception e) {
            throw new ImageSystemException(ImageSystemException.NOTIC_IMAGE_CREATE_SCANJOB, e);
        }
    }

    private String getPersonIdFromCTX(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null && userInfo.getId() != null) {
            return userInfo.getId().toString();
        }
        return ctx.getCaller().toString();
    }

    @Override
    protected void _deleteSSCAndImageDataByBillID(Context ctx, String billID, boolean isImageSystem) throws BOSException {
        this.deleteSSCAndImageData(ctx, billID, isImageSystem);
    }

    private void deleteSSCAndImageData(Context ctx, String billID, boolean isImageSystem) throws BOSException {
        boolean destroyImageResult;
        logger.error((Object)("{ctx.getAIX():" + ctx.getAIS() + ",billID:" + billID + ",caller:" + ctx.getCaller() + "}"));
        if (isImageSystem && !(destroyImageResult = this.deleteImageSystemData(ctx, billID, isImageSystem))) {
            return;
        }
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
        String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createShareTaskWebServiceUrl");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billID", billID);
        JSONMap json = null;
        String param = null;
        boolean deleteSSCDataResult = false;
        try {
            json = new JSONMap(map);
            param = json.toString();
            if (WSSCUtils.isWebService(ctx, sscNumber)) {
                if (StringUtils.isEmpty((String)serviceUrl)) {
                    throw new NullPointerException("serviceUrl is null");
                }
                WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("deleteSSCDataByBillID");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                deleteSSCDataResult = (Boolean)call.invoke(new Object[]{param});
            } else {
                Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
                Object object = tMethod.invoke(null, ctx);
                Method tMethodService = object.getClass().getMethod("deleteSSCDataByBillID", String.class);
                deleteSSCDataResult = (Boolean)tMethodService.invoke(object, param);
            }
            logger.error((Object)("delete ssc :{ctx.getAIX():" + ctx.getAIS() + ",billID:" + billID + ",caller:" + ctx.getCaller() + "}deleteSSCDataResult:" + deleteSSCDataResult));
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664SSC\u6570\u636e\u5f02\u5e38\uff1aparam = " + param), (Throwable)e);
        }
        if (!deleteSSCDataResult) {
            return;
        }
        WSSCUtils.deleteWSSCAndWFRDataByBillID(ctx, billID);
    }

    private boolean deleteImageSystemData(Context ctx, String billID, boolean isImageSystem) {
        boolean destroyImageResult = false;
        String barCode = null;
        try {
            BillImageMapInfo info;
            try {
                info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByBillID(), billID);
                if (info == null || ImageStateEnum.NO_IMAGE.equals((Object)info.getImageState())) {
                    return true;
                }
                barCode = info.getImageNumber();
            }
            catch (EASBizException e) {
                logger.error((Object)e, (Throwable)e);
                return true;
            }
            String userAccount = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            String remark = ResourceBase.getString((String)"com.kingdee.eas.base.wssc.WSSCResource", (String)"BILLIMAGE_DELETE", (Locale)ctx.getOriginLocale());
            NoticeImageSysDestroyInfo destroyInfo = new NoticeImageSysDestroyInfo();
            destroyInfo.setBarCode(barCode);
            destroyInfo.setMessage(remark);
            destroyInfo.setOpreatePerson(userAccount);
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            if (Configure.enableMultiImage(ctx)) {
                String result;
                info = this.getBillImageMapInfoByImageNo(ctx, barCode);
                if ("TCZT".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, info.getImageSysId(), "image.system.type"))) {
                    destroyInfo.setOpreatePerson(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                }
                if (SUCCESS.equals(result = NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).destroyImage(destroyInfo)) || "-1".equals(result)) {
                    destroyImageResult = true;
                }
            } else {
                String result;
                if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                    destroyInfo.setOpreatePerson(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                }
                if (SUCCESS.equals(result = NoticeImageSysFactory.getInstance(ctx, sscNumber).destroyImage(destroyInfo)) || "-1".equals(result)) {
                    destroyImageResult = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664\u5f71\u50cf\u5f02\u5e38\uff1abarCode = " + barCode), (Throwable)e);
        }
        return destroyImageResult;
    }

    private BillImageMapInfo getBillImageMapInfoByImageNo(Context ctx, String barCode) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)barCode));
        BillImageMapCollection billImageMapCollection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(view);
        if (billImageMapCollection.isEmpty()) {
            String msg = "deleteImageSystemData---imageNo: " + barCode + " not exist.";
            logger.error((Object)msg);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5f71\u50cf\u7f16\u7801\u4e0d\u5b58\u5728"));
        }
        return billImageMapCollection.get(0);
    }

    private String getImageNumberByBillId(Context ctx, String billId) throws BOSException {
        String imageNumber = null;
        ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
        String bosType = uuidPK.getObjectType().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("imageNumber"));
        view.setSelector(sic);
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            imageNumber = this.generateImageNumber(ctx, bosType, billId, null).get("imageNumber");
        } else {
            billImageMapInfo = billImageMapCollection.get(0);
            imageNumber = billImageMapInfo.getImageNumber();
        }
        return imageNumber;
    }

    @Override
    protected String _getImageURL(Context ctx, String billID, boolean isAllowRescan, boolean isApp) throws BOSException, EASBizException {
        return this._getImageURL(ctx, billID, isAllowRescan, isApp, null);
    }

    @Override
    protected String _getImageURL(Context ctx, String billID, boolean isAllowRescan, boolean isApp, String commentType) throws BOSException, EASBizException {
        logger.error((Object)("billID:" + billID + ";isAllowRescan:" + isAllowRescan + ";isApp:" + isApp));
        if (!BOSUuid.isValid((String)billID, (boolean)true)) {
            logger.error((Object)("billID:" + billID + " not exists"));
            throw new ImageSystemException(ImageSystemException.IMAGENO_INVALIDBILL);
        }
        ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
        String bosType = uuidPK.getObjectType().toString();
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new ImageSystemException(ImageSystemException.IMAGEMAP_NODATA);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        if (StringUtils.isEmpty((String)commentType)) {
            commentType = WebServiceConfig.getPropertiesValue(ctx, "eas.picture.commentType");
        }
        if (this.isShowImage(billImageMapInfo.getImageState())) {
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, this.getBillIDbyImageNo(ctx, billImageMapInfo.getImageNumber()));
            String viewPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String viewUserNumber = WSSCUtils.getViewUserName(ctx);
            try {
                if ("true".equals(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "usePcImage"))) {
                    logger.error((Object)"\u5f3a\u5236\u4f7f\u7528PC\u5f71\u50cf");
                    isApp = false;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            if (isApp) {
                NoticeImageSysViewOnPhoneInfo viewPhotoInfo = new NoticeImageSysViewOnPhoneInfo();
                viewPhotoInfo.setBarCode(billImageMapInfo.getImageNumber());
                viewPhotoInfo.setAllowRescan(isAllowRescan);
                viewPhotoInfo.setViewPersonId(viewPersonId);
                viewPhotoInfo.setViewUserNumber(viewUserNumber);
                viewPhotoInfo.setViewPersonName(viewUserNumber);
                viewPhotoInfo.setCommentType(commentType);
                if (Configure.enableMultiImage(ctx)) {
                    logger.error((Object)(" Configure enableMultiImage [" + billImageMapInfo.getImageSysId() + "]"));
                    imageURL = NoticeImageSysFactory_New.getInstance(ctx, billImageMapInfo.getImageSysId()).viewPhotoOnPhone(viewPhotoInfo);
                } else {
                    imageURL = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhotoOnPhone(viewPhotoInfo);
                }
            } else {
                NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
                viewPhotoInfo.setBarCode(billImageMapInfo.getImageNumber());
                viewPhotoInfo.setAllowRescan(isAllowRescan);
                viewPhotoInfo.setApp(false);
                viewPhotoInfo.setViewUserNumber(viewUserNumber);
                viewPhotoInfo.setViewPersonName(viewUserNumber);
                viewPhotoInfo.setViewPersonId(viewPersonId);
                viewPhotoInfo.setCommentType(commentType);
                if (Configure.enableMultiImage(ctx)) {
                    logger.error((Object)(" Configure enableMultiImage [" + billImageMapInfo.getImageSysId() + "]"));
                    imageURL = NoticeImageSysFactory_New.getInstance(ctx, billImageMapInfo.getImageSysId()).viewPhoto(viewPhotoInfo);
                } else {
                    imageURL = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhoto(viewPhotoInfo);
                }
            }
        } else {
            throw new ImageSystemException(ImageSystemException.IMAGENO_NOUPLOAD);
        }
        logger.error((Object)("\u5f71\u50cfURL " + imageURL));
        return imageURL;
    }

    @Override
    protected String _sendNote(Context ctx, String billId) throws BOSException {
        logger.error((Object)"_sendNote start!");
        String result = "";
        try {
            BillImageMapInfo bimInfo = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapInfo("where billID='" + billId + "'");
            String barCodeID = bimInfo.getImageNumber();
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
            NoticeImageSys2SendNoteInfo sendNote = new NoticeImageSys2SendNoteInfo();
            sendNote.setBarCode(barCodeID);
            sendNote.setSscNumber(sscNumber);
            sendNote.setCtx(ctx);
            if (Configure.enableMultiImage(ctx)) {
                logger.error((Object)(" Configure enableMultiImage _sendNote [" + bimInfo.getImageSysId() + "]"));
                result = NoticeImageSysFactory_New.getInstance(ctx, bimInfo.getImageSysId()).sendNote(sendNote);
            } else {
                result = NoticeImageSysFactory.getInstance(ctx, sscNumber).sendNote(sendNote);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u5ba1\u6279\u901a\u8fc7\u5bc4\u5355\u5f02\u5e38\uff01", (Throwable)e);
        }
        logger.error((Object)"_sendNote end!");
        return result;
    }

    @Override
    protected String _imageRescan(Context ctx, String billID) throws BOSException {
        try {
            return this._imageRescan(ctx, BOSUuid.read((String)billID), null, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    @Override
    protected String _imageRescan(Context ctx, BOSUuid billID, String operateID, String reScanMsg) throws BOSException, EASBizException {
        String billIDStr = billID.toString();
        try {
            String noticeReturn;
            logger.error((Object)("ctx\uff1a" + ctx.toString() + "\uff0cbillID\uff1a" + billID + "\uff0coperateID\uff1a" + operateID + "\uff0creScanMsg\uff1a" + reScanMsg));
            try {
                String sql = "SELECT top 1 fcreatorId,fopinion_" + ctx.getLocale() + " FROM t_bas_multiapprove where FBILLID = ? order by FCREATETIME desc";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billIDStr});
                if (rs.next()) {
                    if (operateID == null) {
                        operateID = rs.getString(1);
                    }
                    if (reScanMsg == null) {
                        reScanMsg = rs.getString(2) == null ? "" : rs.getString(2);
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"\u67e5\u8be2\u5de5\u4f5c\u6d41\u4e0a\u4e00\u5ba1\u6279\u4eba\u5931\u8d25!");
            }
            String imageNo = this._getImageNumber(ctx, null, billIDStr);
            if (StringUtils.isEmpty((String)imageNo)) {
                throw new BOSException("\u5355\u636e\uff1a[" + billID + "] \u4e0d\u5b58\u5728\u5f71\u50cf\u7f16\u7801\u4fe1\u606f\u3002");
            }
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID.toString());
            String imageSystemType = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type");
            if (Configure.enableMultiImage(ctx)) {
                BillImageMapInfo billImageMapInfo = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByBillIDImpl(), billID.toString());
                imageSystemType = MultiImageConfig.getPropertiesValue(ctx, billImageMapInfo.getImageSysId(), "image.system.type");
            }
            if (!"GXHC".equals(imageSystemType)) {
                RescanImageInfo rescanImageInfo = new RescanImageInfo();
                rescanImageInfo.setImageNo(imageNo);
                rescanImageInfo.setBillID(billIDStr);
                rescanImageInfo.setRescanMessage(reScanMsg);
                rescanImageInfo.setRescanUser(operateID);
                String easRescanReturn = this._imageRescan(ctx, rescanImageInfo);
                if (!SUCCESS.equals(easRescanReturn)) {
                    throw new BOSException("\u4fee\u6539EAS\u5f71\u50cf\u72b6\u6001\u5931\u8d25!");
                }
                logger.error((Object)"\u66f4\u65b0EAS\u5f71\u50cf\u72b6\u6001\u4e3a\u91cd\u626b\u5b8c\u6210!");
                ImageStateParamInfo imageStateParamInfo = new ImageStateParamInfo();
                imageStateParamInfo.setImageNo(imageNo);
                imageStateParamInfo.setMessage(reScanMsg);
                imageStateParamInfo.setRescanMessage(reScanMsg);
                BaseImageList baseList = new BaseImageList();
                baseList.addImageList(imageStateParamInfo);
                imageHandler.invokeTaskCenterServiceRescan(ctx, baseList);
                logger.error((Object)"\u66f4\u65b0SSC\u5f71\u50cf\u72b6\u6001\u4e3a\u91cd\u626b\u5b8c\u6210!");
            }
            NoticeImageSys2RescanInfo rescanInfo = new NoticeImageSys2RescanInfo(ctx);
            rescanInfo.setBarCode(imageNo);
            if (operateID != null) {
                ObjectUuidPK uuid = null;
                if (BOSUuid.isValid((String)operateID, (boolean)true)) {
                    uuid = new ObjectUuidPK(operateID);
                }
                PersonInfo person = null;
                if (uuid != null && "80EF7DED".equals(uuid.getObjectType().toString())) {
                    logger.error((Object)("\u91cd\u626b\u4eba\u5458id\u662fperson\u7684uuid:[" + operateID + "],\u8fdb\u884c\u67e5\u8be2"));
                    try {
                        person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)uuid);
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u91cd\u626b\u4eba\u5458id\u67e5\u8be2person\u51fa\u73b0\u5f02\u5e38:[" + operateID + "]"));
                    }
                } else if (uuid != null && "13B7DE7F".equals(uuid.getObjectType().toString())) {
                    logger.error((Object)("\u91cd\u626b\u4eba\u5458id\u662fuser\u7684uuid:[" + operateID + "],\u8fdb\u884c\u67e5\u8be2"));
                    try {
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("person.*"));
                        person = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)uuid, selector).getPerson();
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u91cd\u626b\u4eba\u5458\u7684id(userid)\u67e5\u8be2person\u51fa\u73b0\u5f02\u5e38:[" + operateID + "]"));
                    }
                }
                if (person != null) {
                    rescanInfo.setRescanPerson(person.getName());
                } else {
                    rescanInfo.setRescanPerson(operateID);
                    logger.error((Object)("\u91cd\u626b\u4eba\u5458id\u67e5\u8be2\u4e0d\u5230\u4eba\u5458.operateID:[" + operateID + "]"));
                }
            } else {
                logger.error((Object)"\u91cd\u626b\u4eba\u5458\u672a\u4f20\u9012,\u6216\u4e3a\u7a7a.");
            }
            rescanInfo.setRescanMessage(reScanMsg);
            if ("TCZT".equalsIgnoreCase(imageSystemType)) {
                rescanInfo.setRescanPerson(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            }
            if (Configure.enableMultiImage(ctx)) {
                BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNo);
                noticeReturn = NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).rescan(rescanInfo);
            } else {
                noticeReturn = NoticeImageSysFactory.getInstance(ctx, sscNumber).rescan(rescanInfo);
            }
            if (!SUCCESS.equals(noticeReturn)) {
                throw new BOSException("\u901a\u77e5\u5f71\u50cf\u7cfb\u7edf\u91cd\u626b\u8fd4\u56de\u5931\u8d25!");
            }
            logger.error((Object)"\u66f4\u65b0\u5f71\u50cf\u7cfb\u7edf\u5f71\u50cf\u72b6\u6001\u4e3a\u91cd\u626b\u5b8c\u6210!\u9000\u56de\u91cd\u626b\u5355\u636e\u5f71\u50cf\u5168\u90e8\u5b8c\u6210,\u8fd4\u56de\u6210\u529f\u4fe1\u606f.");
            return SUCCESS;
        }
        catch (BOSException e) {
            logger.error((Object)("\u9000\u56de\u91cd\u626b\u5355\u636e\u5f71\u50cf\u51fa\u73b0BOS\u5f02\u5e38!" + (Object)((Object)e)));
            throw e;
        }
        catch (RemoteException e) {
            logger.error((Object)("\u9000\u56de\u91cd\u626b\u5355\u636e\u5f71\u50cf\u51fa\u73b0BOS\u5f02\u5e38!" + e));
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _imageRescan(Context ctx, RescanImageInfo rescanImageInfo) throws BOSException, EASBizException {
        try {
            BOSObjectType type;
            SSCUnitInfo sscUnitInfo;
            logger.info((Object)("\u9000\u56de\u91cd\u626b,\u4fee\u6539EAS\u6570\u636e\u72b6\u6001!" + rescanImageInfo));
            String imageNo = rescanImageInfo.getImageNo();
            String billID = rescanImageInfo.getBillID();
            String rescanUser = rescanImageInfo.getRescanUser();
            String sscJobID = rescanImageInfo.getSscJobID();
            String msg = rescanImageInfo.getRescanMessage();
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            String imageType = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type");
            if (Configure.enableMultiImage(ctx)) {
                BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNo);
                imageType = MultiImageConfig.getPropertiesValue(ctx, info.getImageSysId(), "image.system.type");
            }
            if (!"TCZT".equalsIgnoreCase(imageType) && (sscUnitInfo = this.getSscUnit(ctx, (type = new ObjectUuidPK(BOSUuid.read((String)billID)).getObjectType()).toString(), billID)) != null) {
                String sscUnitID = sscUnitInfo.getId().toString();
                ImageHandleTaskInfo taskInfo = new ImageHandleTaskInfo();
                taskInfo.setBarcode(imageNo);
                taskInfo.setBillID(billID);
                taskInfo.setTaskHandler(rescanUser);
                taskInfo.setTaskId(sscJobID);
                taskInfo.setTaskContent(msg);
                taskInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                taskInfo.setState("0");
                IRowSet rowSet = this.getHandlerListQueryExecutor(ctx, sscUnitID).executeQuery();
                IImageHandleTask handTask = ImageHandleTaskFactory.getLocalInstance(ctx);
                while (rowSet.next()) {
                    ImageHandleTaskEntryInfo taskEntryInfo = new ImageHandleTaskEntryInfo();
                    taskEntryInfo.setIsLoaded(false);
                    taskEntryInfo.setImageHandler(rowSet.getString("handlerID.id"));
                    taskInfo.getEntry().add(taskEntryInfo);
                }
                handTask.addnew((CoreBaseInfo)taskInfo);
            }
            this._updateImageState(ctx, "", billID, ImageStateEnum.RESCAN_IAMGE);
        }
        catch (BOSException e) {
            logger.error((Object)("\u4fee\u6539EAS\u5f71\u50cf\u72b6\u6001\u51fa\u73b0BOS\u5f02\u5e38!" + (Object)((Object)e)));
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"\u4fee\u6539EAS\u5f71\u50cf\u72b6\u6001\u51fa\u73b0\u5f02\u5e38!", (Throwable)e);
            return "-2";
        }
        return SUCCESS;
    }

    private IQueryExecutor getHandlerListQueryExecutor(Context ctx, String sscUnitId) {
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.getHandlerQueryPK());
        queryExcu.setObjectView(this.buildHandlerViewInfo(sscUnitId));
        return queryExcu;
    }

    private MetaDataPK getHandlerQueryPK() {
        return new MetaDataPK("com.kingdee.eas.base.wssc.app.SSCUnitHandlerQuery");
    }

    private EntityViewInfo buildHandlerViewInfo(String sscUnitId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("sscUnitID.id", (Object)sscUnitId));
        return viewInfo;
    }

    @Override
    protected String _rejectBill(Context ctx, String billId, String userAccount, String userName, String remark) throws BOSException, EASBizException {
        String result = "";
        try {
            BillImageMapInfo bimInfo = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapInfo("where billID='" + billId + "'");
            NoticeImageSys2RejectBillInfo rejectBillInfo = new NoticeImageSys2RejectBillInfo();
            rejectBillInfo.setBarCode(bimInfo.getImageNumber());
            rejectBillInfo.setRemark(remark);
            rejectBillInfo.setUseraccount(userAccount);
            rejectBillInfo.setUsername(userName);
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
            if (Configure.enableMultiImage(ctx)) {
                String imageSysId = bimInfo.getImageSysId();
                if ("TCZT".equalsIgnoreCase(MultiImageConfig.getPropertiesValue(ctx, imageSysId, "image.system.type"))) {
                    rejectBillInfo.setUserid(ctx.getCaller() + "");
                }
                result = NoticeImageSysFactory_New.getInstance(ctx, bimInfo.getImageSysId()).rejectBill(rejectBillInfo);
            } else {
                if ("TCZT".equalsIgnoreCase(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image.system.type"))) {
                    rejectBillInfo.setUserid(ctx.getCaller() + "");
                }
                result = NoticeImageSysFactory.getInstance(ctx, sscNumber).rejectBill(rejectBillInfo);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"\u5ba1\u6279\u901a\u8fc7\u5bc4\u5355\u5f02\u5e38\uff01", (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _deleteSSCJob(Context ctx, String billId) throws BOSException {
        String DELETE_SSCLOGHST_SQL = "delete from T_wfr_sscloghst where fbillid = ? ";
        String DELETE_SSCLOG_SQL = "delete from t_wfr_ssclog where fbillid = ? ";
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
        String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createShareTaskWebServiceUrl");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billID", billId);
        JSONMap json = null;
        String param = null;
        boolean deleteSSCDataResult = false;
        try {
            json = new JSONMap(map);
            param = json.toString();
            if (WSSCUtils.isWebService(ctx, sscNumber)) {
                if (StringUtils.isEmpty((String)serviceUrl)) {
                    throw new NullPointerException("serviceUrl is null");
                }
                WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("deleteSSCDataByBillID");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                deleteSSCDataResult = (Boolean)call.invoke(new Object[]{param});
            } else {
                Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
                Object object = tMethod.invoke(null, ctx);
                Method tMethodService = object.getClass().getMethod("deleteSSCDataByBillID", String.class);
                deleteSSCDataResult = (Boolean)tMethodService.invoke(object, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664SSC\u6570\u636e\u5f02\u5e38\uff1aparam = " + param), (Throwable)e);
        }
        if (!deleteSSCDataResult) {
            return;
        }
        try {
            DbUtil.execute((Context)ctx, (String)DELETE_SSCLOGHST_SQL, (Object[])new Object[]{billId});
            DbUtil.execute((Context)ctx, (String)DELETE_SSCLOG_SQL, (Object[])new Object[]{billId});
        }
        catch (Exception e) {
            logger.error((Object)("deleteSSCDataByBillID error:" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected String _getToImageAppParam(Context ctx, String imageNo, String userNumber, PhoneSysType phoneSysType, String sscNumber) throws BOSException, EASBizException {
        if (sscNumber == null || sscNumber.trim().length() == 0) {
            sscNumber = "EAS";
        }
        NoticeImageSysToAppParamInfo toAppInfo = new NoticeImageSysToAppParamInfo();
        toAppInfo.setCtx(ctx);
        toAppInfo.setBarCode(imageNo);
        toAppInfo.setSscNumber(sscNumber);
        toAppInfo.setUserNumber(userNumber);
        toAppInfo.setPhoneSys(phoneSysType);
        if (Configure.enableMultiImage(ctx)) {
            BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNo);
            return NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).getToImageAppParam(toAppInfo);
        }
        return NoticeImageSysFactory.getInstance(ctx, sscNumber).getToImageAppParam(toAppInfo);
    }

    @Override
    protected String _coupletImage(Context ctx, String billId, boolean isCanRescan) throws BOSException, EASBizException {
        String imageURL = null;
        imageURL = Configure.enableMultiImage(ctx) ? new CoupletImageHandler().getMultiImageUrl(ctx, billId, isCanRescan) : new CoupletImageHandler().getSingleImageUrl(ctx, billId, isCanRescan);
        logger.error((Object)("com.kingdee.eas.base.wssc.app.BillImageFacadeControllerBean._coupletImage;billid[" + billId + "];isCanRescan[" + isCanRescan + "];imageURL[" + imageURL + "]"));
        return imageURL;
    }

    private String getCoupletImage(Context ctx, String billId, boolean isCanRescan) throws BOSException, EASBizException {
        String imageURL = null;
        ArrayList<String> allBillIdList = new ArrayList<String>();
        List srcBillIdList = new ArrayList();
        ArrayList<NoticeImageSysViewInfo> list = new ArrayList<NoticeImageSysViewInfo>();
        allBillIdList.add(billId);
        try {
            Class<?> factoryClz = Class.forName("com.kingdee.bos.metadata.bot.BOTRelationFactory");
            Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
            Object facadeObj = getInsMethod.invoke(null, ctx);
            Method getAllUpstreamObj = facadeObj.getClass().getMethod("getAllUpstreamObjIdByDestID", String.class);
            srcBillIdList = (List)getAllUpstreamObj.invoke(facadeObj, billId);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u4e0a\u6e38\u5355\u636e\u5f02\u5e38,\u6e90\u5355Id\u4e3a:" + billId), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", "\u83b7\u53d6\u524d\u7f6e\u5355\u636e\u4fe1\u606f\u5931\u8d25!"), (Throwable)e);
        }
        logger.error((Object)("\u4e0a\u6e38\u5355\u636e\u957f\u5ea6\u4e3a:" + srcBillIdList.size()));
        HashSet allBillIdSet = new HashSet();
        allBillIdSet.addAll(srcBillIdList);
        allBillIdList.addAll(allBillIdSet);
        HashSet<String> imageSysSet = new HashSet<String>();
        String imageSysId = "";
        for (int i = 0; i < allBillIdList.size(); ++i) {
            String srcBillId = (String)allBillIdList.get(i);
            ObjectUuidPK uuidPK = new ObjectUuidPK(srcBillId);
            String bosType = uuidPK.getObjectType().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)srcBillId));
            BillImageMapInfo billImageMapInfo = null;
            IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
            BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
            NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
            if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
                String msg = "bosType: " + bosType + ", billId: " + srcBillId + " not exist.";
                logger.error((Object)msg);
                continue;
            }
            billImageMapInfo = billImageMapCollection.get(0);
            imageSysId = billImageMapInfo.getImageSysId();
            imageSysSet.add(imageSysId);
            if (imageSysSet.size() > 1) {
                logger.error((Object)" \u67e5\u770b\u4e0a\u6709\u5355\u636e\u5f71\u50cf \u5f71\u50cf\u7cfb\u7edf\u5c5e\u4e8e\u591a\u4e2a\u5f71\u50cf\u7cfb\u7edf REEOR ");
                throw new ImageSystemException(ImageSystemException.IMAGE_TOMANYTYPE);
            }
            String imageNumber = billImageMapInfo.getImageNumber();
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String personName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            logger.debug((Object)("\u83b7\u53d6\u5f71\u50cfURL\u7684\u5165\u53c2\u4e3a\uff1apersonID=" + personId + "imageNumber=" + imageNumber));
            try {
                viewPhotoInfo.setBarCode(imageNumber);
                if (billId.equals(allBillIdList.get(i))) {
                    viewPhotoInfo.setAllowRescan(isCanRescan);
                } else {
                    viewPhotoInfo.setAllowRescan(false);
                }
                viewPhotoInfo.setAllowRescan(false);
                viewPhotoInfo.setViewPersonId(personId);
                viewPhotoInfo.setViewPersonName(personName);
                list.add(viewPhotoInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()));
            }
        }
        if (list != null && list.size() > 0) {
            imageURL = NoticeImageSysFactory_New.getInstance(ctx, imageSysId).viewPhotos(list.toArray(new NoticeImageSysViewInfo[0]));
        }
        logger.error((Object)("\u5f71\u50cfURL " + imageURL));
        return imageURL;
    }

    @Override
    protected BillImageMapInfo _getBillImageMapInfo(Context ctx, IBillImage billImage, String param) throws BOSException, EASBizException {
        return billImage.getBillImageMapInfo(ctx, param);
    }

    @Override
    protected void _deleteRefInfoByBillID(Context ctx, String billId, boolean isDeleteImageMsg, boolean isDeleteSscMsg, boolean isDeleteImageMapMsg) throws BOSException {
        try {
            if (isDeleteImageMsg) {
                this.deleteImageSystemData(ctx, billId, true);
            }
            if (isDeleteSscMsg) {
                this.deleteSscData(ctx, billId);
            }
            if (isDeleteImageMapMsg) {
                WSSCUtils.deleteWSSCAndWFRDataByBillID(ctx, billId);
            }
        }
        catch (Exception e) {
            logger.error((Object)("deleteSSCDataByBillID error:" + e.getMessage()), (Throwable)e);
        }
    }

    private boolean deleteSscData(Context ctx, String billID) {
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
        String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createShareTaskWebServiceUrl");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("billID", billID);
        JSONMap json = null;
        String param = null;
        boolean deleteSSCDataResult = false;
        try {
            json = new JSONMap(map);
            param = json.toString();
            if (WSSCUtils.isWebService(ctx, sscNumber)) {
                if (StringUtils.isEmpty((String)serviceUrl)) {
                    throw new NullPointerException("serviceUrl is null");
                }
                WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("deleteSSCDataByBillID");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                deleteSSCDataResult = (Boolean)call.invoke(new Object[]{param});
            } else {
                Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
                Object object = tMethod.invoke(null, ctx);
                Method tMethodService = object.getClass().getMethod("deleteSSCDataByBillID", String.class);
                deleteSSCDataResult = (Boolean)tMethodService.invoke(object, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5220\u9664SSC\u6570\u636e\u5f02\u5e38\uff1aparam = " + param), (Throwable)e);
        }
        return deleteSSCDataResult;
    }

    @Override
    protected String _createImagePaths(Context ctx, Map params) throws BOSException, EASBizException {
        if (params.get("barcodes") != null) {
            List barcodes = (List)params.get("barcodes");
            if (barcodes != null && barcodes.size() > 0) {
                String[] imageNumber = new String[barcodes.size()];
                String billType = (String)params.get("type");
                String userAccount = (String)params.get("username");
                String userName = (String)params.get("userstaff");
                boolean isApp = params.get("isApp") == null ? false : Boolean.parseBoolean((String)params.get("isApp"));
                for (int i = 0; i < barcodes.size(); ++i) {
                    Map barcodeMap = (Map)barcodes.get(i);
                    imageNumber[i] = (String)barcodeMap.get("bar");
                }
                return this._createImagePaths(ctx, imageNumber, billType, userAccount, userName, isApp);
            }
            throw new BOSException("params\u4e2dbarcodes\u5185\u5bb9\u4e3a\u7a7a");
        }
        throw new BOSException("params\u4e2dbarcodes\u4e3a\u7a7a");
    }

    @Override
    protected String _noticeArchive(Context ctx, String billID, String imageNo) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)imageNo)) {
            imageNo = this._getImageNumber(ctx, null, billID);
        }
        logger.error((Object)("*********billID*********: " + billID + " *********imageNo*********: " + imageNo));
        ArrayList<Map<String, String>> params = new ArrayList<Map<String, String>>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billID", billID);
        param.put("barcode", imageNo);
        param.put("state", SUCCESS);
        param.put("billtype", SUCCESS);
        params.add(param);
        NoticeImageSysArchive noticeImageSysArchive = new NoticeImageSysArchive();
        noticeImageSysArchive.setCtx(ctx);
        noticeImageSysArchive.setParams(params);
        Map<String, String> result = null;
        if (Configure.enableMultiImage(ctx)) {
            BillImageMapInfo info = BillImageFacadeFactory.getLocalInstance(ctx).getBillImageMapInfo(new BillImageByNOImpl(), imageNo);
            result = NoticeImageSysFactory_New.getInstance(ctx, info.getImageSysId()).noticeArchive(noticeImageSysArchive);
        } else {
            String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
            noticeImageSysArchive.setSscNumber(sscNumber);
            result = NoticeImageSysFactory.getInstance(ctx, sscNumber).noticeArchive(noticeImageSysArchive);
        }
        logger.error((Object)("********result********:" + result == null ? "null" : result.toString()));
        if (result != null && result.size() > 0) {
            return result.get(billID);
        }
        return "0";
    }

    @Override
    protected void _deleteImage4Buss(Context ctx, String billId, boolean isDeleteImageMsg, boolean isDeleteSscMsg, boolean isDeleteImageMapMsg) throws BOSException, EASBizException {
        this._deleteRefInfoByBillID(ctx, billId, isDeleteImageMsg, isDeleteSscMsg, isDeleteImageMapMsg);
    }

    @Override
    protected void _imageRescan4workflow(Context ctx, String billId) throws BOSException {
        this._imageRescan(ctx, billId);
    }

    @Override
    protected List _getBillImage(Context ctx, String billId) throws BOSException, EASBizException {
        logger.error((Object)("_getBillImage billId:" + billId));
        List list = null;
        ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
        String bosType = uuidPK.getObjectType().toString();
        Object imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billId + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        if (this.isShowImage(billImageMapInfo.getImageState())) {
            NoticeImageSysHelper helper = null;
            if (Configure.enableMultiImage(ctx)) {
                helper = NoticeImageSysFactory_New.getInstance(ctx, billImageMapInfo.getImageSysId());
            } else {
                String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
                helper = NoticeImageSysFactory.getInstance(ctx, sscNumber);
            }
            if (helper instanceof IImageOnlyUrl) {
                NoticeImageSysGetBillImageInfo info = new NoticeImageSysGetBillImageInfo();
                info.setBarCode(billImageMapInfo.getImageNumber());
                info.setCtx(ctx);
                list = ((IImageOnlyUrl)((Object)helper)).getBillImage(info);
            } else {
                String msg = "\u5f71\u50cf\u7cfb\u7edf\u5b9e\u73b0\u7c7b\u4e0d\u652f\u6301helper: " + helper.getClass().getName() + ", billID: " + billId + ";billImageNumber:" + billImageMapInfo.getImageNumber();
                logger.error((Object)msg);
                throw new BOSException(msg);
            }
        }
        return list;
    }

    @Override
    protected void _deleteRefInfoByBillIDNoWF(Context ctx, String billID, boolean isDeleteImageMsg, boolean isDeleteSscMsg, boolean isDeleteImageMapMsg) throws BOSException {
        this._deleteRefInfoByBillID(ctx, billID, isDeleteImageMsg, isDeleteSscMsg, isDeleteImageMapMsg);
    }

    private String sysBillToGetImageNuber(Context ctx, String easBillId, String extendName, String extendBillID, String imageNo) throws BOSException, EASBizException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(easBillId);
        String bosType = uuidPK.getObjectType().toString();
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        String oql = "select * where extendBillID = '" + extendBillID + "'";
        BillImageMapCollection billImageMaplist = null;
        try {
            billImageMaplist = billImageMap.getBillImageMapCollection(oql);
            String imageSysId = "";
            try {
                if (Configure.enableMultiImage(ctx)) {
                    imageSysId = this.generateImageNumber(ctx, bosType, easBillId, "").get("imageSysId");
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u83b7\u53d6\u5f71\u50cf\u7cfb\u7edfid\u5931\u8d25\uff0c\u63d2\u5165\u7a7a\u5b57\u7b26\u4e32", (Throwable)e);
            }
            BillImageMapInfo billImageMapInfo = null;
            if (billImageMaplist.size() == 1) {
                billImageMapInfo = billImageMaplist.get(0);
                if (!StringUtils.isEmpty((String)billImageMapInfo.getBillID())) {
                    if (easBillId.equals(billImageMapInfo.getBillID())) {
                        return billImageMapInfo.getImageNumber();
                    }
                    this.printTrack();
                    throw new BOSException("\u5f53\u524d\u5916\u90e8\u7cfb\u7edf\u5355\u636e\uff08cqbillid\uff09\u5b58\u5728\u4e0d\u540c\u7684eas\u5355\u636eid,\u539feas\u5355\u636eid\u4e3a" + billImageMapInfo.getBillID() + "\u3002\u73b0eas\u5355\u636eid\u4e3a" + easBillId);
                }
                billImageMapInfo.setBillID(easBillId);
                billImageMapInfo.setExtendName(StringUtils.isEmpty((String)extendName) ? "CQ" : extendName);
                billImageMapInfo.setImageSysId(imageSysId);
                billImageMap.update((IObjectPK)new ObjectUuidPK(billImageMapInfo.getId().toString()), (CoreBaseInfo)billImageMapInfo);
                return billImageMapInfo.getImageNumber();
            }
            if (billImageMaplist.size() == 0) {
                billImageMapInfo = new BillImageMapInfo();
                billImageMapInfo.setBosType(bosType);
                billImageMapInfo.setBillID(easBillId);
                billImageMapInfo.setImageNumber(StringUtils.isEmpty((String)imageNo) ? "" : imageNo);
                billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
                billImageMapInfo.setExtendBillID(extendBillID);
                billImageMapInfo.setExtendName(StringUtils.isEmpty((String)extendName) ? "CQ" : extendName);
                billImageMapInfo.setImageSysId(imageSysId);
                billImageMap.addnew((CoreBaseInfo)billImageMapInfo);
                return StringUtils.isEmpty((String)imageNo) ? "" : imageNo;
            }
            throw new BOSException("\u5728eas\u7684t_wsc_billimagemap\u5355\u636e\u5f71\u50cf\u6620\u5c04\u8868\u91cc\u5b58\u5728cq\u5355\u636eid\u76f8\u540c\u7684\u6570\u636e\uff0c\u6761\u6570\u4e3a\uff1a" + billImageMaplist.size());
        }
        catch (Exception e) {
            logger.error((Object)("\u5355\u636e\u540c\u6b65\u5931\u8d25extendBillID=" + extendBillID + ";easBillId=" + easBillId), (Throwable)e);
            throw new BOSException("\u4e1a\u52a1\u5355\u636e\u8c03sysBillToGetImageNuber\u5931\u8d25", (Throwable)e);
        }
    }

    private void printTrack() {
        StringBuilder tag = new StringBuilder();
        try {
            for (StackTraceElement log : Thread.currentThread().getStackTrace()) {
                tag.append(log.getClassName() + "." + log.getMethodName() + "__\u884c\u6570" + log.getLineNumber() + ";\n");
            }
            logger.error((Object)("sys billID failt" + tag.toString()));
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5806\u6808\u4fe1\u606f\u9519\u8bef\uff1a" + e));
        }
    }

    @Override
    protected String _getImageNumber(Context ctx, String bosType, String easBillId, String extendName, String extendBillID, String imageNo) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)extendBillID)) {
            return this._getImageNumber(ctx, bosType, easBillId);
        }
        return this.sysBillToGetImageNuber(ctx, easBillId, extendName, extendBillID, imageNo);
    }

    @Override
    protected String _getImageNumber(Context ctx, String bosType, String billID, String billNumber) throws BOSException {
        try {
            return this._createBillImageMapInfo(ctx, bosType, billID, billNumber);
        }
        catch (EASBizException e) {
            logger.error((Object)("_getImageNumber error billId = " + billID + " bosType = " + bosType), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getImageURLForWf(Context ctx, String billID, String paramJson) throws BOSException, EASBizException {
        Map<String, Object> param;
        logger.error((Object)("workflow view photo, billid =" + billID + " and paramJson = " + paramJson));
        if (!BOSUuid.isValid((String)billID, (boolean)true)) {
            logger.error((Object)("billID:" + billID + " not exists"));
            throw new ImageSystemException(ImageSystemException.IMAGENO_INVALIDBILL);
        }
        boolean isApp = false;
        if (!StringUtils.isEmpty((String)paramJson) && (param = this.getParamFromJsonString(paramJson)) != null && param.get("isApp") != null) {
            try {
                isApp = Boolean.parseBoolean(param.get("isApp").toString());
            }
            catch (Exception e) {
                logger.error((Object)"json\u5b57\u7b26\u4e32\u4e2d\u7684isApp\u65e0\u6cd5\u8f6c\u6362\u6210\u5e03\u5c14\u7c7b\u578b\uff0c\u9ed8\u8ba4\u503c\u4e3afalse");
            }
        }
        boolean rescan = false;
        Map shareCenter = WorkFlowUtils.getShareCenterFromWFByBillid(ctx, billID);
        if (shareCenter != null && shareCenter.get("IsRescan") != null) {
            try {
                rescan = Boolean.parseBoolean(shareCenter.get("IsRescan").toString());
            }
            catch (Exception e) {
                logger.error((Object)("\u5de5\u4f5c\u6d41\u4e2dIsRescan\u53c2\u6570\u6709\u8bef\uff0ccenterParamMap = " + shareCenter));
            }
        }
        return this._getImageURL(ctx, billID, rescan, isApp);
    }

    @Override
    protected String _transformBillNumber(Context ctx, String billNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billNumber)) {
            return "";
        }
        return billNumber.toUpperCase(ctx.getLocale());
    }

    private Map<String, Object> getParamFromJsonString(String paramJson) {
        HashMap<String, Object> valueMap = null;
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)paramJson);
            valueMap = new HashMap<String, Object>();
            valueMap.putAll((Map<String, Object>)jsonObject);
        }
        catch (Exception e) {
            logger.error((Object)"json\u5b57\u7b26\u4e32\u8f6c\u6362\u6210json\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8f93\u5165\u53c2\u6570\u683c\u5f0f", (Throwable)e);
        }
        return valueMap;
    }
}

