/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WSContext;
import com.kingdee.eas.base.ssc.BussinessAttributeCollection;
import com.kingdee.eas.base.ssc.BussinessAttributeFactory;
import com.kingdee.eas.base.ssc.tool.JSONUtil;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.app.AbstractBillImageMapControllerBean;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.util.WorkFlowUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class BillImageMapControllerBean
extends AbstractBillImageMapControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.BillImageMapControllerBean");

    @Override
    protected void _afterImageReady(Context ctx, BOSUuid billid) throws BOSException {
        logger.info((Object)("***BillImageControllerBean ctx" + ctx.getCaller() + ";billid=" + billid));
    }

    @Override
    protected Map _isBillHasImage(Context ctx, String billid) throws BOSException {
        try {
            BillImageMapInfo info = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapInfo("select imageNumber,imageState where billID='" + billid + "'");
            if (info != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("imageState", (Object)info.getImageState());
                map.put("imageNumber", info.getImageNumber());
                return map;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        return null;
    }

    @Override
    protected boolean _isBillHasImageNew(Context ctx, String billid) throws BOSException {
        try {
            BillImageMapInfo info = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapInfo("select imageNumber,imageState where billID='" + billid + "'");
            if (info != null) {
                String imageState = info.getImageState().getValue();
                return "2".equals(imageState) || "4".equals(imageState);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
        return false;
    }

    private static String getBillTypeNumByBussAttrNum(Context ctx, String bussNumber, String sscNumber) throws BOSException {
        if (WSSCUtils.isWebService(ctx, sscNumber)) {
            try {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("method", "getBillTypeByBusinessNumber");
                map.put("number", bussNumber);
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setOperationName("getSSCEntryInfoMap");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                String resultStr = (String)call.invoke(new Object[]{JSONUtil.map2json(map)});
                Map resultMap = JSONUtil.jsonToMap((String)resultStr);
                return (String)resultMap.get("number");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bussNumber));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billType.number");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        BussinessAttributeCollection bussinessAttributeCollection = BussinessAttributeFactory.getLocalInstance((Context)ctx).getBussinessAttributeCollection(view);
        if (bussinessAttributeCollection != null && bussinessAttributeCollection.size() == 1) {
            return bussinessAttributeCollection.get(0).getBillType().getNumber();
        }
        throw new BOSException("\u901a\u8fc7\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u67e5\u52300\u4e2a\u6216\u591a\u4e2a\u5355\u636e\u7c7b\u578b\uff0cbusinessAttribute\uff1a" + bussNumber);
    }

    @Override
    protected Map _multistageDealTask(Context ctx, Map shareCenter, String businessAttribute, String level, String isLastLevel) throws BOSException {
        shareCenter.put("businessAttribute", businessAttribute);
        shareCenter.put("level", level);
        shareCenter.put("isLastLevel", isLastLevel);
        shareCenter.put("isTaskCenter", true);
        shareCenter.put("isNode", true);
        return shareCenter;
    }

    @Override
    protected Map _createShareCenter_V10(Context ctx, String jobPriority, boolean isPhotoCopy, String subject, String orgNumber, String businessAttribute, String billofDocumentID, String level, boolean autoApprove, String isLastLevel, String jobCreateID, String sscNumber) throws BOSException {
        HashMap<String, Object> shareCenter = new HashMap<String, Object>();
        if (org.apache.commons.lang.StringUtils.isBlank((String)level)) {
            level = "1";
        }
        shareCenter.put("level", level);
        shareCenter.put("isLastLevel", isLastLevel);
        shareCenter.put("businessAttribute", businessAttribute);
        shareCenter.put("isPhotoCopy", isPhotoCopy ? isPhotoCopy : this._isBillHasImageNew(ctx, billofDocumentID));
        shareCenter.put("sscNumber", sscNumber);
        shareCenter.put("barCodeID", this._isBillHasImage(ctx, billofDocumentID) == null ? "" : this._isBillHasImage(ctx, billofDocumentID).get("imageNumber") + "");
        if (Integer.parseInt(level) == 1) {
            shareCenter.put("orgNumber", orgNumber);
            shareCenter.put("jobPriority", jobPriority);
            shareCenter.put("subject", subject);
            shareCenter.put("billofDocumentID", billofDocumentID);
            shareCenter.put("autoApprove", autoApprove);
            shareCenter.put("jobCreateID", jobCreateID);
        }
        if (Integer.parseInt(level) > 1) {
            if (orgNumber != null && !"".equals(orgNumber) && !"null".equals(orgNumber)) {
                shareCenter.put("orgNumber", orgNumber);
            }
            if (jobPriority != null && !"".equals(jobPriority)) {
                shareCenter.put("jobPriority", jobPriority);
            }
            if (subject != null && !"".equals(subject)) {
                shareCenter.put("subject", subject);
            }
            if (billofDocumentID != null && !"".equals(billofDocumentID)) {
                shareCenter.put("billofDocumentID", billofDocumentID);
            }
            if (Boolean.valueOf(autoApprove) != null) {
                shareCenter.put("autoApprove", autoApprove);
            }
            if (jobCreateID != null && !"".equals(jobCreateID)) {
                shareCenter.put("jobCreateID", jobCreateID);
            }
        }
        shareCenter.put("isTaskCenter", true);
        shareCenter.put("isNode", true);
        return shareCenter;
    }

    @Override
    protected Map _createShareCenter_V11(Context ctx, String jobPriority, boolean isPhotoCopy, String subject, String orgNumber, String businessAttribute, String billofDocumentID, String level, boolean autoApprove, String isLastLevel, String jobCreateID) throws BOSException {
        return this._createShareCenter_V10(ctx, jobPriority, isPhotoCopy, subject, orgNumber, businessAttribute, billofDocumentID, level, autoApprove, isLastLevel, jobCreateID, "EAS");
    }

    @Override
    protected Map _createShareCenter(Context ctx, String jobPriority, boolean isPhotoCopy, String subject, String orgNumber, String businessAttribute, String systemAttribute, String billofDocumentID, String billType, String level, String barCodeID, boolean autoApprove, String isLastLevel, String jobCreateID) throws BOSException {
        return this._createShareCenter_V11(ctx, jobPriority, isPhotoCopy, subject, orgNumber, businessAttribute, billofDocumentID, level, autoApprove, isLastLevel, jobCreateID);
    }

    @Override
    protected void _afterSatisfaction(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        logger.info((Object)("***BillImageControllerBean.afterSatisfaction ctx" + ctx.getCaller() + ";billid=" + billId));
    }

    @Override
    protected Map _isCanRescanInWorkflow(Context ctx, String billid, boolean IsRescan) throws BOSException, EASBizException {
        logger.error((Object)("billid=" + billid + ";IsRescan=" + IsRescan));
        HashMap<String, Boolean> shareCenter = WorkFlowUtils.getShareCenterFromWFByBillid(ctx, billid);
        if (shareCenter == null) {
            shareCenter = new HashMap<String, Boolean>();
        }
        shareCenter.put("IsRescan", IsRescan);
        return shareCenter;
    }
}

