/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.openapi.OpenApiCollection;
import com.kingdee.bos.openapi.OpenApiFactory;
import com.kingdee.bos.openapi.OpenApiInfo;
import com.kingdee.bos.openapi.app.core.DataType;
import com.kingdee.bos.openapi.app.core.processor.OpenApiProcessor;
import com.kingdee.bos.openapi.third.OpenApi;
import com.kingdee.bos.openapi.third.ctx.CommonLogin;
import com.kingdee.bos.openapi.third.invoker.AbstractLoginContext;
import com.kingdee.bos.openapi.third.login.EASLoginContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.AssignmentEvent;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.ProcInstFactory;
import com.kingdee.bos.workflow.metas.ProcInstInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.wssc.app.AbstractCallSSCInterfaceFacadeControllerBean;
import com.kingdee.eas.base.wssc.app.SSCImageHandler;
import com.kingdee.eas.base.wssc.app.sscLogin.WSSOLoginUtil;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.app.webservice.WSContext;
import com.kingdee.eas.base.wssc.message.FsscAssignmentEventHandler;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.log4j.Logger;

public class CallSSCInterfaceFacadeControllerBean
extends AbstractCallSSCInterfaceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.CallSSCInterfaceFacadeControllerBean");
    private static final String DPLOY_TYPE_INDEPENDENT = "1";
    private static final Map<String, Object> wfEngineMap = new HashMap<String, Object>();
    private static Cache<String, Cache<String, OpenApiInfo>> apiCache = CacheBuilder.newBuilder().initialCapacity(5).maximumSize(20L).build();

    @Override
    protected boolean _isShareCenter(Context ctx, String procInstId) throws BOSException, EASBizException {
        String sscNumber = WSSCUtils.getSSCNumber(ctx, procInstId);
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._isShareCenter is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("isShareCenter");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return Boolean.TRUE.equals(call.invoke(new Object[]{procInstId}));
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u5728\u5171\u4eab\u4e2d\u5fc3\u6709\u6b63\u5728\u5904\u7406\u7684\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n procInstId:" + procInstId), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._isShareCenter is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("isShareCenter", String.class);
            return Boolean.TRUE.equals(tMethodService.invoke(object, procInstId));
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u6d41\u7a0b\u662f\u5426\u5728\u5171\u4eab\u4e2d\u5fc3\u6709\u6b63\u5728\u5904\u7406\u7684\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n procInstId:" + procInstId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected static String getWfEngineRegistKey(Context ctx, Class clz) {
        return ctx.getAIS() + clz.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean _creatAssignment(Context ctx, String param) throws BOSException {
        block33: {
            try {
                String registKey = CallSSCInterfaceFacadeControllerBean.getWfEngineRegistKey(ctx, FsscAssignmentEventHandler.class);
                if (wfEngineMap.containsKey(registKey)) break block33;
                Map<String, Object> map = wfEngineMap;
                synchronized (map) {
                    if (!wfEngineMap.containsKey(registKey)) {
                        WfEngine.getEngine((Context)ctx).eventService().registerEventHandler(AssignmentEvent.OnAssignmentAborted.getName(), (Object)new FsscAssignmentEventHandler());
                        wfEngineMap.put(registKey, FsscAssignmentEventHandler.class);
                    }
                }
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
            }
        }
        boolean result = false;
        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)param);
        String sscNumber = (String)paramMap.get("sscNumber");
        if (sscNumber == null || "".equals(sscNumber)) {
            sscNumber = "EAS";
        }
        String createTaskMethodName = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createTaskMethodName");
        String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "createShareTaskWebServiceUrl");
        if (paramMap != null) {
            Object sscBill = paramMap.get("sscBill");
            String procInstId = paramMap.get("procInstId") + "";
            if (BOSUuid.isValid((String)procInstId, (boolean)false)) {
                ProcInstInfo pro = ProcInstFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(procInstId));
                paramMap.put("procdefID", pro.getProcdefID().toString());
                paramMap.put("procdefVer", pro.getProcdefVer());
                param = JSONUtils.convertObjectToJson((Context)ctx, (Object)paramMap);
            }
            String jobCreateID = paramMap.get("jobCreateID") + "";
            if (paramMap.get("creatorName") == null && BOSUuid.isValid((String)jobCreateID, (boolean)false)) {
                try {
                    CoreBaseInfo user = UserFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(jobCreateID));
                    paramMap.put("creatorName", user.get("name"));
                }
                catch (Exception e) {
                    logger.error((Object)"\u63d0\u5355\u4ebaid\u67e5\u8be2user\u8868\u51fa\u73b0\u9519\u8bef", (Throwable)e);
                }
                param = JSONUtils.convertObjectToJson((Context)ctx, (Object)paramMap);
            }
            if (sscBill != null) {
                String createSscBillMethodNname = "synSSCBill";
                try {
                    if (this.isWebService(ctx, sscNumber)) {
                        logger.error((Object)"workflow call create sscbill is webservice");
                        if (StringUtils.isEmpty((String)serviceUrl)) {
                            throw new NullPointerException("serviceUrl is null");
                        }
                        com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                        String loginSessionid = svcCtx.getSessionId();
                        logger.error((Object)("loginSessionid:" + loginSessionid));
                        if (StringUtils.isEmpty((String)loginSessionid)) {
                            logger.error((Object)"login EAS Fail");
                            throw new BOSException("login EAS Fail");
                        }
                        Call call = svcCtx.getCall(true);
                        call.setMaintainSession(true);
                        call.setOperationName(createSscBillMethodNname);
                        call.setTargetEndpointAddress(serviceUrl);
                        call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                        Object retValue = call.invoke(new Object[]{param});
                        try {
                            result = Boolean.valueOf(retValue.toString().trim());
                        }
                        catch (Exception e) {
                            result = false;
                            logger.error((Object)("retValue:" + retValue));
                        }
                    }
                    logger.error((Object)"workflow call create sscbill is RPC");
                    Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                    Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
                    Object object = tMethod.invoke(null, ctx);
                    Method tMethodService = object.getClass().getMethod(createSscBillMethodNname, String.class);
                    Object retValue = tMethodService.invoke(object, param);
                    try {
                        result = Boolean.valueOf(retValue.toString().trim());
                    }
                    catch (Exception e) {
                        result = false;
                        logger.error((Object)("retValue:" + retValue));
                    }
                }
                catch (Exception e) {
                    result = false;
                    if (this.isWebService(ctx, sscNumber)) {
                        logger.error((Object)("invoke createShareTask webservice error! serviceUrl:[" + serviceUrl + "] OperationName:[" + createSscBillMethodNname + "] "), (Throwable)e);
                    } else {
                        logger.error((Object)"createShareTask by RPC error", (Throwable)e);
                    }
                    throw new BOSException((Throwable)e);
                }
            } else {
                try {
                    if (this.isWebService(ctx, sscNumber)) {
                        logger.error((Object)"workflow call create ssc job is webservice");
                        if (StringUtils.isEmpty((String)serviceUrl)) {
                            throw new NullPointerException("serviceUrl is null");
                        }
                        com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                        String loginSessionid = svcCtx.getSessionId();
                        logger.error((Object)("loginSessionid:" + loginSessionid));
                        if (StringUtils.isEmpty((String)loginSessionid)) {
                            logger.error((Object)"login EAS Fail");
                            throw new BOSException("login EAS Fail");
                        }
                        Call call = svcCtx.getCall(true);
                        call.setMaintainSession(true);
                        call.setOperationName(createTaskMethodName);
                        call.setTargetEndpointAddress(serviceUrl);
                        call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                        logger.error((Object)("createTaskMethodName:" + createTaskMethodName.toString() + ",serviceUrl:" + serviceUrl.toString() + ",param:" + SafeFilterUtils.vaildLog(param)));
                        result = (Boolean)call.invoke(new Object[]{param});
                        logger.error((Object)("result:" + result));
                    }
                    logger.error((Object)"workflow call create ssc job is RPC");
                    Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
                    Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
                    Object object = tMethod.invoke(null, ctx);
                    Method tMethodService = object.getClass().getMethod(createTaskMethodName, String.class);
                    result = (Boolean)tMethodService.invoke(object, param);
                }
                catch (Exception e) {
                    if (this.isWebService(ctx, sscNumber)) {
                        logger.error((Object)SafeFilterUtils.vaildLog("invoke createShareTask webservice error! serviceUrl:[" + serviceUrl + "] OperationName:[" + createTaskMethodName + "] param:[" + param + "]"), (Throwable)e);
                    } else {
                        logger.error((Object)"createShareTask by RPC error", (Throwable)e);
                    }
                    throw new BOSException((Throwable)e);
                }
            }
        } else {
            throw new BOSException();
        }
        return result;
    }

    private boolean isWebService(Context ctx, String sscNumber) {
        return DPLOY_TYPE_INDEPENDENT.equals(this.getDeployType(ctx, sscNumber));
    }

    private String getDeployType(Context ctx, String sscNumber) {
        String re = "";
        try {
            re = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "deployType");
        }
        catch (Exception e) {
            logger.error((Object)("get sharetask_webservice deployType fail" + e.getMessage()), (Throwable)e);
        }
        return re;
    }

    @Override
    protected String _getMessageByBillID(Context ctx, String billID, String paramXml) throws BOSException, EASBizException {
        SSCImageHandler handler = new SSCImageHandler();
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._getMessageByBillID is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("getMessageByBillID");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                return (String)call.invoke(new Object[]{billID, paramXml});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u6d41\u7a0b\u5355\u636e\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n billID:" + billID + "\tparamXml:" + paramXml), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._getMessageByBillID is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getMessageByBillID", String.class, String.class);
            return (String)tMethodService.invoke(object, billID, paramXml);
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u6d41\u7a0b\u5355\u636e\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n billID:" + SafeFilterUtils.vaildLog(billID) + "\tparamXml:" + SafeFilterUtils.vaildLog(paramXml)), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _syn2SSCBill(Context ctx, String billID, String bosType, String jsonStr) throws BOSException, EASBizException {
        SSCImageHandler handler = new SSCImageHandler();
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
        if (handler.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._syn2SSCBill is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("updateSSCBill");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                return Boolean.parseBoolean(call.invoke(new Object[]{billID, bosType, jsonStr}).toString());
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u540c\u6b65\u5de5\u5355\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n billID:" + billID + "\tbosType:" + bosType + "\tparamXml:" + jsonStr), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._syn2SSCBill is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("updateSSCBill", String.class, String.class, String.class);
            return Boolean.parseBoolean(tMethodService.invoke(object, billID, bosType, jsonStr).toString());
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u540c\u6b65\u5de5\u5355\u4fe1\u606f\u5f02\u5e38!!" + e.getMessage() + "\n billID:" + billID + "\tbosType:" + bosType + "\tparamXml:" + jsonStr), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _synFromSSCBill(Context ctx, String billID, String bosType, Set attrSet) throws BOSException, EASBizException {
        String sscNumber;
        SSCImageHandler handler = new SSCImageHandler();
        String attrStr = null;
        if (attrSet != null && !attrSet.isEmpty()) {
            Iterator it = attrSet.iterator();
            while (it.hasNext()) {
                if (attrStr == null) {
                    attrStr = it.next().toString();
                    continue;
                }
                attrStr = attrStr + "," + it.next().toString();
            }
        }
        if (handler.isWebService(ctx, sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID))) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._synFromSSCBill is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("synValueToOutSys");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                String ret = (String)call.invoke(new Object[]{billID, bosType, attrStr, null});
                return null;
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u4ece\u5de5\u5355\u540c\u6b65\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n billID:" + billID + "\tbosType:" + bosType + "\tattrSet:" + attrSet), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._synFromSSCBill is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("synValueToOutSys", String.class, String.class, String.class, String.class);
            String ret = (String)tMethodService.invoke((Object)new Object[]{billID, bosType, attrStr, null}, new Object[0]);
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u4ece\u5de5\u5355\u540c\u6b65\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n billID:" + billID + "\tbosType:" + bosType + "\tattrSet:" + attrSet), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getPersonalCreditUrl(Context ctx, String userId, String sscNumber) throws BOSException {
        String url = "";
        String redirectUrl = "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.base.ssc.personalCredit&waf2skin=easbase";
        String erpNumber = this.getErpNumber(ctx, sscNumber);
        logger.error((Object)("******erpNumber******: " + erpNumber));
        if (erpNumber == null || "".equals(erpNumber)) {
            erpNumber = "EAS";
        }
        redirectUrl = redirectUrl + "&userId=" + userId + "&erpNumber=" + erpNumber;
        if (this.isWebService(ctx, sscNumber)) {
            try {
                url = this.getSSOUrl(ctx, sscNumber, redirectUrl);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55url\u5931\u8d25", (Throwable)e);
                throw new BOSException("\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55url\u5931\u8d25", (Throwable)e);
            }
        } else {
            url = redirectUrl;
        }
        logger.error((Object)("****PersonalCreditUrl: " + redirectUrl));
        return url;
    }

    @Override
    protected String _getSatisfactionUrl(Context ctx, String billID, String billNumber) throws BOSException {
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billID);
        String url = "";
        String redirectUrl = "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.base.ssc.satisfactionAppraise&waf2skin=easbase";
        redirectUrl = redirectUrl + "&billID=" + billID + "&billNumber=" + billNumber;
        if (this.isWebService(ctx, sscNumber)) {
            try {
                url = this.getSSOUrl(ctx, sscNumber, redirectUrl);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55ssc\u5931\u8d25", (Throwable)e);
                throw new BOSException("\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55ssc\u5931\u8d25", (Throwable)e);
            }
        } else {
            url = redirectUrl;
        }
        logger.error((Object)("****SatisfactionUrl: " + redirectUrl));
        return url;
    }

    @Override
    protected String _taskOperation(Context ctx, String operationAttribute, String sscNumber) throws BOSException {
        if (sscNumber == null || "".equals(sscNumber)) {
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._taskOperation is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                logger.error((Object)("loginSessionid:" + loginSessionid));
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setOperationName("taskOperation");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                return (String)call.invoke(new Object[]{operationAttribute});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5904\u7406\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n operationAttribute:" + operationAttribute), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._taskOperation is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("taskOperation", String.class);
            return (String)tMethodService.invoke(object, operationAttribute);
        }
        catch (Exception e) {
            logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5904\u7406\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n operationAttribute:" + operationAttribute), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _viewJobDetail(Context ctx, String jobId, String sscNumber) throws BOSException {
        if (sscNumber == null || "".equals(sscNumber)) {
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._viewJobDetail is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                logger.error((Object)("loginSessionid:" + loginSessionid));
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setOperationName("viewJobDetail");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                return (String)call.invoke(new Object[]{jobId});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n jobId:" + jobId), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._viewJobDetail is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("viewJobDetail", String.class);
            return (String)tMethodService.invoke(object, jobId);
        }
        catch (Exception e) {
            logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n jobId:" + jobId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _queryJobList(Context ctx, String queryCondition, String sscNumber) throws BOSException {
        if (sscNumber == null || "".equals(sscNumber)) {
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._queryJobList is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                logger.error((Object)("loginSessionid:" + loginSessionid));
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setOperationName("queryJobList");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                return (String)call.invoke(new Object[]{queryCondition});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5f02\u5e38!" + e.getMessage() + "\n queryCondition:" + queryCondition), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._queryJobList is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("queryJobList", String.class);
            return (String)tMethodService.invoke(object, queryCondition);
        }
        catch (Exception e) {
            logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5f02\u5e38!" + e.getMessage() + "\n queryCondition:" + queryCondition), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getApprovalBasicData(Context ctx, String queryCondition, String sscNumber) throws BOSException {
        if (sscNumber == null || "".equals(sscNumber)) {
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._getApprovalBasicData is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                com.kingdee.bos.workflow.WSContext svcCtx = WSSCUtils.loginEAS(ctx, sscNumber);
                String loginSessionid = svcCtx.getSessionId();
                logger.error((Object)("loginSessionid:" + loginSessionid));
                if (StringUtils.isEmpty((String)loginSessionid)) {
                    logger.error((Object)"login EAS Fail");
                    throw new BOSException("login EAS Fail");
                }
                Call call = svcCtx.getCall(true);
                call.setOperationName("getApprovalBasicData");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)loginSessionid));
                return (String)call.invoke(new Object[]{queryCondition});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5f02\u5e38!" + e.getMessage() + "\n queryCondition:" + queryCondition), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._getApprovalBasicData is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getApprovalBasicData", String.class);
            return (String)tMethodService.invoke(object, queryCondition);
        }
        catch (Exception e) {
            logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4efb\u52a1\u5217\u8868\u5f02\u5e38!" + e.getMessage() + "\n queryCondition:" + queryCondition), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getErpNumber(Context ctx, String sscNumber) {
        String erpNumber = "";
        try {
            erpNumber = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erpNumber");
            logger.error((Object)("****\u4e1a\u52a1\u7cfb\u7edf\u5728\u5171\u4eab\u4e2d\u5fc3\u7684erpNumber: " + SafeFilterUtils.vaildLog(erpNumber)));
        }
        catch (Exception e) {
            logger.error((Object)("****\u672a\u83b7\u53d6ErpNumber****" + e.toString()));
        }
        return erpNumber;
    }

    private String getSSOUrl(Context ctx, String sscNumber, String url) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)url)) {
            return "";
        }
        logger.error((Object)("*****sscNumber****" + sscNumber.toString()));
        String userNumber = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName");
        String password = WSSOLoginUtil.getPassword(userNumber);
        String erpIp = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.ip");
        String erpPort = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.port");
        String itpaUrl = "http://" + erpIp + ":" + erpPort + "/portal/index2sso.jsp?isNotCheckRelogin=true&username=" + WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName") + "&password=" + password + "&redirectTo=";
        return itpaUrl + this.encodeUrl(url);
    }

    private String encodeUrl(String url) {
        String encodeUrl = url;
        try {
            encodeUrl = URLEncoder.encode(encodeUrl, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return encodeUrl;
    }

    @Override
    protected String _getImportOrgType(Context ctx, String sscNumber) throws BOSException {
        sscNumber = StringUtils.isEmpty((String)sscNumber) ? "EAS" : sscNumber;
        String erpNumber = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erpNumber");
        String string = erpNumber = StringUtils.isEmpty((String)erpNumber) ? "EAS" : erpNumber;
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._getImportOrgType is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("getImportOrgType");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return (String)call.invoke(new Object[]{erpNumber});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u5171\u4eab\u5f15\u5165\u7ec4\u7ec7\u7c7b\u578b\u5f02\u5e38!" + e.getMessage() + "\n sscNumber:" + sscNumber), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._getImportOrgType is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getImportOrgType", String.class);
            return (String)tMethodService.invoke(object, erpNumber);
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u5171\u4eab\u5f15\u5165\u7ec4\u7ec7\u7c7b\u578b\u5f02\u5e38!" + e.getMessage() + "\n sscNumber:" + sscNumber), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getSatisfactionUrl(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId.toString());
        String url = "";
        if (this.isWebService(ctx, sscNumber)) {
            try {
                url = this.getSSOUrl(ctx, sscNumber, "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.base.ssc.satisfactionReplyAppPage&waf2skin=eascard&inwafpage=true&useType=PC");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55ssc url\u5931\u8d25", (Throwable)e);
                throw new BOSException("\u83b7\u53d6\u767b\u5f55\u5355\u70b9\u767b\u5f55ssc url\u5931\u8d25", (Throwable)e);
            }
        } else {
            url = "/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.eas.base.ssc.satisfactionReplyAppPage&waf2skin=eascard&inwafpage=true&useType=PC";
        }
        return url;
    }

    @Override
    protected boolean _isNeedToSatisfaction(Context ctx, BOSUuid billId, String sscNumber) throws BOSException, EASBizException {
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._isNeedToSatisfaction is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("isNeedToSatisfaction");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return (Boolean)call.invoke(new Object[]{billId + ""});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u662f\u5426\u9700\u8981\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u5f02\u5e38!" + e.getMessage() + "\n sscNumber:" + sscNumber), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean.isNeedToSatisfaction is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("isNeedToSatisfaction", String.class);
            return (Boolean)tMethodService.invoke(object, billId + "");
        }
        catch (Exception e) {
            logger.error((Object)("\u662f\u5426\u9700\u8981\u6ee1\u610f\u5ea6\u8bc4\u4ef7\u5f02\u5e38!" + e.getMessage() + "\n sscNumber:" + sscNumber), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _destroySSCJob(Context ctx, String procInstId) throws BOSException, EASBizException {
        String sscNumber = "";
        try {
            sscNumber = WSSCUtils.getSSCNumber(ctx, procInstId);
            if (StringUtils.isEmpty((String)sscNumber)) {
                sscNumber = "EAS";
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._destroySSCJob is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("deleteSSCDataByProcInstId");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return Boolean.TRUE.equals(call.invoke(new Object[]{procInstId}));
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5220\u9664\u5171\u4eab\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n procInstId:" + procInstId), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._destroySSCJob is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("deleteSSCDataByProcInstId", String.class);
            return Boolean.TRUE.equals(tMethodService.invoke(object, procInstId));
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5220\u9664\u5171\u4eab\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n procInstId:" + procInstId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _destroySSCJob(Context ctx, String procInstId, String assignId) throws BOSException, EASBizException {
        String sscNumber = "";
        try {
            sscNumber = WSSCUtils.getSSCNumber(ctx, procInstId);
            if (StringUtils.isEmpty((String)sscNumber)) {
                sscNumber = "EAS";
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            sscNumber = "EAS";
        }
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._destroySSCJob procInstId assignId is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("deleteSSCDataByAssignId");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return Boolean.TRUE.equals(call.invoke(new Object[]{assignId}));
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5220\u9664\u5171\u4eab\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n assignId:" + assignId), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._destroySSCJob is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("deleteSSCDataByAssignId", String.class);
            return Boolean.TRUE.equals(tMethodService.invoke(object, assignId));
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u5220\u9664\u5171\u4eab\u4efb\u52a1\u5f02\u5e38!" + e.getMessage() + "\n assignId:" + assignId), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getSscOpenApiData(Context ctx, String methodNumber, String billIdOrSscNumber, String param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billIdOrSscNumber)) {
            throw new IllegalArgumentException("billIdOrSscNumber\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5355\u636eID\u6216\u8005\u5171\u4eab\u4e2d\u5fc3\u7f16\u7801");
        }
        logger.error((Object)("\u53c2\u6570\uff1abillIdOrSscNumber\uff1a" + billIdOrSscNumber + "\uff1bmethodNumber\uff1a" + methodNumber + "\uff1bparam\uff1a" + param + "\uff1bctx\uff1a" + ctx));
        String sscNumber = "";
        sscNumber = BOSUuid.isValid((String)billIdOrSscNumber, (boolean)true) ? WSSCUtils.getSSCNumberByBillId(ctx, billIdOrSscNumber) : billIdOrSscNumber;
        String result = "";
        if (this.isWebService(ctx, sscNumber)) {
            logger.error((Object)"CallSSCInterfaceControllerBean._getSscOpenApiData is webservice!");
            String ip = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.ip");
            String port = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.port");
            String userName = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName");
            String password = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "password");
            String dcName = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dcName");
            String language = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "language");
            boolean isHttps = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.url.prefix") == null ? false : WebServiceConfig.getPropertiesValue(ctx, sscNumber, "erp.url.prefix").equalsIgnoreCase("https");
            logger.error((Object)("sscNumber\uff1a" + sscNumber));
            EASLoginContext loginCtx = new EASLoginContext.Builder(ip, Integer.parseInt(port), new CommonLogin.Builder(userName, password, dcName, language).build()).https(isHttps).build();
            logger.error((Object)("loginCtx\uff1a" + loginCtx));
            try {
                com.kingdee.bos.openapi.third.OpenApiInfo info = new com.kingdee.bos.openapi.third.OpenApiInfo();
                info.setApi(methodNumber);
                info.setData(param);
                OpenApi openApi = com.kingdee.bos.openapi.third.OpenApiFactory.getService((AbstractLoginContext)loginCtx);
                result = openApi.invoke(info);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("001", e.getMessage()));
            }
        }
        try {
            OpenApiProcessor processor = new OpenApiProcessor();
            processor.setDataType(DataType.JSON);
            processor.setClientIp(ctx.getClientHostIP());
            processor.setCharset("UTF-8");
            processor.setEncoding(null);
            processor.setEncryptKey("");
            processor.setReqUrl("/api/");
            OpenApiInfo openApiInfo = CallSSCInterfaceFacadeControllerBean.getOpenApiFromCache(ctx, methodNumber);
            openApiInfo.setIsApiFromUrl(Boolean.valueOf(false));
            result = (String)processor.callMethod(ctx, openApiInfo, param);
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new EASBizException(new NumericExceptionSubItem("001", e.getMessage()));
        }
        return result;
    }

    private static OpenApiInfo getOpenApiFromCache(final Context ctx, final String api) throws Exception {
        if (ctx != null && !StringUtils.isEmpty((String)api)) {
            Cache aisApiCache = (Cache)apiCache.get((Object)ctx.getAIS(), (Callable)new Callable<Cache<String, OpenApiInfo>>(){

                @Override
                public Cache<String, OpenApiInfo> call() throws Exception {
                    return CacheBuilder.newBuilder().initialCapacity(100).maximumSize(10000L).build();
                }
            });
            OpenApiInfo info = (OpenApiInfo)aisApiCache.get((Object)api, (Callable)new Callable<OpenApiInfo>(){

                @Override
                public OpenApiInfo call() throws Exception {
                    EntityViewInfo view = new EntityViewInfo();
                    view.setTopCount(1);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)api));
                    view.setFilter(filter);
                    FilterInfo entryFilter = new FilterInfo();
                    entryFilter.setEntryName("entry");
                    entryFilter.getFilterItems().add(new FilterItemInfo("type", (Object)0));
                    view.getEntryFilters().add(entryFilter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("*"));
                    sic.add(new SelectorItemInfo("treeid.start"));
                    sic.add(new SelectorItemInfo("treeid.open"));
                    sic.add(new SelectorItemInfo("treeid.log"));
                    sic.add(new SelectorItemInfo("entry.*"));
                    view.setSelector(sic);
                    OpenApiCollection collection = OpenApiFactory.getLocalInstance((Context)ctx).getOpenApiCollection(view);
                    OpenApiInfo info = null;
                    info = collection.size() > 0 ? collection.get(0) : new OpenApiInfo();
                    return info;
                }
            });
            if (info.getId() == null) {
                info = null;
            }
            return info;
        }
        return null;
    }

    @Override
    protected String _getPersonalCredit(Context ctx, String userId) throws BOSException, EASBizException {
        String sscNumber = "EAS";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("userId", userId);
        String params = JSONUtils.convertObjectToJson((Context)ctx, paramsMap);
        if (this.isWebService(ctx, sscNumber)) {
            try {
                logger.error((Object)"CallSSCInterfaceControllerBean._getPersonalCredit is webService!");
                String serviceUrl = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "sharetaskaddress");
                WSContext servCtx = SSCImageHandler.login(ctx, sscNumber);
                String sessionId = servCtx.getSessionId();
                if (StringUtils.isEmpty((String)sessionId)) {
                    logger.error((Object)"login SSC Fail!");
                    throw new BOSException("login SSC Fail!");
                }
                Call call = servCtx.getCall(true);
                call.setMaintainSession(true);
                call.setOperationName("getUserProfile");
                call.setTargetEndpointAddress(serviceUrl);
                call.addHeader(new SOAPHeaderElement("http://login.webservice.bos.kingdee.com", "SessionId", (Object)sessionId));
                call.setTimeout(Integer.valueOf(5000));
                return (String)call.invoke(new Object[]{params});
            }
            catch (Exception e) {
                logger.error((Object)("webService\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4fe1\u7528\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n userId:" + params), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("001", e.getMessage() + "\u786e\u8ba4\u662f\u5426\u5b89\u88c5\u8865\u4e01PT162635"), (Throwable)e);
            }
        }
        logger.error((Object)"CallSSCInterfaceControllerBean._getPersonalCredit is RPC!");
        try {
            Class<?> tClass = Class.forName("com.kingdee.eas.base.ssc.TaskInterFacedeFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getUserProfile", String.class);
            return (String)tMethodService.invoke(object, params);
        }
        catch (Exception e) {
            logger.error((Object)("\u672c\u5730\u5316\u8c03\u7528\u5171\u4eab\u4e2d\u5fc3\u67e5\u8be2\u4fe1\u7528\u4fe1\u606f\u5f02\u5e38!" + e.getMessage() + "\n userId:" + params), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("001", e.getMessage()), (Throwable)e);
        }
    }
}

