/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.Context2;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.MultiapproveOpertationWebService;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EngineUtil;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IAfterImageStateUpdateHandler;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.IWSSCBillImageStateReverse;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.base.wssc.PhonePhotoFacadeFactory;
import com.kingdee.eas.base.wssc.app.AbstractSSCImageBaseServiceFacadeControllerBean;
import com.kingdee.eas.base.wssc.app.ClearImageLog;
import com.kingdee.eas.base.wssc.app.SSCImageHandler;
import com.kingdee.eas.base.wssc.app.thread.ImageActiveWorkflowThread;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceUtil;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.AEServiceException;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.GuosenWSProxy;
import com.kingdee.eas.base.wssc.app.trd.webservice.image.params.GuosenParamsHelper;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolBuilder;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.base.wssc.image.ISSCXMLTrans;
import com.kingdee.eas.base.wssc.image.SSCImageUtils;
import com.kingdee.eas.base.wssc.image.SSCXMLTrans;
import com.kingdee.eas.base.wssc.image.helper.xmlParmas.ParseXMLUtils;
import com.kingdee.eas.base.wssc.image.helper.xmlParmas.TCZTXmlHelper;
import com.kingdee.eas.base.wssc.image.helper.xmlParmas.bean.ReturnInfo;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.BaseImageList;
import com.kingdee.eas.base.wssc.image.pojo.BillImageResultInfo;
import com.kingdee.eas.base.wssc.image.pojo.BillImageResultList;
import com.kingdee.eas.base.wssc.image.pojo.ImageStateParamInfo;
import com.kingdee.eas.base.wssc.image.pojo.ReceiveImageInfo;
import com.kingdee.eas.base.wssc.image.pojo.SendImageInfo;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.EASDBException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.siit.image.wscommon.obj.base.Params;
import com.siit.image.wscommon.tools.ResultMsg;
import java.io.Reader;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.rpc.ServiceException;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;

public class SSCImageBaseServiceFacadeControllerBean
extends AbstractSSCImageBaseServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.SSCImageBaseServiceFacadeControllerBean");
    static ISSCXMLTrans xmlTrans = null;
    static SSCImageHandler imageHandler = null;
    public static String IMAGE_SYSTEM_TYPE = "image.system.type";
    public static String IMAGE_SYSTEM_TYPE_GXHC = "GXHC";
    public static String IMAGE_SYSTEM_TYPE_DKWS = "DKWS";
    protected int saftyNumber = 0;
    private static final int MAX_NUMBER = 50;
    private ExecutorService executorService = null;

    private synchronized void getPool(Context ctx) {
        if (this.executorService == null) {
            ThreadPoolProperties properties;
            String applicationName = "\u5171\u4eab\u670d\u52a1\u4e2d\u5fc3\u5f71\u50cf\u529f\u80fd";
            String threadPoolName = "\u5ef6\u8fdf\u4e0a\u4f20\u5f71\u50cf\u7ebf\u7a0b\u6c60";
            DynamicThreadPoolManager manager = DynamicThreadPoolManager.getInstance();
            DynamicThreadPoolProperties dynamicThreadPoolProperties = manager.getDynamicThreadPoolProperties();
            if (!dynamicThreadPoolProperties.exists(properties = new ThreadPoolBuilder().ctx(ctx).applicationName(applicationName).threadPoolName(threadPoolName).corePoolSize(5).maximumPoolSize(10).queueCapacity(5000).keepAliveTime(0L).timeUnit(TimeUnit.SECONDS).queueType(QueueTypeEnum.LINKED_BLOCKING_QUEUE).getProperties())) {
                dynamicThreadPoolProperties.getExecutors().add(properties);
            }
            manager.createThreadPoolExecutor(dynamicThreadPoolProperties);
            this.executorService = manager.getThreadPoolExecutor(applicationName, threadPoolName);
        }
    }

    public SSCImageBaseServiceFacadeControllerBean() {
        if (null == xmlTrans) {
            xmlTrans = new SSCXMLTrans();
        }
        if (null == imageHandler) {
            imageHandler = new SSCImageHandler();
        }
    }

    @Override
    protected String _getImageInfo(Context ctx, String inputXml) throws BOSException, EASBizException {
        logger.error((Object)("imagetest:_getImageInfo" + inputXml + "datacenter:" + ctx.getAIS() + "user:" + ctx.getCaller()));
        BaseImageList baseList = xmlTrans.parseXml(inputXml, new BaseImageInfo());
        ArrayList<String> billIDList = new ArrayList<String>();
        BaseImageInfo imageInfo2 = null;
        String imageNo = null;
        String billID = null;
        for (BaseImageInfo imageInfo2 : baseList.getImageList()) {
            imageNo = imageInfo2.getImageNo();
            billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNo);
            billIDList.add(billID);
        }
        BaseImageList newList = new BaseImageList();
        imageHandler.createAccount(ctx, billIDList, newList);
        SSCImageUtils.addErrorImageList(baseList, newList, SendImageInfo.class.getName());
        logger.error((Object)xmlTrans.bulidXml(newList));
        return xmlTrans.bulidXml(newList);
    }

    @Override
    protected String _imageReady(Context ctx, String inputXml) throws BOSException, EASBizException {
        logger.error((Object)("********lulululululuimageReady:_imageReady" + inputXml));
        try {
            logger.error((Object)("ctx.getCaller()" + ctx.getCaller()));
        }
        catch (Exception e) {
            logger.error((Object)("\u8f93\u51factx\u4eba\u5458\u4fe1\u606f\u5931\u8d25,\u6d41\u7a0b\u4e0d\u5f71\u54cd" + e));
        }
        BaseImageList baseList = xmlTrans.parseXml(inputXml, new ReceiveImageInfo());
        logger.error((Object)"imageReady:getBaseList");
        ArrayList<String> billIDList = new ArrayList<String>();
        BaseImageInfo imageInfo2 = null;
        String imageNo = null;
        String billID = null;
        ImageStateEnum imageState = null;
        String bosType = "";
        ArrayList<String> rescanIDList = new ArrayList<String>();
        ArrayList<BaseImageInfo> billIDListNoImage = new ArrayList<BaseImageInfo>();
        for (BaseImageInfo imageInfo2 : baseList.getImageList()) {
            imageNo = imageInfo2.getImageNo();
            billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNo);
            imageInfo2.setBillNo(billID);
            ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
            bosType = uuidPK.getObjectType().toString();
            imageState = BillImageFacadeFactory.getLocalInstance(ctx).getImageState(bosType, billID);
            if (ImageStateEnum.RESCAN_IAMGE == imageState) {
                rescanIDList.add(billID);
                billIDListNoImage.add(imageInfo2);
            } else {
                billIDList.add(billID);
            }
            if (ImageStateEnum.NO_IMAGE.equals((Object)imageState) || ImageStateEnum.UPLOADING_IMAGE.equals((Object)imageState)) {
                billIDListNoImage.add(imageInfo2);
            }
            try {
                PhonePhotoFacadeFactory.getLocalInstance(ctx).clearSavedPhotos(billID);
            }
            catch (Exception e) {
                logger.error((Object)("\u5220\u9664\u7f13\u5b58\u56fe\u7247\u5931\u8d25!billID:[" + billID + "]" + e));
            }
        }
        logger.error((Object)"imageRead:getImageNoMap");
        imageHandler.updateAccount(ctx, rescanIDList, ImageStateEnum.REUPLOAD_IMAGE);
        imageHandler.updateAccount(ctx, billIDList, ImageStateEnum.HAS_IMAGE);
        logger.error((Object)"imageRead:saveImageReady");
        imageHandler.saveImageReady(ctx, baseList);
        if (!billIDListNoImage.isEmpty() || !rescanIDList.isEmpty()) {
            this.afterImageReadyHandle(ctx, billIDListNoImage);
            if (this.executorService == null) {
                this.getPool(ctx);
            }
            this.executorService.execute(new ImageActiveWorkflowThread(ctx, billIDListNoImage));
        }
        try {
            logger.error((Object)"imageRead:invokeTaskCenterService");
            imageHandler.invokeTaskCenterService(ctx, baseList);
        }
        catch (Exception e) {
            logger.error((Object)"invoke taskcenter ----  update image state error ", (Throwable)e);
            imageNo = "";
            throw new BOSException((Throwable)e);
        }
        return imageNo;
    }

    public void afterImageReadyHandle(Context ctx, List<BaseImageInfo> billIDList) throws BOSException, EASBizException {
        logger.error((Object)("start afterImageReadyHandle!billIDList:" + billIDList));
        if (billIDList == null || billIDList.size() <= 0) {
            return;
        }
        if (ctx instanceof Context2) {
            ctx = new Context(ctx.getCaller(), ctx.getSolution(), ctx.getAIS(), ctx.getLocale(), ctx.getContextID());
        }
        Iterator<BaseImageInfo> it = billIDList.iterator();
        String billIDStr = null;
        ProcessInstInfo instInfo = null;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        WfEngine engine = WfEngine.getEngine((Context)ctx);
        block0: while (it.hasNext()) {
            ReceiveImageInfo imageInfo = (ReceiveImageInfo)it.next();
            billIDStr = imageInfo.getBillNo();
            ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billIDStr);
            logger.error((Object)("procInsts.length:" + procInsts.length));
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                logger.error((Object)("procInsts[i].getCode():" + procInsts[i].getCode() + ";procInsts[i].getStat():" + procInsts[i].getState()));
                if (!"open.running".equals(procInsts[i].getState()) && !"open.not_running.suspended".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
                this.saftyNumber = 0;
                if (this.activeWorkflow(ctx, service, engine, instInfo, billIDStr, imageInfo.getScanUserID())) continue block0;
            }
        }
    }

    private boolean activeWorkflow(Context ctx, IEnactmentService service, WfEngine engine, ProcessInstInfo instInfo, String billIDStr, String scanUserID) throws BOSException {
        ++this.saftyNumber;
        logger.error((Object)("start activeWorkflow!billIDStr:" + billIDStr + ";instInfo.getyCode():" + (instInfo == null ? instInfo : instInfo.getCode())));
        ObjectUuidPK billID = null;
        String[] checkers = null;
        String checkerName = "";
        if (instInfo != null && this.saftyNumber <= 50) {
            try {
                int length;
                int i;
                Object obj = service.getProcessContext(instInfo.getProcInstId(), "autoApprove");
                if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                    logger.error((Object)("end activeWorkflow by autoApprove is true!billIDStr:" + billIDStr + ";instInfo.getyCode():" + instInfo.getCode()));
                    return true;
                }
                billID = new ObjectUuidPK(billIDStr);
                AssignmentInfo[] assignments = engine.getAssignmentAllByProcInstId(instInfo.getProcInstId());
                boolean is_FYBX_UploadImageNode = false;
                logger.error((Object)("assignments.length:" + assignments.length));
                if (assignments != null) {
                    for (i = 0; i < assignments.length; ++i) {
                        if (!this.isCurrent(assignments[i])) {
                            logger.error((Object)("assignID : [" + assignments[i].getAssignInfo().getAssignID() + "] \u5728\u5f85\u4e0a\u4f20\u8282\u70b9\u88ab\u8fc7\u6ee4\u4e86,\u8df3\u8fc7."));
                            continue;
                        }
                        if ("afterImageUpload".equalsIgnoreCase(assignments[i].getBizOperation()) || "ImageUploadEvent".equalsIgnoreCase(assignments[i].getBizOperation()) || "actionImageUpload".equalsIgnoreCase(assignments[i].getBizOperation())) {
                            is_FYBX_UploadImageNode = true;
                            ctx.setCaller((IObjectPK)new ObjectUuidPK(assignments[i].getAssignInfo().getPersonUserID()));
                            break;
                        }
                        if (!assignments[i].getBizFunction().equals("WsscCommonFunction") || !assignments[i].getBizOperation().equals("afterImageReadyHandler")) continue;
                        logger.error((Object)"\u662f\u5171\u4eab\u57fa\u7840\u63d0\u4f9b\u7684\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9,\u66f4\u65b0\u8282\u70b9\u5904\u7406\u4eba,\u5e76\u89e6\u53d1\u5de5\u4f5c\u6d41!");
                        AssignInfo assignInfo = assignments[i].getAssignInfo();
                        IObjectPK trueCaller = ctx.getCaller();
                        logger.error((Object)("trueCaller:" + trueCaller));
                        logger.error((Object)("assignmentCaller:" + ctx.getCaller()));
                        String assignId = assignInfo.getAssignID().toString();
                        logger.error((Object)("assignId:" + assignId));
                        String userId = null;
                        try {
                            ctx.setCaller((IObjectPK)new ObjectUuidPK(assignInfo.getPersonUserID()));
                            userId = assignInfo.getPersonUserID().toString();
                        }
                        catch (Exception e) {
                            logger.error((Object)("assignInfo getPersonUserID is null;" + e.getMessage()), (Throwable)e);
                        }
                        try {
                            BOSUuid.read((String)scanUserID);
                        }
                        catch (Exception e) {
                            scanUserID = "";
                            logger.error((Object)("\u626b\u63cf\u4eba\u5458id\u4e0d\u662f\u6709\u6548\u7684uuid:[" + scanUserID + "],\u7f6e\u7a7a\uff01"));
                        }
                        try {
                            if (StringUtils.isEmpty((String)scanUserID) || "null".equalsIgnoreCase(scanUserID)) {
                                logger.error((Object)("scanUserID\u4f20\u8fc7\u6765\u4e3a\u7a7a\uff0c\u8d4b\u503c\u4e3auserId\uff1a" + userId));
                                scanUserID = userId;
                            }
                            if (StringUtils.isEmpty((String)scanUserID) || "null".equalsIgnoreCase(scanUserID)) {
                                logger.error((Object)("scanUserID\u4f20\u8fc7\u6765\u4e3a\u7a7a\uff0c\u8d4b\u503c\u4e3actx\u91cc\u9762\u7684user\uff1a" + userId));
                                scanUserID = trueCaller.toString();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)e, (Throwable)e);
                        }
                        try {
                            Person person = this.getPersonByEmployeeId(scanUserID, ctx);
                            MultiapproveOpertationWebService workService = new MultiapproveOpertationWebService();
                            workService._updateAssignmentPerformer(ctx, assignId, person.getUserId());
                            userId = person.getUserId();
                        }
                        catch (Exception e) {
                            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.base.wssc.WSSCAutoGenerateResource", (String)"145_SSCImageBaseServiceFacadeControllerBean", (Locale)ctx.getLocale()) + scanUserID + "]"));
                        }
                        ctx.setCaller((IObjectPK)new ObjectUuidPK(userId));
                        logger.error((Object)("assignmentCaller:" + ctx.getCaller()));
                        IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
                        iBillImageMap.afterImageReady(BOSUuid.read((String)billIDStr));
                        ctx.setCaller(trueCaller);
                        logger.error((Object)("end activeWorkflow by WsscCommonFunction!billIDStr:" + billIDStr + ";instInfo.getyCode():" + instInfo.getCode()));
                        return true;
                    }
                }
                if (is_FYBX_UploadImageNode) {
                    logger.error((Object)"\u662f\u8d39\u7528\u62a5\u9500\u5f85\u4e0a\u4f20\u5f71\u50cf\u8282\u70b9.\u89e6\u53d1\u8d39\u62a5\u7684function!");
                    checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)billID.getObjectType().toString(), IAfterImageStateUpdateHandler.class);
                    if (checkers == null || checkers.length == 0) {
                        logger.error((Object)"\u662f\u8d39\u7528\u62a5\u9500\u5f85\u4e0a\u4f20\u5f71\u50cf\u8282\u70b9.\u4f46\u662f\u672a\u5728\u6570\u636e\u5e93\u914d\u7f6echeckers.");
                        logger.error((Object)("end activeWorkflow without checkers by afterImageUpload!billIDStr:" + billIDStr + ";instInfo.getyCode():" + instInfo.getCode()));
                        return true;
                    }
                    for (i = 0; i < checkers.length; ++i) {
                        checkerName = checkers[i];
                        ((IAfterImageStateUpdateHandler)Class.forName(checkerName).newInstance()).handler(ctx, billID);
                    }
                    logger.error((Object)("end activeWorkflow by afterImageUpload!billIDStr:" + billIDStr + ";instInfo.getyCode():" + instInfo.getCode()));
                    return true;
                }
                String procInstId = instInfo.getProcInstId();
                ProcessInstInfo[] childrenProcessInsts = engine.getProcessInstancesByParentProcInstId(procInstId);
                int n = length = childrenProcessInsts == null ? 0 : childrenProcessInsts.length;
                for (int i2 = 0; i2 < length; ++i2) {
                    if (!this.activeWorkflow(ctx, service, engine, childrenProcessInsts[i2], billIDStr, scanUserID)) continue;
                    logger.error((Object)("end activeWorkflow by childrenProcessInsts!billIDStr:" + billIDStr + ";instInfo.getCode():" + instInfo.getCode() + ";childrenProcessInst.getCode():" + childrenProcessInsts[i2].getCode()));
                    return true;
                }
            }
            catch (EASDBException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        logger.error((Object)"end activeWorkflow and return false;");
        return false;
    }

    private Person getPersonByEmployeeId(String employeeId, Context ctx) throws WfException {
        Person person = null;
        IParticipantProvider participantProvider = EngineUtil.getEngine((Context)ctx).getPariticipantProvider();
        Person[] personArray = participantProvider.getPersonByEmployeeId(ctx, employeeId);
        if (personArray == null || personArray.length == 0) {
            logger.warn((Object)("wssc participantProvider.getPersonByEmployeeId return null, EmployeeId:" + employeeId + "  context:" + ctx));
            personArray = participantProvider.getPersonsByUserId(ctx, employeeId);
            if (personArray != null && personArray.length > 0) {
                for (int i = 0; i < personArray.length; ++i) {
                    if (!employeeId.equals(personArray[i].getUserId())) continue;
                    return personArray[i];
                }
            }
        }
        if (personArray != null && personArray.length > 0) {
            person = personArray[0];
        } else {
            logger.warn((Object)("wssc participantProvider.getPersonByEmployeeId & getPersonsByUserId return null, EmployeeId:" + employeeId + "  context:" + ctx));
        }
        return person;
    }

    @Override
    protected String _getRescanningImageNoList(Context ctx, String scanUserID) throws BOSException, EASBizException {
        String result = xmlTrans.bulidXml(imageHandler.getImageList(ctx, scanUserID));
        logger.error((Object)("scanUserID:" + scanUserID + ",\u83b7\u53d6\u91cd\u626b\u5217\u8868\u8fd4\u56de\u4fe1\u606f" + result));
        return result;
    }

    @Override
    protected String _getRescanningImageByPerson(Context ctx, String personID) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _updateImageState(Context ctx, String inputXml) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        logger.error((Object)("updateImageState:_getImageInfo" + inputXml));
        BaseImageList baseList = xmlTrans.parseXml(inputXml, new ImageStateParamInfo());
        logger.error((Object)"updateImageState:parseXml");
        imageHandler.saveImageHandleTaskState(ctx, baseList, "0");
        try {
            logger.error((Object)"updateImageState:invokeTaskCenterService");
            imageHandler.invokeTaskCenterServiceRescan(ctx, baseList);
        }
        catch (Exception e) {
            logger.error((Object)"invoke taskcenter ----  update image state error ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ImageStateEnum ise = null;
        for (ImageStateParamInfo imageStateParamInfo : baseList.getImageList()) {
            String imageNo = imageStateParamInfo.getImageNo();
            String state = String.valueOf(imageStateParamInfo.getState());
            ise = "1".equals(state) ? ImageStateEnum.NO_IMAGE : ("2".equals(state) ? ImageStateEnum.HAS_IMAGE : ("3".equals(state) ? ImageStateEnum.RESCAN_IAMGE : ("4".equals(state) ? ImageStateEnum.REUPLOAD_IMAGE : ImageStateEnum.NO_IMAGE)));
            if (!StringUtils.isEmpty((String)imageStateParamInfo.getRescanMessage())) {
                String resMsg = imageStateParamInfo.getRescanMessage();
                resMsg = resMsg.replace("&lt;", "<");
                resMsg = resMsg.replace("&gt;", ">");
                resMsg = resMsg.replace("&amp;", "&");
                resMsg = resMsg.replace("&apos;", "'");
                resMsg = resMsg.replace("&quot;", "\"");
                imageStateParamInfo.setRescanMessage(resMsg);
            }
            String billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNo);
            ArrayList<String> billIDList = new ArrayList<String>();
            billIDList.add(billID);
            imageHandler.updateAccount(ctx, billIDList, ise);
        }
        long endTime = System.currentTimeMillis();
        logger.error((Object)("task time:" + (endTime - startTime)));
    }

    @Override
    protected String _getImageNumberForErp(Context ctx, String billTypeCode, String billNumber) throws BOSException, EASBizException {
        String imageNumber = null;
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            billImageMapInfo = new BillImageMapInfo();
            billImageMapInfo.setBillID(billNumber);
            imageNumber = this.generateImageNumber(ctx, billTypeCode, billNumber);
            billImageMapInfo.setImageNumber(imageNumber);
            billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            billImageMap.addnew((CoreBaseInfo)billImageMapInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageNumber;
    }

    @Override
    protected String _getImageState(Context ctx, String imageNumber) throws BOSException, EASBizException {
        String billId = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNumber);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billId));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "imageNumber: " + imageNumber + ",billId" + billId + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return billImageMapInfo.getImageState().getName();
    }

    @Override
    protected String _getImageUrl(Context ctx, String imageNumber) throws BOSException, EASBizException {
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "imageNumber: " + imageNumber + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        imageURL = billImageMapInfo.getImageURL();
        if (imageURL == null || imageURL.trim().length() <= 0) {
            imageURL = this._updateImageURL(ctx, imageNumber);
        }
        return imageURL;
    }

    private String generateImageNumber(Context ctx, String billTypeCode, String billNumber) throws BOSException {
        String imageNumber = null;
        String imagePrefix = null;
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billNumber);
        imagePrefix = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "imagePrefix");
        if (StringUtils.isEmpty((String)imagePrefix)) {
            imagePrefix = "KD";
        }
        String billNum = "";
        try {
            billNum = BillImageFacadeFactory.getLocalInstance(ctx).transformBillNumber(billNumber);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        imageNumber = imagePrefix + billTypeCode + billNum;
        return imageNumber;
    }

    protected String _updateImageURL(Context ctx, String imageNumber) throws BOSException {
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", (Object)imageNumber));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "imageNumber: " + imageNumber + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        imageNumber = billImageMapInfo.getImageNumber();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageNumber);
            String imageSystemType = WebServiceConfig.getPropertiesValue(ctx, sscNumber, IMAGE_SYSTEM_TYPE);
            if (IMAGE_SYSTEM_TYPE_DKWS.equalsIgnoreCase(imageSystemType)) {
                imageURL = WebServiceUtil.getImageServiceInstance().getViewUrl(personId, imageNumber, true, true, true, "zh-CN");
            } else if (IMAGE_SYSTEM_TYPE_GXHC.equalsIgnoreCase(imageSystemType)) {
                String viewUser = WSSCUtils.getViewUserName(ctx);
                imageURL = this.wsInvokeGetImageUrl(ctx, imageNumber, false, viewUser);
            } else {
                logger.error((Object)("\u672a\u77e5\u7684\u5f71\u50cf\u7cfb\u7edf\u7c7b\u578b " + SafeFilterUtils.vaildLog(imageSystemType)));
            }
            logger.error((Object)("\u5f71\u50cfURL " + SafeFilterUtils.vaildLog(imageURL)));
        }
        catch (AEServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)((Object)e));
            throw new BOSException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        billImageMapInfo.setImageURL(imageURL);
        try {
            billImageMap.update((IObjectPK)new ObjectUuidPK(billImageMapInfo.getId()), (CoreBaseInfo)billImageMapInfo);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageURL;
    }

    private String wsInvokeGetImageUrl(Context ctx, String imageNumber, boolean canRescan, String viewUser) throws RemoteException, ServiceException, Exception {
        GuosenParamsHelper guosenParamsHelper = new GuosenParamsHelper();
        Params params = guosenParamsHelper.buildCreateImagePathParams(imageNumber, canRescan, viewUser);
        String sscNumber = WSSCUtils.getSSCNumberByImageNb(ctx, imageNumber);
        GuosenWSProxy proxy = new GuosenWSProxy(WebServiceConfig.getPropertiesValue(ctx, sscNumber, "image"));
        List<ResultMsg> list = proxy.invokeWS(params);
        return list.get(0).getSuccess();
    }

    @Override
    protected void _reverse(Context ctx, String inputXml) throws BOSException, EASBizException {
        logger.error((Object)("imagetest:_reverse" + inputXml));
        BillImageResultList baseList = this.parseImageResultXml(inputXml, new BillImageResultInfo());
        ArrayList<BillImageResultInfo> resultList = new ArrayList<BillImageResultInfo>();
        BillImageResultInfo imageResultInfo2 = null;
        Object imageNo = null;
        HashSet<String> imageNoSet = new HashSet<String>();
        HashMap<String, BillImageResultInfo> tempMap = new HashMap<String, BillImageResultInfo>();
        for (BillImageResultInfo imageResultInfo2 : baseList.getImageResultList()) {
            imageNoSet.add(imageResultInfo2.getImageNo());
            tempMap.put(imageResultInfo2.getImageNo(), imageResultInfo2);
        }
        BillImageMapCollection billImageMapColl = this.getBillImageCollection(ctx, imageNoSet);
        String billID = "";
        IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
        Iterator it = billImageMapColl.iterator();
        while (it.hasNext()) {
            BillImageMapInfo billImageMapInfo = (BillImageMapInfo)it.next();
            String imageNumber = billImageMapInfo.getImageNumber();
            if (StringUtils.isEmpty((String)imageNumber)) continue;
            BillImageResultInfo tempInfo = ((BillImageResultInfo)tempMap.get(imageNumber)).clone();
            tempInfo.setBillID(billImageMapInfo.getBillID());
            resultList.add(tempInfo);
            if (StringUtils.isEmpty((String)billID)) {
                billID = billImageMapInfo.getBillID();
            }
            if (tempInfo.isResult()) {
                billImageMapInfo.setImageState(ImageStateEnum.HAS_IMAGE);
            } else {
                billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("imageState"));
            iBillImageMap.updatePartial((CoreBaseInfo)billImageMapInfo, selector);
        }
        String[] checkers = null;
        String checkerName = "";
        try {
            ObjectUuidPK pk = new ObjectUuidPK(billID);
            checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)pk.getObjectType().toString(), IWSSCBillImageStateReverse.class);
            if (checkers == null || checkers.length == 0) {
                logger.error((Object)("imagetest:_reverse():\u672a\u5b9e\u73b0\u63a5\u53e3,\u4e0d\u9700\u8981\u53cd\u5199\u5355\u636e\u72b6\u6001, billID=" + billID + ", inputXml =" + inputXml));
                return;
            }
            for (int i = 0; i < checkers.length; ++i) {
                checkerName = checkers[i];
                ((IWSSCBillImageStateReverse)Class.forName(checkerName).newInstance()).update(ctx, resultList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BillImageResultList parseImageResultXml(String inputXml, BillImageResultInfo imageResultInfo) throws BOSException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.addObjectCreate("imageResultList", BillImageResultList.class.getName());
            digester.addObjectCreate("imageResultList/imageResult", imageResultInfo.getClass().getName());
            digester.addBeanPropertySetter("imageResultList/imageResult/imageNo", "imageNo");
            digester.addBeanPropertySetter("imageResultList/imageResult/result", "result");
            digester.addBeanPropertySetter("imageResultList/imageResult/exceptionMsg", "exceptionMsg");
            digester.addSetProperties("imageResultList/imageResult");
            digester.addSetNext("imageResultList/imageResult", "addImageResultList");
            return (BillImageResultList)digester.parse((Reader)new StringReader(inputXml));
        }
        catch (Exception e) {
            logger.error((Object)("BillImageResultList Error: inputXml: " + inputXml));
            throw new BOSException((Throwable)e);
        }
    }

    private BillImageMapCollection getBillImageCollection(Context ctx, Set<String> imageNoSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNumber", imageNoSet, CompareType.INCLUDE));
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("createTime");
        sorterItem.setSortType(SortType.DESCEND);
        sorterItemCollection.add(sorterItem);
        view.setSorter(sorterItemCollection);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billID"));
        sic.add(new SelectorItemInfo("imageNumber"));
        view.setSelector(sic);
        IBillImageMap iBillImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = iBillImageMap.getBillImageMapCollection(view);
        BillImageMapCollection result = new BillImageMapCollection();
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            return new BillImageMapCollection();
        }
        for (int i = 0; i < billImageMapCollection.size(); ++i) {
            BillImageMapInfo billImageMapInfo = billImageMapCollection.get(i);
            String billID = billImageMapInfo.getBillID();
            BOSUuid uuid = BOSUuid.read((String)billID);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            if (iDynamicObject.exists(uuid.getType(), (IObjectPK)pk)) {
                result.add(billImageMapInfo);
                continue;
            }
            logger.error((Object)("imagetest:_reverse().getBillImageMapCollection(), billId = " + billID + ", imageNo = " + billImageMapInfo.getImageNumber()));
        }
        return result;
    }

    private boolean isCurrent(AssignmentInfo assignmentInfo) {
        WfAssignmentState state = assignmentInfo.getAssignInfo().getState();
        return WfAssignmentState.ASSIGNED.equals((Object)state) || WfAssignmentState.ACCEPTED.equals((Object)state);
    }

    @Override
    protected String _snchronyOrg(Context ctx, String inputXML) throws BOSException, EASBizException {
        logger.error((Object)("********_snchronyOrg:_snchronyOrg" + inputXML));
        try {
            logger.error((Object)("ctx.getCaller()" + ctx.getCaller()));
        }
        catch (Exception e) {
            logger.error((Object)("\u8f93\u51factx\u4eba\u5458\u4fe1\u606f\u5931\u8d25,\u6d41\u7a0b\u4e0d\u5f71\u54cd" + e));
        }
        ParseXMLUtils pxml = new ParseXMLUtils();
        Map<String, Object> maps = null;
        try {
            maps = pxml.parseXML(inputXML);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException("change data fail and never go on", (Throwable)e1);
        }
        String beginTime = (String)maps.get("beginTime");
        String endTime = (String)maps.get("endTime");
        String beginDate = this.getStr2Date(beginTime);
        String endDate = this.getStr2Date(endTime);
        StringBuffer sb = new StringBuffer();
        sb.append(" select ");
        sb.append(" fid,fnumber,fname_l2,fisleaf,flevel,fparentid ");
        sb.append(" from T_ORG_BaseUnit ");
        sb.append(" where 1=1 ");
        if (beginDate != null && endDate != null) {
            sb.append(" and FLastUpdateTime  >= ");
            sb.append("{ts'" + beginDate + "'}");
            sb.append(" and FLastUpdateTime  <= ");
            sb.append("{ts'" + endDate + "'}");
        }
        logger.error((Object)("\u5929\u521b\u5f71\u50cf\u540c\u6b65EAS\u7ec4\u7ec7sql***_snchronyOrg:" + sb.toString() + "***beginDate:" + beginDate + "***endDate:" + endDate));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList orgList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("orgID", rowSet.getString("fid"));
                map.put("orgNumber", rowSet.getString("fnumber"));
                map.put("orgName", rowSet.getString("fname_l2"));
                map.put("isLeaf", rowSet.getString("fisleaf"));
                map.put("level", rowSet.getString("flevel"));
                map.put("parentID", rowSet.getString("fparentid"));
                orgList.add(map);
            }
            logger.error((Object)("******_snchronyOrg******orgList.size=" + orgList.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, orgList);
    }

    private String getStr2Date(String str) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = sdf1.parse(str);
            return sdf2.format(date);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _snchronyUser(Context ctx, String inputXML) throws BOSException, EASBizException {
        logger.error((Object)("********_snchronyUser:_snchronyUser" + inputXML));
        try {
            logger.error((Object)("ctx.getCaller()" + ctx.getCaller()));
        }
        catch (Exception e) {
            logger.error((Object)("\u8f93\u51factx\u4eba\u5458\u4fe1\u606f\u5931\u8d25,\u6d41\u7a0b\u4e0d\u5f71\u54cd" + e));
        }
        ParseXMLUtils pxml = new ParseXMLUtils();
        Map<String, Object> maps = null;
        try {
            maps = pxml.parseXML(inputXML);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException("change data fail and never go on", (Throwable)e1);
        }
        String beginTime = (String)maps.get("beginTime");
        String endTime = (String)maps.get("endTime");
        String beginDate = this.getStr2Date(beginTime);
        String endDate = this.getStr2Date(endTime);
        StringBuffer sb = new StringBuffer();
        sb.append(" select distinct users.fid id, users.fnumber number,");
        sb.append(" users.fname_l2 as name, person.fid personID, cu.fid orgID, ");
        sb.append(" users.ftype type ");
        sb.append(" from t_pm_user users ");
        sb.append(" inner join t_bd_person person on users.fpersonid = person.fid ");
        sb.append(" inner join t_org_ctrlunit cu on users.fcontrolunitid = cu.fid ");
        sb.append(" inner join t_org_positionmember positionmember on person.fid = positionmember.fpersonid ");
        sb.append(" inner join t_org_position  position on positionmember.fpositionid = position.fid ");
        sb.append(" inner join t_org_admin adminorgunit on position.fadminorgunitid = adminorgunit.fid ");
        sb.append(" where positionmember.fisprimary = 1 and users.fforbidden = 0 and users.fisdelete = 0 ");
        if (beginDate != null && endDate != null) {
            sb.append(" and users.FLastUpdateTime  >= ");
            sb.append("{ts'" + beginDate + "'}");
            sb.append(" and users.FLastUpdateTime  <= ");
            sb.append("{ts'" + endDate + "'}");
        }
        logger.error((Object)("\u5929\u521b\u5f71\u50cf\u540c\u6b65EAS\u7528\u6237sql***_snchronyUser:" + sb.toString() + "***beginDate:" + beginDate + "***endDate:" + endDate));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList userList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userID", rowSet.getString("id"));
                map.put("userNumber", rowSet.getString("number"));
                map.put("userName", rowSet.getString("name"));
                map.put("personID", rowSet.getString("personID"));
                map.put("orgID", rowSet.getString("orgID"));
                userList.add(map);
            }
            logger.error((Object)("******_snchronyUser******userList.size=" + userList.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return JSONUtils.convertObjectToJson((Context)ctx, userList);
    }

    @Override
    protected String _updateImageStateNew(Context ctx, String inputXML) throws BOSException, EASBizException {
        String imageNo;
        Iterator it;
        Set keySet;
        Map barInfo;
        BaseImageInfo info;
        int i;
        logger.error((Object)("********_updateImageStateNew:_updateImageStateNew" + inputXML));
        try {
            logger.error((Object)("ctx.getCaller()" + ctx.getCaller()));
        }
        catch (Exception e) {
            logger.error((Object)("\u8f93\u51factx\u4eba\u5458\u4fe1\u606f\u5931\u8d25,\u6d41\u7a0b\u4e0d\u5f71\u54cd" + e));
        }
        TCZTXmlHelper pxml = new TCZTXmlHelper();
        Map<String, Object> map = null;
        try {
            map = pxml.parseXML(inputXML);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException("_updateImageStateNew input data transfer fail,please check", (Throwable)e1);
        }
        List barCodeList = (List)map.get("barCodeList");
        BaseImageList baseList = new BaseImageList();
        if ("2".equalsIgnoreCase((String)map.get("imageState"))) {
            for (i = 0; i < barCodeList.size(); ++i) {
                info = new ReceiveImageInfo();
                barInfo = (Map)barCodeList.get(i);
                keySet = barInfo.keySet();
                it = keySet.iterator();
                if (it.hasNext()) {
                    imageNo = (String)it.next();
                    info.setImageNo(imageNo);
                    try {
                        ((ReceiveImageInfo)info).setPageCount(Integer.parseInt((String)barInfo.get(imageNo)));
                    }
                    catch (Exception e) {
                        logger.equals(e + "&&_updateImageStateNew&&Integer.parseInt");
                        ((ReceiveImageInfo)info).setPageCount(0);
                    }
                }
                ((ReceiveImageInfo)info).setScanUserID((String)map.get("updaterID"));
                baseList.addImageList(info);
            }
        } else {
            for (i = 0; i < barCodeList.size(); ++i) {
                info = new ImageStateParamInfo();
                barInfo = (Map)barCodeList.get(i);
                keySet = barInfo.keySet();
                it = keySet.iterator();
                if (it.hasNext()) {
                    imageNo = (String)it.next();
                    info.setImageNo(imageNo);
                }
                ((ImageStateParamInfo)info).setScanUserID((String)map.get("updaterID"));
                ((ImageStateParamInfo)info).setMessage((String)map.get("updReason"));
                baseList.addImageList(info);
            }
        }
        logger.error((Object)("imageReady:getBaseList" + baseList));
        ArrayList<String> billIDList = new ArrayList<String>();
        BaseImageInfo imageInfo2 = null;
        String imageNo2 = null;
        String billID = null;
        ImageStateEnum imageState = ImageStateEnum.HAS_IMAGE;
        String bosType = "";
        ArrayList<String> rescanIDList = new ArrayList<String>();
        ArrayList<BaseImageInfo> billIDListNoImage = new ArrayList<BaseImageInfo>();
        for (BaseImageInfo imageInfo2 : baseList.getImageList()) {
            imageNo2 = imageInfo2.getImageNo();
            billID = BillImageFacadeFactory.getLocalInstance(ctx).getBillIDbyImageNo(imageNo2);
            imageInfo2.setBillNo(billID);
            ObjectUuidPK uuidPK = new ObjectUuidPK(billID);
            bosType = uuidPK.getObjectType().toString();
            imageState = BillImageFacadeFactory.getLocalInstance(ctx).getImageState(bosType, billID);
            if (ImageStateEnum.RESCAN_IAMGE == imageState) {
                rescanIDList.add(billID);
                billIDListNoImage.add(imageInfo2);
            } else {
                billIDList.add(billID);
            }
            if (!ImageStateEnum.NO_IMAGE.equals((Object)imageState) && !ImageStateEnum.UPLOADING_IMAGE.equals((Object)imageState)) continue;
            billIDListNoImage.add(imageInfo2);
        }
        if ("2".equalsIgnoreCase((String)map.get("imageState"))) {
            logger.error((Object)"imageRead:getImageNoMap");
            imageHandler.updateAccount(ctx, rescanIDList, ImageStateEnum.REUPLOAD_IMAGE);
            imageHandler.updateAccount(ctx, billIDList);
            logger.error((Object)"imageRead:saveImageReady");
            imageHandler.saveImageReady(ctx, baseList);
            if (!billIDListNoImage.isEmpty() || !rescanIDList.isEmpty()) {
                this.afterImageReadyHandle(ctx, billIDListNoImage);
            }
            try {
                logger.error((Object)"imageRead:invokeTaskCenterService");
                imageHandler.invokeTaskCenterService(ctx, baseList);
            }
            catch (Exception e) {
                logger.error((Object)"invoke taskcenter ----  update image state error ", (Throwable)e);
                imageNo2 = "";
                throw new BOSException((Throwable)e);
            }
        } else if ("3".equalsIgnoreCase((String)map.get("imageState"))) {
            logger.error((Object)"updateImageState:parseXml");
            Object ise = null;
            imageHandler.updateAccount(ctx, billIDList, ImageStateEnum.RESCAN_IAMGE);
            imageHandler.saveImageHandleTaskState(ctx, baseList, "0");
            try {
                logger.error((Object)"updateImageState:invokeTaskCenterService");
                imageHandler.invokeTaskCenterServiceRescan(ctx, baseList);
            }
            catch (Exception e) {
                logger.error((Object)"invoke taskcenter ----  update image state error ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            logger.error((Object)("\u5929\u521b\u5f71\u50cf\u7cfb\u7edf\u901a\u77e5EAS\u66f4\u65b0\u5f71\u50cf\u72b6\u6001\uff1a" + (String)map.get("map") + "\u72b6\u6001\u4e0d\u5bf9\uff1a\u8981\u4e48\u5f71\u50cf\u5df2\u5c31\u7eea\uff0c\u8981\u4e48\u9000\u56de\u91cd\u626b(\u9a73\u56de\u91cd\u626b)"));
            throw new BOSException((Throwable)new Exception("\u72b6\u6001\u4e0d\u5bf9\uff1a\u8981\u4e48\u5f71\u50cf\u5df2\u5c31\u7eea\uff0c\u8981\u4e48\u9000\u56de\u91cd\u626b(\u9a73\u56de\u91cd\u626b)"));
        }
        ReturnInfo returnInfo = new ReturnInfo();
        returnInfo.setRetCode("0");
        returnInfo.setRetMsg("success");
        return returnInfo.toXML();
    }

    @Override
    protected void _clearImageLog(Context ctx) throws BOSException, EASBizException {
        ClearImageLog log = new ClearImageLog();
        log._dumpData(ctx);
    }
}

