/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SSCSendMessageUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.SSCSendMessageUtil");

    public static void sendMessageAndEmail(Context ctx, String billID) {
        try {
            Map map = SSCSendMessageUtil.getSendMessageMap(ctx, billID);
            SSCSendMessageUtil.sendMessage(ctx, map);
            SSCSendMessageUtil.sendMail(ctx, map);
        }
        catch (Exception e) {
            logger.error((Object)("sendMessageAndEmail error" + e));
            e.printStackTrace();
        }
    }

    private static Map getSendMessageMap(Context ctx, String billID) throws BOSException {
        BOSUuid pk = BOSUuid.read((String)billID);
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectValue tIObjectValue = dynamicObject.getValue(pk.getType(), (IObjectPK)new ObjectUuidPK(billID));
        String receiver = tIObjectValue.get("creator") == null ? "" : tIObjectValue.get("creator").toString();
        String name = tIObjectValue.get("name") == null ? "" : tIObjectValue.get("name").toString();
        HashMap<String, String> map = new HashMap<String, String>();
        String title = "\u5355\u636e\u9000\u56de\u91cd\u626b\u63d0\u9192\u6d88\u606f";
        String body = "\u5355\u636e" + name + "\u5df2\u7ecf\u9000\u56de\u91cd\u626b\uff0c\u8bf7\u77e5\u6653";
        String sender = "administrator";
        map.put("title", title);
        map.put("body", body);
        map.put("receiver", receiver);
        map.put("sender", sender);
        return map;
    }

    private static void sendMessage(Context ctx, Map map) {
        Message message = SSCSendMessageUtil.createMessage(ctx, map);
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        if (senderAgent.getState() != 1) {
            senderAgent.start();
        }
        senderAgent.sendMessage(message);
    }

    private static void sendMail(Context ctx, Map map) throws EASBizException, BOSException, SQLException {
        String title = (String)map.get("title");
        String body = (String)map.get("body");
        String receiver = (String)map.get("receiver");
        String email = "";
        StringBuffer tStrBuffer = new StringBuffer();
        tStrBuffer.append("select a.femail from t_bd_person a inner join t_pm_user b on a.fid = b.fpersonid  ");
        tStrBuffer.append("where b.fid = ? ");
        IRowSet tIRowSet = DbUtil.executeQuery((Context)ctx, (String)tStrBuffer.toString(), (Object[])new Object[]{receiver});
        if (tIRowSet.next()) {
            email = tIRowSet.getString(1);
        }
        if (!StringUtils.isEmpty((CharSequence)email)) {
            MsgUtil.msgMailDerect((Context)ctx, (String)title, (String)body, (String)email, null, null, null);
        }
    }

    private static Message createMessage(Context context, Map map) {
        String title = (String)map.get("title");
        String body = (String)map.get("body");
        String sender = (String)map.get("sender");
        String receiver = (String)map.get("receiver");
        Message message = MessageFactory.newMessage((String)"kingdee.wssc");
        if (context != null) {
            message.setStringHeader("databaseCenter", context.getAIS());
            message.setStringHeader("solution", context.getSolution());
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 20);
        message.setLocaleStringHeader("title", title, new Locale("L2"));
        message.setLocaleStringHeader("body", body, new Locale("L2"));
        message.setLocaleStringHeader("sender", sender, new Locale("L2"));
        message.setStringHeader("receiver", receiver);
        return message;
    }
}

