/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.imagehandler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.base.wssc.ImageSystemException;
import com.kingdee.eas.base.wssc.app.imagehandler.ICoupletImageRelationBill;
import com.kingdee.eas.base.wssc.app.imagehandler.util.ImageHandlerUtils;
import com.kingdee.eas.base.wssc.app.util.WSSCUtils;
import com.kingdee.eas.base.wssc.image.helper.NoticeImageSysFactory;
import com.kingdee.eas.base.wssc.image.pojo.NoticeImageSysViewInfo;
import com.kingdee.eas.base.wssc.imageNew.helper.NoticeImageSysFactory_New;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.RefCheckersDAO;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CoupletImageHandler {
    private static Logger logger = Logger.getLogger(CoupletImageHandler.class);

    public String getSingleImageUrl(Context ctx, String billId, boolean isCanRescan) throws BOSException, EASBizException {
        String imageURL = "";
        ArrayList<NoticeImageSysViewInfo> list = new ArrayList<NoticeImageSysViewInfo>();
        String sscNumber = WSSCUtils.getSSCNumberByBillId(ctx, billId);
        if (sscNumber == null || sscNumber.trim().length() == 0) {
            sscNumber = "EAS";
        }
        List<String> allBillIdList = this.getBotpBillIdList(ctx, billId);
        this.getImageSysViewInfoList(ctx, billId, isCanRescan, list, allBillIdList, false);
        if (list != null && list.size() > 0) {
            imageURL = NoticeImageSysFactory.getInstance(ctx, sscNumber).viewPhotos(list.toArray(new NoticeImageSysViewInfo[0]));
        }
        logger.error((Object)("\u5f71\u50cfURL " + imageURL));
        return imageURL;
    }

    public String getMultiImageUrl(Context ctx, String billId, boolean isCanRescan) throws BOSException, EASBizException {
        String imageURL = null;
        ArrayList<NoticeImageSysViewInfo> list = new ArrayList<NoticeImageSysViewInfo>();
        List<String> allBillIdList = this.getBotpBillIdList(ctx, billId);
        String imageSysId = this.getImageSysViewInfoList(ctx, billId, isCanRescan, list, allBillIdList, true);
        if (list != null && list.size() > 0) {
            imageURL = NoticeImageSysFactory_New.getInstance(ctx, imageSysId).viewPhotos(list.toArray(new NoticeImageSysViewInfo[0]));
        }
        logger.error((Object)("\u5f71\u50cfURL " + imageURL));
        return imageURL;
    }

    private String getImageSysViewInfoList(Context ctx, String billId, boolean isCanRescan, List<NoticeImageSysViewInfo> list, List<String> allBillIdList, boolean isMultiImage) throws BOSException, EASBizException {
        HashSet<String> imageSysSet = new HashSet<String>();
        String imageSysId = "";
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        for (int i = 0; i < allBillIdList.size(); ++i) {
            String srcBillId = allBillIdList.get(i);
            ObjectUuidPK uuidPK = new ObjectUuidPK(srcBillId);
            String bosType = uuidPK.getObjectType().toString();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)srcBillId));
            BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
            NoticeImageSysViewInfo viewPhotoInfo = new NoticeImageSysViewInfo();
            if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
                String msg = "bosType: " + bosType + ", billId: " + srcBillId + " not exist.";
                logger.error((Object)msg);
                continue;
            }
            billImageMapInfo = billImageMapCollection.get(0);
            if (ImageStateEnum.NO_IMAGE.equals((Object)billImageMapInfo.getImageState()) || ImageStateEnum.RESCAN_IAMGE.equals((Object)billImageMapInfo.getImageState()) || ImageStateEnum.UPLOADING_IMAGE.equals((Object)billImageMapInfo.getImageState())) {
                logger.error((Object)("getImageSysViewInfoList imageState is :" + (Object)((Object)billImageMapInfo.getImageState()) + ";continue next"));
                continue;
            }
            if (isMultiImage) {
                imageSysId = billImageMapInfo.getImageSysId();
                imageSysSet.add(imageSysId);
                if (imageSysSet.size() > 1) {
                    logger.error((Object)"\u67e5\u770b\u4e0a\u6709\u5355\u636e\u5f71\u50cf \u5f71\u50cf\u7cfb\u7edf\u5c5e\u4e8e\u591a\u4e2a\u5f71\u50cf\u7cfb\u7edf REEOR ");
                    throw new ImageSystemException(ImageSystemException.IMAGE_TOMANYTYPE);
                }
            }
            String imageNumber = billImageMapInfo.getImageNumber();
            String personId = ImageHandlerUtils.getPersonIdFromCTX(ctx);
            String personName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            logger.debug((Object)("\u83b7\u53d6\u5f71\u50cfURL\u7684\u5165\u53c2\u4e3a\uff1apersonID=" + personId + "imageNumber=" + imageNumber));
            try {
                viewPhotoInfo.setBarCode(imageNumber);
                if (srcBillId.equals(billId)) {
                    viewPhotoInfo.setAllowRescan(isCanRescan);
                } else {
                    viewPhotoInfo.setAllowRescan(false);
                }
                viewPhotoInfo.setViewPersonId(personId);
                viewPhotoInfo.setViewPersonName(personName);
                list.add(viewPhotoInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()));
            }
        }
        return imageSysId;
    }

    private List<String> getBotpBillIdList(Context ctx, String billId) throws EASBizException {
        ArrayList<String> list;
        int i;
        List destBillIdList;
        List srcBillIdList;
        ArrayList<String> allBillIdList = new ArrayList<String>();
        HashMap allBillBotpMap = new HashMap();
        try {
            Class<?> factoryClz = Class.forName("com.kingdee.bos.metadata.bot.BOTRelationFactory");
            Method getInsMethod = factoryClz.getMethod("getLocalInstance", Context.class);
            Object facadeObj = getInsMethod.invoke(null, ctx);
            Method getAllUpstreamObj = facadeObj.getClass().getMethod("getRelativeInfoByCreateTime", String.class, String.class, String.class, Boolean.TYPE, String.class);
            srcBillIdList = (List)getAllUpstreamObj.invoke(facadeObj, billId, null, "1", true, "ASC");
            destBillIdList = (List)getAllUpstreamObj.invoke(facadeObj, billId, null, "0", true, "ASC");
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u4e0a\u6e38\u5355\u636e\u5f02\u5e38,\u6e90\u5355Id\u4e3a:" + billId), (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", ResourceBase.getString((String)"com.kingdee.eas.base.wssc.WSSCAutoGenerateResource", (String)"47_BillImageFacadeControllerBean", (Locale)ctx.getLocale())));
        }
        logger.error((Object)("\u4e0a\u6e38\u5355\u636e\u957f\u5ea6\u4e3a:" + srcBillIdList.size()));
        logger.error((Object)("destBillIdListSize\uff1a" + destBillIdList.size()));
        for (i = 0; i < srcBillIdList.size(); ++i) {
            if (allBillIdList.contains(((Map)srcBillIdList.get(i)).get("billId"))) continue;
            String srcId = ((Map)srcBillIdList.get(i)).get("billId").toString();
            allBillIdList.add(srcId);
            if (allBillBotpMap.containsKey(BOSUuid.read((String)srcId).getType().toString())) {
                ((ArrayList)allBillBotpMap.get(BOSUuid.read((String)srcId).getType().toString())).add(srcId);
                continue;
            }
            list = new ArrayList<String>();
            list.add(srcId);
            allBillBotpMap.put(BOSUuid.read((String)srcId).getType().toString(), list);
        }
        allBillIdList.add(billId);
        for (i = 0; i < destBillIdList.size(); ++i) {
            if (allBillIdList.contains(((Map)destBillIdList.get(i)).get("billId"))) continue;
            String destBillId = ((Map)destBillIdList.get(i)).get("billId").toString();
            allBillIdList.add(destBillId);
            if (allBillBotpMap.containsKey(BOSUuid.read((String)destBillId).getType().toString())) {
                ((ArrayList)allBillBotpMap.get(BOSUuid.read((String)destBillId).getType().toString())).add(destBillId);
                continue;
            }
            list = new ArrayList();
            list.add(destBillId);
            allBillBotpMap.put(BOSUuid.read((String)destBillId).getType().toString(), list);
        }
        try {
            for (String bosType : allBillBotpMap.keySet()) {
                String[] checkers = RefCheckersDAO.getCheckers((Context)ctx, (String)bosType, ICoupletImageRelationBill.class);
                if (checkers == null || checkers.length == 0) {
                    logger.error((Object)(bosType + "\u5bf9\u5e94bosType checkers\u4e3a\u7a7a \u4e8b\u4ef6\u672a\u5728T_SYS_Checkers\u8868\u4e2d\u6ce8\u518c\u901a\u77e5\u7c7b."));
                    continue;
                }
                List<String> list2 = ((ICoupletImageRelationBill)Class.forName(checkers[0]).newInstance()).getRelationBillIds(ctx, (List)allBillBotpMap.get(bosType));
                for (int j = 0; j < list2.size(); ++j) {
                    if (allBillIdList.contains(list2.get(j))) continue;
                    allBillIdList.add(list2.get(j));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return allBillIdList;
    }
}

