/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.assignjob;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.eas.base.wssc.app.notice.api.AbstractMessage;
import com.kingdee.eas.base.wssc.app.notice.api.MessageModelEnum;
import com.kingdee.eas.base.wssc.app.notice.api.MessageTypeEnum;
import com.kingdee.eas.base.wssc.app.notice.api.TextMessageBody;
import com.kingdee.eas.base.wssc.app.notice.assignjob.YzjMessageHead;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class YzjMessage
extends AbstractMessage {
    private static Logger logger = Logger.getLogger(YzjMessage.class);
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";

    public YzjMessage(Context ctx, String eid, Message msg, String pubAcctCode, String pubacckey, String code, boolean toAllUser) throws Exception {
        super(pubAcctCode);
        int k;
        if (msg == null) {
            throw new NullPointerException("adapter is null");
        }
        MessageTypeEnum type = MessageTypeEnum.TEXT;
        MessageModelEnum model = MessageModelEnum.SINGLETEXT;
        HashMap<String, Object> headPackage = null;
        Map<Object, Object> bodyPackage = null;
        String signTime = null;
        List<String> userList = null;
        ArrayList<Map<String, Object>> bodyList = new ArrayList<Map<String, Object>>();
        signTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis());
        Map<String, Object> m = this.getContent(msg);
        if (m != null) {
            bodyList.add(m);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(msg.getStringHeader("receiver"));
        List<String> xtList = this.transferUserIdToXtId(ctx, list);
        logger.info((Object)("CommonMessage === xtList" + xtList.size()));
        for (k = 0; k < xtList.size(); ++k) {
            logger.info((Object)("CommonMessage === xtList.get(" + k + ")" + xtList.get(k)));
        }
        userList = this.mergeUsers(userList, xtList, toAllUser);
        logger.info((Object)("CommonMessage === userList" + userList.size()));
        for (k = 0; k < userList.size(); ++k) {
            logger.info((Object)("CommonMessage === xtList.get(" + k + ")" + userList.get(k)));
        }
        if (userList == null || userList.size() < 1) {
            logger.error((Object)"userList is null");
            throw new Exception("nouser");
        }
        if (bodyList.size() > 0) {
            this.head = new YzjMessageHead(eid);
            headPackage = new HashMap<String, Object>();
            headPackage.put("account", pubAcctCode);
            headPackage.put("signtime", signTime);
            headPackage.put("users", userList);
            headPackage.put("pubacckey", pubacckey);
            headPackage.put("code", code);
            this.head.makeContent(headPackage);
            this.body = new TextMessageBody();
            bodyPackage = new HashMap();
            if (this.body.isSupportMultiEntries()) {
                if (bodyList.size() > 1 && model != null) {
                    model = MessageModelEnum.MULTIGRAPHIC;
                }
                bodyPackage.put("list", bodyList);
            } else {
                bodyPackage = this.getContent(msg);
            }
            this.body.makeContent(bodyPackage);
        } else {
            logger.info((Object)"has found 1 adapter messages,but no message need push");
        }
    }

    public Map<String, Object> getContent(Message msg) {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String content = this.parseContent(msg);
        contents.put("wxtitle", "\u6d88\u606f\u901a\u77e5");
        contents.put("text", content);
        contents.put("procinstid", msg.getStringHeader("ProcessInstId"));
        contents.put("receiver", msg.getStringHeader("receiver"));
        return contents;
    }

    private String parseContent(Message msg) {
        String msgContent = msg.getLocaleStringHeader("title", new Locale("L2"));
        msgContent = msgContent + "\n\u6d88\u606f\u5185\u5bb9\uff1a\n" + msg.getLocaleStringHeader("body", new Locale("L2"));
        logger.info((Object)("XT Notices parseContext() body=" + msg.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + msg.getLocaleStringHeader("title", new Locale("L2"))));
        return msgContent;
    }

    private List<String> transferUserIdToXtId(Context ctx, List<String> userIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        if (userIdList != null) {
            int pageSize = 900;
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / pageSize + 1;
            for (int i = 0; i < totalPage; ++i) {
                IRowSet rs;
                int firstCount = i * pageSize;
                int maxCount = (i + 1) * pageSize;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtils.isNotEmpty((CharSequence)userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                String sql = "select FXtId from T_PM_easxtusermap where FuserId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtils.isEmpty((CharSequence)rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                }
                catch (BOSException var16) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + var16.getMessage()));
                    var16.printStackTrace();
                }
                catch (SQLException var17) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + var17.getMessage()));
                    var17.printStackTrace();
                }
                if (xtIdList.size() != 0) continue;
                sql = "select FXtId from T_PM_easxtusermap where FPersonId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtils.isEmpty((CharSequence)rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                    continue;
                }
                catch (BOSException var14) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + var14.getMessage()));
                    var14.printStackTrace();
                    continue;
                }
                catch (SQLException var15) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + var15.getMessage()));
                    var15.printStackTrace();
                }
            }
        }
        return xtIdList;
    }

    private List<String> mergeUsers(List<String> firstList, List<String> secondList, boolean toAllUser) {
        List<Object> list;
        block5: {
            list = null;
            if (!toAllUser) {
                try {
                    if (firstList == null) {
                        list = secondList;
                        break block5;
                    }
                    list = new ArrayList();
                    list.addAll(firstList);
                    secondList.removeAll(list);
                    list.addAll(secondList);
                }
                catch (Exception var6) {
                    logger.error((Object)("the list of user has error:" + var6.getMessage()));
                }
            } else {
                list = new ArrayList();
                list.add(PUSH_ALL_USERS);
                logger.info((Object)"push to all user switch has enabled");
            }
        }
        return list;
    }
}

