/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.dynamicthreadpool;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolExecutor;
import com.kingdee.eas.base.wssc.dynamicthreadpool.ResizableCapacityLinkedBlockIngQueue;
import com.kingdee.eas.base.wssc.dynamicthreadpool.alarm.DynamicThreadPoolAlarm;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.DynamicThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.RejectedExecutionHandlerEnum;
import com.kingdee.eas.base.wssc.dynamicthreadpool.info.ExecuteRecordInfo;
import com.kingdee.eas.base.wssc.dynamicthreadpool.notify.ThreadPoolChangeNotify;
import com.kingdee.eas.base.wssc.dynamicthreadpool.utils.WsscRefCheckersDAO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DynamicThreadPoolManager {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.dynamicthreadpool.DynamicThreadPoolManager");
    private DynamicThreadPoolProperties dynamicThreadPoolProperties;
    private static volatile DynamicThreadPoolManager instance;
    private Map<String, DynamicThreadPoolExecutor> threadPoolExecutorMap = new HashMap<String, DynamicThreadPoolExecutor>();
    private static ConcurrentHashMap<String, AtomicLong> threadPoolExecutorRejectCountMap;
    private ConcurrentHashMap<Context, ArrayBlockingQueue<ExecuteRecordInfo>> executeRecodeMap = new ConcurrentHashMap();
    static final String sql = "insert into T_WSC_ThreadExecuteRecord(applicationName,threadPoolName,threadName,className,status,exceptionInfo,beginDate,endDate,beginMem,endMem,runtimeinfo,ctx) values(?,?,?,?,?,?,?,?,?,?,?,?)";

    private DynamicThreadPoolManager() {
        this.dynamicThreadPoolProperties = DynamicThreadPoolProperties.getInstance();
        this.initExecuteRecordQueue();
        this.initAlarm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DynamicThreadPoolManager getInstance() {
        if (instance != null) return instance;
        Class<DynamicThreadPoolManager> clazz = DynamicThreadPoolManager.class;
        synchronized (DynamicThreadPoolManager.class) {
            if (instance != null) return instance;
            instance = new DynamicThreadPoolManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public DynamicThreadPoolProperties getDynamicThreadPoolProperties() {
        if (this.dynamicThreadPoolProperties == null) {
            this.dynamicThreadPoolProperties = DynamicThreadPoolProperties.getInstance();
        }
        return this.dynamicThreadPoolProperties;
    }

    public void initAlarm() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                DynamicThreadPoolAlarm.getInstance();
            }
        }).start();
    }

    public void initExecuteRecordQueue() {
        new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                while (true) lbl-1000:
                // 4 sources

                {
                    for (Map.Entry<K, V> map : DynamicThreadPoolManager.access$100(DynamicThreadPoolManager.this).entrySet()) {
                        list = new ArrayList<E>(20);
                        ((ArrayBlockingQueue)map.getValue()).drainTo(list, 20);
                        paramList = new ArrayList<Object[]>(list.size());
                        for (i = 0; i < list.size(); ++i) {
                            paramList.add(new Object[]{((ExecuteRecordInfo)list.get(i)).getApplicationName(), ((ExecuteRecordInfo)list.get(i)).getThreadPoolName(), ((ExecuteRecordInfo)list.get(i)).getThreadName(), ((ExecuteRecordInfo)list.get(i)).getClassName(), ((ExecuteRecordInfo)list.get(i)).getStatus(), ((ExecuteRecordInfo)list.get(i)).getExceptionInfo(), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((ExecuteRecordInfo)list.get(i)).getBeginDate()), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(((ExecuteRecordInfo)list.get(i)).getEndDate()), ((ExecuteRecordInfo)list.get(i)).getBeginMem(), ((ExecuteRecordInfo)list.get(i)).getEndMem(), ((ExecuteRecordInfo)list.get(i)).getRuntimeInfos(), ((ExecuteRecordInfo)list.get(i)).getCtx().toString()});
                        }
                        try {
                            DbUtil.executeBatch((Context)((Context)map.getKey()), (String)"insert into T_WSC_ThreadExecuteRecord(applicationName,threadPoolName,threadName,className,status,exceptionInfo,beginDate,endDate,beginMem,endMem,runtimeinfo,ctx) values(?,?,?,?,?,?,?,?,?,?,?,?)", paramList);
                        }
                        catch (Exception e) {
                            DynamicThreadPoolManager.access$000().error((Object)e.getMessage(), (Throwable)e);
                        }
                        var3_4 = null;
                    }
                    try {
                        Thread.sleep(10000L);
                        ** continue;
                    }
                    catch (InterruptedException e) {
                        DynamicThreadPoolManager.access$000().error((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void initExecutor() {
        this.createThreadPoolExecutor(this.dynamicThreadPoolProperties);
    }

    public void initChecker() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(120000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }).start();
    }

    public void createThreadPoolExecutor(DynamicThreadPoolProperties threadPoolProperties) {
        for (ThreadPoolProperties executor : threadPoolProperties.getExecutors()) {
            if (this.threadPoolExecutorMap.containsKey(executor.getApplicationName().concat(executor.getThreadPoolName()))) continue;
            DynamicThreadPoolExecutor threadPoolExecutor = new DynamicThreadPoolExecutor(executor.getCtx(), executor.getCorePoolSize(), executor.getMaximumPoolSize(), executor.getKeepAliveTime(), executor.getUnit(), this.getBlockingQueue(executor.getQueueType(), executor.getQueueCapacity(), executor.isFair()), new KingThreadFactory(executor.getApplicationName(), executor.getThreadPoolName()), this.getRejectedExecutionHandler(executor.getRejectedExecutionType(), executor.getApplicationName(), executor.getThreadPoolName()), executor.getThreadPoolName(), executor.getApplicationName());
            this.threadPoolExecutorMap.put(executor.getApplicationName().concat(executor.getThreadPoolName()), threadPoolExecutor);
        }
    }

    public Map getThreadPoolInfo(ThreadPoolProperties prop, DynamicThreadPoolExecutor executor) {
        AtomicLong rejectCount = this.getRejectCount(prop.getApplicationName(), prop.getThreadPoolName());
        HashMap<String, String> pool = new HashMap<String, String>();
        pool.put("applicationName", prop.getApplicationName());
        pool.put("threadPoolName", prop.getThreadPoolName());
        pool.put("ctx", prop.getCtx().toString());
        pool.put("corepoolsize", String.valueOf(prop.getCorePoolSize()));
        pool.put("maximumpoolsize", String.valueOf(prop.getMaximumPoolSize()));
        pool.put("queueType", prop.getQueueType());
        pool.put("queueCapacity", String.valueOf(prop.getQueueCapacity()));
        pool.put("activeCount", String.valueOf(executor.getActiveCount()));
        pool.put("completedTaskCount", String.valueOf(executor.getCompletedTaskCount()));
        pool.put("largestPoolSize", String.valueOf(executor.getLargestPoolSize()));
        pool.put("taskCount", String.valueOf(executor.getTaskCount()));
        pool.put("rejectCount", String.valueOf(rejectCount == null ? 0L : rejectCount.get()));
        pool.put("waitTaskCount", String.valueOf(executor.getQueue().size()));
        return pool;
    }

    public static String getAllThreadPoolInfo() {
        DynamicThreadPoolProperties dynamicThreadPoolProperties = DynamicThreadPoolProperties.getInstance();
        DynamicThreadPoolManager dynamicThreadPoolManager = DynamicThreadPoolManager.getInstance();
        HashMap<String, Map> result = new HashMap<String, Map>();
        for (ThreadPoolProperties executor : dynamicThreadPoolProperties.getExecutors()) {
            String threadPoolName = executor.getThreadPoolName();
            String applicationName = executor.getApplicationName();
            DynamicThreadPoolExecutor threadPoolExecutor = dynamicThreadPoolManager.getThreadPoolExecutor(applicationName, threadPoolName);
            Map threadPoolInfo = dynamicThreadPoolManager.getThreadPoolInfo(executor, threadPoolExecutor);
            result.put(applicationName + "-" + threadPoolName, threadPoolInfo);
        }
        return JSON.toJSONString(result);
    }

    private RejectedExecutionHandler getRejectedExecutionHandler(String rejectedExecutionType, String applicationName, String threadPoolName) {
        if (RejectedExecutionHandlerEnum.CALLER_RUNS_POLICY.getType().equals(rejectedExecutionType)) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        if (RejectedExecutionHandlerEnum.DISCARD_OLDEST_POLICY.getType().equals(rejectedExecutionType)) {
            return new ThreadPoolExecutor.DiscardOldestPolicy();
        }
        if (RejectedExecutionHandlerEnum.DISCARD_POLICY.getType().equals(rejectedExecutionType)) {
            return new ThreadPoolExecutor.DiscardPolicy();
        }
        ServiceLoader<RejectedExecutionHandler> serviceLoader = ServiceLoader.load(RejectedExecutionHandler.class);
        for (RejectedExecutionHandler rejectedExecutionHandler : serviceLoader) {
            String rejectedExecutionHandlerName = rejectedExecutionHandler.getClass().getSimpleName();
            if (!rejectedExecutionType.equals(rejectedExecutionHandlerName)) continue;
            return rejectedExecutionHandler;
        }
        return new KingAbortPolicy(applicationName, threadPoolName);
    }

    private BlockingQueue getBlockingQueue(String queueType, int queueCapacity, boolean fair) {
        if (!QueueTypeEnum.exists(queueType)) {
            throw new RuntimeException("\u961f\u5217\u4e0d\u5b58\u5728 " + queueType);
        }
        if (QueueTypeEnum.ARRAY_BLOCKING_QUEUE.getType().equals(queueType)) {
            return new ArrayBlockingQueue(queueCapacity);
        }
        if (QueueTypeEnum.SYNCHRONOUS_QUEUE.getType().equals(queueType)) {
            return new SynchronousQueue(fair);
        }
        if (QueueTypeEnum.PRIORITY_BLOCKING_QUEUE.getType().equals(queueType)) {
            return new PriorityBlockingQueue(queueCapacity);
        }
        if (QueueTypeEnum.DELAY_QUEUE.getType().equals(queueType)) {
            return new DelayQueue();
        }
        if (QueueTypeEnum.LINKED_BLOCKING_DEQUE.getType().equals(queueType)) {
            return new LinkedBlockingDeque(queueCapacity);
        }
        return new ResizableCapacityLinkedBlockIngQueue(queueCapacity);
    }

    public synchronized void refreshThreadPoolExecutor(ThreadPoolProperties properties) throws EASBizException, BOSException {
        if (properties == null) {
            return;
        }
        for (ThreadPoolProperties executor : this.dynamicThreadPoolProperties.getExecutors()) {
            if (!StringUtils.isEmpty((String)properties.getThreadPoolName()) && !executor.getApplicationName().concat(executor.getThreadPoolName()).equals(properties.getApplicationName().concat(properties.getThreadPoolName()))) continue;
            executor.setCorePoolSize(properties.getCorePoolSize());
            executor.setMaximumPoolSize(properties.getMaximumPoolSize());
            executor.setQueueCapacity(properties.getQueueCapacity());
            String param = JSONUtils.convertObjectToJson((Context)executor.getCtx(), (Object)executor);
            String checkerName = "";
            try {
                String[] checkers = WsscRefCheckersDAO.getCheckers(executor.getCtx(), "NOTIFYCH", ThreadPoolChangeNotify.class, executor.getThreadPoolName());
                if (checkers == null || checkers.length == 0) {
                    logger.error((Object)("\u53c2\u6570checkers\u4e3a\u7a7a\uff0c\u7ebf\u7a0b\u6c60\uff1a" + executor.getThreadPoolName() + "\u7684" + "NOTIFYCH" + "\u4e8b\u4ef6\u672a\u5728T_SYS_Checkers\u8868\u4e2d\u6ce8\u518c\u901a\u77e5\u7c7b."));
                }
                if (checkers != null) {
                    for (int i = 0; i < checkers.length; ++i) {
                        checkerName = checkers[i];
                        logger.error((Object)("\u901a\u77e5\u7ebf\u7a0b\u6c60\uff1a" + executor.getThreadPoolName() + "\uff1bcheckerName\uff1a" + checkerName + "\uff1b\u53c2\u6570\uff1a" + param + "\uff1b\u901a\u77e5\u7c7b\u578b\uff1a" + "NOTIFYCH"));
                        ((ThreadPoolChangeNotify)Class.forName(checkerName).newInstance()).changenotify(executor.getCtx(), param);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u901a\u77e5\u5931\u8d25\uff0c\u7ebf\u7a0b\u6c60\uff1a" + executor.getThreadPoolName() + "\uff1bcheckerName\uff1a" + checkerName + "\uff1b\u53c2\u6570\uff1a" + param + "\uff1b\u901a\u77e5\u7c7b\u578b\uff1a" + "NOTIFYCH"), (Throwable)e);
            }
            ThreadPoolExecutor threadPoolExecutor = this.threadPoolExecutorMap.get(executor.getApplicationName().concat(executor.getThreadPoolName()));
            threadPoolExecutor.setCorePoolSize(executor.getCorePoolSize());
            threadPoolExecutor.setMaximumPoolSize(executor.getMaximumPoolSize());
            threadPoolExecutor.setKeepAliveTime(executor.getKeepAliveTime(), executor.getUnit());
            threadPoolExecutor.setRejectedExecutionHandler(this.getRejectedExecutionHandler(executor.getRejectedExecutionType(), executor.getApplicationName(), executor.getThreadPoolName()));
            BlockingQueue<Runnable> queue = threadPoolExecutor.getQueue();
            if (!(queue instanceof ResizableCapacityLinkedBlockIngQueue)) continue;
            ((ResizableCapacityLinkedBlockIngQueue)queue).setCapacity(executor.getQueueCapacity());
        }
    }

    public DynamicThreadPoolExecutor getThreadPoolExecutor(String applicationName, String threadPoolName) {
        DynamicThreadPoolExecutor threadPoolExecutor = this.threadPoolExecutorMap.get(applicationName.concat(threadPoolName));
        if (threadPoolExecutor == null) {
            logger.error((Object)("\u627e\u4e0d\u5230\u7ebf\u7a0b\u6c60 " + threadPoolName));
        }
        return threadPoolExecutor;
    }

    public AtomicLong getRejectCount(String appicationName, String threadPoolName) {
        return threadPoolExecutorRejectCountMap.get(appicationName.concat(threadPoolName));
    }

    public void clearRejectCount(String appicationName, String threadPoolName) {
        threadPoolExecutorRejectCountMap.remove(appicationName.concat(threadPoolName));
    }

    public ConcurrentHashMap<Context, ArrayBlockingQueue<ExecuteRecordInfo>> getExecuteRecodeMap() {
        return this.executeRecodeMap;
    }

    static /* synthetic */ ConcurrentHashMap access$100(DynamicThreadPoolManager x0) {
        return x0.executeRecodeMap;
    }

    static {
        threadPoolExecutorRejectCountMap = new ConcurrentHashMap();
    }

    static class KingAbortPolicy
    implements RejectedExecutionHandler {
        private String applicationName;
        private String threadPoolName;

        public KingAbortPolicy() {
        }

        public KingAbortPolicy(String applicationName, String threadPoolName) {
            this.applicationName = applicationName;
            this.threadPoolName = threadPoolName;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            AtomicLong atomicLong = threadPoolExecutorRejectCountMap.putIfAbsent(this.applicationName.concat(this.threadPoolName), new AtomicLong(1L));
            if (atomicLong != null) {
                atomicLong.incrementAndGet();
            }
            throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + e.toString());
        }
    }

    static class KingThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        KingThreadFactory(String applicationName, String threadPoolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = applicationName + "-" + threadPoolName + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

