/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SafeFilterUtils {
    private static Logger logger = Logger.getLogger(SafeFilterUtils.class);
    static List<String> LogForgingList = new ArrayList<String>();
    static Pattern pa;
    static Pattern pa1;

    public static String vaildLog(String logs) {
        if (StringUtils.isEmpty((CharSequence)logs)) {
            return logs;
        }
        String normalize = Normalizer.normalize(logs, Normalizer.Form.NFKC);
        for (String str : LogForgingList) {
            normalize = normalize.replace(str, "");
        }
        return normalize;
    }

    public static String headerManipulation(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        Matcher ma = pa.matcher(str);
        if (ma.find()) {
            str = ma.replaceAll("");
        }
        return str;
    }

    public static String formulaInjection(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        Matcher ma = pa1.matcher(str);
        if (ma.find()) {
            str = ma.replaceAll("");
        }
        return str;
    }

    public static void safeClose(InputStream is) {
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void safeClose(OutputStream os) {
        if (null != os) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void safeClose(PreparedStatement ps) {
        if (null != ps) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
    }

    public static String SSRFVerify(String externalUrl) throws IOException {
        URL url = new URL(externalUrl);
        String host = url.getHost();
        String protocol = url.getProtocol();
        String decode = URLDecoder.decode(externalUrl, "utf-8");
        if (decode.contains("\r\n")) {
            throw new IllegalArgumentException();
        }
        return externalUrl;
    }

    public static void main(String[] args) {
        String msg = "\u54e6-\u8c37\u6b4c\u963f\u8428\u5fb7\u6492+\u963f\u8428\u5fb7=\u7684\u963f\u8428\u5fb7@";
        System.out.println(SafeFilterUtils.formulaInjection(msg));
    }

    static {
        LogForgingList.add("%0d");
        LogForgingList.add("%0a");
        LogForgingList.add("%0A");
        LogForgingList.add("%0D");
        LogForgingList.add("\r");
        LogForgingList.add("\n");
        String regex = "[`~!@#$%^&*()\\+\\=\\{}|:\"?><\u3010\u3011\\\r\\\n]";
        pa = Pattern.compile(regex);
        String regex1 = "[@\\-\\+\\=]";
        pa1 = Pattern.compile(regex1);
    }
}

